// third_party/blink/public/mojom/widget/device_emulation_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/display/mojom/screen_orientation.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/widget/device_emulation_params_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT DeviceEmulationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceEmulationParams, T>::value>;
  using DataView = DeviceEmulationParamsDataView;
  using Data_ = internal::DeviceEmulationParams_Data;

  template <typename... Args>
  static DeviceEmulationParamsPtr New(Args&&... args) {
    return DeviceEmulationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceEmulationParamsPtr From(const U& u) {
    return mojo::TypeConverter<DeviceEmulationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceEmulationParams>::Convert(*this);
  }


  DeviceEmulationParams();

  DeviceEmulationParams(
      EmulatedScreenType screen_type,
      const ::gfx::Size& screen_size,
      const std::optional<::gfx::Point>& view_position,
      const ::gfx::Size& view_size,
      float device_scale_factor,
      float scale,
      const ::gfx::PointF& viewport_offset,
      float viewport_scale,
      ::display::mojom::blink::ScreenOrientation screen_orientation_type,
      uint32_t screen_orientation_angle,
      ::blink::Vector<::gfx::Rect> viewport_segments,
      ::blink::mojom::blink::DevicePostureType device_posture);


  ~DeviceEmulationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceEmulationParamsPtr>
  DeviceEmulationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceEmulationParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceEmulationParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceEmulationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceEmulationParams_UnserializedMessageContext<
            UserType, DeviceEmulationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceEmulationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceEmulationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceEmulationParams_UnserializedMessageContext<
            UserType, DeviceEmulationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceEmulationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  EmulatedScreenType screen_type;
  
  ::gfx::Size screen_size;
  
  std::optional<::gfx::Point> view_position;
  
  ::gfx::Size view_size;
  
  float device_scale_factor;
  
  float scale;
  
  ::gfx::PointF viewport_offset;
  
  float viewport_scale;
  
  ::display::mojom::blink::ScreenOrientation screen_orientation_type;
  
  uint32_t screen_orientation_angle;
  
  ::blink::Vector<::gfx::Rect> viewport_segments;
  
  ::blink::mojom::blink::DevicePostureType device_posture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceEmulationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DeviceEmulationParamsPtr DeviceEmulationParams::Clone() const {
  return New(
      mojo::Clone(screen_type),
      mojo::Clone(screen_size),
      mojo::Clone(view_position),
      mojo::Clone(view_size),
      mojo::Clone(device_scale_factor),
      mojo::Clone(scale),
      mojo::Clone(viewport_offset),
      mojo::Clone(viewport_scale),
      mojo::Clone(screen_orientation_type),
      mojo::Clone(screen_orientation_angle),
      mojo::Clone(viewport_segments),
      mojo::Clone(device_posture)
  );
}

template <typename T, DeviceEmulationParams::EnableIfSame<T>*>
bool DeviceEmulationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_type, other_struct.screen_type))
    return false;
  if (!mojo::Equals(this->screen_size, other_struct.screen_size))
    return false;
  if (!mojo::Equals(this->view_position, other_struct.view_position))
    return false;
  if (!mojo::Equals(this->view_size, other_struct.view_size))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  if (!mojo::Equals(this->viewport_offset, other_struct.viewport_offset))
    return false;
  if (!mojo::Equals(this->viewport_scale, other_struct.viewport_scale))
    return false;
  if (!mojo::Equals(this->screen_orientation_type, other_struct.screen_orientation_type))
    return false;
  if (!mojo::Equals(this->screen_orientation_angle, other_struct.screen_orientation_angle))
    return false;
  if (!mojo::Equals(this->viewport_segments, other_struct.viewport_segments))
    return false;
  if (!mojo::Equals(this->device_posture, other_struct.device_posture))
    return false;
  return true;
}

template <typename T, DeviceEmulationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.screen_type < rhs.screen_type)
    return true;
  if (rhs.screen_type < lhs.screen_type)
    return false;
  if (lhs.screen_size < rhs.screen_size)
    return true;
  if (rhs.screen_size < lhs.screen_size)
    return false;
  if (lhs.view_position < rhs.view_position)
    return true;
  if (rhs.view_position < lhs.view_position)
    return false;
  if (lhs.view_size < rhs.view_size)
    return true;
  if (rhs.view_size < lhs.view_size)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  if (lhs.viewport_offset < rhs.viewport_offset)
    return true;
  if (rhs.viewport_offset < lhs.viewport_offset)
    return false;
  if (lhs.viewport_scale < rhs.viewport_scale)
    return true;
  if (rhs.viewport_scale < lhs.viewport_scale)
    return false;
  if (lhs.screen_orientation_type < rhs.screen_orientation_type)
    return true;
  if (rhs.screen_orientation_type < lhs.screen_orientation_type)
    return false;
  if (lhs.screen_orientation_angle < rhs.screen_orientation_angle)
    return true;
  if (rhs.screen_orientation_angle < lhs.screen_orientation_angle)
    return false;
  if (lhs.viewport_segments < rhs.viewport_segments)
    return true;
  if (rhs.viewport_segments < lhs.viewport_segments)
    return false;
  if (lhs.device_posture < rhs.device_posture)
    return true;
  if (rhs.device_posture < lhs.device_posture)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DeviceEmulationParams::DataView,
                                         ::blink::mojom::blink::DeviceEmulationParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DeviceEmulationParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::screen_type) screen_type(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->screen_type;
  }

  static const decltype(::blink::mojom::blink::DeviceEmulationParams::screen_size)& screen_size(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->screen_size;
  }

  static const decltype(::blink::mojom::blink::DeviceEmulationParams::view_position)& view_position(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->view_position;
  }

  static const decltype(::blink::mojom::blink::DeviceEmulationParams::view_size)& view_size(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->view_size;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::device_scale_factor) device_scale_factor(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::scale) scale(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->scale;
  }

  static const decltype(::blink::mojom::blink::DeviceEmulationParams::viewport_offset)& viewport_offset(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->viewport_offset;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::viewport_scale) viewport_scale(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->viewport_scale;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::screen_orientation_type) screen_orientation_type(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->screen_orientation_type;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::screen_orientation_angle) screen_orientation_angle(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->screen_orientation_angle;
  }

  static const decltype(::blink::mojom::blink::DeviceEmulationParams::viewport_segments)& viewport_segments(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->viewport_segments;
  }

  static decltype(::blink::mojom::blink::DeviceEmulationParams::device_posture) device_posture(
      const ::blink::mojom::blink::DeviceEmulationParamsPtr& input) {
    return input->device_posture;
  }

  static bool Read(::blink::mojom::blink::DeviceEmulationParams::DataView input, ::blink::mojom::blink::DeviceEmulationParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_BLINK_H_