// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_contrast.mojom-shared.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"


namespace blink::mojom {
class WebPreferencesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebPreferencesDataView> {
  using Data = ::blink::mojom::internal::WebPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PointerType : int32_t {
  
  kPointerNone = 1,
  
  kPointerFirstType = 1,
  
  kPointerCoarseType = 2,
  
  kPointerFineType = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PointerType value);
inline bool IsKnownEnumValue(PointerType value) {
  return internal::PointerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HoverType : int32_t {
  
  kHoverNone = 1,
  
  kHoverFirstType = 1,
  
  kHoverHoverType = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HoverType value);
inline bool IsKnownEnumValue(HoverType value) {
  return internal::HoverType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OutputDeviceUpdateAbilityType : int32_t {
  
  kSlowType = 0,
  
  kFastType = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, OutputDeviceUpdateAbilityType value);
inline bool IsKnownEnumValue(OutputDeviceUpdateAbilityType value) {
  return internal::OutputDeviceUpdateAbilityType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EditingBehavior : int32_t {
  
  kEditingMacBehavior = 0,
  
  kEditingWindowsBehavior = 1,
  
  kEditingUnixBehavior = 2,
  
  kEditingAndroidBehavior = 3,
  
  kEditingChromeOSBehavior = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EditingBehavior value);
inline bool IsKnownEnumValue(EditingBehavior value) {
  return internal::EditingBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageAnimationPolicy : int32_t {
  
  kImageAnimationPolicyAllowed = 0,
  
  kImageAnimationPolicyAnimateOnce = 1,
  
  kImageAnimationPolicyNoAnimation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value);
inline bool IsKnownEnumValue(ImageAnimationPolicy value) {
  return internal::ImageAnimationPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewportStyle : int32_t {
  
  kDefault = 0,
  
  kMobile = 1,
  
  kTelevision = 2,
  
  kLast = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewportStyle value);
inline bool IsKnownEnumValue(ViewportStyle value) {
  return internal::ViewportStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutoplayPolicy : int32_t {
  
  kNoUserGestureRequired = 0,
  
  kUserGestureRequired = 1,
  
  kDocumentUserActivationRequired = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AutoplayPolicy value);
inline bool IsKnownEnumValue(AutoplayPolicy value) {
  return internal::AutoplayPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EffectiveConnectionType : int32_t {
  
  kEffectiveConnectionUnknownType = 0,
  
  kEffectiveConnectionOfflineType = 1,
  
  kEffectiveConnectionSlow2GType = 2,
  
  kEffectiveConnection2GType = 3,
  
  kEffectiveConnection3GType = 4,
  
  kEffectiveConnection4GType = 5,
  
  kEffectiveConnectionTypeLast = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value);
inline bool IsKnownEnumValue(EffectiveConnectionType value) {
  return internal::EffectiveConnectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebPreferencesDataView {
 public:
  WebPreferencesDataView() = default;

  WebPreferencesDataView(
      internal::WebPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStandardFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStandardFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->standard_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetFixedFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFixedFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fixed_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetSansSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSansSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->sans_serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetCursiveFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCursiveFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->cursive_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetFantasyFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFantasyFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fantasy_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetMathFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMathFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->math_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  int32_t default_font_size() const {
    return data_->default_font_size;
  }
  int32_t default_fixed_font_size() const {
    return data_->default_fixed_font_size;
  }
  int32_t minimum_font_size() const {
    return data_->minimum_font_size;
  }
  int32_t minimum_logical_font_size() const {
    return data_->minimum_logical_font_size;
  }
  inline void GetDefaultEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultEncoding(UserType* output) {
    
    auto* pointer = data_->default_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool always_show_context_menu_on_touch() const {
    return data_->always_show_context_menu_on_touch;
  }
  bool context_menu_on_mouse_up() const {
    return data_->context_menu_on_mouse_up;
  }
  bool javascript_enabled() const {
    return data_->javascript_enabled;
  }
  bool web_security_enabled() const {
    return data_->web_security_enabled;
  }
  bool loads_images_automatically() const {
    return data_->loads_images_automatically;
  }
  bool images_enabled() const {
    return data_->images_enabled;
  }
  bool plugins_enabled() const {
    return data_->plugins_enabled;
  }
  bool dom_paste_enabled() const {
    return data_->dom_paste_enabled;
  }
  bool shrinks_standalone_images_to_fit() const {
    return data_->shrinks_standalone_images_to_fit;
  }
  bool text_areas_are_resizable() const {
    return data_->text_areas_are_resizable;
  }
  bool allow_scripts_to_close_windows() const {
    return data_->allow_scripts_to_close_windows;
  }
  bool remote_fonts_enabled() const {
    return data_->remote_fonts_enabled;
  }
  bool javascript_can_access_clipboard() const {
    return data_->javascript_can_access_clipboard;
  }
  bool dns_prefetching_enabled() const {
    return data_->dns_prefetching_enabled;
  }
  bool data_saver_enabled() const {
    return data_->data_saver_enabled;
  }
  bool local_storage_enabled() const {
    return data_->local_storage_enabled;
  }
  bool tabs_to_links() const {
    return data_->tabs_to_links;
  }
  bool disable_ipc_flooding_protection() const {
    return data_->disable_ipc_flooding_protection;
  }
  bool hyperlink_auditing_enabled() const {
    return data_->hyperlink_auditing_enabled;
  }
  bool allow_universal_access_from_file_urls() const {
    return data_->allow_universal_access_from_file_urls;
  }
  bool allow_file_access_from_file_urls() const {
    return data_->allow_file_access_from_file_urls;
  }
  bool webgl1_enabled() const {
    return data_->webgl1_enabled;
  }
  bool webgl2_enabled() const {
    return data_->webgl2_enabled;
  }
  bool privileged_webgl_extensions_enabled() const {
    return data_->privileged_webgl_extensions_enabled;
  }
  bool webgl_errors_to_console_enabled() const {
    return data_->webgl_errors_to_console_enabled;
  }
  bool hide_scrollbars() const {
    return data_->hide_scrollbars;
  }
  bool prefers_default_scrollbar_styles() const {
    return data_->prefers_default_scrollbar_styles;
  }
  bool accelerated_2d_canvas_enabled() const {
    return data_->accelerated_2d_canvas_enabled;
  }
  bool canvas_2d_layers_enabled() const {
    return data_->canvas_2d_layers_enabled;
  }
  bool antialiased_2d_canvas_disabled() const {
    return data_->antialiased_2d_canvas_disabled;
  }
  bool antialiased_clips_2d_canvas_enabled() const {
    return data_->antialiased_clips_2d_canvas_enabled;
  }
  bool accelerated_filters_enabled() const {
    return data_->accelerated_filters_enabled;
  }
  bool deferred_filters_enabled() const {
    return data_->deferred_filters_enabled;
  }
  bool container_culling_enabled() const {
    return data_->container_culling_enabled;
  }
  bool allow_running_insecure_content() const {
    return data_->allow_running_insecure_content;
  }
  bool disable_reading_from_canvas() const {
    return data_->disable_reading_from_canvas;
  }
  bool strict_mixed_content_checking() const {
    return data_->strict_mixed_content_checking;
  }
  bool strict_powerful_feature_restrictions() const {
    return data_->strict_powerful_feature_restrictions;
  }
  bool allow_geolocation_on_insecure_origins() const {
    return data_->allow_geolocation_on_insecure_origins;
  }
  bool strictly_block_blockable_mixed_content() const {
    return data_->strictly_block_blockable_mixed_content;
  }
  bool block_mixed_plugin_content() const {
    return data_->block_mixed_plugin_content;
  }
  bool password_echo_enabled() const {
    return data_->password_echo_enabled;
  }
  bool should_clear_document_background() const {
    return data_->should_clear_document_background;
  }
  bool enable_scroll_animator() const {
    return data_->enable_scroll_animator;
  }
  bool prefers_reduced_motion() const {
    return data_->prefers_reduced_motion;
  }
  bool prefers_reduced_transparency() const {
    return data_->prefers_reduced_transparency;
  }
  bool inverted_colors() const {
    return data_->inverted_colors;
  }
  bool touch_event_feature_detection_enabled() const {
    return data_->touch_event_feature_detection_enabled;
  }
  int32_t pointer_events_max_touch_points() const {
    return data_->pointer_events_max_touch_points;
  }
  int32_t available_pointer_types() const {
    return data_->available_pointer_types;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::blink::mojom::PointerType>(
        data_value, output);
  }
  PointerType primary_pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PointerType>(data_->primary_pointer_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOutputDeviceUpdateAbilityType(UserType* output) const {
    auto data_value = data_->output_device_update_ability_type;
    return mojo::internal::Deserialize<::blink::mojom::OutputDeviceUpdateAbilityType>(
        data_value, output);
  }
  OutputDeviceUpdateAbilityType output_device_update_ability_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::OutputDeviceUpdateAbilityType>(data_->output_device_update_ability_type));
  }
  int32_t available_hover_types() const {
    return data_->available_hover_types;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryHoverType(UserType* output) const {
    auto data_value = data_->primary_hover_type;
    return mojo::internal::Deserialize<::blink::mojom::HoverType>(
        data_value, output);
  }
  HoverType primary_hover_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::HoverType>(data_->primary_hover_type));
  }
  bool dont_send_key_events_to_javascript() const {
    return data_->dont_send_key_events_to_javascript;
  }
  bool barrel_button_for_drag_enabled() const {
    return data_->barrel_button_for_drag_enabled;
  }
  bool sync_xhr_in_documents_enabled() const {
    return data_->sync_xhr_in_documents_enabled;
  }
  bool target_blank_implies_no_opener_enabled_will_be_removed() const {
    return data_->target_blank_implies_no_opener_enabled_will_be_removed;
  }
  bool ignore_permission_for_device_changed_event() const {
    return data_->ignore_permission_for_device_changed_event;
  }
  int32_t number_of_cpu_cores() const {
    return data_->number_of_cpu_cores;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEditingBehavior(UserType* output) const {
    auto data_value = data_->editing_behavior;
    return mojo::internal::Deserialize<::blink::mojom::EditingBehavior>(
        data_value, output);
  }
  EditingBehavior editing_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EditingBehavior>(data_->editing_behavior));
  }
  bool supports_multiple_windows() const {
    return data_->supports_multiple_windows;
  }
  bool viewport_enabled() const {
    return data_->viewport_enabled;
  }
  bool viewport_meta_enabled() const {
    return data_->viewport_meta_enabled;
  }
  bool auto_zoom_focused_editable_to_legible_scale() const {
    return data_->auto_zoom_focused_editable_to_legible_scale;
  }
  bool shrinks_viewport_contents_to_fit() const {
    return data_->shrinks_viewport_contents_to_fit;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadViewportStyle(UserType* output) const {
    auto data_value = data_->viewport_style;
    return mojo::internal::Deserialize<::blink::mojom::ViewportStyle>(
        data_value, output);
  }
  ViewportStyle viewport_style() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ViewportStyle>(data_->viewport_style));
  }
  bool smooth_scroll_for_find_enabled() const {
    return data_->smooth_scroll_for_find_enabled;
  }
  bool main_frame_resizes_are_orientation_changes() const {
    return data_->main_frame_resizes_are_orientation_changes;
  }
  bool initialize_at_minimum_page_scale() const {
    return data_->initialize_at_minimum_page_scale;
  }
  bool smart_insert_delete_enabled() const {
    return data_->smart_insert_delete_enabled;
  }
  bool spatial_navigation_enabled() const {
    return data_->spatial_navigation_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadV8CacheOptions(UserType* output) const {
    auto data_value = data_->v8_cache_options;
    return mojo::internal::Deserialize<::blink::mojom::V8CacheOptions>(
        data_value, output);
  }
  ::blink::mojom::V8CacheOptions v8_cache_options() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::V8CacheOptions>(data_->v8_cache_options));
  }
  bool record_whole_document() const {
    return data_->record_whole_document;
  }
  bool stylus_handwriting_enabled() const {
    return data_->stylus_handwriting_enabled;
  }
  bool cookie_enabled() const {
    return data_->cookie_enabled;
  }
  bool accelerated_video_decode_enabled() const {
    return data_->accelerated_video_decode_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAnimationPolicy(UserType* output) const {
    auto data_value = data_->animation_policy;
    return mojo::internal::Deserialize<::blink::mojom::ImageAnimationPolicy>(
        data_value, output);
  }
  ImageAnimationPolicy animation_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ImageAnimationPolicy>(data_->animation_policy));
  }
  bool user_gesture_required_for_presentation() const {
    return data_->user_gesture_required_for_presentation;
  }
  bool text_tracks_enabled() const {
    return data_->text_tracks_enabled;
  }
  inline void GetTextTrackBackgroundColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackBackgroundColor(UserType* output) {
    
    auto* pointer = data_->text_track_background_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextColor(UserType* output) {
    
    auto* pointer = data_->text_track_text_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextSize(UserType* output) {
    
    auto* pointer = data_->text_track_text_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextShadowDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextShadow(UserType* output) {
    
    auto* pointer = data_->text_track_text_shadow.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontFamilyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontFamily(UserType* output) {
    
    auto* pointer = data_->text_track_font_family.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontStyleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontStyle(UserType* output) {
    
    auto* pointer = data_->text_track_font_style.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontVariantDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontVariant(UserType* output) {
    
    auto* pointer = data_->text_track_font_variant.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackWindowColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackWindowColor(UserType* output) {
    
    auto* pointer = data_->text_track_window_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackWindowRadiusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackWindowRadius(UserType* output) {
    
    auto* pointer = data_->text_track_window_radius.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  float text_track_margin_percentage() const {
    return data_->text_track_margin_percentage;
  }
  bool immersive_mode_enabled() const {
    return data_->immersive_mode_enabled;
  }
  bool double_tap_to_zoom_enabled() const {
    return data_->double_tap_to_zoom_enabled;
  }
  bool fullscreen_supported() const {
    return data_->fullscreen_supported;
  }
  bool text_autosizing_enabled() const {
    return data_->text_autosizing_enabled;
  }
  inline void GetWebAppScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebAppScope(UserType* output) {
    
    auto* pointer = data_->web_app_scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool force_dark_mode_enabled() const {
    return data_->force_dark_mode_enabled;
  }
  float default_minimum_page_scale_factor() const {
    return data_->default_minimum_page_scale_factor;
  }
  float default_maximum_page_scale_factor() const {
    return data_->default_maximum_page_scale_factor;
  }
  bool hide_download_ui() const {
    return data_->hide_download_ui;
  }
  bool presentation_receiver() const {
    return data_->presentation_receiver;
  }
  bool media_controls_enabled() const {
    return data_->media_controls_enabled;
  }
  bool do_not_update_selection_on_mutating_selection_range() const {
    return data_->do_not_update_selection_on_mutating_selection_range;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAutoplayPolicy(UserType* output) const {
    auto data_value = data_->autoplay_policy;
    return mojo::internal::Deserialize<::blink::mojom::AutoplayPolicy>(
        data_value, output);
  }
  AutoplayPolicy autoplay_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AutoplayPolicy>(data_->autoplay_policy));
  }
  bool require_transient_activation_for_get_display_media() const {
    return data_->require_transient_activation_for_get_display_media;
  }
  bool require_transient_activation_for_show_file_or_directory_picker() const {
    return data_->require_transient_activation_for_show_file_or_directory_picker;
  }
  bool require_transient_activation_and_user_confirmation_for_subapps_api() const {
    return data_->require_transient_activation_and_user_confirmation_for_subapps_api;
  }
  bool in_forced_colors() const {
    return data_->in_forced_colors;
  }
  bool is_forced_colors_disabled() const {
    return data_->is_forced_colors_disabled;
  }
  inline void GetRootScrollbarThemeColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootScrollbarThemeColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `root_scrollbar_theme_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRootScrollbarThemeColor` instead "
    "of `ReadRootScrollbarThemeColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root_scrollbar_theme_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredRootScrollbarColorScheme(UserType* output) const {
    auto data_value = data_->preferred_root_scrollbar_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }
  ::blink::mojom::PreferredColorScheme preferred_root_scrollbar_color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredColorScheme>(data_->preferred_root_scrollbar_color_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredColorScheme(UserType* output) const {
    auto data_value = data_->preferred_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }
  ::blink::mojom::PreferredColorScheme preferred_color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredColorScheme>(data_->preferred_color_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredContrast(UserType* output) const {
    auto data_value = data_->preferred_contrast;
    return mojo::internal::Deserialize<::blink::mojom::PreferredContrast>(
        data_value, output);
  }
  ::blink::mojom::PreferredContrast preferred_contrast() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredContrast>(data_->preferred_contrast));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLowPriorityIframesThreshold(UserType* output) const {
    auto data_value = data_->low_priority_iframes_threshold;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }
  EffectiveConnectionType low_priority_iframes_threshold() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EffectiveConnectionType>(data_->low_priority_iframes_threshold));
  }
  bool picture_in_picture_enabled() const {
    return data_->picture_in_picture_enabled;
  }
  bool translate_service_available() const {
    return data_->translate_service_available;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkQualityEstimatorWebHoldback(UserType* output) const {
    auto data_value = data_->network_quality_estimator_web_holdback;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }
  EffectiveConnectionType network_quality_estimator_web_holdback() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EffectiveConnectionType>(data_->network_quality_estimator_web_holdback));
  }
  bool lazy_load_enabled() const {
    return data_->lazy_load_enabled;
  }
  bool allow_mixed_content_upgrades() const {
    return data_->allow_mixed_content_upgrades;
  }
  bool always_show_focus() const {
    return data_->always_show_focus;
  }
  bool touch_drag_drop_enabled() const {
    return data_->touch_drag_drop_enabled;
  }
  bool touch_dragend_context_menu() const {
    return data_->touch_dragend_context_menu;
  }
  bool webxr_immersive_ar_allowed() const {
    return data_->webxr_immersive_ar_allowed;
  }
  bool renderer_wide_named_frame_lookup() const {
    return data_->renderer_wide_named_frame_lookup;
  }
  bool strict_mime_type_check_for_worker_scripts_enabled() const {
    return data_->strict_mime_type_check_for_worker_scripts_enabled;
  }
  bool modal_context_menu() const {
    return data_->modal_context_menu;
  }
  bool dynamic_safe_area_insets_enabled() const {
    return data_->dynamic_safe_area_insets_enabled;
  }
  bool payment_request_enabled() const {
    return data_->payment_request_enabled;
  }
  bool api_based_fingerprinting_interventions_enabled() const {
    return data_->api_based_fingerprinting_interventions_enabled;
  }
  bool content_based_fingerprinting_protection_enabled() const {
    return data_->content_based_fingerprinting_protection_enabled;
  }
  bool ai_prompt_api_enabled() const {
    return data_->ai_prompt_api_enabled;
  }
 private:
  internal::WebPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_DATA_VIEW_H_