// third_party/blink/public/mojom/webid/federated_auth_request.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT FederatedAuthRequestInterceptorForTesting : public FederatedAuthRequest {
  virtual FederatedAuthRequest* GetForwardingInterface() = 0;
  void RequestToken(std::vector<IdentityProviderGetParametersPtr> idp_get_params, ::password_manager::CredentialMediationRequirement requirement, RequestTokenCallback callback) override;
  void RequestUserInfo(IdentityProviderConfigPtr provider, RequestUserInfoCallback callback) override;
  void CancelTokenRequest() override;
  void ResolveTokenRequest(const std::optional<std::string>& account_id, const std::string& token, ResolveTokenRequestCallback callback) override;
  void SetIdpSigninStatus(const ::url::Origin& origin, IdpSigninStatus status, const std::optional<::blink::common::webid::LoginStatusOptions>& options, SetIdpSigninStatusCallback callback) override;
  void RegisterIdP(const ::GURL& url, RegisterIdPCallback callback) override;
  void UnregisterIdP(const ::GURL& url, UnregisterIdPCallback callback) override;
  void CloseModalDialogView() override;
  void PreventSilentAccess(PreventSilentAccessCallback callback) override;
  void Disconnect(IdentityCredentialDisconnectOptionsPtr options, DisconnectCallback callback) override;
};
class BLINK_COMMON_EXPORT FederatedAuthRequestAsyncWaiter {
 public:
  explicit FederatedAuthRequestAsyncWaiter(FederatedAuthRequest* proxy);

  FederatedAuthRequestAsyncWaiter(const FederatedAuthRequestAsyncWaiter&) = delete;
  FederatedAuthRequestAsyncWaiter& operator=(const FederatedAuthRequestAsyncWaiter&) = delete;

  ~FederatedAuthRequestAsyncWaiter();
  void RequestToken(
      std::vector<IdentityProviderGetParametersPtr> idp_get_params, ::password_manager::CredentialMediationRequirement requirement, RequestTokenStatus* out_status, std::optional<::GURL>* out_selected_identity_provider_config_url, std::optional<::base::Value>* out_token, TokenErrorPtr* out_error, bool* out_is_auto_selected);
  
  void RequestUserInfo(
      IdentityProviderConfigPtr provider, RequestUserInfoStatus* out_status, std::optional<std::vector<IdentityUserInfoPtr>>* out_user_info);
  
  void ResolveTokenRequest(
      const std::optional<std::string>& account_id, const std::string& token, bool* out_success);
  bool ResolveTokenRequest(const std::optional<std::string>& account_id, const std::string& token);
  void SetIdpSigninStatus(
      const ::url::Origin& origin, IdpSigninStatus status, const std::optional<::blink::common::webid::LoginStatusOptions>& options);
  
  void RegisterIdP(
      const ::GURL& url, RegisterIdpStatus* out_status);
  RegisterIdpStatus RegisterIdP(const ::GURL& url);
  void UnregisterIdP(
      const ::GURL& url, bool* out_success);
  bool UnregisterIdP(const ::GURL& url);
  void PreventSilentAccess(
      );
  
  void Disconnect(
      IdentityCredentialDisconnectOptionsPtr options, DisconnectStatus* out_status);
  DisconnectStatus Disconnect(IdentityCredentialDisconnectOptionsPtr options);

 private:
  FederatedAuthRequest* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_TEST_UTILS_H_