// third_party/blink/public/mojom/webid/digital_identity_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace blink::mojom {
class DigitalCredentialGetRequestDataView;

class DigitalCredentialCreateRequestDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DigitalCredentialGetRequestDataView> {
  using Data = ::blink::mojom::internal::DigitalCredentialGetRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DigitalCredentialCreateRequestDataView> {
  using Data = ::blink::mojom::internal::DigitalCredentialCreateRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class RequestDigitalIdentityStatus : int32_t {
  
  kSuccess = 0,
  
  kError = 1,
  
  kErrorTooManyRequests = 2,
  
  kErrorCanceled = 3,
  
  kErrorNoRequests = 4,
  
  kErrorNoTransientUserActivation = 5,
  
  kErrorInvalidJson = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RequestDigitalIdentityStatus value);
inline bool IsKnownEnumValue(RequestDigitalIdentityStatus value) {
  return internal::RequestDigitalIdentityStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DigitalIdentityRequestInterfaceBase {};

using DigitalIdentityRequestPtrDataView =
    mojo::InterfacePtrDataView<DigitalIdentityRequestInterfaceBase>;
using DigitalIdentityRequestRequestDataView =
    mojo::InterfaceRequestDataView<DigitalIdentityRequestInterfaceBase>;
using DigitalIdentityRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DigitalIdentityRequestInterfaceBase>;
using DigitalIdentityRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DigitalIdentityRequestInterfaceBase>;


class DigitalCredentialGetRequestDataView {
 public:
  DigitalCredentialGetRequestDataView() = default;

  DigitalCredentialGetRequestDataView(
      internal::DigitalCredentialGetRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::DigitalCredentialGetRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DigitalCredentialCreateRequestDataView {
 public:
  DigitalCredentialCreateRequestDataView() = default;

  DigitalCredentialCreateRequestDataView(
      internal::DigitalCredentialCreateRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::DigitalCredentialCreateRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_DATA_VIEW_H_