// third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AuthenticatorStatusToStringHelper(AuthenticatorStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorStatus::SUCCESS:
      return "SUCCESS";
    case AuthenticatorStatus::PENDING_REQUEST:
      return "PENDING_REQUEST";
    case AuthenticatorStatus::NOT_ALLOWED_ERROR:
      return "NOT_ALLOWED_ERROR";
    case AuthenticatorStatus::INVALID_DOMAIN:
      return "INVALID_DOMAIN";
    case AuthenticatorStatus::CREDENTIAL_EXCLUDED:
      return "CREDENTIAL_EXCLUDED";
    case AuthenticatorStatus::NOT_IMPLEMENTED:
      return "NOT_IMPLEMENTED";
    case AuthenticatorStatus::NOT_FOCUSED:
      return "NOT_FOCUSED";
    case AuthenticatorStatus::RESIDENT_CREDENTIALS_UNSUPPORTED:
      return "RESIDENT_CREDENTIALS_UNSUPPORTED";
    case AuthenticatorStatus::USER_VERIFICATION_UNSUPPORTED:
      return "USER_VERIFICATION_UNSUPPORTED";
    case AuthenticatorStatus::ALGORITHM_UNSUPPORTED:
      return "ALGORITHM_UNSUPPORTED";
    case AuthenticatorStatus::EMPTY_ALLOW_CREDENTIALS:
      return "EMPTY_ALLOW_CREDENTIALS";
    case AuthenticatorStatus::ANDROID_NOT_SUPPORTED_ERROR:
      return "ANDROID_NOT_SUPPORTED_ERROR";
    case AuthenticatorStatus::PROTECTION_POLICY_INCONSISTENT:
      return "PROTECTION_POLICY_INCONSISTENT";
    case AuthenticatorStatus::ABORT_ERROR:
      return "ABORT_ERROR";
    case AuthenticatorStatus::OPAQUE_DOMAIN:
      return "OPAQUE_DOMAIN";
    case AuthenticatorStatus::INVALID_PROTOCOL:
      return "INVALID_PROTOCOL";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID:
      return "BAD_RELYING_PARTY_ID";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH:
      return "BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE:
      return "BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR:
      return "BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID_NO_JSON_MATCH:
      return "BAD_RELYING_PARTY_ID_NO_JSON_MATCH";
    case AuthenticatorStatus::BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS:
      return "BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS";
    case AuthenticatorStatus::CANNOT_READ_AND_WRITE_LARGE_BLOB:
      return "CANNOT_READ_AND_WRITE_LARGE_BLOB";
    case AuthenticatorStatus::INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB:
      return "INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB";
    case AuthenticatorStatus::FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION:
      return "FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION";
    case AuthenticatorStatus::REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED:
      return "REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED";
    case AuthenticatorStatus::DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED:
      return "DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED";
    case AuthenticatorStatus::CERTIFICATE_ERROR:
      return "CERTIFICATE_ERROR";
    case AuthenticatorStatus::ERROR_WITH_DOM_EXCEPTION_DETAILS:
      return "ERROR_WITH_DOM_EXCEPTION_DETAILS";
    case AuthenticatorStatus::IMMEDIATE_NOT_FOUND:
      return "IMMEDIATE_NOT_FOUND";
    case AuthenticatorStatus::UNKNOWN_ERROR:
      return "UNKNOWN_ERROR";
    default:
      return nullptr;
  }
}

std::string AuthenticatorStatusToString(AuthenticatorStatus value) {
  const char *str = AuthenticatorStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorStatus value) {
  return os << AuthenticatorStatusToString(value);
}

NOINLINE static const char* AuthenticatorTransportToStringHelper(AuthenticatorTransport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorTransport::USB:
      return "USB";
    case AuthenticatorTransport::NFC:
      return "NFC";
    case AuthenticatorTransport::BLE:
      return "BLE";
    case AuthenticatorTransport::HYBRID:
      return "HYBRID";
    case AuthenticatorTransport::INTERNAL:
      return "INTERNAL";
    default:
      return nullptr;
  }
}

std::string AuthenticatorTransportToString(AuthenticatorTransport value) {
  const char *str = AuthenticatorTransportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorTransport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorTransport value) {
  return os << AuthenticatorTransportToString(value);
}

NOINLINE static const char* HintToStringHelper(Hint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Hint::SECURITY_KEY:
      return "SECURITY_KEY";
    case Hint::CLIENT_DEVICE:
      return "CLIENT_DEVICE";
    case Hint::HYBRID:
      return "HYBRID";
    default:
      return nullptr;
  }
}

std::string HintToString(Hint value) {
  const char *str = HintToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Hint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Hint value) {
  return os << HintToString(value);
}

NOINLINE static const char* UserVerificationRequirementToStringHelper(UserVerificationRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserVerificationRequirement::REQUIRED:
      return "REQUIRED";
    case UserVerificationRequirement::PREFERRED:
      return "PREFERRED";
    case UserVerificationRequirement::DISCOURAGED:
      return "DISCOURAGED";
    default:
      return nullptr;
  }
}

std::string UserVerificationRequirementToString(UserVerificationRequirement value) {
  const char *str = UserVerificationRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserVerificationRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserVerificationRequirement value) {
  return os << UserVerificationRequirementToString(value);
}

NOINLINE static const char* MediationToStringHelper(Mediation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Mediation::MODAL:
      return "MODAL";
    case Mediation::CONDITIONAL:
      return "CONDITIONAL";
    case Mediation::IMMEDIATE:
      return "IMMEDIATE";
    default:
      return nullptr;
  }
}

std::string MediationToString(Mediation value) {
  const char *str = MediationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Mediation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Mediation value) {
  return os << MediationToString(value);
}

NOINLINE static const char* ResidentKeyRequirementToStringHelper(ResidentKeyRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResidentKeyRequirement::DISCOURAGED:
      return "DISCOURAGED";
    case ResidentKeyRequirement::PREFERRED:
      return "PREFERRED";
    case ResidentKeyRequirement::REQUIRED:
      return "REQUIRED";
    default:
      return nullptr;
  }
}

std::string ResidentKeyRequirementToString(ResidentKeyRequirement value) {
  const char *str = ResidentKeyRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResidentKeyRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResidentKeyRequirement value) {
  return os << ResidentKeyRequirementToString(value);
}

NOINLINE static const char* AuthenticatorAttachmentToStringHelper(AuthenticatorAttachment value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuthenticatorAttachment::NO_PREFERENCE:
      return "NO_PREFERENCE";
    case AuthenticatorAttachment::PLATFORM:
      return "PLATFORM";
    case AuthenticatorAttachment::CROSS_PLATFORM:
      return "CROSS_PLATFORM";
    default:
      return nullptr;
  }
}

std::string AuthenticatorAttachmentToString(AuthenticatorAttachment value) {
  const char *str = AuthenticatorAttachmentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuthenticatorAttachment value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuthenticatorAttachment value) {
  return os << AuthenticatorAttachmentToString(value);
}

NOINLINE static const char* ProtectionPolicyToStringHelper(ProtectionPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProtectionPolicy::UNSPECIFIED:
      return "UNSPECIFIED";
    case ProtectionPolicy::NONE:
      return "NONE";
    case ProtectionPolicy::UV_OR_CRED_ID_REQUIRED:
      return "UV_OR_CRED_ID_REQUIRED";
    case ProtectionPolicy::UV_REQUIRED:
      return "UV_REQUIRED";
    default:
      return nullptr;
  }
}

std::string ProtectionPolicyToString(ProtectionPolicy value) {
  const char *str = ProtectionPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProtectionPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProtectionPolicy value) {
  return os << ProtectionPolicyToString(value);
}

NOINLINE static const char* LargeBlobSupportToStringHelper(LargeBlobSupport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LargeBlobSupport::NOT_REQUESTED:
      return "NOT_REQUESTED";
    case LargeBlobSupport::REQUIRED:
      return "REQUIRED";
    case LargeBlobSupport::PREFERRED:
      return "PREFERRED";
    default:
      return nullptr;
  }
}

std::string LargeBlobSupportToString(LargeBlobSupport value) {
  const char *str = LargeBlobSupportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LargeBlobSupport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LargeBlobSupport value) {
  return os << LargeBlobSupportToString(value);
}

NOINLINE static const char* AttestationConveyancePreferenceToStringHelper(AttestationConveyancePreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AttestationConveyancePreference::NONE:
      return "NONE";
    case AttestationConveyancePreference::INDIRECT:
      return "INDIRECT";
    case AttestationConveyancePreference::DIRECT:
      return "DIRECT";
    case AttestationConveyancePreference::ENTERPRISE:
      return "ENTERPRISE";
    default:
      return nullptr;
  }
}

std::string AttestationConveyancePreferenceToString(AttestationConveyancePreference value) {
  const char *str = AttestationConveyancePreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AttestationConveyancePreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AttestationConveyancePreference value) {
  return os << AttestationConveyancePreferenceToString(value);
}

NOINLINE static const char* PublicKeyCredentialTypeToStringHelper(PublicKeyCredentialType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PublicKeyCredentialType::PUBLIC_KEY:
      return "PUBLIC_KEY";
    default:
      return nullptr;
  }
}

std::string PublicKeyCredentialTypeToString(PublicKeyCredentialType value) {
  const char *str = PublicKeyCredentialTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PublicKeyCredentialType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PublicKeyCredentialType value) {
  return os << PublicKeyCredentialTypeToString(value);
}

namespace internal {
// static
bool GetCredentialResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetCredentialResponse_Data* object = static_cast<const GetCredentialResponse_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetCredentialResponse_Tag::kGetAssertionResponse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_get_assertion_response, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_get_assertion_response, validation_context))
        return false;
      return true;
    }
    case GetCredentialResponse_Tag::kPasswordResponse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_password_response, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_password_response, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetCredentialResponse");
      return false;
    }
  }
}


// static
bool CommonCredentialInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommonCredentialInfo_Data* object =
      static_cast<const CommonCredentialInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_id, validation_context,
                                         &raw_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_data_json, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_data_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_data_json, validation_context,
                                         &client_data_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->authenticator_data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& authenticator_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->authenticator_data, validation_context,
                                         &authenticator_data_validate_params)) {
    return false;
  }

  return true;
}

CommonCredentialInfo_Data::CommonCredentialInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SupplementalPubKeysResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupplementalPubKeysResponse_Data* object =
      static_cast<const SupplementalPubKeysResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signatures, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->signatures, validation_context,
                                         &signatures_validate_params)) {
    return false;
  }

  return true;
}

SupplementalPubKeysResponse_Data::SupplementalPubKeysResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationExtensionsPaymentResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthenticationExtensionsPaymentResponse_Data* object =
      static_cast<const AuthenticationExtensionsPaymentResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_bound_signature, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& browser_bound_signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_bound_signature, validation_context,
                                         &browser_bound_signature_validate_params)) {
    return false;
  }

  return true;
}

AuthenticationExtensionsPaymentResponse_Data::AuthenticationExtensionsPaymentResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MakeCredentialAuthenticatorResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MakeCredentialAuthenticatorResponse_Data* object =
      static_cast<const MakeCredentialAuthenticatorResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;


  if (!::blink::mojom::internal::AuthenticatorAttachment_Data
        ::Validate(object->authenticator_attachment, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attestation_object, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attestation_object_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attestation_object, validation_context,
                                         &attestation_object_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transports, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->transports, validation_context,
                                         &transports_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->prf_results, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& public_key_der_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_key_der, validation_context,
                                         &public_key_der_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->supplemental_pub_keys, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->payment, validation_context))
    return false;

  return true;
}

MakeCredentialAuthenticatorResponse_Data::MakeCredentialAuthenticatorResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetAssertionAuthenticatorResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetAssertionAuthenticatorResponse_Data* object =
      static_cast<const GetAssertionAuthenticatorResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;


  if (!::blink::mojom::internal::AuthenticatorAttachment_Data
        ::Validate(object->authenticator_attachment, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& user_handle_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_handle, validation_context,
                                         &user_handle_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extensions, validation_context))
    return false;

  return true;
}

GetAssertionAuthenticatorResponse_Data::GetAssertionAuthenticatorResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationExtensionsClientOutputs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthenticationExtensionsClientOutputs_Data* object =
      static_cast<const AuthenticationExtensionsClientOutputs_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->prf_results, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& large_blob_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->large_blob, validation_context,
                                         &large_blob_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& get_cred_blob_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->get_cred_blob, validation_context,
                                         &get_cred_blob_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->supplemental_pub_keys, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->payment, validation_context))
    return false;

  return true;
}

AuthenticationExtensionsClientOutputs_Data::AuthenticationExtensionsClientOutputs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialRpEntity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialRpEntity_Data* object =
      static_cast<const PublicKeyCredentialRpEntity_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialRpEntity_Data::PublicKeyCredentialRpEntity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialUserEntity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialUserEntity_Data* object =
      static_cast<const PublicKeyCredentialUserEntity_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialUserEntity_Data::PublicKeyCredentialUserEntity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialParameters_Data* object =
      static_cast<const PublicKeyCredentialParameters_Data*>(data);


  if (!::blink::mojom::internal::PublicKeyCredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

PublicKeyCredentialParameters_Data::PublicKeyCredentialParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CableAuthentication_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CableAuthentication_Data* object =
      static_cast<const CableAuthentication_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& client_eid_validate_params =
      mojo::internal::GetArrayValidator<16, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_eid, validation_context,
                                         &client_eid_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& authenticator_eid_validate_params =
      mojo::internal::GetArrayValidator<16, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->authenticator_eid, validation_context,
                                         &authenticator_eid_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& session_pre_key_validate_params =
      mojo::internal::GetArrayValidator<32, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_pre_key, validation_context,
                                         &session_pre_key_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& server_link_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->server_link_data, validation_context,
                                         &server_link_data_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& experiments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->experiments, validation_context,
                                         &experiments_validate_params)) {
    return false;
  }

  return true;
}

CableAuthentication_Data::CableAuthentication_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PRFValues_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PRFValues_Data* object =
      static_cast<const PRFValues_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->first, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& first_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->first, validation_context,
                                         &first_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& second_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->second, validation_context,
                                         &second_validate_params)) {
    return false;
  }

  return true;
}

PRFValues_Data::PRFValues_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentOptions_Data* object =
      static_cast<const PaymentOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& payee_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payee_name, validation_context,
                                         &payee_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->payee_origin, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& payment_entities_logos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payment_entities_logos, validation_context,
                                         &payment_entities_logos_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& browser_bound_public_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_bound_public_key, validation_context,
                                         &browser_bound_public_key_validate_params)) {
    return false;
  }

  return true;
}

PaymentOptions_Data::PaymentOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentCredentialInstrument_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentCredentialInstrument_Data* object =
      static_cast<const PaymentCredentialInstrument_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

PaymentCredentialInstrument_Data::PaymentCredentialInstrument_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShownPaymentEntityLogo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShownPaymentEntityLogo_Data* object =
      static_cast<const ShownPaymentEntityLogo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ShownPaymentEntityLogo_Data::ShownPaymentEntityLogo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteDesktopClientOverride_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteDesktopClientOverride_Data* object =
      static_cast<const RemoteDesktopClientOverride_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

RemoteDesktopClientOverride_Data::RemoteDesktopClientOverride_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SupplementalPubKeysRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupplementalPubKeysRequest_Data* object =
      static_cast<const SupplementalPubKeysRequest_Data*>(data);


  if (!::blink::mojom::internal::AttestationConveyancePreference_Data
        ::Validate(object->attestation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attestation_formats, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attestation_formats_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->attestation_formats, validation_context,
                                         &attestation_formats_validate_params)) {
    return false;
  }

  return true;
}

SupplementalPubKeysRequest_Data::SupplementalPubKeysRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialRequestOptions_Data* object =
      static_cast<const PublicKeyCredentialRequestOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->challenge_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relying_party_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->relying_party_id, validation_context,
                                         &relying_party_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allow_credentials, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allow_credentials_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->allow_credentials, validation_context,
                                         &allow_credentials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hints, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hints_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::Hint_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->hints, validation_context,
                                         &hints_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extensions, validation_context))
    return false;

  return true;
}

PublicKeyCredentialRequestOptions_Data::PublicKeyCredentialRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationExtensionsClientInputs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthenticationExtensionsClientInputs_Data* object =
      static_cast<const AuthenticationExtensionsClientInputs_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& appid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->appid, validation_context,
                                         &appid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cable_authentication_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cable_authentication_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cable_authentication_data, validation_context,
                                         &cable_authentication_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prf_inputs, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prf_inputs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prf_inputs, validation_context,
                                         &prf_inputs_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& large_blob_write_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->large_blob_write, validation_context,
                                         &large_blob_write_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->remote_desktop_client_override, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->supplemental_pub_keys, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& payment_browser_bound_key_parameters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payment_browser_bound_key_parameters, validation_context,
                                         &payment_browser_bound_key_parameters_validate_params)) {
    return false;
  }

  return true;
}

AuthenticationExtensionsClientInputs_Data::AuthenticationExtensionsClientInputs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetCredentialOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetCredentialOptions_Data* object =
      static_cast<const GetCredentialOptions_Data*>(data);


  if (!::blink::mojom::internal::Mediation_Data
        ::Validate(object->mediation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  return true;
}

GetCredentialOptions_Data::GetCredentialOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticatorSelectionCriteria_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthenticatorSelectionCriteria_Data* object =
      static_cast<const AuthenticatorSelectionCriteria_Data*>(data);


  if (!::blink::mojom::internal::AuthenticatorAttachment_Data
        ::Validate(object->authenticator_attachment, validation_context))
    return false;


  if (!::blink::mojom::internal::ResidentKeyRequirement_Data
        ::Validate(object->resident_key, validation_context))
    return false;


  if (!::blink::mojom::internal::UserVerificationRequirement_Data
        ::Validate(object->user_verification, validation_context))
    return false;

  return true;
}

AuthenticatorSelectionCriteria_Data::AuthenticatorSelectionCriteria_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialCreationOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialCreationOptions_Data* object =
      static_cast<const PublicKeyCredentialCreationOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relying_party, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key_parameters, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& public_key_parameters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_key_parameters, validation_context,
                                         &public_key_parameters_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclude_credentials, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& exclude_credentials_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->exclude_credentials, validation_context,
                                         &exclude_credentials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->authenticator_selection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hints, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hints_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::Hint_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->hints, validation_context,
                                         &hints_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::AttestationConveyancePreference_Data
        ::Validate(object->attestation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->prf_input, validation_context))
    return false;


  if (!::blink::mojom::internal::ProtectionPolicy_Data
        ::Validate(object->protection_policy, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& appid_exclude_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->appid_exclude, validation_context,
                                         &appid_exclude_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::LargeBlobSupport_Data
        ::Validate(object->large_blob_enable, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& cred_blob_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cred_blob, validation_context,
                                         &cred_blob_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->remote_desktop_client_override, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->supplemental_pub_keys, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& payment_browser_bound_key_parameters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payment_browser_bound_key_parameters, validation_context,
                                         &payment_browser_bound_key_parameters_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attestation_formats, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attestation_formats_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->attestation_formats, validation_context,
                                         &attestation_formats_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialCreationOptions_Data::PublicKeyCredentialCreationOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialDescriptor_Data* object =
      static_cast<const PublicKeyCredentialDescriptor_Data*>(data);


  if (!::blink::mojom::internal::PublicKeyCredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transports, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->transports, validation_context,
                                         &transports_validate_params)) {
    return false;
  }

  return true;
}

PublicKeyCredentialDescriptor_Data::PublicKeyCredentialDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAuthnDOMExceptionDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAuthnDOMExceptionDetails_Data* object =
      static_cast<const WebAuthnDOMExceptionDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

WebAuthnDOMExceptionDetails_Data::WebAuthnDOMExceptionDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PublicKeyCredentialReportOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PublicKeyCredentialReportOptions_Data* object =
      static_cast<const PublicKeyCredentialReportOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relying_party_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relying_party_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->relying_party_id, validation_context,
                                         &relying_party_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& unknown_credential_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->unknown_credential_id, validation_context,
                                         &unknown_credential_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->all_accepted_credentials, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->current_user_details, validation_context))
    return false;

  return true;
}

PublicKeyCredentialReportOptions_Data::PublicKeyCredentialReportOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AllAcceptedCredentialsOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AllAcceptedCredentialsOptions_Data* object =
      static_cast<const AllAcceptedCredentialsOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_accepted_credentials_ids, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_accepted_credentials_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->all_accepted_credentials_ids, validation_context,
                                         &all_accepted_credentials_ids_validate_params)) {
    return false;
  }

  return true;
}

AllAcceptedCredentialsOptions_Data::AllAcceptedCredentialsOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CurrentUserDetailsOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CurrentUserDetailsOptions_Data* object =
      static_cast<const CurrentUserDetailsOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  return true;
}

CurrentUserDetailsOptions_Data::CurrentUserDetailsOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebAuthnClientCapability_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebAuthnClientCapability_Data* object =
      static_cast<const WebAuthnClientCapability_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

WebAuthnClientCapability_Data::WebAuthnClientCapability_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetAssertionResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetAssertionResponse_Data* object =
      static_cast<const GetAssertionResponse_Data*>(data);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dom_exception_details, validation_context))
    return false;

  return true;
}

GetAssertionResponse_Data::GetAssertionResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_MakeCredential_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_MakeCredential_Params_Data* object =
      static_cast<const Authenticator_MakeCredential_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Authenticator_MakeCredential_Params_Data::Authenticator_MakeCredential_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_MakeCredential_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_MakeCredential_ResponseParams_Data* object =
      static_cast<const Authenticator_MakeCredential_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dom_exception_details, validation_context))
    return false;

  return true;
}

Authenticator_MakeCredential_ResponseParams_Data::Authenticator_MakeCredential_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetCredential_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_GetCredential_Params_Data* object =
      static_cast<const Authenticator_GetCredential_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Authenticator_GetCredential_Params_Data::Authenticator_GetCredential_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetCredential_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_GetCredential_ResponseParams_Data* object =
      static_cast<const Authenticator_GetCredential_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->response, validation_context))
    return false;

  return true;
}

Authenticator_GetCredential_ResponseParams_Data::Authenticator_GetCredential_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* object =
      static_cast<const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data*>(data);

  return true;
}

Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* object =
      static_cast<const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data*>(data);

  return true;
}

Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsConditionalMediationAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_IsConditionalMediationAvailable_Params_Data* object =
      static_cast<const Authenticator_IsConditionalMediationAvailable_Params_Data*>(data);

  return true;
}

Authenticator_IsConditionalMediationAvailable_Params_Data::Authenticator_IsConditionalMediationAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_IsConditionalMediationAvailable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_IsConditionalMediationAvailable_ResponseParams_Data* object =
      static_cast<const Authenticator_IsConditionalMediationAvailable_ResponseParams_Data*>(data);

  return true;
}

Authenticator_IsConditionalMediationAvailable_ResponseParams_Data::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_Report_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_Report_Params_Data* object =
      static_cast<const Authenticator_Report_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

Authenticator_Report_Params_Data::Authenticator_Report_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_Report_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_Report_ResponseParams_Data* object =
      static_cast<const Authenticator_Report_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::AuthenticatorStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dom_exception_details, validation_context))
    return false;

  return true;
}

Authenticator_Report_ResponseParams_Data::Authenticator_Report_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetClientCapabilities_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_GetClientCapabilities_Params_Data* object =
      static_cast<const Authenticator_GetClientCapabilities_Params_Data*>(data);

  return true;
}

Authenticator_GetClientCapabilities_Params_Data::Authenticator_GetClientCapabilities_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_GetClientCapabilities_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_GetClientCapabilities_ResponseParams_Data* object =
      static_cast<const Authenticator_GetClientCapabilities_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capabilities, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->capabilities, validation_context,
                                         &capabilities_validate_params)) {
    return false;
  }

  return true;
}

Authenticator_GetClientCapabilities_ResponseParams_Data::Authenticator_GetClientCapabilities_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Authenticator_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Authenticator_Cancel_Params_Data* object =
      static_cast<const Authenticator_Cancel_Params_Data*>(data);

  return true;
}

Authenticator_Cancel_Params_Data::Authenticator_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorStatus value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorTransport>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorTransport value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorTransportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Hint>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Hint value) {
  return std::move(context).WriteString(::blink::mojom::HintToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::UserVerificationRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::UserVerificationRequirement value) {
  return std::move(context).WriteString(::blink::mojom::UserVerificationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Mediation>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Mediation value) {
  return std::move(context).WriteString(::blink::mojom::MediationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ResidentKeyRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ResidentKeyRequirement value) {
  return std::move(context).WriteString(::blink::mojom::ResidentKeyRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuthenticatorAttachment>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuthenticatorAttachment value) {
  return std::move(context).WriteString(::blink::mojom::AuthenticatorAttachmentToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ProtectionPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ProtectionPolicy value) {
  return std::move(context).WriteString(::blink::mojom::ProtectionPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LargeBlobSupport>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::LargeBlobSupport value) {
  return std::move(context).WriteString(::blink::mojom::LargeBlobSupportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AttestationConveyancePreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AttestationConveyancePreference value) {
  return std::move(context).WriteString(::blink::mojom::AttestationConveyancePreferenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PublicKeyCredentialType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PublicKeyCredentialType value) {
  return std::move(context).WriteString(::blink::mojom::PublicKeyCredentialTypeToString(value));
}

} // namespace perfetto