// third_party/blink/public/mojom/webaudio/audio_context_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-import-headers.h"
#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

AudioContextManager::IPCStableHashFunction AudioContextManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioContextManager>(message.name())) {
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStarted: {
      return &AudioContextManager::AudioContextAudiblePlaybackStarted_Sym::IPCStableHash;
    }
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStopped: {
      return &AudioContextManager::AudioContextAudiblePlaybackStopped_Sym::IPCStableHash;
    }
    case messages::AudioContextManager::kAudioContextCreated: {
      return &AudioContextManager::AudioContextCreated_Sym::IPCStableHash;
    }
    case messages::AudioContextManager::kAudioContextClosed: {
      return &AudioContextManager::AudioContextClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioContextManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioContextManager>(message.name())) {
      case messages::AudioContextManager::kAudioContextAudiblePlaybackStarted:
            return "Receive blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStarted";
      case messages::AudioContextManager::kAudioContextAudiblePlaybackStopped:
            return "Receive blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStopped";
      case messages::AudioContextManager::kAudioContextCreated:
            return "Receive blink::mojom::AudioContextManager::AudioContextCreated";
      case messages::AudioContextManager::kAudioContextClosed:
            return "Receive blink::mojom::AudioContextManager::AudioContextClosed";
    }
  } else {
    switch (static_cast<messages::AudioContextManager>(message.name())) {
      case messages::AudioContextManager::kAudioContextAudiblePlaybackStarted:
            return "Receive reply blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStarted";
      case messages::AudioContextManager::kAudioContextAudiblePlaybackStopped:
            return "Receive reply blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStopped";
      case messages::AudioContextManager::kAudioContextCreated:
            return "Receive reply blink::mojom::AudioContextManager::AudioContextCreated";
      case messages::AudioContextManager::kAudioContextClosed:
            return "Receive reply blink::mojom::AudioContextManager::AudioContextClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioContextManager::AudioContextAudiblePlaybackStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa421ed9;  // IPCStableHash for blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioContextManager::AudioContextAudiblePlaybackStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14ac2ae0;  // IPCStableHash for blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioContextManager::AudioContextCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd43434ba;  // IPCStableHash for blink::mojom::AudioContextManager::AudioContextCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioContextManager::AudioContextClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33644d28;  // IPCStableHash for blink::mojom::AudioContextManager::AudioContextClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioContextManagerProxy::AudioContextManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioContextManagerProxy::AudioContextAudiblePlaybackStarted(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioContextManager::kAudioContextAudiblePlaybackStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AudioContextManager_AudioContextAudiblePlaybackStarted_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioContextManager::Name_);
  message.set_method_name("AudioContextAudiblePlaybackStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioContextManagerProxy::AudioContextAudiblePlaybackStopped(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AudioContextManager::AudioContextAudiblePlaybackStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioContextManager::kAudioContextAudiblePlaybackStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AudioContextManager_AudioContextAudiblePlaybackStopped_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioContextManager::Name_);
  message.set_method_name("AudioContextAudiblePlaybackStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioContextManagerProxy::AudioContextCreated(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AudioContextManager::AudioContextCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioContextManager::kAudioContextCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AudioContextManager_AudioContextCreated_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioContextManager::Name_);
  message.set_method_name("AudioContextCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioContextManagerProxy::AudioContextClosed(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AudioContextManager::AudioContextClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioContextManager::kAudioContextClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AudioContextManager_AudioContextClosed_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioContextManager::Name_);
  message.set_method_name("AudioContextClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioContextManagerStubDispatch::Accept(
    AudioContextManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioContextManager>(message->header()->name)) {
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStarted: {
      DCHECK(message->is_serialized());
      internal::AudioContextManager_AudioContextAudiblePlaybackStarted_Params_Data* params =
          reinterpret_cast<internal::AudioContextManager_AudioContextAudiblePlaybackStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioContextManager.0
      bool success = true;
      uint32_t p_id{};
      AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioContextManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioContextAudiblePlaybackStarted(        
        std::move(p_id));
      return true;
    }
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStopped: {
      DCHECK(message->is_serialized());
      internal::AudioContextManager_AudioContextAudiblePlaybackStopped_Params_Data* params =
          reinterpret_cast<internal::AudioContextManager_AudioContextAudiblePlaybackStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioContextManager.1
      bool success = true;
      uint32_t p_id{};
      AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioContextManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioContextAudiblePlaybackStopped(        
        std::move(p_id));
      return true;
    }
    case messages::AudioContextManager::kAudioContextCreated: {
      DCHECK(message->is_serialized());
      internal::AudioContextManager_AudioContextCreated_Params_Data* params =
          reinterpret_cast<internal::AudioContextManager_AudioContextCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioContextManager.2
      bool success = true;
      uint32_t p_id{};
      AudioContextManager_AudioContextCreated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioContextManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioContextCreated(        
        std::move(p_id));
      return true;
    }
    case messages::AudioContextManager::kAudioContextClosed: {
      DCHECK(message->is_serialized());
      internal::AudioContextManager_AudioContextClosed_Params_Data* params =
          reinterpret_cast<internal::AudioContextManager_AudioContextClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioContextManager.3
      bool success = true;
      uint32_t p_id{};
      AudioContextManager_AudioContextClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioContextManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioContextClosed(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool AudioContextManagerStubDispatch::AcceptWithResponder(
    AudioContextManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioContextManager>(message->header()->name)) {
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStarted: {
      break;
    }
    case messages::AudioContextManager::kAudioContextAudiblePlaybackStopped: {
      break;
    }
    case messages::AudioContextManager::kAudioContextCreated: {
      break;
    }
    case messages::AudioContextManager::kAudioContextClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioContextManagerValidationInfo[] = {
    { &internal::AudioContextManager_AudioContextAudiblePlaybackStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioContextManager_AudioContextAudiblePlaybackStopped_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioContextManager_AudioContextCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioContextManager_AudioContextClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioContextManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AudioContextManager::Name_,
    kAudioContextManagerValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AudioContextManagerInterceptorForTesting::AudioContextAudiblePlaybackStarted(uint32_t id) {
  GetForwardingInterface()->AudioContextAudiblePlaybackStarted(
    std::move(id)
    );
}
void AudioContextManagerInterceptorForTesting::AudioContextAudiblePlaybackStopped(uint32_t id) {
  GetForwardingInterface()->AudioContextAudiblePlaybackStopped(
    std::move(id)
    );
}
void AudioContextManagerInterceptorForTesting::AudioContextCreated(uint32_t id) {
  GetForwardingInterface()->AudioContextCreated(
    std::move(id)
    );
}
void AudioContextManagerInterceptorForTesting::AudioContextClosed(uint32_t id) {
  GetForwardingInterface()->AudioContextClosed(
    std::move(id)
    );
}
AudioContextManagerAsyncWaiter::AudioContextManagerAsyncWaiter(
    AudioContextManager* proxy) : proxy_(proxy) {}

AudioContextManagerAsyncWaiter::~AudioContextManagerAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif