// third_party/blink/public/mojom/web_launch/web_launch.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/web_launch/web_launch.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-params-data.h"
#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-import-headers.h"
#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

WebLaunchService::IPCStableHashFunction WebLaunchService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebLaunchService>(message.name())) {
    case messages::WebLaunchService::kSetLaunchFiles: {
      return &WebLaunchService::SetLaunchFiles_Sym::IPCStableHash;
    }
    case messages::WebLaunchService::kEnqueueLaunchParams: {
      return &WebLaunchService::EnqueueLaunchParams_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebLaunchService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebLaunchService>(message.name())) {
      case messages::WebLaunchService::kSetLaunchFiles:
            return "Receive blink::mojom::WebLaunchService::SetLaunchFiles";
      case messages::WebLaunchService::kEnqueueLaunchParams:
            return "Receive blink::mojom::WebLaunchService::EnqueueLaunchParams";
    }
  } else {
    switch (static_cast<messages::WebLaunchService>(message.name())) {
      case messages::WebLaunchService::kSetLaunchFiles:
            return "Receive reply blink::mojom::WebLaunchService::SetLaunchFiles";
      case messages::WebLaunchService::kEnqueueLaunchParams:
            return "Receive reply blink::mojom::WebLaunchService::EnqueueLaunchParams";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebLaunchService::SetLaunchFiles_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d653b82;  // IPCStableHash for blink::mojom::WebLaunchService::SetLaunchFiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebLaunchService::EnqueueLaunchParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f21983a;  // IPCStableHash for blink::mojom::WebLaunchService::EnqueueLaunchParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebLaunchServiceProxy::WebLaunchServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebLaunchServiceProxy::SetLaunchFiles(
    std::vector<::blink::mojom::FileSystemAccessEntryPtr> in_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebLaunchService::SetLaunchFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type std::vector<::blink::mojom::FileSystemAccessEntryPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebLaunchService::kSetLaunchFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebLaunchService_SetLaunchFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessEntryDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in WebLaunchService.SetLaunchFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebLaunchService::Name_);
  message.set_method_name("SetLaunchFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebLaunchServiceProxy::EnqueueLaunchParams(
    const ::GURL& in_launch_url, ::base::TimeTicks in_time_navigation_started_in_browser, bool in_navigation_started) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebLaunchService::EnqueueLaunchParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_url"), in_launch_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_navigation_started_in_browser"), in_time_navigation_started_in_browser,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_started"), in_navigation_started,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebLaunchService::kEnqueueLaunchParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebLaunchService_EnqueueLaunchParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->launch_url)::BaseType> launch_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_launch_url,
    launch_url_fragment);

  params->launch_url.Set(
      launch_url_fragment.is_null() ? nullptr : launch_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->launch_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null launch_url in WebLaunchService.EnqueueLaunchParams request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_navigation_started_in_browser)::BaseType> time_navigation_started_in_browser_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_time_navigation_started_in_browser,
    time_navigation_started_in_browser_fragment);

  params->time_navigation_started_in_browser.Set(
      time_navigation_started_in_browser_fragment.is_null() ? nullptr : time_navigation_started_in_browser_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time_navigation_started_in_browser.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time_navigation_started_in_browser in WebLaunchService.EnqueueLaunchParams request");

  params->navigation_started = in_navigation_started;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebLaunchService::Name_);
  message.set_method_name("EnqueueLaunchParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebLaunchServiceStubDispatch::Accept(
    WebLaunchService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebLaunchService>(message->header()->name)) {
    case messages::WebLaunchService::kSetLaunchFiles: {
      DCHECK(message->is_serialized());
      internal::WebLaunchService_SetLaunchFiles_Params_Data* params =
          reinterpret_cast<internal::WebLaunchService_SetLaunchFiles_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebLaunchService.0
      bool success = true;
      std::vector<::blink::mojom::FileSystemAccessEntryPtr> p_files{};
      WebLaunchService_SetLaunchFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebLaunchService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLaunchFiles(        
        std::move(p_files));
      return true;
    }
    case messages::WebLaunchService::kEnqueueLaunchParams: {
      DCHECK(message->is_serialized());
      internal::WebLaunchService_EnqueueLaunchParams_Params_Data* params =
          reinterpret_cast<internal::WebLaunchService_EnqueueLaunchParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebLaunchService.1
      bool success = true;
      ::GURL p_launch_url{};
      ::base::TimeTicks p_time_navigation_started_in_browser{};
      bool p_navigation_started{};
      WebLaunchService_EnqueueLaunchParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLaunchUrl(&p_launch_url))
        success = false;
      if (success && !input_data_view.ReadTimeNavigationStartedInBrowser(&p_time_navigation_started_in_browser))
        success = false;
      if (success)
        p_navigation_started = input_data_view.navigation_started();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebLaunchService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnqueueLaunchParams(        
        std::move(p_launch_url), 
        std::move(p_time_navigation_started_in_browser), 
        std::move(p_navigation_started));
      return true;
    }
  }
  return false;
}

// static
bool WebLaunchServiceStubDispatch::AcceptWithResponder(
    WebLaunchService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebLaunchService>(message->header()->name)) {
    case messages::WebLaunchService::kSetLaunchFiles: {
      break;
    }
    case messages::WebLaunchService::kEnqueueLaunchParams: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebLaunchServiceValidationInfo[] = {
    { &internal::WebLaunchService_SetLaunchFiles_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebLaunchService_EnqueueLaunchParams_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebLaunchServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebLaunchService::Name_,
    kWebLaunchServiceValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void WebLaunchServiceInterceptorForTesting::SetLaunchFiles(std::vector<::blink::mojom::FileSystemAccessEntryPtr> files) {
  GetForwardingInterface()->SetLaunchFiles(
    std::move(files)
    );
}
void WebLaunchServiceInterceptorForTesting::EnqueueLaunchParams(const ::GURL& launch_url, ::base::TimeTicks time_navigation_started_in_browser, bool navigation_started) {
  GetForwardingInterface()->EnqueueLaunchParams(
    std::move(launch_url)
    , 
    std::move(time_navigation_started_in_browser)
    , 
    std::move(navigation_started)
    );
}
WebLaunchServiceAsyncWaiter::WebLaunchServiceAsyncWaiter(
    WebLaunchService* proxy) : proxy_(proxy) {}

WebLaunchServiceAsyncWaiter::~WebLaunchServiceAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif