// third_party/blink/public/mojom/web_install/web_install.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/web_install/web_install.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/web_install/web_install.mojom-params-data.h"
#include "third_party/blink/public/mojom/web_install/web_install.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/web_install/web_install.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/web_install/web_install.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
InstallOptions::InstallOptions()
    : install_url(),
      manifest_id() {}

InstallOptions::InstallOptions(
    const ::blink::KURL& install_url_in,
    const std::optional<::blink::KURL>& manifest_id_in)
    : install_url(std::move(install_url_in)),
      manifest_id(std::move(manifest_id_in)) {}

InstallOptions::~InstallOptions() = default;

void InstallOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_url"), this->install_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_id"), this->manifest_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InstallOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebInstallService::IPCStableHashFunction WebInstallService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebInstallService>(message.name())) {
    case messages::WebInstallService::kInstall: {
      return &WebInstallService::Install_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebInstallService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebInstallService>(message.name())) {
      case messages::WebInstallService::kInstall:
            return "Receive blink::mojom::WebInstallService::Install";
    }
  } else {
    switch (static_cast<messages::WebInstallService>(message.name())) {
      case messages::WebInstallService::kInstall:
            return "Receive reply blink::mojom::WebInstallService::Install";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebInstallService::Install_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee1ca595;  // IPCStableHash for blink::mojom::WebInstallService::Install
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebInstallService_Install_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebInstallService_Install_ForwardToCallback(
      WebInstallService::InstallCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebInstallService_Install_ForwardToCallback(const WebInstallService_Install_ForwardToCallback&) = delete;
  WebInstallService_Install_ForwardToCallback& operator=(const WebInstallService_Install_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebInstallService::InstallCallback callback_;
};

WebInstallServiceProxy::WebInstallServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebInstallServiceProxy::Install(
    InstallOptionsPtr in_options, InstallCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebInstallService::Install", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type InstallOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebInstallService::kInstall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebInstallService_Install_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::InstallOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebInstallService::Name_);
  message.set_method_name("Install");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebInstallService_Install_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebInstallService_Install_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebInstallService::InstallCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebInstallService_Install_ProxyToResponder> proxy(
        new WebInstallService_Install_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebInstallService_Install_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebInstallService_Install_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebInstallService_Install_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebInstallService::InstallCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebInstallServiceResult in_result, const ::blink::KURL& in_manifest_id);
};

bool WebInstallService_Install_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebInstallService_Install_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebInstallService_Install_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebInstallService.0
  bool success = true;
  WebInstallServiceResult p_result{};
  ::blink::KURL p_manifest_id{};
  WebInstallService_Install_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadManifestId(&p_manifest_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebInstallService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_manifest_id));
  }
  return true;
}

void WebInstallService_Install_ProxyToResponder::Run(
    WebInstallServiceResult in_result, const ::blink::KURL& in_manifest_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebInstallService::Install", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebInstallServiceResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest_id"), in_manifest_id,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebInstallService::kInstall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebInstallService_Install_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebInstallServiceResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->manifest_id)::BaseType> manifest_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_manifest_id,
    manifest_id_fragment);

  params->manifest_id.Set(
      manifest_id_fragment.is_null() ? nullptr : manifest_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebInstallService::Name_);
  message.set_method_name("Install");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebInstallServiceStubDispatch::Accept(
    WebInstallService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebInstallService>(message->header()->name)) {
    case messages::WebInstallService::kInstall: {
      break;
    }
  }
  return false;
}

// static
bool WebInstallServiceStubDispatch::AcceptWithResponder(
    WebInstallService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebInstallService>(message->header()->name)) {
    case messages::WebInstallService::kInstall: {
      internal::WebInstallService_Install_Params_Data* params =
          reinterpret_cast<
              internal::WebInstallService_Install_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebInstallService.0
      bool success = true;
      InstallOptionsPtr p_options{};
      WebInstallService_Install_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebInstallService::Name_, 0, false);
        return false;
      }
      auto callback =
          WebInstallService_Install_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Install(        
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebInstallServiceValidationInfo[] = {
    { &internal::WebInstallService_Install_Params_Data::Validate,
     &internal::WebInstallService_Install_ResponseParams_Data::Validate},
};

bool WebInstallServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebInstallService::Name_,
    kWebInstallServiceValidationInfo);
}

bool WebInstallServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebInstallService::Name_,
    kWebInstallServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::InstallOptions::DataView, ::blink::mojom::blink::InstallOptionsPtr>::Read(
    ::blink::mojom::blink::InstallOptions::DataView input,
    ::blink::mojom::blink::InstallOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InstallOptionsPtr result(::blink::mojom::blink::InstallOptions::New());
  
      if (success && !input.ReadInstallUrl(&result->install_url))
        success = false;
      if (success && !input.ReadManifestId(&result->manifest_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebInstallServiceInterceptorForTesting::Install(InstallOptionsPtr options, InstallCallback callback) {
  GetForwardingInterface()->Install(
    std::move(options)
    , std::move(callback));
}
WebInstallServiceAsyncWaiter::WebInstallServiceAsyncWaiter(
    WebInstallService* proxy) : proxy_(proxy) {}

WebInstallServiceAsyncWaiter::~WebInstallServiceAsyncWaiter() = default;


void WebInstallServiceAsyncWaiter::Install(
    InstallOptionsPtr options, WebInstallServiceResult* out_result, ::blink::KURL* out_manifest_id) {
  base::RunLoop loop;
  proxy_->Install(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebInstallServiceResult* out_result
,
             ::blink::KURL* out_manifest_id
,
             WebInstallServiceResult result,
             const ::blink::KURL& manifest_id) {*out_result = std::move(result);*out_manifest_id = std::move(manifest_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_manifest_id));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif