// third_party/blink/public/mojom/usb/web_usb_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WebUsbServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WebUsbService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.WebUsbServiceInterface }
 */
blink.mojom.WebUsbServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WebUsbServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WebUsbServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WebUsbServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        results: !Array<!device.mojom.UsbDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.WebUsbService_GetDevices_ParamsSpec.$,
        blink.mojom.WebUsbService_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } guid
   * @param { !device.mojom.UsbDevicePendingReceiver } deviceReceiver
   */

  getDevice(
      guid,
      deviceReceiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.WebUsbService_GetDevice_ParamsSpec.$,
        null,
        [
          guid,
          deviceReceiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebUsbRequestDeviceOptions } options
   * @return {!Promise<{
        result: ?device.mojom.UsbDeviceInfo,
   *  }>}
   */

  getPermission(
      options) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.WebUsbService_GetPermission_ParamsSpec.$,
        blink.mojom.WebUsbService_GetPermission_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !string } guid
   * @return {!Promise}
   */

  forgetDevice(
      guid) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.WebUsbService_ForgetDevice_ParamsSpec.$,
        blink.mojom.WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        [
          guid
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        4,
        blink.mojom.WebUsbService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebUsbService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WebUsbServiceReceiver = class {
  /**
   * @param {!blink.mojom.WebUsbServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WebUsbServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WebUsbServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebUsbServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebUsbService_GetDevices_ParamsSpec.$,
        blink.mojom.WebUsbService_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WebUsbService_GetDevice_ParamsSpec.$,
        null,
        impl.getDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WebUsbService_GetPermission_ParamsSpec.$,
        blink.mojom.WebUsbService_GetPermission_ResponseParamsSpec.$,
        impl.getPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WebUsbService_ForgetDevice_ParamsSpec.$,
        blink.mojom.WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        impl.forgetDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WebUsbService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WebUsbService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebUsbService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WebUsbServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WebUsbServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebUsbService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WebUsbServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WebUsbServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WebUsbServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WebUsbService_GetDevices_ParamsSpec.$,
        blink.mojom.WebUsbService_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WebUsbService_GetDevice_ParamsSpec.$,
        null,
        this.getDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WebUsbService_GetPermission_ParamsSpec.$,
        blink.mojom.WebUsbService_GetPermission_ResponseParamsSpec.$,
        this.getPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forgetDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WebUsbService_ForgetDevice_ParamsSpec.$,
        blink.mojom.WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        this.forgetDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WebUsbService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbRequestDeviceOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_GetDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_GetPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_GetPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_ForgetDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_ForgetDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WebUsbService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.WebUsbRequestDeviceOptionsSpec.$,
    'WebUsbRequestDeviceOptions',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(device.mojom.UsbDeviceFilterSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exclusionFilters', 8,
        0,
        mojo.internal.Array(device.mojom.UsbDeviceFilterSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebUsbRequestDeviceOptions = class {
  constructor() {
    /** @export { !Array<!device.mojom.UsbDeviceFilter> } */
    this.filters;
    /** @export { !Array<!device.mojom.UsbDeviceFilter> } */
    this.exclusionFilters;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_GetDevices_ParamsSpec.$,
    'WebUsbService_GetDevices_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.WebUsbService_GetDevices_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_GetDevices_ResponseParamsSpec.$,
    'WebUsbService_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(device.mojom.UsbDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebUsbService_GetDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.UsbDeviceInfo> } */
    this.results;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_GetDevice_ParamsSpec.$,
    'WebUsbService_GetDevice_Params',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(device.mojom.UsbDevicePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.WebUsbService_GetDevice_Params = class {
  constructor() {
    /** @export { !string } */
    this.guid;
    /** @export { !device.mojom.UsbDevicePendingReceiver } */
    this.deviceReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_GetPermission_ParamsSpec.$,
    'WebUsbService_GetPermission_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.WebUsbRequestDeviceOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebUsbService_GetPermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebUsbRequestDeviceOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_GetPermission_ResponseParamsSpec.$,
    'WebUsbService_GetPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.UsbDeviceInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebUsbService_GetPermission_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.UsbDeviceInfo|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_ForgetDevice_ParamsSpec.$,
    'WebUsbService_ForgetDevice_Params',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebUsbService_ForgetDevice_Params = class {
  constructor() {
    /** @export { !string } */
    this.guid;
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_ForgetDevice_ResponseParamsSpec.$,
    'WebUsbService_ForgetDevice_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.WebUsbService_ForgetDevice_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WebUsbService_SetClient_ParamsSpec.$,
    'WebUsbService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.UsbDeviceManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.WebUsbService_SetClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};

