// third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/timing/resource_timing.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::CacheState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CacheState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CacheState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CacheState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServerTimingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServerTimingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServerTimingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ServerTimingInfo struct");

    fragment->duration = Traits::duration(input);

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ServerTimingInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServerTimingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServerTimingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceTimingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceTimingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ResourceTimingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ResourceTimingInfo struct");

    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_time)::BaseType> start_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_start_time,
      start_time_fragment);

    fragment->start_time.Set(
        start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in ResourceTimingInfo struct");

    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_alpn_negotiated_protocol,
      alpn_negotiated_protocol_fragment);

    fragment->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alpn_negotiated_protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alpn_negotiated_protocol in ResourceTimingInfo struct");

    decltype(Traits::connection_info(input)) in_connection_info = Traits::connection_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connection_info)::BaseType> connection_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_connection_info,
      connection_info_fragment);

    fragment->connection_info.Set(
        connection_info_fragment.is_null() ? nullptr : connection_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->connection_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null connection_info in ResourceTimingInfo struct");

    decltype(Traits::timing(input)) in_timing = Traits::timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timing)::BaseType> timing_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
      in_timing,
      timing_fragment);

    fragment->timing.Set(
        timing_fragment.is_null() ? nullptr : timing_fragment.data());

    decltype(Traits::last_redirect_end_time(input)) in_last_redirect_end_time = Traits::last_redirect_end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_redirect_end_time)::BaseType> last_redirect_end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_last_redirect_end_time,
      last_redirect_end_time_fragment);

    fragment->last_redirect_end_time.Set(
        last_redirect_end_time_fragment.is_null() ? nullptr : last_redirect_end_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_redirect_end_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_redirect_end_time in ResourceTimingInfo struct");

    decltype(Traits::response_end(input)) in_response_end = Traits::response_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_end)::BaseType> response_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_response_end,
      response_end_fragment);

    fragment->response_end.Set(
        response_end_fragment.is_null() ? nullptr : response_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_end in ResourceTimingInfo struct");

    
    mojo::internal::Serialize<::blink::mojom::CacheState>(
      Traits::cache_state(input),
      &fragment->cache_state);

    fragment->encoded_body_size = Traits::encoded_body_size(input);

    fragment->decoded_body_size = Traits::decoded_body_size(input);

    fragment->did_reuse_connection = Traits::did_reuse_connection(input);

    fragment->is_secure_transport = Traits::is_secure_transport(input);

    fragment->allow_timing_details = Traits::allow_timing_details(input);

    fragment->allow_negative_values = Traits::allow_negative_values(input);

    decltype(Traits::server_timing(input)) in_server_timing = Traits::server_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_timing)::BaseType>
        server_timing_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& server_timing_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServerTimingInfoDataView>>(
      in_server_timing,
      server_timing_fragment,
      &server_timing_validate_params);

    fragment->server_timing.Set(
        server_timing_fragment.is_null() ? nullptr : server_timing_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->server_timing.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_timing in ResourceTimingInfo struct");

    fragment->render_blocking_status = Traits::render_blocking_status(input);

    fragment->response_status = Traits::response_status(input);

    decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_type)::BaseType> content_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type,
      content_type_fragment);

    fragment->content_type.Set(
        content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in ResourceTimingInfo struct");

    decltype(Traits::content_encoding(input)) in_content_encoding = Traits::content_encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_encoding)::BaseType> content_encoding_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_encoding,
      content_encoding_fragment);

    fragment->content_encoding.Set(
        content_encoding_fragment.is_null() ? nullptr : content_encoding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_encoding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_encoding in ResourceTimingInfo struct");

    decltype(Traits::initiator_url(input)) in_initiator_url = Traits::initiator_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_url)::BaseType> initiator_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_url,
      initiator_url_fragment);

    fragment->initiator_url.Set(
        initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initiator_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_url in ResourceTimingInfo struct");

    decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
      in_service_worker_router_info,
      service_worker_router_info_fragment);

    fragment->service_worker_router_info.Set(
        service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
      Traits::service_worker_response_source(input),
      &fragment->service_worker_response_source);
  }

  static bool Deserialize(::blink::mojom::internal::ResourceTimingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ResourceTimingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ServerTimingInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ServerTimingInfoDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ResourceTimingInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetConnectionInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->connection_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetTimingDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->timing.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetLastRedirectEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->last_redirect_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetResponseEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->response_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetServerTimingDataView(
    mojo::ArrayDataView<ServerTimingInfoDataView>* output) {
  auto pointer = data_->server_timing.Get();
  *output = mojo::ArrayDataView<ServerTimingInfoDataView>(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetContentEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetInitiatorUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->initiator_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ResourceTimingInfoDataView::GetServiceWorkerRouterInfoDataView(
    ::network::mojom::ServiceWorkerRouterInfoDataView* output) {
  auto pointer = data_->service_worker_router_info.Get();
  *output = ::network::mojom::ServiceWorkerRouterInfoDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CacheState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CacheState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_