// third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

StorageAccessHandle::IPCStableHashFunction StorageAccessHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StorageAccessHandle>(message.name())) {
    case messages::StorageAccessHandle::kBindIndexedDB: {
      return &StorageAccessHandle::BindIndexedDB_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kBindLocks: {
      return &StorageAccessHandle::BindLocks_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kBindCaches: {
      return &StorageAccessHandle::BindCaches_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kGetDirectory: {
      return &StorageAccessHandle::GetDirectory_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kEstimate: {
      return &StorageAccessHandle::Estimate_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kBindBlobStorage: {
      return &StorageAccessHandle::BindBlobStorage_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kBindBroadcastChannel: {
      return &StorageAccessHandle::BindBroadcastChannel_Sym::IPCStableHash;
    }
    case messages::StorageAccessHandle::kBindSharedWorker: {
      return &StorageAccessHandle::BindSharedWorker_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StorageAccessHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StorageAccessHandle>(message.name())) {
      case messages::StorageAccessHandle::kBindIndexedDB:
            return "Receive blink::mojom::StorageAccessHandle::BindIndexedDB";
      case messages::StorageAccessHandle::kBindLocks:
            return "Receive blink::mojom::StorageAccessHandle::BindLocks";
      case messages::StorageAccessHandle::kBindCaches:
            return "Receive blink::mojom::StorageAccessHandle::BindCaches";
      case messages::StorageAccessHandle::kGetDirectory:
            return "Receive blink::mojom::StorageAccessHandle::GetDirectory";
      case messages::StorageAccessHandle::kEstimate:
            return "Receive blink::mojom::StorageAccessHandle::Estimate";
      case messages::StorageAccessHandle::kBindBlobStorage:
            return "Receive blink::mojom::StorageAccessHandle::BindBlobStorage";
      case messages::StorageAccessHandle::kBindBroadcastChannel:
            return "Receive blink::mojom::StorageAccessHandle::BindBroadcastChannel";
      case messages::StorageAccessHandle::kBindSharedWorker:
            return "Receive blink::mojom::StorageAccessHandle::BindSharedWorker";
    }
  } else {
    switch (static_cast<messages::StorageAccessHandle>(message.name())) {
      case messages::StorageAccessHandle::kBindIndexedDB:
            return "Receive reply blink::mojom::StorageAccessHandle::BindIndexedDB";
      case messages::StorageAccessHandle::kBindLocks:
            return "Receive reply blink::mojom::StorageAccessHandle::BindLocks";
      case messages::StorageAccessHandle::kBindCaches:
            return "Receive reply blink::mojom::StorageAccessHandle::BindCaches";
      case messages::StorageAccessHandle::kGetDirectory:
            return "Receive reply blink::mojom::StorageAccessHandle::GetDirectory";
      case messages::StorageAccessHandle::kEstimate:
            return "Receive reply blink::mojom::StorageAccessHandle::Estimate";
      case messages::StorageAccessHandle::kBindBlobStorage:
            return "Receive reply blink::mojom::StorageAccessHandle::BindBlobStorage";
      case messages::StorageAccessHandle::kBindBroadcastChannel:
            return "Receive reply blink::mojom::StorageAccessHandle::BindBroadcastChannel";
      case messages::StorageAccessHandle::kBindSharedWorker:
            return "Receive reply blink::mojom::StorageAccessHandle::BindSharedWorker";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StorageAccessHandle::BindIndexedDB_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x668f8569;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindIndexedDB
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::BindLocks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdfcb5762;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindLocks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::BindCaches_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x483c9af5;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindCaches
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::GetDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39249549;  // IPCStableHash for blink::mojom::StorageAccessHandle::GetDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::Estimate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76716d04;  // IPCStableHash for blink::mojom::StorageAccessHandle::Estimate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::BindBlobStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76e5d4c8;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindBlobStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::BindBroadcastChannel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75f53b10;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindBroadcastChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAccessHandle::BindSharedWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73cc7c0a;  // IPCStableHash for blink::mojom::StorageAccessHandle::BindSharedWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class StorageAccessHandle_GetDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageAccessHandle_GetDirectory_ForwardToCallback(
      StorageAccessHandle::GetDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageAccessHandle_GetDirectory_ForwardToCallback(const StorageAccessHandle_GetDirectory_ForwardToCallback&) = delete;
  StorageAccessHandle_GetDirectory_ForwardToCallback& operator=(const StorageAccessHandle_GetDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageAccessHandle::GetDirectoryCallback callback_;
};

class StorageAccessHandle_Estimate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageAccessHandle_Estimate_ForwardToCallback(
      StorageAccessHandle::EstimateCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageAccessHandle_Estimate_ForwardToCallback(const StorageAccessHandle_Estimate_ForwardToCallback&) = delete;
  StorageAccessHandle_Estimate_ForwardToCallback& operator=(const StorageAccessHandle_Estimate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageAccessHandle::EstimateCallback callback_;
};

StorageAccessHandleProxy::StorageAccessHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAccessHandleProxy::BindIndexedDB(
    ::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindIndexedDB", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindIndexedDB), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindIndexedDB_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBFactoryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in StorageAccessHandle.BindIndexedDB request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindIndexedDB");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAccessHandleProxy::BindLocks(
    ::mojo::PendingReceiver<::blink::mojom::blink::LockManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindLocks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::LockManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindLocks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindLocks_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::LockManagerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in StorageAccessHandle.BindLocks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindLocks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAccessHandleProxy::BindCaches(
    ::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindCaches", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindCaches), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindCaches_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::CacheStorageInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in StorageAccessHandle.BindCaches request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindCaches");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAccessHandleProxy::GetDirectory(
    GetDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::StorageAccessHandle::GetDirectory");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_GetDirectory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("GetDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageAccessHandle_GetDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StorageAccessHandleProxy::Estimate(
    EstimateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::StorageAccessHandle::Estimate");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kEstimate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_Estimate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("Estimate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageAccessHandle_Estimate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StorageAccessHandleProxy::BindBlobStorage(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindBlobStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindBlobStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindBlobStorage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BlobURLStoreAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in StorageAccessHandle.BindBlobStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindBlobStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAccessHandleProxy::BindBroadcastChannel(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindBroadcastChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindBroadcastChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindBroadcastChannel_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BroadcastChannelProviderAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in StorageAccessHandle.BindBroadcastChannel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindBroadcastChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAccessHandleProxy::BindSharedWorker(
    ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAccessHandle::BindSharedWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kBindSharedWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_BindSharedWorker_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SharedWorkerConnectorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in StorageAccessHandle.BindSharedWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("BindSharedWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class StorageAccessHandle_GetDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageAccessHandle::GetDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageAccessHandle_GetDirectory_ProxyToResponder> proxy(
        new StorageAccessHandle_GetDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageAccessHandle_GetDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageAccessHandle_GetDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageAccessHandle_GetDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageAccessHandle::GetDirectoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle> in_directory);
};

bool StorageAccessHandle_GetDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageAccessHandle_GetDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageAccessHandle_GetDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageAccessHandle.3
  bool success = true;
  ::blink::mojom::blink::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle> p_directory{};
  StorageAccessHandle_GetDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageAccessHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void StorageAccessHandle_GetDirectory_ProxyToResponder::Run(
    ::blink::mojom::blink::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageAccessHandle::GetDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::blink::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_GetDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("GetDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageAccessHandle_Estimate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageAccessHandle::EstimateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageAccessHandle_Estimate_ProxyToResponder> proxy(
        new StorageAccessHandle_Estimate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageAccessHandle_Estimate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageAccessHandle_Estimate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageAccessHandle_Estimate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageAccessHandle::EstimateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ByteCount in_current_usage, ::base::ByteCount in_current_quota, bool in_success);
};

bool StorageAccessHandle_Estimate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageAccessHandle_Estimate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageAccessHandle_Estimate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageAccessHandle.4
  bool success = true;
  ::base::ByteCount p_current_usage{};
  ::base::ByteCount p_current_quota{};
  bool p_success{};
  StorageAccessHandle_Estimate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCurrentUsage(&p_current_usage))
    success = false;
  if (success && !input_data_view.ReadCurrentQuota(&p_current_quota))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageAccessHandle::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_current_usage), 
std::move(p_current_quota), 
std::move(p_success));
  }
  return true;
}

void StorageAccessHandle_Estimate_ProxyToResponder::Run(
    ::base::ByteCount in_current_usage, ::base::ByteCount in_current_quota, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageAccessHandle::Estimate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage,
                        "<value of type ::base::ByteCount>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_quota"), in_current_quota,
                        "<value of type ::base::ByteCount>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAccessHandle::kEstimate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAccessHandle_Estimate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->current_usage)::BaseType> current_usage_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
    in_current_usage,
    current_usage_fragment);

  params->current_usage.Set(
      current_usage_fragment.is_null() ? nullptr : current_usage_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->current_usage.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null current_usage in ");
  mojo::internal::MessageFragment<
      typename decltype(params->current_quota)::BaseType> current_quota_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
    in_current_quota,
    current_quota_fragment);

  params->current_quota.Set(
      current_quota_fragment.is_null() ? nullptr : current_quota_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->current_quota.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null current_quota in ");

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAccessHandle::Name_);
  message.set_method_name("Estimate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StorageAccessHandleStubDispatch::Accept(
    StorageAccessHandle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StorageAccessHandle>(message->header()->name)) {
    case messages::StorageAccessHandle::kBindIndexedDB: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindIndexedDB_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindIndexedDB_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.0
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory> p_receiver{};
      StorageAccessHandle_BindIndexedDB_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindIndexedDB(        
        std::move(p_receiver));
      return true;
    }
    case messages::StorageAccessHandle::kBindLocks: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindLocks_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindLocks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.1
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::LockManager> p_receiver{};
      StorageAccessHandle_BindLocks_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindLocks(        
        std::move(p_receiver));
      return true;
    }
    case messages::StorageAccessHandle::kBindCaches: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindCaches_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindCaches_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.2
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage> p_receiver{};
      StorageAccessHandle_BindCaches_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindCaches(        
        std::move(p_receiver));
      return true;
    }
    case messages::StorageAccessHandle::kGetDirectory: {
      break;
    }
    case messages::StorageAccessHandle::kEstimate: {
      break;
    }
    case messages::StorageAccessHandle::kBindBlobStorage: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindBlobStorage_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindBlobStorage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.5
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore> p_receiver{};
      StorageAccessHandle_BindBlobStorage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBlobStorage(        
        std::move(p_receiver));
      return true;
    }
    case messages::StorageAccessHandle::kBindBroadcastChannel: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindBroadcastChannel_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindBroadcastChannel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.6
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider> p_receiver{};
      StorageAccessHandle_BindBroadcastChannel_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBroadcastChannel(        
        std::move(p_receiver));
      return true;
    }
    case messages::StorageAccessHandle::kBindSharedWorker: {
      DCHECK(message->is_serialized());
      internal::StorageAccessHandle_BindSharedWorker_Params_Data* params =
          reinterpret_cast<internal::StorageAccessHandle_BindSharedWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAccessHandle.7
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector> p_receiver{};
      StorageAccessHandle_BindSharedWorker_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSharedWorker(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool StorageAccessHandleStubDispatch::AcceptWithResponder(
    StorageAccessHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StorageAccessHandle>(message->header()->name)) {
    case messages::StorageAccessHandle::kBindIndexedDB: {
      break;
    }
    case messages::StorageAccessHandle::kBindLocks: {
      break;
    }
    case messages::StorageAccessHandle::kBindCaches: {
      break;
    }
    case messages::StorageAccessHandle::kGetDirectory: {
      internal::StorageAccessHandle_GetDirectory_Params_Data* params =
          reinterpret_cast<
              internal::StorageAccessHandle_GetDirectory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageAccessHandle.3
      bool success = true;
      StorageAccessHandle_GetDirectory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 3, false);
        return false;
      }
      auto callback =
          StorageAccessHandle_GetDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectory(std::move(callback));
      return true;
    }
    case messages::StorageAccessHandle::kEstimate: {
      internal::StorageAccessHandle_Estimate_Params_Data* params =
          reinterpret_cast<
              internal::StorageAccessHandle_Estimate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageAccessHandle.4
      bool success = true;
      StorageAccessHandle_Estimate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAccessHandle::Name_, 4, false);
        return false;
      }
      auto callback =
          StorageAccessHandle_Estimate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Estimate(std::move(callback));
      return true;
    }
    case messages::StorageAccessHandle::kBindBlobStorage: {
      break;
    }
    case messages::StorageAccessHandle::kBindBroadcastChannel: {
      break;
    }
    case messages::StorageAccessHandle::kBindSharedWorker: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStorageAccessHandleValidationInfo[] = {
    { &internal::StorageAccessHandle_BindIndexedDB_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAccessHandle_BindLocks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAccessHandle_BindCaches_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAccessHandle_GetDirectory_Params_Data::Validate,
     &internal::StorageAccessHandle_GetDirectory_ResponseParams_Data::Validate},
    { &internal::StorageAccessHandle_Estimate_Params_Data::Validate,
     &internal::StorageAccessHandle_Estimate_ResponseParams_Data::Validate},
    { &internal::StorageAccessHandle_BindBlobStorage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAccessHandle_BindBroadcastChannel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAccessHandle_BindSharedWorker_Params_Data::Validate,
     nullptr /* no response */},
};

bool StorageAccessHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::StorageAccessHandle::Name_,
    kStorageAccessHandleValidationInfo);
}

bool StorageAccessHandleResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::StorageAccessHandle::Name_,
    kStorageAccessHandleValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void StorageAccessHandleInterceptorForTesting::BindIndexedDB(::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory> receiver) {
  GetForwardingInterface()->BindIndexedDB(
    std::move(receiver)
    );
}
void StorageAccessHandleInterceptorForTesting::BindLocks(::mojo::PendingReceiver<::blink::mojom::blink::LockManager> receiver) {
  GetForwardingInterface()->BindLocks(
    std::move(receiver)
    );
}
void StorageAccessHandleInterceptorForTesting::BindCaches(::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage> receiver) {
  GetForwardingInterface()->BindCaches(
    std::move(receiver)
    );
}
void StorageAccessHandleInterceptorForTesting::GetDirectory(GetDirectoryCallback callback) {
  GetForwardingInterface()->GetDirectory(std::move(callback));
}
void StorageAccessHandleInterceptorForTesting::Estimate(EstimateCallback callback) {
  GetForwardingInterface()->Estimate(std::move(callback));
}
void StorageAccessHandleInterceptorForTesting::BindBlobStorage(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore> receiver) {
  GetForwardingInterface()->BindBlobStorage(
    std::move(receiver)
    );
}
void StorageAccessHandleInterceptorForTesting::BindBroadcastChannel(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider> receiver) {
  GetForwardingInterface()->BindBroadcastChannel(
    std::move(receiver)
    );
}
void StorageAccessHandleInterceptorForTesting::BindSharedWorker(::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector> receiver) {
  GetForwardingInterface()->BindSharedWorker(
    std::move(receiver)
    );
}
StorageAccessHandleAsyncWaiter::StorageAccessHandleAsyncWaiter(
    StorageAccessHandle* proxy) : proxy_(proxy) {}

StorageAccessHandleAsyncWaiter::~StorageAccessHandleAsyncWaiter() = default;


void StorageAccessHandleAsyncWaiter::GetDirectory(
    ::blink::mojom::blink::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetDirectory(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::blink::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}



void StorageAccessHandleAsyncWaiter::Estimate(
    ::base::ByteCount* out_current_usage, ::base::ByteCount* out_current_quota, bool* out_success) {
  base::RunLoop loop;
  proxy_->Estimate(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ByteCount* out_current_usage
,
             ::base::ByteCount* out_current_quota
,
             bool* out_success
,
             ::base::ByteCount current_usage,
             ::base::ByteCount current_quota,
             bool success) {*out_current_usage = std::move(current_usage);*out_current_quota = std::move(current_quota);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_current_usage,
          out_current_quota,
          out_success));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif