// third_party/blink/public/mojom/speech/speech_synthesis.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');




goog.provide('blink.mojom.SPEECH_SYNTHESIS_DEFAULT_RATE');
/**
 * @const { !number }
 * @export
 */
blink.mojom.SPEECH_SYNTHESIS_DEFAULT_RATE = 1.0;
goog.provide('blink.mojom.SPEECH_SYNTHESIS_DEFAULT_PITCH');
/**
 * @const { !number }
 * @export
 */
blink.mojom.SPEECH_SYNTHESIS_DEFAULT_PITCH = 1.0;
goog.provide('blink.mojom.SPEECH_SYNTHESIS_DEFAULT_VOLUME');
/**
 * @const { !number }
 * @export
 */
blink.mojom.SPEECH_SYNTHESIS_DEFAULT_VOLUME = 1.0;
goog.provide('blink.mojom.SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET');
/**
 * @const { !number }
 * @export
 */
blink.mojom.SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET = -1.0;

goog.provide('blink.mojom.SpeechSynthesisErrorCode');
goog.provide('blink.mojom.SpeechSynthesisErrorCodeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SpeechSynthesisErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SpeechSynthesisErrorCode = {
  
  kCancelled: 0,
  kInterrupted: 1,
  kErrorOccurred: 2,
  kNoError: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('blink.mojom.SpeechSynthesisVoiceListObserver');
goog.provide('blink.mojom.SpeechSynthesisVoiceListObserverReceiver');
goog.provide('blink.mojom.SpeechSynthesisVoiceListObserverCallbackRouter');
goog.provide('blink.mojom.SpeechSynthesisVoiceListObserverInterface');
goog.provide('blink.mojom.SpeechSynthesisVoiceListObserverRemote');
goog.provide('blink.mojom.SpeechSynthesisVoiceListObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SpeechSynthesisVoiceListObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SpeechSynthesisVoiceListObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SpeechSynthesisVoiceListObserverInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.SpeechSynthesisVoice> } voiceList
   */

  onSetVoiceList(voiceList) {}
};

/**
 * @export
 * @implements { blink.mojom.SpeechSynthesisVoiceListObserverInterface }
 */
blink.mojom.SpeechSynthesisVoiceListObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SpeechSynthesisVoiceListObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SpeechSynthesisVoiceListObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SpeechSynthesisVoiceListObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.SpeechSynthesisVoice> } voiceList
   */

  onSetVoiceList(
      voiceList) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        [
          voiceList
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechSynthesisVoiceListObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SpeechSynthesisVoiceListObserverReceiver = class {
  /**
   * @param {!blink.mojom.SpeechSynthesisVoiceListObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SpeechSynthesisVoiceListObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SpeechSynthesisVoiceListObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisVoiceListObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        impl.onSetVoiceList.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SpeechSynthesisVoiceListObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesisVoiceListObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SpeechSynthesisVoiceListObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SpeechSynthesisVoiceListObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechSynthesisVoiceListObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SpeechSynthesisVoiceListObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SpeechSynthesisVoiceListObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisVoiceListObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSetVoiceList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
        null,
        this.onSetVoiceList.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SpeechSynthesisClient');
goog.provide('blink.mojom.SpeechSynthesisClientReceiver');
goog.provide('blink.mojom.SpeechSynthesisClientCallbackRouter');
goog.provide('blink.mojom.SpeechSynthesisClientInterface');
goog.provide('blink.mojom.SpeechSynthesisClientRemote');
goog.provide('blink.mojom.SpeechSynthesisClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SpeechSynthesisClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SpeechSynthesisClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SpeechSynthesisClientInterface = class {
  
  /**
   */

  onStartedSpeaking() {}
  
  /**
   * @param { !blink.mojom.SpeechSynthesisErrorCode } errorCode
   */

  onFinishedSpeaking(errorCode) {}
  
  /**
   */

  onPausedSpeaking() {}
  
  /**
   */

  onResumedSpeaking() {}
  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredWordBoundary(charIndex, charLength) {}
  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredSentenceBoundary(charIndex, charLength) {}
  
  /**
   */

  onEncounteredSpeakingError() {}
};

/**
 * @export
 * @implements { blink.mojom.SpeechSynthesisClientInterface }
 */
blink.mojom.SpeechSynthesisClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SpeechSynthesisClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SpeechSynthesisClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SpeechSynthesisClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onStartedSpeaking() {
    this.proxy.sendMessage(
        0,
        blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SpeechSynthesisErrorCode } errorCode
   */

  onFinishedSpeaking(
      errorCode) {
    this.proxy.sendMessage(
        1,
        blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        [
          errorCode
        ],
        false);
  }

  
  /**
   */

  onPausedSpeaking() {
    this.proxy.sendMessage(
        2,
        blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onResumedSpeaking() {
    this.proxy.sendMessage(
        3,
        blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredWordBoundary(
      charIndex,
      charLength) {
    this.proxy.sendMessage(
        4,
        blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        [
          charIndex,
          charLength
        ],
        false);
  }

  
  /**
   * @param { !number } charIndex
   * @param { !number } charLength
   */

  onEncounteredSentenceBoundary(
      charIndex,
      charLength) {
    this.proxy.sendMessage(
        5,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        [
          charIndex,
          charLength
        ],
        false);
  }

  
  /**
   */

  onEncounteredSpeakingError() {
    this.proxy.sendMessage(
        6,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechSynthesisClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SpeechSynthesisClientReceiver = class {
  /**
   * @param {!blink.mojom.SpeechSynthesisClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SpeechSynthesisClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SpeechSynthesisClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        impl.onStartedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        impl.onFinishedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        impl.onPausedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        impl.onResumedSpeaking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        impl.onEncounteredWordBoundary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        impl.onEncounteredSentenceBoundary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        impl.onEncounteredSpeakingError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SpeechSynthesisClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesisClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SpeechSynthesisClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SpeechSynthesisClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechSynthesisClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SpeechSynthesisClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SpeechSynthesisClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStartedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
        null,
        this.onStartedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFinishedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
        null,
        this.onFinishedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPausedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
        null,
        this.onPausedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResumedSpeaking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
        null,
        this.onResumedSpeaking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredWordBoundary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
        null,
        this.onEncounteredWordBoundary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredSentenceBoundary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
        null,
        this.onEncounteredSentenceBoundary.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncounteredSpeakingError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
        null,
        this.onEncounteredSpeakingError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SpeechSynthesis');
goog.provide('blink.mojom.SpeechSynthesisReceiver');
goog.provide('blink.mojom.SpeechSynthesisCallbackRouter');
goog.provide('blink.mojom.SpeechSynthesisInterface');
goog.provide('blink.mojom.SpeechSynthesisRemote');
goog.provide('blink.mojom.SpeechSynthesisPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SpeechSynthesisPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SpeechSynthesis.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SpeechSynthesisInterface = class {
  
  /**
   * @param { !blink.mojom.SpeechSynthesisVoiceListObserverRemote } observer
   */

  addVoiceListObserver(observer) {}
  
  /**
   * @param { !blink.mojom.SpeechSynthesisUtterance } utterance
   * @param { !blink.mojom.SpeechSynthesisClientRemote } client
   */

  speak(utterance, client) {}
  
  /**
   */

  pause() {}
  
  /**
   */

  resume() {}
  
  /**
   */

  cancel() {}
};

/**
 * @export
 * @implements { blink.mojom.SpeechSynthesisInterface }
 */
blink.mojom.SpeechSynthesisRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SpeechSynthesisPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SpeechSynthesisPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SpeechSynthesisPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SpeechSynthesisVoiceListObserverRemote } observer
   */

  addVoiceListObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SpeechSynthesisUtterance } utterance
   * @param { !blink.mojom.SpeechSynthesisClientRemote } client
   */

  speak(
      utterance,
      client) {
    this.proxy.sendMessage(
        1,
        blink.mojom.SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        [
          utterance,
          client
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        2,
        blink.mojom.SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        3,
        blink.mojom.SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        4,
        blink.mojom.SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechSynthesis
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SpeechSynthesisReceiver = class {
  /**
   * @param {!blink.mojom.SpeechSynthesisInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SpeechSynthesisRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SpeechSynthesisRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        impl.addVoiceListObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        impl.speak.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SpeechSynthesis = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeechSynthesis";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SpeechSynthesisRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SpeechSynthesisRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechSynthesis
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SpeechSynthesisCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SpeechSynthesisRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeechSynthesisRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addVoiceListObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
        null,
        this.addVoiceListObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speak =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeechSynthesis_Speak_ParamsSpec.$,
        null,
        this.speak.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeechSynthesis_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SpeechSynthesis_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SpeechSynthesis_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SpeechSynthesisUtteranceSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisUtteranceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisVoiceSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisVoiceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesis_Speak_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesis_Speak_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesis_Pause_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesis_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesis_Resume_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesis_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SpeechSynthesis_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeechSynthesis_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SpeechSynthesisUtteranceSpec.$,
    'SpeechSynthesisUtterance',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lang', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'voice', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'volume', 24,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rate', 32,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pitch', 40,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.SpeechSynthesisUtterance');

/** @record */
blink.mojom.SpeechSynthesisUtterance = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !string } */
    this.lang;
    /** @export { !string } */
    this.voice;
    /** @export { !number } */
    this.volume;
    /** @export { !number } */
    this.rate;
    /** @export { !number } */
    this.pitch;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisVoiceSpec.$,
    'SpeechSynthesisVoice',
    [
      mojo.internal.StructField(
        'voiceUri', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lang', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isLocalService', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isDefault', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.SpeechSynthesisVoice');

/** @record */
blink.mojom.SpeechSynthesisVoice = class {
  constructor() {
    /** @export { !string } */
    this.voiceUri;
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.lang;
    /** @export { !boolean } */
    this.isLocalService;
    /** @export { !boolean } */
    this.isDefault;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsSpec.$,
    'SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params',
    [
      mojo.internal.StructField(
        'voiceList', 0,
        0,
        mojo.internal.Array(blink.mojom.SpeechSynthesisVoiceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params');

/** @record */
blink.mojom.SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SpeechSynthesisVoice> } */
    this.voiceList;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnStartedSpeaking_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnStartedSpeaking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnFinishedSpeaking_Params',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        blink.mojom.SpeechSynthesisErrorCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnFinishedSpeaking_Params = class {
  constructor() {
    /** @export { !blink.mojom.SpeechSynthesisErrorCode } */
    this.errorCode;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnPausedSpeaking_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnPausedSpeaking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_ParamsSpec.$,
    'SpeechSynthesisClient_OnResumedSpeaking_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnResumedSpeaking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredWordBoundary_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'charLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnEncounteredWordBoundary_Params = class {
  constructor() {
    /** @export { !number } */
    this.charIndex;
    /** @export { !number } */
    this.charLength;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params',
    [
      mojo.internal.StructField(
        'charIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'charLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params = class {
  constructor() {
    /** @export { !number } */
    this.charIndex;
    /** @export { !number } */
    this.charLength;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsSpec.$,
    'SpeechSynthesisClient_OnEncounteredSpeakingError_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_Params');

/** @record */
blink.mojom.SpeechSynthesisClient_OnEncounteredSpeakingError_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesis_AddVoiceListObserver_ParamsSpec.$,
    'SpeechSynthesis_AddVoiceListObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SpeechSynthesisVoiceListObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SpeechSynthesis_AddVoiceListObserver_Params');

/** @record */
blink.mojom.SpeechSynthesis_AddVoiceListObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.SpeechSynthesisVoiceListObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesis_Speak_ParamsSpec.$,
    'SpeechSynthesis_Speak_Params',
    [
      mojo.internal.StructField(
        'utterance', 0,
        0,
        blink.mojom.SpeechSynthesisUtteranceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SpeechSynthesisClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SpeechSynthesis_Speak_Params');

/** @record */
blink.mojom.SpeechSynthesis_Speak_Params = class {
  constructor() {
    /** @export { !blink.mojom.SpeechSynthesisUtterance } */
    this.utterance;
    /** @export { !blink.mojom.SpeechSynthesisClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesis_Pause_ParamsSpec.$,
    'SpeechSynthesis_Pause_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesis_Pause_Params');

/** @record */
blink.mojom.SpeechSynthesis_Pause_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesis_Resume_ParamsSpec.$,
    'SpeechSynthesis_Resume_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesis_Resume_Params');

/** @record */
blink.mojom.SpeechSynthesis_Resume_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeechSynthesis_Cancel_ParamsSpec.$,
    'SpeechSynthesis_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SpeechSynthesis_Cancel_Params');

/** @record */
blink.mojom.SpeechSynthesis_Cancel_Params = class {
  constructor() {
  }
};

