// third_party/blink/public/mojom/sms/webotp_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/sms/webotp_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var SmsStatus = {};
  SmsStatus.kSuccess = 0;
  SmsStatus.kUnhandledRequest = 1;
  SmsStatus.kCancelled = 2;
  SmsStatus.kAborted = 3;
  SmsStatus.kTimeout = 4;
  SmsStatus.kBackendNotAvailable = 5;
  SmsStatus.MIN_VALUE = 0;
  SmsStatus.MAX_VALUE = 5;

  SmsStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  SmsStatus.toKnownEnumValue = function(value) {
    return value;
  };

  SmsStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function WebOTPService_Receive_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebOTPService_Receive_Params.prototype.initDefaults_ = function() {
  };
  WebOTPService_Receive_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebOTPService_Receive_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebOTPService_Receive_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebOTPService_Receive_Params.decode = function(decoder) {
    var packed;
    var val = new WebOTPService_Receive_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebOTPService_Receive_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebOTPService_Receive_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebOTPService_Receive_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebOTPService_Receive_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.otp = null;
  };
  WebOTPService_Receive_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebOTPService_Receive_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebOTPService_Receive_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SmsStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebOTPService_Receive_ResponseParams.otp
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebOTPService_Receive_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebOTPService_Receive_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebOTPService_Receive_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(SmsStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.otp =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebOTPService_Receive_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebOTPService_Receive_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.otp);
  };
  function WebOTPService_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebOTPService_Abort_Params.prototype.initDefaults_ = function() {
  };
  WebOTPService_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebOTPService_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebOTPService_Abort_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebOTPService_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new WebOTPService_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebOTPService_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebOTPService_Abort_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kWebOTPService_Receive_Name = 0;
  var kWebOTPService_Abort_Name = 1;

  function WebOTPServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebOTPService,
                                                   handleOrPtrInfo);
  }

  function WebOTPServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebOTPService, associatedInterfacePtrInfo);
  }

  WebOTPServiceAssociatedPtr.prototype =
      Object.create(WebOTPServicePtr.prototype);
  WebOTPServiceAssociatedPtr.prototype.constructor =
      WebOTPServiceAssociatedPtr;

  function WebOTPServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebOTPServicePtr.prototype.receive = function() {
    return WebOTPServiceProxy.prototype.receive
        .apply(this.ptr.getProxy(), arguments);
  };

  WebOTPServiceProxy.prototype.receive = function() {
    var params_ = new WebOTPService_Receive_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebOTPService_Receive_Name,
          codec.align(WebOTPService_Receive_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebOTPService_Receive_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebOTPService_Receive_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebOTPServicePtr.prototype.abort = function() {
    return WebOTPServiceProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  WebOTPServiceProxy.prototype.abort = function() {
    var params_ = new WebOTPService_Abort_Params();
    var builder = new codec.MessageV0Builder(
        kWebOTPService_Abort_Name,
        codec.align(WebOTPService_Abort_Params.encodedSize));
    builder.encodeStruct(WebOTPService_Abort_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebOTPServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  WebOTPServiceStub.prototype.receive = function() {
    return this.delegate_ && this.delegate_.receive && this.delegate_.receive();
  }
  WebOTPServiceStub.prototype.abort = function() {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort();
  }

  WebOTPServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebOTPService_Abort_Name:
      var params = reader.decodeStruct(WebOTPService_Abort_Params);
      this.abort();
      return true;
    default:
      return false;
    }
  };

  WebOTPServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebOTPService_Receive_Name:
      var params = reader.decodeStruct(WebOTPService_Receive_Params);
      this.receive().then(function(response) {
        var responseParams =
            new WebOTPService_Receive_ResponseParams();
        responseParams.status = response.status;
        responseParams.otp = response.otp;
        var builder = new codec.MessageV1Builder(
            kWebOTPService_Receive_Name,
            codec.align(WebOTPService_Receive_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebOTPService_Receive_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebOTPServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebOTPService_Receive_Name:
        if (message.expectsResponse())
          paramsClass = WebOTPService_Receive_Params;
      break;
      case kWebOTPService_Abort_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebOTPService_Abort_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebOTPServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebOTPService_Receive_Name:
        if (message.isResponse())
          paramsClass = WebOTPService_Receive_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebOTPService = {
    name: 'blink.mojom.WebOTPService',
    kVersion: 0,
    ptrClass: WebOTPServicePtr,
    proxyClass: WebOTPServiceProxy,
    stubClass: WebOTPServiceStub,
    validateRequest: validateWebOTPServiceRequest,
    validateResponse: validateWebOTPServiceResponse,
  };
  WebOTPServiceStub.prototype.validator = validateWebOTPServiceRequest;
  WebOTPServiceProxy.prototype.validator = validateWebOTPServiceResponse;
  exports.SmsStatus = SmsStatus;
  exports.WebOTPService = WebOTPService;
  exports.WebOTPServicePtr = WebOTPServicePtr;
  exports.WebOTPServiceAssociatedPtr = WebOTPServiceAssociatedPtr;
})();