// third_party/blink/public/mojom/sms/webotp_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/sms/webotp_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/sms/webotp_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/sms/webotp_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

WebOTPService::IPCStableHashFunction WebOTPService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebOTPService>(message.name())) {
    case messages::WebOTPService::kReceive: {
      return &WebOTPService::Receive_Sym::IPCStableHash;
    }
    case messages::WebOTPService::kAbort: {
      return &WebOTPService::Abort_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebOTPService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebOTPService>(message.name())) {
      case messages::WebOTPService::kReceive:
            return "Receive blink::mojom::WebOTPService::Receive";
      case messages::WebOTPService::kAbort:
            return "Receive blink::mojom::WebOTPService::Abort";
    }
  } else {
    switch (static_cast<messages::WebOTPService>(message.name())) {
      case messages::WebOTPService::kReceive:
            return "Receive reply blink::mojom::WebOTPService::Receive";
      case messages::WebOTPService::kAbort:
            return "Receive reply blink::mojom::WebOTPService::Abort";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebOTPService::Receive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf3038f6;  // IPCStableHash for blink::mojom::WebOTPService::Receive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebOTPService::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x992d271e;  // IPCStableHash for blink::mojom::WebOTPService::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebOTPService_Receive_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebOTPService_Receive_ForwardToCallback(
      WebOTPService::ReceiveCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebOTPService_Receive_ForwardToCallback(const WebOTPService_Receive_ForwardToCallback&) = delete;
  WebOTPService_Receive_ForwardToCallback& operator=(const WebOTPService_Receive_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebOTPService::ReceiveCallback callback_;
};

WebOTPServiceProxy::WebOTPServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebOTPServiceProxy::Receive(
    ReceiveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebOTPService::Receive");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebOTPService::kReceive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Receive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Receive");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebOTPService_Receive_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebOTPServiceProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebOTPService::Abort");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebOTPService::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebOTPService_Receive_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebOTPService::ReceiveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebOTPService_Receive_ProxyToResponder> proxy(
        new WebOTPService_Receive_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebOTPService_Receive_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebOTPService_Receive_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebOTPService_Receive_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebOTPService::ReceiveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmsStatus in_status, const ::blink::String& in_otp);
};

bool WebOTPService_Receive_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebOTPService_Receive_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebOTPService_Receive_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebOTPService.0
  bool success = true;
  SmsStatus p_status{};
  ::blink::String p_otp{};
  WebOTPService_Receive_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadOtp(&p_otp))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebOTPService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_otp));
  }
  return true;
}

void WebOTPService_Receive_ProxyToResponder::Run(
    SmsStatus in_status, const ::blink::String& in_otp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebOTPService::Receive", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type SmsStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("otp"), in_otp,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebOTPService::kReceive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebOTPService_Receive_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SmsStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->otp)::BaseType> otp_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_otp,
    otp_fragment);

  params->otp.Set(
      otp_fragment.is_null() ? nullptr : otp_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebOTPService::Name_);
  message.set_method_name("Receive");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebOTPServiceStubDispatch::Accept(
    WebOTPService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebOTPService>(message->header()->name)) {
    case messages::WebOTPService::kReceive: {
      break;
    }
    case messages::WebOTPService::kAbort: {
      DCHECK(message->is_serialized());
      internal::WebOTPService_Abort_Params_Data* params =
          reinterpret_cast<internal::WebOTPService_Abort_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebOTPService.1
      bool success = true;
      WebOTPService_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebOTPService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        );
      return true;
    }
  }
  return false;
}

// static
bool WebOTPServiceStubDispatch::AcceptWithResponder(
    WebOTPService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebOTPService>(message->header()->name)) {
    case messages::WebOTPService::kReceive: {
      internal::WebOTPService_Receive_Params_Data* params =
          reinterpret_cast<
              internal::WebOTPService_Receive_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebOTPService.0
      bool success = true;
      WebOTPService_Receive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebOTPService::Name_, 0, false);
        return false;
      }
      auto callback =
          WebOTPService_Receive_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Receive(std::move(callback));
      return true;
    }
    case messages::WebOTPService::kAbort: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebOTPServiceValidationInfo[] = {
    { &internal::WebOTPService_Receive_Params_Data::Validate,
     &internal::WebOTPService_Receive_ResponseParams_Data::Validate},
    { &internal::WebOTPService_Abort_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebOTPServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebOTPService::Name_,
    kWebOTPServiceValidationInfo);
}

bool WebOTPServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebOTPService::Name_,
    kWebOTPServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebOTPServiceInterceptorForTesting::Receive(ReceiveCallback callback) {
  GetForwardingInterface()->Receive(std::move(callback));
}
void WebOTPServiceInterceptorForTesting::Abort() {
  GetForwardingInterface()->Abort();
}
WebOTPServiceAsyncWaiter::WebOTPServiceAsyncWaiter(
    WebOTPService* proxy) : proxy_(proxy) {}

WebOTPServiceAsyncWaiter::~WebOTPServiceAsyncWaiter() = default;


void WebOTPServiceAsyncWaiter::Receive(
    SmsStatus* out_status, ::blink::String* out_otp) {
  base::RunLoop loop;
  proxy_->Receive(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmsStatus* out_status
,
             ::blink::String* out_otp
,
             SmsStatus status,
             const ::blink::String& otp) {*out_status = std::move(status);*out_otp = std::move(otp);
            loop->Quit();
          },
          &loop,
          out_status,
          out_otp));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif