// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool GetInterestGroupsResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetInterestGroupsResult_Data* object = static_cast<const GetInterestGroupsResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetInterestGroupsResult_Tag::kErrorMessage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_message, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error_message, validation_context,
                                             &error_message_validate_params)) {
        return false;
      }
      return true;
    }
    case GetInterestGroupsResult_Tag::kGroups: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_groups, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_groups, validation_context,
                                             &groups_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetInterestGroupsResult");
      return false;
    }
  }
}


// static
bool SharedStorageWorkletPermissionsPolicyState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletPermissionsPolicyState_Data* object =
      static_cast<const SharedStorageWorkletPermissionsPolicyState_Data*>(data);

  return true;
}

SharedStorageWorkletPermissionsPolicyState_Data::SharedStorageWorkletPermissionsPolicyState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageKeyAndOrValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageKeyAndOrValue_Data* object =
      static_cast<const SharedStorageKeyAndOrValue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageKeyAndOrValue_Data::SharedStorageKeyAndOrValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrivateAggregationOperationDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrivateAggregationOperationDetails_Data* object =
      static_cast<const PrivateAggregationOperationDetails_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pa_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pa_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PrivateAggregationOperationDetails_Data::PrivateAggregationOperationDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageEntriesListener_DidReadEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageEntriesListener_DidReadEntries_Params_Data* object =
      static_cast<const SharedStorageEntriesListener_DidReadEntries_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageEntriesListener_DidReadEntries_Params_Data::SharedStorageEntriesListener_DidReadEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_with_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_with_options, validation_context))
    return false;

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data::SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data::SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->methods_with_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->methods_with_options, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->with_lock, validation_context))
    return false;

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data::SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::SharedStorageGetStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data::SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data::SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data::SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data*>(data);

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data::SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data::SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data*>(data);

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data*>(data);

  return true;
}

SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data::SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data::SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data*>(data);


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->log_level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data::SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data* object =
      static_cast<const SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->features, validation_context,
                                         &features_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data::SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_Initialize_Params_Data* object =
      static_cast<const SharedStorageWorkletService_Initialize_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permissions_policy_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->embedder_context, validation_context))
    return false;

  return true;
}

SharedStorageWorkletService_Initialize_Params_Data::SharedStorageWorkletService_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_AddModule_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_AddModule_Params_Data* object =
      static_cast<const SharedStorageWorkletService_AddModule_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_source_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_source_url, validation_context))
    return false;

  return true;
}

SharedStorageWorkletService_AddModule_Params_Data::SharedStorageWorkletService_AddModule_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_AddModule_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_AddModule_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletService_AddModule_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletService_AddModule_ResponseParams_Data::SharedStorageWorkletService_AddModule_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_RunURLSelectionOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_RunURLSelectionOperation_Params_Data* object =
      static_cast<const SharedStorageWorkletService_RunURLSelectionOperation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pa_operation_details, validation_context))
    return false;

  return true;
}

SharedStorageWorkletService_RunURLSelectionOperation_Params_Data::SharedStorageWorkletService_RunURLSelectionOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data::SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_RunOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_RunOperation_Params_Data* object =
      static_cast<const SharedStorageWorkletService_RunOperation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pa_operation_details, validation_context))
    return false;

  return true;
}

SharedStorageWorkletService_RunOperation_Params_Data::SharedStorageWorkletService_RunOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletService_RunOperation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletService_RunOperation_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletService_RunOperation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletService_RunOperation_ResponseParams_Data::SharedStorageWorkletService_RunOperation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink