// third_party/blink/public/mojom/service_worker/service_worker_worker_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ControllerServiceWorkerMode as blink_mojom_ControllerServiceWorkerMode,
  ControllerServiceWorkerModeSpec as blink_mojom_ControllerServiceWorkerModeSpec
} from './controller_service_worker_mode.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerWorkerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerWorkerClient', scope);
  }
}

/** @interface */
export class ServiceWorkerWorkerClientInterface {
  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerMode } mode
   */

  onControllerChanged(mode) {}
}

/**
 * @implements { ServiceWorkerWorkerClientInterface }
 */
export class ServiceWorkerWorkerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerWorkerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerWorkerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerWorkerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerMode } mode
   */

  onControllerChanged(
      mode) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerWorkerClient_OnControllerChanged_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerWorkerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerWorkerClientReceiver {
  /**
   * @param {!ServiceWorkerWorkerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerWorkerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerWorkerClient_OnControllerChanged_ParamsSpec.$,
        null,
        impl.onControllerChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerWorkerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerWorkerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerWorkerClientRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerWorkerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerWorkerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerWorkerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onControllerChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerWorkerClient_OnControllerChanged_ParamsSpec.$,
        null,
        this.onControllerChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerWorkerClient_OnControllerChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerWorkerClient_OnControllerChanged_ParamsSpec.$,
    'ServiceWorkerWorkerClient_OnControllerChanged_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_ControllerServiceWorkerModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerWorkerClient_OnControllerChanged_Params {
  constructor() {
    /** @type { !blink_mojom_ControllerServiceWorkerMode } */
    this.mode;
  }
}

