// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_registration.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var fetch_client_settings_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom', '../loader/fetch_client_settings_object.mojom.js');
  }
  var navigation_preload_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom', 'navigation_preload_state.mojom.js');
  }
  var service_worker_database$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_database.mojom', 'service_worker_database.mojom.js');
  }
  var service_worker_error_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom', 'service_worker_error_type.mojom.js');
  }
  var service_worker_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_object.mojom', 'service_worker_object.mojom.js');
  }
  var service_worker_registration_options$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom', 'service_worker_registration_options.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function ChangedServiceWorkerObjectsMask(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ChangedServiceWorkerObjectsMask.prototype.initDefaults_ = function() {
    this.installing = false;
    this.waiting = false;
    this.active = false;
  };
  ChangedServiceWorkerObjectsMask.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ChangedServiceWorkerObjectsMask.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ChangedServiceWorkerObjectsMask.encodedSize = codec.kStructHeaderSize + 8;

  ChangedServiceWorkerObjectsMask.decode = function(decoder) {
    var packed;
    var val = new ChangedServiceWorkerObjectsMask();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.installing = (packed >> 0) & 1 ? true : false;
    val.waiting = (packed >> 1) & 1 ? true : false;
    val.active = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ChangedServiceWorkerObjectsMask.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ChangedServiceWorkerObjectsMask.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.installing & 1) << 0
    packed |= (val.waiting & 1) << 1
    packed |= (val.active & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerRegistrationObjectInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectInfo.prototype.initDefaults_ = function() {
    this.registrationId = service_worker_database$.INVALID_SERVICE_WORKER_REGISTRATION_ID;
    this.scope = null;
    this.updateViaCache = 0;
    this.hostRemote = new associatedBindings.AssociatedInterfacePtrInfo();
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
    this.installing = null;
    this.waiting = null;
    this.active = null;
  };
  ServiceWorkerRegistrationObjectInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRegistrationObjectInfo.scope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.updateViaCache
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, service_worker_registration_options$.ServiceWorkerUpdateViaCache);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.hostRemote
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 20, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 28, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.installing
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.waiting
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectInfo.active
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectInfo.encodedSize = codec.kStructHeaderSize + 56;

  ServiceWorkerRegistrationObjectInfo.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.registrationId =
        decoder.decodeStruct(codec.Int64);
    val.scope =
        decoder.decodeStructPointer(url$.Url);
    val.updateViaCache =
        decoder.decodeStruct(new codec.Enum(service_worker_registration_options$.ServiceWorkerUpdateViaCache));
    val.hostRemote =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.installing =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.waiting =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.active =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    return val;
  };

  ServiceWorkerRegistrationObjectInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.registrationId);
    encoder.encodeStructPointer(url$.Url, val.scope);
    encoder.encodeStruct(codec.Int32, val.updateViaCache);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.hostRemote);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.installing);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.waiting);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.active);
  };
  function ServiceWorkerRegistrationObjectHost_Update_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_Update_Params.prototype.initDefaults_ = function() {
    this.outsideFetchClientSettingsObject = null;
  };
  ServiceWorkerRegistrationObjectHost_Update_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_Update_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_Update_Params.outsideFetchClientSettingsObject
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_client_settings_object$.FetchClientSettingsObject, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_Update_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRegistrationObjectHost_Update_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_Update_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outsideFetchClientSettingsObject =
        decoder.decodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_Update_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_Update_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject, val.outsideFetchClientSettingsObject);
  };
  function ServiceWorkerRegistrationObjectHost_Update_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
  };
  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_Update_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_Update_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_Update_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_Update_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_Update_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
  };
  function ServiceWorkerRegistrationObjectHost_Unregister_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_Unregister_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRegistrationObjectHost_Unregister_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_Unregister_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_Unregister_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRegistrationObjectHost_Unregister_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_Unregister_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRegistrationObjectHost_Unregister_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_Unregister_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
  };
  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
  };
  function ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
  };
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
  };
  function ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
    this.state = null;
  };
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, navigation_preload_state$.NavigationPreloadState, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    val.state =
        decoder.decodeStructPointer(navigation_preload_state$.NavigationPreloadState);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
    encoder.encodeStructPointer(navigation_preload_state$.NavigationPreloadState, val.state);
  };
  function ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.prototype.initDefaults_ = function() {
    this.value = null;
  };
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.value);
  };
  function ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
  };
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
  };
  function ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.prototype.initDefaults_ = function() {
    this.changedMask = null;
    this.installing = null;
    this.waiting = null;
    this.active = null;
  };
  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.changedMask
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ChangedServiceWorkerObjectsMask, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.installing
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.waiting
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.active
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.encodedSize = codec.kStructHeaderSize + 32;

  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changedMask =
        decoder.decodeStructPointer(ChangedServiceWorkerObjectsMask);
    val.installing =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.waiting =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.active =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    return val;
  };

  ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ChangedServiceWorkerObjectsMask, val.changedMask);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.installing);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.waiting);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.active);
  };
  function ServiceWorkerRegistrationObject_SetUpdateViaCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.prototype.initDefaults_ = function() {
    this.updateViaCache = 0;
  };
  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.updateViaCache
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_registration_options$.ServiceWorkerUpdateViaCache);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObject_SetUpdateViaCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.updateViaCache =
        decoder.decodeStruct(new codec.Enum(service_worker_registration_options$.ServiceWorkerUpdateViaCache));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.updateViaCache);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerRegistrationObject_UpdateFound_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRegistrationObject_UpdateFound_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRegistrationObject_UpdateFound_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRegistrationObject_UpdateFound_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRegistrationObject_UpdateFound_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRegistrationObject_UpdateFound_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRegistrationObject_UpdateFound_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRegistrationObject_UpdateFound_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRegistrationObject_UpdateFound_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kServiceWorkerRegistrationObjectHost_Update_Name = 0;
  var kServiceWorkerRegistrationObjectHost_Unregister_Name = 1;
  var kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name = 2;
  var kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name = 3;
  var kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name = 4;

  function ServiceWorkerRegistrationObjectHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerRegistrationObjectHost,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerRegistrationObjectHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerRegistrationObjectHost, associatedInterfacePtrInfo);
  }

  ServiceWorkerRegistrationObjectHostAssociatedPtr.prototype =
      Object.create(ServiceWorkerRegistrationObjectHostPtr.prototype);
  ServiceWorkerRegistrationObjectHostAssociatedPtr.prototype.constructor =
      ServiceWorkerRegistrationObjectHostAssociatedPtr;

  function ServiceWorkerRegistrationObjectHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerRegistrationObjectHostPtr.prototype.update = function() {
    return ServiceWorkerRegistrationObjectHostProxy.prototype.update
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectHostProxy.prototype.update = function(outsideFetchClientSettingsObject) {
    var params_ = new ServiceWorkerRegistrationObjectHost_Update_Params();
    params_.outsideFetchClientSettingsObject = outsideFetchClientSettingsObject;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerRegistrationObjectHost_Update_Name,
          codec.align(ServiceWorkerRegistrationObjectHost_Update_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerRegistrationObjectHost_Update_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerRegistrationObjectHost_Update_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerRegistrationObjectHostPtr.prototype.unregister = function() {
    return ServiceWorkerRegistrationObjectHostProxy.prototype.unregister
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectHostProxy.prototype.unregister = function() {
    var params_ = new ServiceWorkerRegistrationObjectHost_Unregister_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerRegistrationObjectHost_Unregister_Name,
          codec.align(ServiceWorkerRegistrationObjectHost_Unregister_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerRegistrationObjectHost_Unregister_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerRegistrationObjectHostPtr.prototype.enableNavigationPreload = function() {
    return ServiceWorkerRegistrationObjectHostProxy.prototype.enableNavigationPreload
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectHostProxy.prototype.enableNavigationPreload = function(enable) {
    var params_ = new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params();
    params_.enable = enable;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name,
          codec.align(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerRegistrationObjectHostPtr.prototype.getNavigationPreloadState = function() {
    return ServiceWorkerRegistrationObjectHostProxy.prototype.getNavigationPreloadState
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectHostProxy.prototype.getNavigationPreloadState = function() {
    var params_ = new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name,
          codec.align(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerRegistrationObjectHostPtr.prototype.setNavigationPreloadHeader = function() {
    return ServiceWorkerRegistrationObjectHostProxy.prototype.setNavigationPreloadHeader
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectHostProxy.prototype.setNavigationPreloadHeader = function(value) {
    var params_ = new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name,
          codec.align(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ServiceWorkerRegistrationObjectHostStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerRegistrationObjectHostStub.prototype.update = function(outsideFetchClientSettingsObject) {
    return this.delegate_ && this.delegate_.update && this.delegate_.update(outsideFetchClientSettingsObject);
  }
  ServiceWorkerRegistrationObjectHostStub.prototype.unregister = function() {
    return this.delegate_ && this.delegate_.unregister && this.delegate_.unregister();
  }
  ServiceWorkerRegistrationObjectHostStub.prototype.enableNavigationPreload = function(enable) {
    return this.delegate_ && this.delegate_.enableNavigationPreload && this.delegate_.enableNavigationPreload(enable);
  }
  ServiceWorkerRegistrationObjectHostStub.prototype.getNavigationPreloadState = function() {
    return this.delegate_ && this.delegate_.getNavigationPreloadState && this.delegate_.getNavigationPreloadState();
  }
  ServiceWorkerRegistrationObjectHostStub.prototype.setNavigationPreloadHeader = function(value) {
    return this.delegate_ && this.delegate_.setNavigationPreloadHeader && this.delegate_.setNavigationPreloadHeader(value);
  }

  ServiceWorkerRegistrationObjectHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ServiceWorkerRegistrationObjectHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerRegistrationObjectHost_Update_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObjectHost_Update_Params);
      this.update(params.outsideFetchClientSettingsObject).then(function(response) {
        var responseParams =
            new ServiceWorkerRegistrationObjectHost_Update_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerRegistrationObjectHost_Update_Name,
            codec.align(ServiceWorkerRegistrationObjectHost_Update_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerRegistrationObjectHost_Update_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerRegistrationObjectHost_Unregister_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObjectHost_Unregister_Params);
      this.unregister().then(function(response) {
        var responseParams =
            new ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerRegistrationObjectHost_Unregister_Name,
            codec.align(ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params);
      this.enableNavigationPreload(params.enable).then(function(response) {
        var responseParams =
            new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name,
            codec.align(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params);
      this.getNavigationPreloadState().then(function(response) {
        var responseParams =
            new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        responseParams.state = response.state;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name,
            codec.align(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params);
      this.setNavigationPreloadHeader(params.value).then(function(response) {
        var responseParams =
            new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name,
            codec.align(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateServiceWorkerRegistrationObjectHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerRegistrationObjectHost_Update_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_Update_Params;
      break;
      case kServiceWorkerRegistrationObjectHost_Unregister_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_Unregister_Params;
      break;
      case kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params;
      break;
      case kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params;
      break;
      case kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerRegistrationObjectHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kServiceWorkerRegistrationObjectHost_Update_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_Update_ResponseParams;
        break;
      case kServiceWorkerRegistrationObjectHost_Unregister_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams;
        break;
      case kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams;
        break;
      case kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams;
        break;
      case kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ServiceWorkerRegistrationObjectHost = {
    name: 'blink.mojom.ServiceWorkerRegistrationObjectHost',
    kVersion: 0,
    ptrClass: ServiceWorkerRegistrationObjectHostPtr,
    proxyClass: ServiceWorkerRegistrationObjectHostProxy,
    stubClass: ServiceWorkerRegistrationObjectHostStub,
    validateRequest: validateServiceWorkerRegistrationObjectHostRequest,
    validateResponse: validateServiceWorkerRegistrationObjectHostResponse,
  };
  ServiceWorkerRegistrationObjectHostStub.prototype.validator = validateServiceWorkerRegistrationObjectHostRequest;
  ServiceWorkerRegistrationObjectHostProxy.prototype.validator = validateServiceWorkerRegistrationObjectHostResponse;
  var kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name = 0;
  var kServiceWorkerRegistrationObject_SetUpdateViaCache_Name = 1;
  var kServiceWorkerRegistrationObject_UpdateFound_Name = 2;

  function ServiceWorkerRegistrationObjectPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerRegistrationObject,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerRegistrationObjectAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerRegistrationObject, associatedInterfacePtrInfo);
  }

  ServiceWorkerRegistrationObjectAssociatedPtr.prototype =
      Object.create(ServiceWorkerRegistrationObjectPtr.prototype);
  ServiceWorkerRegistrationObjectAssociatedPtr.prototype.constructor =
      ServiceWorkerRegistrationObjectAssociatedPtr;

  function ServiceWorkerRegistrationObjectProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerRegistrationObjectPtr.prototype.setServiceWorkerObjects = function() {
    return ServiceWorkerRegistrationObjectProxy.prototype.setServiceWorkerObjects
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectProxy.prototype.setServiceWorkerObjects = function(changedMask, installing, waiting, active) {
    var params_ = new ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params();
    params_.changedMask = changedMask;
    params_.installing = installing;
    params_.waiting = waiting;
    params_.active = active;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name,
        codec.align(ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params.encodedSize));
    builder.setPayload(ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerRegistrationObjectPtr.prototype.setUpdateViaCache = function() {
    return ServiceWorkerRegistrationObjectProxy.prototype.setUpdateViaCache
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectProxy.prototype.setUpdateViaCache = function(updateViaCache) {
    var params_ = new ServiceWorkerRegistrationObject_SetUpdateViaCache_Params();
    params_.updateViaCache = updateViaCache;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerRegistrationObject_SetUpdateViaCache_Name,
        codec.align(ServiceWorkerRegistrationObject_SetUpdateViaCache_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerRegistrationObject_SetUpdateViaCache_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerRegistrationObjectPtr.prototype.updateFound = function() {
    return ServiceWorkerRegistrationObjectProxy.prototype.updateFound
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRegistrationObjectProxy.prototype.updateFound = function() {
    var params_ = new ServiceWorkerRegistrationObject_UpdateFound_Params();
    var builder = new codec.MessageV0Builder(
        kServiceWorkerRegistrationObject_UpdateFound_Name,
        codec.align(ServiceWorkerRegistrationObject_UpdateFound_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerRegistrationObject_UpdateFound_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerRegistrationObjectStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerRegistrationObjectStub.prototype.setServiceWorkerObjects = function(changedMask, installing, waiting, active) {
    return this.delegate_ && this.delegate_.setServiceWorkerObjects && this.delegate_.setServiceWorkerObjects(changedMask, installing, waiting, active);
  }
  ServiceWorkerRegistrationObjectStub.prototype.setUpdateViaCache = function(updateViaCache) {
    return this.delegate_ && this.delegate_.setUpdateViaCache && this.delegate_.setUpdateViaCache(updateViaCache);
  }
  ServiceWorkerRegistrationObjectStub.prototype.updateFound = function() {
    return this.delegate_ && this.delegate_.updateFound && this.delegate_.updateFound();
  }

  ServiceWorkerRegistrationObjectStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params);
      this.setServiceWorkerObjects(params.changedMask, params.installing, params.waiting, params.active);
      return true;
    case kServiceWorkerRegistrationObject_SetUpdateViaCache_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObject_SetUpdateViaCache_Params);
      this.setUpdateViaCache(params.updateViaCache);
      return true;
    case kServiceWorkerRegistrationObject_UpdateFound_Name:
      var params = reader.decodeStruct(ServiceWorkerRegistrationObject_UpdateFound_Params);
      this.updateFound();
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerRegistrationObjectStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceWorkerRegistrationObjectRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params;
      break;
      case kServiceWorkerRegistrationObject_SetUpdateViaCache_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerRegistrationObject_SetUpdateViaCache_Params;
      break;
      case kServiceWorkerRegistrationObject_UpdateFound_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerRegistrationObject_UpdateFound_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerRegistrationObjectResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceWorkerRegistrationObject = {
    name: 'blink.mojom.ServiceWorkerRegistrationObject',
    kVersion: 0,
    ptrClass: ServiceWorkerRegistrationObjectPtr,
    proxyClass: ServiceWorkerRegistrationObjectProxy,
    stubClass: ServiceWorkerRegistrationObjectStub,
    validateRequest: validateServiceWorkerRegistrationObjectRequest,
    validateResponse: null,
  };
  ServiceWorkerRegistrationObjectStub.prototype.validator = validateServiceWorkerRegistrationObjectRequest;
  ServiceWorkerRegistrationObjectProxy.prototype.validator = null;
  exports.ChangedServiceWorkerObjectsMask = ChangedServiceWorkerObjectsMask;
  exports.ServiceWorkerRegistrationObjectInfo = ServiceWorkerRegistrationObjectInfo;
  exports.ServiceWorkerRegistrationObjectHost = ServiceWorkerRegistrationObjectHost;
  exports.ServiceWorkerRegistrationObjectHostPtr = ServiceWorkerRegistrationObjectHostPtr;
  exports.ServiceWorkerRegistrationObjectHostAssociatedPtr = ServiceWorkerRegistrationObjectHostAssociatedPtr;
  exports.ServiceWorkerRegistrationObject = ServiceWorkerRegistrationObject;
  exports.ServiceWorkerRegistrationObjectPtr = ServiceWorkerRegistrationObjectPtr;
  exports.ServiceWorkerRegistrationObjectAssociatedPtr = ServiceWorkerRegistrationObjectAssociatedPtr;
})();