// third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallbackPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerFetchResponseCallback.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ServiceWorkerFetchResponseCallbackInterface }
 */
blink.mojom.ServiceWorkerFetchResponseCallbackRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerFetchResponseCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerFetchResponseCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerFetchResponseCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FetchAPIResponse } response
   * @param { !blink.mojom.ServiceWorkerFetchEventTiming } timing
   */

  onResponse(
      response,
      timing) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        [
          response,
          timing
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FetchAPIResponse } response
   * @param { !blink.mojom.ServiceWorkerStreamHandle } bodyAsStream
   * @param { !blink.mojom.ServiceWorkerFetchEventTiming } timing
   */

  onResponseStream(
      response,
      bodyAsStream,
      timing) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        [
          response,
          bodyAsStream,
          timing
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.DataElementChunkedDataPipe } requestBody
   * @param { !blink.mojom.ServiceWorkerFetchEventTiming } timing
   */

  onFallback(
      requestBody,
      timing) {
    this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        [
          requestBody,
          timing
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerFetchResponseCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallbackReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerFetchResponseCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerFetchResponseCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerFetchResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerFetchResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        impl.onResponseStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerFetchResponseCallback = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerFetchResponseCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerFetchResponseCallbackRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerFetchResponseCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerFetchResponseCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallbackCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerFetchResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerFetchResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        this.onResponseStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerFetchEventTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerFetchEventTimingSpec.$,
    'ServiceWorkerFetchEventTiming',
    [
      mojo.internal.StructField(
        'dispatchEventTime', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'respondWithSettledTime', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ServiceWorkerFetchEventTiming = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.dispatchEventTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.respondWithSettledTime;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnResponse_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timing', 8,
        0,
        blink.mojom.ServiceWorkerFetchEventTimingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ServiceWorkerFetchResponseCallback_OnResponse_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIResponse } */
    this.response;
    /** @export { !blink.mojom.ServiceWorkerFetchEventTiming } */
    this.timing;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnResponseStream_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bodyAsStream', 8,
        0,
        blink.mojom.ServiceWorkerStreamHandleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timing', 16,
        0,
        blink.mojom.ServiceWorkerFetchEventTimingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ServiceWorkerFetchResponseCallback_OnResponseStream_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIResponse } */
    this.response;
    /** @export { !blink.mojom.ServiceWorkerStreamHandle } */
    this.bodyAsStream;
    /** @export { !blink.mojom.ServiceWorkerFetchEventTiming } */
    this.timing;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnFallback_Params',
    [
      mojo.internal.StructField(
        'requestBody', 0,
        0,
        network.mojom.DataElementChunkedDataPipeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timing', 8,
        0,
        blink.mojom.ServiceWorkerFetchEventTimingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ServiceWorkerFetchResponseCallback_OnFallback_Params = class {
  constructor() {
    /** @export { (network.mojom.DataElementChunkedDataPipe|undefined) } */
    this.requestBody;
    /** @export { !blink.mojom.ServiceWorkerFetchEventTiming } */
    this.timing;
  }
};

