// third_party/blink/public/mojom/service_worker/service_worker_container.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_container.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var fetch_client_settings_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom', '../loader/fetch_client_settings_object.mojom.js');
  }
  var transferable_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/transferable_message.mojom', '../messaging/transferable_message.mojom.js');
  }
  var controller_service_worker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/controller_service_worker.mojom', 'controller_service_worker.mojom.js');
  }
  var service_worker_embedded_worker_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom', 'service_worker_embedded_worker_status.mojom.js');
  }
  var service_worker_error_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom', 'service_worker_error_type.mojom.js');
  }
  var service_worker_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_object.mojom', 'service_worker_object.mojom.js');
  }
  var service_worker_registration$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_registration.mojom', 'service_worker_registration.mojom.js');
  }
  var service_worker_registration_options$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom', 'service_worker_registration_options.mojom.js');
  }
  var web_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom', '../use_counter/metrics/web_feature.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var ControllerServiceWorkerPurpose = {};
  ControllerServiceWorkerPurpose.FETCH_SUB_RESOURCE = 0;
  ControllerServiceWorkerPurpose.MIN_VALUE = 0;
  ControllerServiceWorkerPurpose.MAX_VALUE = 0;

  ControllerServiceWorkerPurpose.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  ControllerServiceWorkerPurpose.toKnownEnumValue = function(value) {
    return value;
  };

  ControllerServiceWorkerPurpose.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ServiceWorkerContainerInfoForClient(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerInfoForClient.prototype.initDefaults_ = function() {
    this.hostRemote = new associatedBindings.AssociatedInterfacePtrInfo();
    this.clientReceiver = new associatedBindings.AssociatedInterfaceRequest();
  };
  ServiceWorkerContainerInfoForClient.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerInfoForClient.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerInfoForClient.hostRemote
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerInfoForClient.clientReceiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerInfoForClient.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerContainerInfoForClient.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerInfoForClient();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hostRemote =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.clientReceiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerContainerInfoForClient.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerInfoForClient.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.hostRemote);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.clientReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerContainerHost_Register_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_Register_Params.prototype.initDefaults_ = function() {
    this.scriptUrl = null;
    this.options = null;
    this.outsideFetchClientSettingsObject = null;
  };
  ServiceWorkerContainerHost_Register_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_Register_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_Params.scriptUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, service_worker_registration_options$.ServiceWorkerRegistrationOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_Params.outsideFetchClientSettingsObject
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, fetch_client_settings_object$.FetchClientSettingsObject, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_Register_Params.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerContainerHost_Register_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_Register_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scriptUrl =
        decoder.decodeStructPointer(url$.Url);
    val.options =
        decoder.decodeStructPointer(service_worker_registration_options$.ServiceWorkerRegistrationOptions);
    val.outsideFetchClientSettingsObject =
        decoder.decodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject);
    return val;
  };

  ServiceWorkerContainerHost_Register_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_Register_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.scriptUrl);
    encoder.encodeStructPointer(service_worker_registration_options$.ServiceWorkerRegistrationOptions, val.options);
    encoder.encodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject, val.outsideFetchClientSettingsObject);
  };
  function ServiceWorkerContainerHost_Register_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_Register_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
    this.registration = null;
  };
  ServiceWorkerContainerHost_Register_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_Register_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_Register_ResponseParams.registration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, service_worker_registration$.ServiceWorkerRegistrationObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_Register_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerContainerHost_Register_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_Register_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    val.registration =
        decoder.decodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo);
    return val;
  };

  ServiceWorkerContainerHost_Register_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_Register_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
    encoder.encodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo, val.registration);
  };
  function ServiceWorkerContainerHost_GetRegistration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistration_Params.prototype.initDefaults_ = function() {
    this.clientUrl = null;
  };
  ServiceWorkerContainerHost_GetRegistration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistration_Params.clientUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistration_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainerHost_GetRegistration_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.clientUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ServiceWorkerContainerHost_GetRegistration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.clientUrl);
  };
  function ServiceWorkerContainerHost_GetRegistration_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistration_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
    this.registration = null;
  };
  ServiceWorkerContainerHost_GetRegistration_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistration_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistration_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistration_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistration_ResponseParams.registration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, service_worker_registration$.ServiceWorkerRegistrationObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistration_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerContainerHost_GetRegistration_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistration_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    val.registration =
        decoder.decodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo);
    return val;
  };

  ServiceWorkerContainerHost_GetRegistration_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistration_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
    encoder.encodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo, val.registration);
  };
  function ServiceWorkerContainerHost_GetRegistrations_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistrations_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerContainerHost_GetRegistrations_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistrations_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistrations_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerContainerHost_GetRegistrations_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistrations_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerContainerHost_GetRegistrations_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistrations_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerContainerHost_GetRegistrations_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.errorMsg = null;
    this.infos = null;
  };
  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistrations_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_error_type$.ServiceWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistrations_ResponseParams.errorMsg
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistrations_ResponseParams.infos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(service_worker_registration$.ServiceWorkerRegistrationObjectInfo), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistrations_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(service_worker_error_type$.ServiceWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMsg =
        decoder.decodeStruct(codec.String);
    val.infos =
        decoder.decodeArrayPointer(new codec.PointerTo(service_worker_registration$.ServiceWorkerRegistrationObjectInfo));
    return val;
  };

  ServiceWorkerContainerHost_GetRegistrations_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistrations_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMsg);
    encoder.encodeArrayPointer(new codec.PointerTo(service_worker_registration$.ServiceWorkerRegistrationObjectInfo), val.infos);
  };
  function ServiceWorkerContainerHost_GetRegistrationForReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistrationForReady_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerContainerHost_GetRegistrationForReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerContainerHost_GetRegistrationForReady_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistrationForReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistrationForReady_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.prototype.initDefaults_ = function() {
    this.registration = null;
  };
  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.registration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, service_worker_registration$.ServiceWorkerRegistrationObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.registration =
        decoder.decodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo);
    return val;
  };

  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(service_worker_registration$.ServiceWorkerRegistrationObjectInfo, val.registration);
  };
  function ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.purpose = 0;
  };
  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.purpose
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ControllerServiceWorkerPurpose);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.purpose =
        decoder.decodeStruct(new codec.Enum(ControllerServiceWorkerPurpose));
    return val;
  };

  ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(codec.Int32, val.purpose);
  };
  function ServiceWorkerContainerHost_CloneContainerHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_CloneContainerHost_Params.prototype.initDefaults_ = function() {
    this.containerHost = new bindings.InterfaceRequest();
  };
  ServiceWorkerContainerHost_CloneContainerHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_CloneContainerHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_CloneContainerHost_Params.containerHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_CloneContainerHost_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainerHost_CloneContainerHost_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_CloneContainerHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.containerHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerContainerHost_CloneContainerHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_CloneContainerHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.containerHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerContainerHost_EnsureFileAccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_EnsureFileAccess_Params.prototype.initDefaults_ = function() {
    this.files = null;
  };
  ServiceWorkerContainerHost_EnsureFileAccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_EnsureFileAccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainerHost_EnsureFileAccess_Params.files
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(file_path$.FilePath), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_EnsureFileAccess_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainerHost_EnsureFileAccess_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_EnsureFileAccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.files =
        decoder.decodeArrayPointer(new codec.PointerTo(file_path$.FilePath));
    return val;
  };

  ServiceWorkerContainerHost_EnsureFileAccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_EnsureFileAccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(file_path$.FilePath), val.files);
  };
  function ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.prototype.initDefaults_ = function() {
  };
  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerContainerHost_OnExecutionReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainerHost_OnExecutionReady_Params.prototype.initDefaults_ = function() {
  };
  ServiceWorkerContainerHost_OnExecutionReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainerHost_OnExecutionReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainerHost_OnExecutionReady_Params.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerContainerHost_OnExecutionReady_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainerHost_OnExecutionReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerContainerHost_OnExecutionReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainerHost_OnExecutionReady_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerContainer_SetController_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainer_SetController_Params.prototype.initDefaults_ = function() {
    this.controllerInfo = null;
    this.shouldNotifyControllerchange = false;
  };
  ServiceWorkerContainer_SetController_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainer_SetController_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainer_SetController_Params.controllerInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, controller_service_worker$.ControllerServiceWorkerInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ServiceWorkerContainer_SetController_Params.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerContainer_SetController_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainer_SetController_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.controllerInfo =
        decoder.decodeStructPointer(controller_service_worker$.ControllerServiceWorkerInfo);
    packed = decoder.readUint8();
    val.shouldNotifyControllerchange = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerContainer_SetController_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainer_SetController_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(controller_service_worker$.ControllerServiceWorkerInfo, val.controllerInfo);
    packed = 0;
    packed |= (val.shouldNotifyControllerchange & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerContainer_PostMessageToClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainer_PostMessageToClient_Params.prototype.initDefaults_ = function() {
    this.source = null;
    this.message = null;
  };
  ServiceWorkerContainer_PostMessageToClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainer_PostMessageToClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainer_PostMessageToClient_Params.source
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, service_worker_object$.ServiceWorkerObjectInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainer_PostMessageToClient_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, transferable_message$.TransferableMessage, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainer_PostMessageToClient_Params.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerContainer_PostMessageToClient_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainer_PostMessageToClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.message =
        decoder.decodeStructPointer(transferable_message$.TransferableMessage);
    return val;
  };

  ServiceWorkerContainer_PostMessageToClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainer_PostMessageToClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.source);
    encoder.encodeStructPointer(transferable_message$.TransferableMessage, val.message);
  };
  function ServiceWorkerContainer_CountFeature_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContainer_CountFeature_Params.prototype.initDefaults_ = function() {
    this.feature = 0;
  };
  ServiceWorkerContainer_CountFeature_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContainer_CountFeature_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContainer_CountFeature_Params.feature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, web_feature$.WebFeature);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerContainer_CountFeature_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerContainer_CountFeature_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContainer_CountFeature_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.feature =
        decoder.decodeStruct(new codec.Enum(web_feature$.WebFeature));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerContainer_CountFeature_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContainer_CountFeature_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.feature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kServiceWorkerContainerHost_Register_Name = 0;
  var kServiceWorkerContainerHost_GetRegistration_Name = 1;
  var kServiceWorkerContainerHost_GetRegistrations_Name = 2;
  var kServiceWorkerContainerHost_GetRegistrationForReady_Name = 3;
  var kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name = 4;
  var kServiceWorkerContainerHost_CloneContainerHost_Name = 5;
  var kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name = 6;
  var kServiceWorkerContainerHost_EnsureFileAccess_Name = 7;
  var kServiceWorkerContainerHost_OnExecutionReady_Name = 8;

  function ServiceWorkerContainerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerContainerHost,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerContainerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerContainerHost, associatedInterfacePtrInfo);
  }

  ServiceWorkerContainerHostAssociatedPtr.prototype =
      Object.create(ServiceWorkerContainerHostPtr.prototype);
  ServiceWorkerContainerHostAssociatedPtr.prototype.constructor =
      ServiceWorkerContainerHostAssociatedPtr;

  function ServiceWorkerContainerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerContainerHostPtr.prototype.register = function() {
    return ServiceWorkerContainerHostProxy.prototype.register
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.register = function(scriptUrl, options, outsideFetchClientSettingsObject) {
    var params_ = new ServiceWorkerContainerHost_Register_Params();
    params_.scriptUrl = scriptUrl;
    params_.options = options;
    params_.outsideFetchClientSettingsObject = outsideFetchClientSettingsObject;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kServiceWorkerContainerHost_Register_Name,
          codec.align(ServiceWorkerContainerHost_Register_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ServiceWorkerContainerHost_Register_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerContainerHost_Register_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerContainerHostPtr.prototype.getRegistration = function() {
    return ServiceWorkerContainerHostProxy.prototype.getRegistration
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.getRegistration = function(clientUrl) {
    var params_ = new ServiceWorkerContainerHost_GetRegistration_Params();
    params_.clientUrl = clientUrl;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kServiceWorkerContainerHost_GetRegistration_Name,
          codec.align(ServiceWorkerContainerHost_GetRegistration_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ServiceWorkerContainerHost_GetRegistration_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerContainerHost_GetRegistration_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerContainerHostPtr.prototype.getRegistrations = function() {
    return ServiceWorkerContainerHostProxy.prototype.getRegistrations
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.getRegistrations = function() {
    var params_ = new ServiceWorkerContainerHost_GetRegistrations_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kServiceWorkerContainerHost_GetRegistrations_Name,
          codec.align(ServiceWorkerContainerHost_GetRegistrations_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ServiceWorkerContainerHost_GetRegistrations_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerContainerHost_GetRegistrations_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerContainerHostPtr.prototype.getRegistrationForReady = function() {
    return ServiceWorkerContainerHostProxy.prototype.getRegistrationForReady
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.getRegistrationForReady = function() {
    var params_ = new ServiceWorkerContainerHost_GetRegistrationForReady_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kServiceWorkerContainerHost_GetRegistrationForReady_Name,
          codec.align(ServiceWorkerContainerHost_GetRegistrationForReady_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ServiceWorkerContainerHost_GetRegistrationForReady_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerContainerHostPtr.prototype.ensureControllerServiceWorker = function() {
    return ServiceWorkerContainerHostProxy.prototype.ensureControllerServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.ensureControllerServiceWorker = function(receiver, purpose) {
    var params_ = new ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params();
    params_.receiver = receiver;
    params_.purpose = purpose;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name,
        codec.align(ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerContainerHostPtr.prototype.cloneContainerHost = function() {
    return ServiceWorkerContainerHostProxy.prototype.cloneContainerHost
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.cloneContainerHost = function(containerHost) {
    var params_ = new ServiceWorkerContainerHost_CloneContainerHost_Params();
    params_.containerHost = containerHost;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerContainerHost_CloneContainerHost_Name,
        codec.align(ServiceWorkerContainerHost_CloneContainerHost_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerContainerHost_CloneContainerHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerContainerHostPtr.prototype.hintToUpdateServiceWorker = function() {
    return ServiceWorkerContainerHostProxy.prototype.hintToUpdateServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.hintToUpdateServiceWorker = function() {
    var params_ = new ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params();
    var builder = new codec.MessageV0Builder(
        kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name,
        codec.align(ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerContainerHostPtr.prototype.ensureFileAccess = function() {
    return ServiceWorkerContainerHostProxy.prototype.ensureFileAccess
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.ensureFileAccess = function(files) {
    var params_ = new ServiceWorkerContainerHost_EnsureFileAccess_Params();
    params_.files = files;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerContainerHost_EnsureFileAccess_Name,
          codec.align(ServiceWorkerContainerHost_EnsureFileAccess_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerContainerHost_EnsureFileAccess_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerContainerHostPtr.prototype.onExecutionReady = function() {
    return ServiceWorkerContainerHostProxy.prototype.onExecutionReady
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerHostProxy.prototype.onExecutionReady = function() {
    var params_ = new ServiceWorkerContainerHost_OnExecutionReady_Params();
    var builder = new codec.MessageV0Builder(
        kServiceWorkerContainerHost_OnExecutionReady_Name,
        codec.align(ServiceWorkerContainerHost_OnExecutionReady_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerContainerHost_OnExecutionReady_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerContainerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerContainerHostStub.prototype.register = function(scriptUrl, options, outsideFetchClientSettingsObject) {
    return this.delegate_ && this.delegate_.register && this.delegate_.register(scriptUrl, options, outsideFetchClientSettingsObject);
  }
  ServiceWorkerContainerHostStub.prototype.getRegistration = function(clientUrl) {
    return this.delegate_ && this.delegate_.getRegistration && this.delegate_.getRegistration(clientUrl);
  }
  ServiceWorkerContainerHostStub.prototype.getRegistrations = function() {
    return this.delegate_ && this.delegate_.getRegistrations && this.delegate_.getRegistrations();
  }
  ServiceWorkerContainerHostStub.prototype.getRegistrationForReady = function() {
    return this.delegate_ && this.delegate_.getRegistrationForReady && this.delegate_.getRegistrationForReady();
  }
  ServiceWorkerContainerHostStub.prototype.ensureControllerServiceWorker = function(receiver, purpose) {
    return this.delegate_ && this.delegate_.ensureControllerServiceWorker && this.delegate_.ensureControllerServiceWorker(receiver, purpose);
  }
  ServiceWorkerContainerHostStub.prototype.cloneContainerHost = function(containerHost) {
    return this.delegate_ && this.delegate_.cloneContainerHost && this.delegate_.cloneContainerHost(containerHost);
  }
  ServiceWorkerContainerHostStub.prototype.hintToUpdateServiceWorker = function() {
    return this.delegate_ && this.delegate_.hintToUpdateServiceWorker && this.delegate_.hintToUpdateServiceWorker();
  }
  ServiceWorkerContainerHostStub.prototype.ensureFileAccess = function(files) {
    return this.delegate_ && this.delegate_.ensureFileAccess && this.delegate_.ensureFileAccess(files);
  }
  ServiceWorkerContainerHostStub.prototype.onExecutionReady = function() {
    return this.delegate_ && this.delegate_.onExecutionReady && this.delegate_.onExecutionReady();
  }

  ServiceWorkerContainerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params);
      this.ensureControllerServiceWorker(params.receiver, params.purpose);
      return true;
    case kServiceWorkerContainerHost_CloneContainerHost_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_CloneContainerHost_Params);
      this.cloneContainerHost(params.containerHost);
      return true;
    case kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params);
      this.hintToUpdateServiceWorker();
      return true;
    case kServiceWorkerContainerHost_OnExecutionReady_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_OnExecutionReady_Params);
      this.onExecutionReady();
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerContainerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerContainerHost_Register_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_Register_Params);
      this.register(params.scriptUrl, params.options, params.outsideFetchClientSettingsObject).then(function(response) {
        var responseParams =
            new ServiceWorkerContainerHost_Register_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        responseParams.registration = response.registration;
        var builder = new codec.MessageV2Builder(
            kServiceWorkerContainerHost_Register_Name,
            codec.align(ServiceWorkerContainerHost_Register_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ServiceWorkerContainerHost_Register_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerContainerHost_GetRegistration_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_GetRegistration_Params);
      this.getRegistration(params.clientUrl).then(function(response) {
        var responseParams =
            new ServiceWorkerContainerHost_GetRegistration_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        responseParams.registration = response.registration;
        var builder = new codec.MessageV2Builder(
            kServiceWorkerContainerHost_GetRegistration_Name,
            codec.align(ServiceWorkerContainerHost_GetRegistration_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ServiceWorkerContainerHost_GetRegistration_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerContainerHost_GetRegistrations_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_GetRegistrations_Params);
      this.getRegistrations().then(function(response) {
        var responseParams =
            new ServiceWorkerContainerHost_GetRegistrations_ResponseParams();
        responseParams.error = response.error;
        responseParams.errorMsg = response.errorMsg;
        responseParams.infos = response.infos;
        var builder = new codec.MessageV2Builder(
            kServiceWorkerContainerHost_GetRegistrations_Name,
            codec.align(ServiceWorkerContainerHost_GetRegistrations_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ServiceWorkerContainerHost_GetRegistrations_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerContainerHost_GetRegistrationForReady_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_GetRegistrationForReady_Params);
      this.getRegistrationForReady().then(function(response) {
        var responseParams =
            new ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams();
        responseParams.registration = response.registration;
        var builder = new codec.MessageV2Builder(
            kServiceWorkerContainerHost_GetRegistrationForReady_Name,
            codec.align(ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kServiceWorkerContainerHost_EnsureFileAccess_Name:
      var params = reader.decodeStruct(ServiceWorkerContainerHost_EnsureFileAccess_Params);
      this.ensureFileAccess(params.files).then(function(response) {
        var responseParams =
            new ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kServiceWorkerContainerHost_EnsureFileAccess_Name,
            codec.align(ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateServiceWorkerContainerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerContainerHost_Register_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerContainerHost_Register_Params;
      break;
      case kServiceWorkerContainerHost_GetRegistration_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistration_Params;
      break;
      case kServiceWorkerContainerHost_GetRegistrations_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistrations_Params;
      break;
      case kServiceWorkerContainerHost_GetRegistrationForReady_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistrationForReady_Params;
      break;
      case kServiceWorkerContainerHost_EnsureControllerServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params;
      break;
      case kServiceWorkerContainerHost_CloneContainerHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainerHost_CloneContainerHost_Params;
      break;
      case kServiceWorkerContainerHost_HintToUpdateServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params;
      break;
      case kServiceWorkerContainerHost_EnsureFileAccess_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerContainerHost_EnsureFileAccess_Params;
      break;
      case kServiceWorkerContainerHost_OnExecutionReady_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainerHost_OnExecutionReady_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerContainerHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kServiceWorkerContainerHost_Register_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerContainerHost_Register_ResponseParams;
        break;
      case kServiceWorkerContainerHost_GetRegistration_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistration_ResponseParams;
        break;
      case kServiceWorkerContainerHost_GetRegistrations_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistrations_ResponseParams;
        break;
      case kServiceWorkerContainerHost_GetRegistrationForReady_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams;
        break;
      case kServiceWorkerContainerHost_EnsureFileAccess_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ServiceWorkerContainerHost = {
    name: 'blink.mojom.ServiceWorkerContainerHost',
    kVersion: 0,
    ptrClass: ServiceWorkerContainerHostPtr,
    proxyClass: ServiceWorkerContainerHostProxy,
    stubClass: ServiceWorkerContainerHostStub,
    validateRequest: validateServiceWorkerContainerHostRequest,
    validateResponse: validateServiceWorkerContainerHostResponse,
  };
  ServiceWorkerContainerHostStub.prototype.validator = validateServiceWorkerContainerHostRequest;
  ServiceWorkerContainerHostProxy.prototype.validator = validateServiceWorkerContainerHostResponse;
  var kServiceWorkerContainer_SetController_Name = 0;
  var kServiceWorkerContainer_PostMessageToClient_Name = 1;
  var kServiceWorkerContainer_CountFeature_Name = 2;

  function ServiceWorkerContainerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerContainer,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerContainerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerContainer, associatedInterfacePtrInfo);
  }

  ServiceWorkerContainerAssociatedPtr.prototype =
      Object.create(ServiceWorkerContainerPtr.prototype);
  ServiceWorkerContainerAssociatedPtr.prototype.constructor =
      ServiceWorkerContainerAssociatedPtr;

  function ServiceWorkerContainerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerContainerPtr.prototype.setController = function() {
    return ServiceWorkerContainerProxy.prototype.setController
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerProxy.prototype.setController = function(controllerInfo, shouldNotifyControllerchange) {
    var params_ = new ServiceWorkerContainer_SetController_Params();
    params_.controllerInfo = controllerInfo;
    params_.shouldNotifyControllerchange = shouldNotifyControllerchange;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerContainer_SetController_Name,
        codec.align(ServiceWorkerContainer_SetController_Params.encodedSize));
    builder.setPayload(ServiceWorkerContainer_SetController_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerContainerPtr.prototype.postMessageToClient = function() {
    return ServiceWorkerContainerProxy.prototype.postMessageToClient
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerProxy.prototype.postMessageToClient = function(source, message) {
    var params_ = new ServiceWorkerContainer_PostMessageToClient_Params();
    params_.source = source;
    params_.message = message;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerContainer_PostMessageToClient_Name,
        codec.align(ServiceWorkerContainer_PostMessageToClient_Params.encodedSize));
    builder.setPayload(ServiceWorkerContainer_PostMessageToClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerContainerPtr.prototype.countFeature = function() {
    return ServiceWorkerContainerProxy.prototype.countFeature
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerContainerProxy.prototype.countFeature = function(feature) {
    var params_ = new ServiceWorkerContainer_CountFeature_Params();
    params_.feature = feature;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerContainer_CountFeature_Name,
        codec.align(ServiceWorkerContainer_CountFeature_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerContainer_CountFeature_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerContainerStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerContainerStub.prototype.setController = function(controllerInfo, shouldNotifyControllerchange) {
    return this.delegate_ && this.delegate_.setController && this.delegate_.setController(controllerInfo, shouldNotifyControllerchange);
  }
  ServiceWorkerContainerStub.prototype.postMessageToClient = function(source, message) {
    return this.delegate_ && this.delegate_.postMessageToClient && this.delegate_.postMessageToClient(source, message);
  }
  ServiceWorkerContainerStub.prototype.countFeature = function(feature) {
    return this.delegate_ && this.delegate_.countFeature && this.delegate_.countFeature(feature);
  }

  ServiceWorkerContainerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerContainer_SetController_Name:
      var params = reader.decodeStruct(ServiceWorkerContainer_SetController_Params);
      this.setController(params.controllerInfo, params.shouldNotifyControllerchange);
      return true;
    case kServiceWorkerContainer_PostMessageToClient_Name:
      var params = reader.decodeStruct(ServiceWorkerContainer_PostMessageToClient_Params);
      this.postMessageToClient(params.source, params.message);
      return true;
    case kServiceWorkerContainer_CountFeature_Name:
      var params = reader.decodeStruct(ServiceWorkerContainer_CountFeature_Params);
      this.countFeature(params.feature);
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerContainerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceWorkerContainerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerContainer_SetController_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainer_SetController_Params;
      break;
      case kServiceWorkerContainer_PostMessageToClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainer_PostMessageToClient_Params;
      break;
      case kServiceWorkerContainer_CountFeature_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerContainer_CountFeature_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerContainerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceWorkerContainer = {
    name: 'blink.mojom.ServiceWorkerContainer',
    kVersion: 0,
    ptrClass: ServiceWorkerContainerPtr,
    proxyClass: ServiceWorkerContainerProxy,
    stubClass: ServiceWorkerContainerStub,
    validateRequest: validateServiceWorkerContainerRequest,
    validateResponse: null,
  };
  ServiceWorkerContainerStub.prototype.validator = validateServiceWorkerContainerRequest;
  ServiceWorkerContainerProxy.prototype.validator = null;
  exports.ControllerServiceWorkerPurpose = ControllerServiceWorkerPurpose;
  exports.ServiceWorkerContainerInfoForClient = ServiceWorkerContainerInfoForClient;
  exports.ServiceWorkerContainerHost = ServiceWorkerContainerHost;
  exports.ServiceWorkerContainerHostPtr = ServiceWorkerContainerHostPtr;
  exports.ServiceWorkerContainerHostAssociatedPtr = ServiceWorkerContainerHostAssociatedPtr;
  exports.ServiceWorkerContainer = ServiceWorkerContainer;
  exports.ServiceWorkerContainerPtr = ServiceWorkerContainerPtr;
  exports.ServiceWorkerContainerAssociatedPtr = ServiceWorkerContainerAssociatedPtr;
})();