// third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/public/common/messaging/accelerated_static_bitmap_image_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_embedded_worker_status_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace blink::mojom::blink {
ServiceWorkerContainerInfoForClient::ServiceWorkerContainerInfoForClient()
    : host_remote(),
      client_receiver() {}

ServiceWorkerContainerInfoForClient::ServiceWorkerContainerInfoForClient(
    ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost> host_remote_in,
    ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer> client_receiver_in)
    : host_remote(std::move(host_remote_in)),
      client_receiver(std::move(client_receiver_in)) {}

ServiceWorkerContainerInfoForClient::~ServiceWorkerContainerInfoForClient() = default;

void ServiceWorkerContainerInfoForClient::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_remote"), this->host_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<ServiceWorkerContainerHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<ServiceWorkerContainer>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerContainerInfoForClient::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerContainerHost::IPCStableHashFunction ServiceWorkerContainerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerContainerHost>(message.name())) {
    case messages::ServiceWorkerContainerHost::kRegister: {
      return &ServiceWorkerContainerHost::Register_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistration: {
      return &ServiceWorkerContainerHost::GetRegistration_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrations: {
      return &ServiceWorkerContainerHost::GetRegistrations_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrationForReady: {
      return &ServiceWorkerContainerHost::GetRegistrationForReady_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker: {
      return &ServiceWorkerContainerHost::EnsureControllerServiceWorker_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kCloneContainerHost: {
      return &ServiceWorkerContainerHost::CloneContainerHost_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker: {
      return &ServiceWorkerContainerHost::HintToUpdateServiceWorker_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kEnsureFileAccess: {
      return &ServiceWorkerContainerHost::EnsureFileAccess_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainerHost::kOnExecutionReady: {
      return &ServiceWorkerContainerHost::OnExecutionReady_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerContainerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerContainerHost>(message.name())) {
      case messages::ServiceWorkerContainerHost::kRegister:
            return "Receive blink::mojom::ServiceWorkerContainerHost::Register";
      case messages::ServiceWorkerContainerHost::kGetRegistration:
            return "Receive blink::mojom::ServiceWorkerContainerHost::GetRegistration";
      case messages::ServiceWorkerContainerHost::kGetRegistrations:
            return "Receive blink::mojom::ServiceWorkerContainerHost::GetRegistrations";
      case messages::ServiceWorkerContainerHost::kGetRegistrationForReady:
            return "Receive blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady";
      case messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker:
            return "Receive blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker";
      case messages::ServiceWorkerContainerHost::kCloneContainerHost:
            return "Receive blink::mojom::ServiceWorkerContainerHost::CloneContainerHost";
      case messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker:
            return "Receive blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker";
      case messages::ServiceWorkerContainerHost::kEnsureFileAccess:
            return "Receive blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess";
      case messages::ServiceWorkerContainerHost::kOnExecutionReady:
            return "Receive blink::mojom::ServiceWorkerContainerHost::OnExecutionReady";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerContainerHost>(message.name())) {
      case messages::ServiceWorkerContainerHost::kRegister:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::Register";
      case messages::ServiceWorkerContainerHost::kGetRegistration:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::GetRegistration";
      case messages::ServiceWorkerContainerHost::kGetRegistrations:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::GetRegistrations";
      case messages::ServiceWorkerContainerHost::kGetRegistrationForReady:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady";
      case messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker";
      case messages::ServiceWorkerContainerHost::kCloneContainerHost:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::CloneContainerHost";
      case messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker";
      case messages::ServiceWorkerContainerHost::kEnsureFileAccess:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess";
      case messages::ServiceWorkerContainerHost::kOnExecutionReady:
            return "Receive reply blink::mojom::ServiceWorkerContainerHost::OnExecutionReady";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerContainerHost::Register_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5573413;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::Register
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::GetRegistration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefd2a65e;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::GetRegistration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::GetRegistrations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc0362cf;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::GetRegistrations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::GetRegistrationForReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5a0c34f;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::EnsureControllerServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ed6b36f;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::CloneContainerHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a6ccd2a;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::CloneContainerHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::HintToUpdateServiceWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb10041f;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::EnsureFileAccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbff6ebd8;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainerHost::OnExecutionReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b4771ed;  // IPCStableHash for blink::mojom::ServiceWorkerContainerHost::OnExecutionReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerContainerHost_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_Register_ForwardToCallback(
      ServiceWorkerContainerHost::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerContainerHost_Register_ForwardToCallback(const ServiceWorkerContainerHost_Register_ForwardToCallback&) = delete;
  ServiceWorkerContainerHost_Register_ForwardToCallback& operator=(const ServiceWorkerContainerHost_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::RegisterCallback callback_;
};

class ServiceWorkerContainerHost_GetRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistration_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerContainerHost_GetRegistration_ForwardToCallback(const ServiceWorkerContainerHost_GetRegistration_ForwardToCallback&) = delete;
  ServiceWorkerContainerHost_GetRegistration_ForwardToCallback& operator=(const ServiceWorkerContainerHost_GetRegistration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationCallback callback_;
};

class ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback(const ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback&) = delete;
  ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback& operator=(const ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationsCallback callback_;
};

class ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback(
      ServiceWorkerContainerHost::GetRegistrationForReadyCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback(const ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback&) = delete;
  ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback& operator=(const ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::GetRegistrationForReadyCallback callback_;
};

class ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback(
      ServiceWorkerContainerHost::EnsureFileAccessCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback(const ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback&) = delete;
  ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback& operator=(const ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerContainerHost::EnsureFileAccessCallback callback_;
};

ServiceWorkerContainerHostProxy::ServiceWorkerContainerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerContainerHostProxy::Register(
    const ::blink::KURL& in_script_url, ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr in_options, ::blink::mojom::blink::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainerHost::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outside_fetch_client_settings_object"), in_outside_fetch_client_settings_object,
                        "<value of type ::blink::mojom::blink::FetchClientSettingsObjectPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_script_url,
    script_url_fragment);

  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_url in ServiceWorkerContainerHost.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in ServiceWorkerContainerHost.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
    in_outside_fetch_client_settings_object,
    outside_fetch_client_settings_object_fragment);

  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->outside_fetch_client_settings_object.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null outside_fetch_client_settings_object in ServiceWorkerContainerHost.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerContainerHostProxy::GetRegistration(
    const ::blink::KURL& in_client_url, GetRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainerHost::GetRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_url"), in_client_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_url)::BaseType> client_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_client_url,
    client_url_fragment);

  params->client_url.Set(
      client_url_fragment.is_null() ? nullptr : client_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_url in ServiceWorkerContainerHost.GetRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerContainerHostProxy::GetRegistrations(
    GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerContainerHost::GetRegistrations");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerContainerHostProxy::GetRegistrationForReady(
    GetRegistrationForReadyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistrationForReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrationForReady");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerContainerHostProxy::EnsureControllerServiceWorker(
    ::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> in_receiver, ControllerServiceWorkerPurpose in_purpose) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainerHost::EnsureControllerServiceWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purpose"), in_purpose,
                        "<value of type ControllerServiceWorkerPurpose>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ServiceWorkerContainerHost.EnsureControllerServiceWorker request");

  
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerPurpose>(
    in_purpose,
    &params->purpose);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureControllerServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerContainerHostProxy::CloneContainerHost(
    ::mojo::PendingReceiver<ServiceWorkerContainerHost> in_container_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainerHost::CloneContainerHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_host"), in_container_host,
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerContainerHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kCloneContainerHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerContainerHostInterfaceBase>>(
    in_container_host,
    &params->container_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->container_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid container_host in ServiceWorkerContainerHost.CloneContainerHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("CloneContainerHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerContainerHostProxy::HintToUpdateServiceWorker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerContainerHost::HintToUpdateServiceWorker");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("HintToUpdateServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerContainerHostProxy::EnsureFileAccess(
    const ::blink::Vector<::base::FilePath>& in_files, EnsureFileAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type const ::blink::Vector<::base::FilePath>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kEnsureFileAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in ServiceWorkerContainerHost.EnsureFileAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureFileAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerContainerHostProxy::OnExecutionReady(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerContainerHost::OnExecutionReady");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kOnExecutionReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("OnExecutionReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ServiceWorkerContainerHost_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerContainerHost_Register_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerContainerHost_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerContainerHost_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerContainerHost::RegisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration);
};

bool ServiceWorkerContainerHost_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_Register_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerContainerHost.0
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerErrorType p_error{};
  ::blink::String p_error_msg{};
  ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_registration));
  }
  return true;
}

void ServiceWorkerContainerHost_Register_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerContainerHost::Register", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistration_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerContainerHost_GetRegistration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerContainerHost::GetRegistrationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration);
};

bool ServiceWorkerContainerHost_GetRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerContainerHost.1
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerErrorType p_error{};
  ::blink::String p_error_msg{};
  ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_GetRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_registration));
  }
  return true;
}

void ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerContainerHost::GetRegistration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerContainerHost::GetRegistrationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>> in_infos);
};

bool ServiceWorkerContainerHost_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerContainerHost.2
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerErrorType p_error{};
  ::blink::String p_error_msg{};
  std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>> p_infos{};
  ServiceWorkerContainerHost_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadInfos(&p_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_infos));
  }
  return true;
}

void ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerErrorType in_error, const ::blink::String& in_error_msg, std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerContainerHost::GetRegistrations", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::ServiceWorkerErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos,
                        "<value of type std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>>(
    in_infos,
    infos_fragment,
    &infos_validate_params);

  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::GetRegistrationForReadyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerContainerHost::GetRegistrationForReadyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration);
};

bool ServiceWorkerContainerHost_GetRegistrationForReady_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerContainerHost.3
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr p_registration{};
  ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_registration));
  }
  return true;
}

void ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::Run(
    ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ServiceWorkerContainerHost::GetRegistrationForReady", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kGetRegistrationForReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerRegistrationObjectInfoDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("GetRegistrationForReady");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerContainerHost::EnsureFileAccessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder> proxy(
        new ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerContainerHost::EnsureFileAccessCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorkerContainerHost_EnsureFileAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerContainerHost.7
  bool success = true;
  ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerContainerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::ServiceWorkerContainerHost::EnsureFileAccess");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainerHost::kEnsureFileAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainerHost::Name_);
  message.set_method_name("EnsureFileAccess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerContainerHostStubDispatch::Accept(
    ServiceWorkerContainerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerContainerHost>(message->header()->name)) {
    case messages::ServiceWorkerContainerHost::kRegister: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistration: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrations: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrationForReady: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.4
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> p_receiver{};
      ControllerServiceWorkerPurpose p_purpose{};
      ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadPurpose(&p_purpose))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnsureControllerServiceWorker(        
        std::move(p_receiver), 
        std::move(p_purpose));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kCloneContainerHost: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.5
      bool success = true;
      ::mojo::PendingReceiver<ServiceWorkerContainerHost> p_container_host{};
      ServiceWorkerContainerHost_CloneContainerHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_container_host =
            input_data_view.TakeContainerHost<decltype(p_container_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneContainerHost(        
        std::move(p_container_host));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.6
      bool success = true;
      ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HintToUpdateServiceWorker(        );
      return true;
    }
    case messages::ServiceWorkerContainerHost::kEnsureFileAccess: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kOnExecutionReady: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.8
      bool success = true;
      ServiceWorkerContainerHost_OnExecutionReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExecutionReady(        );
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerContainerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerContainerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerContainerHost>(message->header()->name)) {
    case messages::ServiceWorkerContainerHost::kRegister: {
      internal::ServiceWorkerContainerHost_Register_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_Register_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.0
      bool success = true;
      ::blink::KURL p_script_url{};
      ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr p_options{};
      ::blink::mojom::blink::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ServiceWorkerContainerHost_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerContainerHost_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(        
        std::move(p_script_url), 
        std::move(p_options), 
        std::move(p_outside_fetch_client_settings_object), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistration: {
      internal::ServiceWorkerContainerHost_GetRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.1
      bool success = true;
      ::blink::KURL p_client_url{};
      ServiceWorkerContainerHost_GetRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUrl(&p_client_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorkerContainerHost_GetRegistration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistration(        
        std::move(p_client_url), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrations: {
      internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.2
      bool success = true;
      ServiceWorkerContainerHost_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorkerContainerHost_GetRegistrations_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kGetRegistrationForReady: {
      internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.3
      bool success = true;
      ServiceWorkerContainerHost_GetRegistrationForReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorkerContainerHost_GetRegistrationForReady_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrationForReady(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kEnsureControllerServiceWorker: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kCloneContainerHost: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kHintToUpdateServiceWorker: {
      break;
    }
    case messages::ServiceWorkerContainerHost::kEnsureFileAccess: {
      internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerContainerHost.7
      bool success = true;
      ::blink::Vector<::base::FilePath> p_files{};
      ServiceWorkerContainerHost_EnsureFileAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainerHost::Name_, 7, false);
        return false;
      }
      auto callback =
          ServiceWorkerContainerHost_EnsureFileAccess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnsureFileAccess(        
        std::move(p_files), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerContainerHost::kOnExecutionReady: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerContainerHostValidationInfo[] = {
    { &internal::ServiceWorkerContainerHost_Register_Params_Data::Validate,
     &internal::ServiceWorkerContainerHost_Register_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerContainerHost_GetRegistration_Params_Data::Validate,
     &internal::ServiceWorkerContainerHost_GetRegistration_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerContainerHost_GetRegistrations_Params_Data::Validate,
     &internal::ServiceWorkerContainerHost_GetRegistrations_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerContainerHost_GetRegistrationForReady_Params_Data::Validate,
     &internal::ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerContainerHost_CloneContainerHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerContainerHost_EnsureFileAccess_Params_Data::Validate,
     &internal::ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerContainerHost_OnExecutionReady_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerContainerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerContainerHost::Name_,
    kServiceWorkerContainerHostValidationInfo);
}

bool ServiceWorkerContainerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerContainerHost::Name_,
    kServiceWorkerContainerHostValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorkerContainer::IPCStableHashFunction ServiceWorkerContainer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerContainer>(message.name())) {
    case messages::ServiceWorkerContainer::kSetController: {
      return &ServiceWorkerContainer::SetController_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainer::kPostMessageToClient: {
      return &ServiceWorkerContainer::PostMessageToClient_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerContainer::kCountFeature: {
      return &ServiceWorkerContainer::CountFeature_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerContainer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerContainer>(message.name())) {
      case messages::ServiceWorkerContainer::kSetController:
            return "Receive blink::mojom::ServiceWorkerContainer::SetController";
      case messages::ServiceWorkerContainer::kPostMessageToClient:
            return "Receive blink::mojom::ServiceWorkerContainer::PostMessageToClient";
      case messages::ServiceWorkerContainer::kCountFeature:
            return "Receive blink::mojom::ServiceWorkerContainer::CountFeature";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerContainer>(message.name())) {
      case messages::ServiceWorkerContainer::kSetController:
            return "Receive reply blink::mojom::ServiceWorkerContainer::SetController";
      case messages::ServiceWorkerContainer::kPostMessageToClient:
            return "Receive reply blink::mojom::ServiceWorkerContainer::PostMessageToClient";
      case messages::ServiceWorkerContainer::kCountFeature:
            return "Receive reply blink::mojom::ServiceWorkerContainer::CountFeature";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerContainer::SetController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcfb4d1e7;  // IPCStableHash for blink::mojom::ServiceWorkerContainer::SetController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainer::PostMessageToClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a673468;  // IPCStableHash for blink::mojom::ServiceWorkerContainer::PostMessageToClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerContainer::CountFeature_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e516b59;  // IPCStableHash for blink::mojom::ServiceWorkerContainer::CountFeature
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerContainerProxy::ServiceWorkerContainerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerContainerProxy::SetController(
    ::blink::mojom::blink::ControllerServiceWorkerInfoPtr in_controller_info, bool in_should_notify_controllerchange) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainer::SetController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_info"), in_controller_info,
                        "<value of type ::blink::mojom::blink::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_notify_controllerchange"), in_should_notify_controllerchange,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainer::kSetController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_SetController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->controller_info)::BaseType> controller_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
    in_controller_info,
    controller_info_fragment);

  params->controller_info.Set(
      controller_info_fragment.is_null() ? nullptr : controller_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->controller_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null controller_info in ServiceWorkerContainer.SetController request");

  params->should_notify_controllerchange = in_should_notify_controllerchange;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("SetController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerContainerProxy::PostMessageToClient(
    ::blink::mojom::blink::ServiceWorkerObjectInfoPtr in_source, ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainer::PostMessageToClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::blink::mojom::blink::ServiceWorkerObjectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::BlinkTransferableMessage>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainer::kPostMessageToClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_PostMessageToClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in ServiceWorkerContainer.PostMessageToClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ServiceWorkerContainer.PostMessageToClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("PostMessageToClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerContainerProxy::CountFeature(
    ::blink::mojom::blink::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerContainer::CountFeature", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::blink::WebFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerContainer::kCountFeature), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerContainer_CountFeature_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerContainer::Name_);
  message.set_method_name("CountFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerContainerStubDispatch::Accept(
    ServiceWorkerContainer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerContainer>(message->header()->name)) {
    case messages::ServiceWorkerContainer::kSetController: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_SetController_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_SetController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainer.0
      bool success = true;
      ::blink::mojom::blink::ControllerServiceWorkerInfoPtr p_controller_info{};
      bool p_should_notify_controllerchange{};
      ServiceWorkerContainer_SetController_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (success)
        p_should_notify_controllerchange = input_data_view.should_notify_controllerchange();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetController(        
        std::move(p_controller_info), 
        std::move(p_should_notify_controllerchange));
      return true;
    }
    case messages::ServiceWorkerContainer::kPostMessageToClient: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_PostMessageToClient_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_PostMessageToClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainer.1
      bool success = true;
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr p_source{};
      ::blink::BlinkTransferableMessage p_message{};
      ServiceWorkerContainer_PostMessageToClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToClient(        
        std::move(p_source), 
        std::move(p_message));
      return true;
    }
    case messages::ServiceWorkerContainer::kCountFeature: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerContainer_CountFeature_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerContainer_CountFeature_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerContainer.2
      bool success = true;
      ::blink::mojom::blink::WebFeature p_feature{};
      ServiceWorkerContainer_CountFeature_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerContainer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CountFeature(        
        std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerContainerStubDispatch::AcceptWithResponder(
    ServiceWorkerContainer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerContainer>(message->header()->name)) {
    case messages::ServiceWorkerContainer::kSetController: {
      break;
    }
    case messages::ServiceWorkerContainer::kPostMessageToClient: {
      break;
    }
    case messages::ServiceWorkerContainer::kCountFeature: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerContainerValidationInfo[] = {
    { &internal::ServiceWorkerContainer_SetController_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerContainer_PostMessageToClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerContainer_CountFeature_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerContainerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerContainer::Name_,
    kServiceWorkerContainerValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerContainerInfoForClient::DataView, ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerContainerInfoForClient::DataView input,
    ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr result(::blink::mojom::blink::ServiceWorkerContainerInfoForClient::New());
  
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ServiceWorkerContainerHostInterceptorForTesting::Register(const ::blink::KURL& script_url, ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr options, ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, RegisterCallback callback) {
  GetForwardingInterface()->Register(
    std::move(script_url)
    , 
    std::move(options)
    , 
    std::move(outside_fetch_client_settings_object)
    , std::move(callback));
}
void ServiceWorkerContainerHostInterceptorForTesting::GetRegistration(const ::blink::KURL& client_url, GetRegistrationCallback callback) {
  GetForwardingInterface()->GetRegistration(
    std::move(client_url)
    , std::move(callback));
}
void ServiceWorkerContainerHostInterceptorForTesting::GetRegistrations(GetRegistrationsCallback callback) {
  GetForwardingInterface()->GetRegistrations(std::move(callback));
}
void ServiceWorkerContainerHostInterceptorForTesting::GetRegistrationForReady(GetRegistrationForReadyCallback callback) {
  GetForwardingInterface()->GetRegistrationForReady(std::move(callback));
}
void ServiceWorkerContainerHostInterceptorForTesting::EnsureControllerServiceWorker(::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> receiver, ControllerServiceWorkerPurpose purpose) {
  GetForwardingInterface()->EnsureControllerServiceWorker(
    std::move(receiver)
    , 
    std::move(purpose)
    );
}
void ServiceWorkerContainerHostInterceptorForTesting::CloneContainerHost(::mojo::PendingReceiver<ServiceWorkerContainerHost> container_host) {
  GetForwardingInterface()->CloneContainerHost(
    std::move(container_host)
    );
}
void ServiceWorkerContainerHostInterceptorForTesting::HintToUpdateServiceWorker() {
  GetForwardingInterface()->HintToUpdateServiceWorker();
}
void ServiceWorkerContainerHostInterceptorForTesting::EnsureFileAccess(const ::blink::Vector<::base::FilePath>& files, EnsureFileAccessCallback callback) {
  GetForwardingInterface()->EnsureFileAccess(
    std::move(files)
    , std::move(callback));
}
void ServiceWorkerContainerHostInterceptorForTesting::OnExecutionReady() {
  GetForwardingInterface()->OnExecutionReady();
}
ServiceWorkerContainerHostAsyncWaiter::ServiceWorkerContainerHostAsyncWaiter(
    ServiceWorkerContainerHost* proxy) : proxy_(proxy) {}

ServiceWorkerContainerHostAsyncWaiter::~ServiceWorkerContainerHostAsyncWaiter() = default;


void ServiceWorkerContainerHostAsyncWaiter::Register(
    const ::blink::KURL& script_url, ::blink::mojom::blink::ServiceWorkerRegistrationOptionsPtr options, ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, ::blink::mojom::blink::ServiceWorkerErrorType* out_error, ::blink::String* out_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration) {
  base::RunLoop loop;
  proxy_->Register(
      std::move(script_url),
      std::move(options),
      std::move(outside_fetch_client_settings_object),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerErrorType* out_error
,
             ::blink::String* out_error_msg
,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration
,
             ::blink::mojom::blink::ServiceWorkerErrorType error,
             const ::blink::String& error_msg,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);*out_registration = std::move(registration);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg,
          out_registration));
  loop.Run();
}



void ServiceWorkerContainerHostAsyncWaiter::GetRegistration(
    const ::blink::KURL& client_url, ::blink::mojom::blink::ServiceWorkerErrorType* out_error, ::blink::String* out_error_msg, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration) {
  base::RunLoop loop;
  proxy_->GetRegistration(
      std::move(client_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerErrorType* out_error
,
             ::blink::String* out_error_msg
,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration
,
             ::blink::mojom::blink::ServiceWorkerErrorType error,
             const ::blink::String& error_msg,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);*out_registration = std::move(registration);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg,
          out_registration));
  loop.Run();
}



void ServiceWorkerContainerHostAsyncWaiter::GetRegistrations(
    ::blink::mojom::blink::ServiceWorkerErrorType* out_error, ::blink::String* out_error_msg, std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>>* out_infos) {
  base::RunLoop loop;
  proxy_->GetRegistrations(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerErrorType* out_error
,
             ::blink::String* out_error_msg
,
             std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>>* out_infos
,
             ::blink::mojom::blink::ServiceWorkerErrorType error,
             const ::blink::String& error_msg,
             std::optional<::blink::Vector<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr>> infos) {*out_error = std::move(error);*out_error_msg = std::move(error_msg);*out_infos = std::move(infos);
            loop->Quit();
          },
          &loop,
          out_error,
          out_error_msg,
          out_infos));
  loop.Run();
}



void ServiceWorkerContainerHostAsyncWaiter::GetRegistrationForReady(
    ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration) {
  base::RunLoop loop;
  proxy_->GetRegistrationForReady(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* out_registration
,
             ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration) {*out_registration = std::move(registration);
            loop->Quit();
          },
          &loop,
          out_registration));
  loop.Run();
}

::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr ServiceWorkerContainerHostAsyncWaiter::GetRegistrationForReady(
    ) {
  ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr async_wait_result;
  GetRegistrationForReady(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerContainerHostAsyncWaiter::EnsureFileAccess(
    const ::blink::Vector<::base::FilePath>& files) {
  base::RunLoop loop;
  proxy_->EnsureFileAccess(
      std::move(files),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void ServiceWorkerContainerInterceptorForTesting::SetController(::blink::mojom::blink::ControllerServiceWorkerInfoPtr controller_info, bool should_notify_controllerchange) {
  GetForwardingInterface()->SetController(
    std::move(controller_info)
    , 
    std::move(should_notify_controllerchange)
    );
}
void ServiceWorkerContainerInterceptorForTesting::PostMessageToClient(::blink::mojom::blink::ServiceWorkerObjectInfoPtr source, ::blink::BlinkTransferableMessage message) {
  GetForwardingInterface()->PostMessageToClient(
    std::move(source)
    , 
    std::move(message)
    );
}
void ServiceWorkerContainerInterceptorForTesting::CountFeature(::blink::mojom::blink::WebFeature feature) {
  GetForwardingInterface()->CountFeature(
    std::move(feature)
    );
}
ServiceWorkerContainerAsyncWaiter::ServiceWorkerContainerAsyncWaiter(
    ServiceWorkerContainer* proxy) : proxy_(proxy) {}

ServiceWorkerContainerAsyncWaiter::~ServiceWorkerContainerAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif