// third_party/blink/public/mojom/service_worker/service_worker_client.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ServiceWorkerClientQueryOptionsDataView;

class ServiceWorkerClientInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerClientQueryOptionsDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerClientQueryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerClientInfoDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerClientInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ServiceWorkerClientType : int32_t {
  
  kWindow = 0,
  
  kDedicatedWorker = 1,
  
  kSharedWorker = 2,
  
  kAll = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ServiceWorkerClientType value);
inline bool IsKnownEnumValue(ServiceWorkerClientType value) {
  return internal::ServiceWorkerClientType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ServiceWorkerClientLifecycleState : int32_t {
  
  kActive = 0,
  
  kFrozen = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ServiceWorkerClientLifecycleState value);
inline bool IsKnownEnumValue(ServiceWorkerClientLifecycleState value) {
  return internal::ServiceWorkerClientLifecycleState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerClientQueryOptionsDataView {
 public:
  ServiceWorkerClientQueryOptionsDataView() = default;

  ServiceWorkerClientQueryOptionsDataView(
      internal::ServiceWorkerClientQueryOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_uncontrolled() const {
    return data_->include_uncontrolled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientType(UserType* output) const {
    auto data_value = data_->client_type;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerClientType>(
        data_value, output);
  }
  ServiceWorkerClientType client_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerClientType>(data_->client_type));
  }
 private:
  internal::ServiceWorkerClientQueryOptions_Data* data_ = nullptr;
};


class ServiceWorkerClientInfoDataView {
 public:
  ServiceWorkerClientInfoDataView() = default;

  ServiceWorkerClientInfoDataView(
      internal::ServiceWorkerClientInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFrameType(UserType* output) const {
    auto data_value = data_->frame_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextFrameType>(
        data_value, output);
  }
  ::blink::mojom::RequestContextFrameType frame_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RequestContextFrameType>(data_->frame_type));
  }
  inline void GetClientUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientUuid(UserType* output) {
    
    auto* pointer = data_->client_uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientType(UserType* output) const {
    auto data_value = data_->client_type;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerClientType>(
        data_value, output);
  }
  ServiceWorkerClientType client_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerClientType>(data_->client_type));
  }
  bool page_hidden() const {
    return data_->page_hidden;
  }
  bool is_focused() const {
    return data_->is_focused;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLifecycleState(UserType* output) const {
    auto data_value = data_->lifecycle_state;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerClientLifecycleState>(
        data_value, output);
  }
  ServiceWorkerClientLifecycleState lifecycle_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerClientLifecycleState>(data_->lifecycle_state));
  }
  inline void GetLastFocusTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastFocusTime(UserType* output) {
    
    auto* pointer = data_->last_focus_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerClientInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_DATA_VIEW_H_