// third_party/blink/public/mojom/service_worker/embedded_worker.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.EmbeddedWorkerInstanceClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.EmbeddedWorkerInstanceClientInterface }
 */
blink.mojom.EmbeddedWorkerInstanceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.EmbeddedWorkerInstanceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.EmbeddedWorkerInstanceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.EmbeddedWorkerInstanceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.EmbeddedWorkerStartParams } params
   */

  startWorker(
      params) {
    this.proxy.sendMessage(
        0,
        blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   */

  stopWorker() {
    this.proxy.sendMessage(
        1,
        blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EmbeddedWorkerInstanceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceClientReceiver = class {
  /**
   * @param {!blink.mojom.EmbeddedWorkerInstanceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.EmbeddedWorkerInstanceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.EmbeddedWorkerInstanceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedWorkerInstanceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        impl.startWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        impl.stopWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.EmbeddedWorkerInstanceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedWorkerInstanceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.EmbeddedWorkerInstanceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.EmbeddedWorkerInstanceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EmbeddedWorkerInstanceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.EmbeddedWorkerInstanceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedWorkerInstanceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        this.startWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        this.stopWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.EmbeddedWorkerInstanceHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.EmbeddedWorkerInstanceHostInterface }
 */
blink.mojom.EmbeddedWorkerInstanceHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.EmbeddedWorkerInstanceHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.EmbeddedWorkerInstanceHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.EmbeddedWorkerInstanceHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        willBeTerminated: !boolean,
   *  }>}
   */

  requestTermination() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebFeature } feature
   */

  countFeature(
      feature) {
    this.proxy.sendMessage(
        1,
        blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DevToolsAgentRemote } agent
   * @param { !blink.mojom.DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(
      agent,
      agentHost) {
    this.proxy.sendMessage(
        2,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        [
          agent,
          agentHost
        ],
        false);
  }

  
  /**
   */

  onScriptLoaded() {
    this.proxy.sendMessage(
        3,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onScriptEvaluationStart() {
    this.proxy.sendMessage(
        4,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerStartStatus } status
   * @param { !blink.mojom.ServiceWorkerFetchHandlerType } fetchHandlerType
   * @param { !boolean } hasHidEventHandlers
   * @param { !boolean } hasUsbEventHandlers
   * @param { !number } threadId
   * @param { !blink.mojom.EmbeddedWorkerStartTiming } startTiming
   */

  onStarted(
      status,
      fetchHandlerType,
      hasHidEventHandlers,
      hasUsbEventHandlers,
      threadId,
      startTiming) {
    this.proxy.sendMessage(
        5,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        [
          status,
          fetchHandlerType,
          hasHidEventHandlers,
          hasUsbEventHandlers,
          threadId,
          startTiming
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } errorMessage
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   * @param { !url.mojom.Url } sourceUrl
   */

  onReportException(
      errorMessage,
      lineNumber,
      columnNumber,
      sourceUrl) {
    this.proxy.sendMessage(
        6,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        [
          errorMessage,
          lineNumber,
          columnNumber,
          sourceUrl
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ConsoleMessageSource } source
   * @param { !blink.mojom.ConsoleMessageLevel } messageLevel
   * @param { !mojoBase.mojom.String16 } message
   * @param { !number } lineNumber
   * @param { !url.mojom.Url } sourceUrl
   */

  onReportConsoleMessage(
      source,
      messageLevel,
      message,
      lineNumber,
      sourceUrl) {
    this.proxy.sendMessage(
        7,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        [
          source,
          messageLevel,
          message,
          lineNumber,
          sourceUrl
        ],
        false);
  }

  
  /**
   */

  onStopped() {
    this.proxy.sendMessage(
        8,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EmbeddedWorkerInstanceHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHostReceiver = class {
  /**
   * @param {!blink.mojom.EmbeddedWorkerInstanceHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.EmbeddedWorkerInstanceHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.EmbeddedWorkerInstanceHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedWorkerInstanceHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        impl.requestTermination.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        impl.countFeature.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        impl.onReadyForInspection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        impl.onScriptLoaded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        impl.onScriptEvaluationStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        impl.onStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        impl.onReportException.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        impl.onReportConsoleMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        impl.onStopped.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.EmbeddedWorkerInstanceHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedWorkerInstanceHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.EmbeddedWorkerInstanceHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.EmbeddedWorkerInstanceHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EmbeddedWorkerInstanceHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.EmbeddedWorkerInstanceHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedWorkerInstanceHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestTermination =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        this.requestTermination.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.countFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        this.countFeature.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadyForInspection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        this.onReadyForInspection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoaded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        this.onScriptLoaded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptEvaluationStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        this.onScriptEvaluationStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        this.onStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportException =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        this.onReportException.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportConsoleMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        this.onReportConsoleMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        this.onStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerStartParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerStartTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerStartParamsSpec.$,
    'EmbeddedWorkerStartParams',
    [
      mojo.internal.StructField(
        'serviceWorkerVersionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scope', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptType', 24,
        0,
        blink.mojom.ScriptTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 32,
        0,
        blink.mojom.FetchClientSettingsObjectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userAgent', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uaMetadata', 48,
        0,
        blink.mojom.UserAgentMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerRouteId', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 56,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptUrlToSkipThrottling', 64,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 72,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isInstalled', 72,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rendererPreferences', 80,
        0,
        blink.mojom.RendererPreferencesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forcedEnabledRuntimeFeatures', 88,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerReceiver', 76,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ServiceWorkerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfaceProvider', 96,
        0,
        mojo.internal.InterfaceRequest(serviceManager.mojom.InterfaceProviderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controllerReceiver', 100,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ControllerServiceWorkerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'installedScriptsInfo', 104,
        0,
        blink.mojom.ServiceWorkerInstalledScriptsInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instanceHost', 112,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.EmbeddedWorkerInstanceHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'providerInfo', 120,
        0,
        blink.mojom.ServiceWorkerProviderInfoForStartWorkerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSettingsProxy', 128,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WorkerContentSettingsProxyRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferenceWatcherReceiver', 136,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.RendererPreferenceWatcherPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 144,
        0,
        blink.mojom.URLLoaderFactoryBundleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoaderUpdater', 140,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.SubresourceLoaderUpdaterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerToken', 152,
        0,
        blink.mojom.ServiceWorkerTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ukmSourceId', 160,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 168,
        0,
        blink.mojom.WorkerMainScriptLoadParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyContainer', 176,
        0,
        blink.mojom.PolicyContainerSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageKey', 184,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corsExemptHeaderList', 192,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coepReportingObserver', 200,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dipReportingObserver', 204,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canvasNoiseToken', 208,
        0,
        blink.mojom.NoiseTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 224],]);





/** @record */
blink.mojom.EmbeddedWorkerStartParams = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerVersionId;
    /** @export { !url.mojom.Url } */
    this.scope;
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
    /** @export { !blink.mojom.ScriptType } */
    this.scriptType;
    /** @export { !blink.mojom.FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
    /** @export { !string } */
    this.userAgent;
    /** @export { !blink.mojom.UserAgentMetadata } */
    this.uaMetadata;
    /** @export { !number } */
    this.serviceWorkerRouteId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @export { !url.mojom.Url } */
    this.scriptUrlToSkipThrottling;
    /** @export { !boolean } */
    this.waitForDebugger;
    /** @export { !boolean } */
    this.isInstalled;
    /** @export { !blink.mojom.RendererPreferences } */
    this.rendererPreferences;
    /** @export { !Array<!string> } */
    this.forcedEnabledRuntimeFeatures;
    /** @export { !blink.mojom.ServiceWorkerPendingReceiver } */
    this.serviceWorkerReceiver;
    /** @export { !serviceManager.mojom.InterfaceProviderPendingReceiver } */
    this.interfaceProvider;
    /** @export { !blink.mojom.ControllerServiceWorkerPendingReceiver } */
    this.controllerReceiver;
    /** @export { (blink.mojom.ServiceWorkerInstalledScriptsInfo|undefined) } */
    this.installedScriptsInfo;
    /** @export { !Object } */
    this.instanceHost;
    /** @export { !blink.mojom.ServiceWorkerProviderInfoForStartWorker } */
    this.providerInfo;
    /** @export { !blink.mojom.WorkerContentSettingsProxyRemote } */
    this.contentSettingsProxy;
    /** @export { !blink.mojom.RendererPreferenceWatcherPendingReceiver } */
    this.preferenceWatcherReceiver;
    /** @export { !blink.mojom.URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @export { !blink.mojom.SubresourceLoaderUpdaterPendingReceiver } */
    this.subresourceLoaderUpdater;
    /** @export { !blink.mojom.ServiceWorkerToken } */
    this.serviceWorkerToken;
    /** @export { !bigint } */
    this.ukmSourceId;
    /** @export { (blink.mojom.WorkerMainScriptLoadParams|undefined) } */
    this.mainScriptLoadParams;
    /** @export { (blink.mojom.PolicyContainer|undefined) } */
    this.policyContainer;
    /** @export { !blink.mojom.StorageKey } */
    this.storageKey;
    /** @export { !Array<!string> } */
    this.corsExemptHeaderList;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserver;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserver;
    /** @export { (blink.mojom.NoiseToken|undefined) } */
    this.canvasNoiseToken;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerStartTimingSpec.$,
    'EmbeddedWorkerStartTiming',
    [
      mojo.internal.StructField(
        'startWorkerReceivedTime', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptEvaluationStartTime', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptEvaluationEndTime', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.EmbeddedWorkerStartTiming = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.startWorkerReceivedTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.scriptEvaluationStartTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.scriptEvaluationEndTime;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
    'EmbeddedWorkerInstanceClient_StartWorker_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.EmbeddedWorkerStartParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceClient_StartWorker_Params = class {
  constructor() {
    /** @export { !blink.mojom.EmbeddedWorkerStartParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
    'EmbeddedWorkerInstanceClient_StopWorker_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceClient_StopWorker_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_RequestTermination_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
    'EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams',
    [
      mojo.internal.StructField(
        'willBeTerminated', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.willBeTerminated;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_CountFeature_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink.mojom.WebFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_CountFeature_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebFeature } */
    this.feature;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReadyForInspection_Params',
    [
      mojo.internal.StructField(
        'agent', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DevToolsAgentRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DevToolsAgentHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnReadyForInspection_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsAgentRemote } */
    this.agent;
    /** @export { !blink.mojom.DevToolsAgentHostPendingReceiver } */
    this.agentHost;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnScriptLoaded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnScriptLoaded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnStarted_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerStartStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchHandlerType', 4,
        0,
        blink.mojom.ServiceWorkerFetchHandlerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasHidEventHandlers', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUsbEventHandlers', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'threadId', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startTiming', 16,
        0,
        blink.mojom.EmbeddedWorkerStartTimingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnStarted_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerStartStatus } */
    this.status;
    /** @export { !blink.mojom.ServiceWorkerFetchHandlerType } */
    this.fetchHandlerType;
    /** @export { !boolean } */
    this.hasHidEventHandlers;
    /** @export { !boolean } */
    this.hasUsbEventHandlers;
    /** @export { !number } */
    this.threadId;
    /** @export { !blink.mojom.EmbeddedWorkerStartTiming } */
    this.startTiming;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReportException_Params',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnReportException_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.errorMessage;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
    /** @export { !url.mojom.Url } */
    this.sourceUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink.mojom.ConsoleMessageSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'messageLevel', 4,
        0,
        blink.mojom.ConsoleMessageLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params = class {
  constructor() {
    /** @export { !blink.mojom.ConsoleMessageSource } */
    this.source;
    /** @export { !blink.mojom.ConsoleMessageLevel } */
    this.messageLevel;
    /** @export { !mojoBase.mojom.String16 } */
    this.message;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !url.mojom.Url } */
    this.sourceUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnStopped_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.EmbeddedWorkerInstanceHost_OnStopped_Params = class {
  constructor() {
  }
};

