// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-test-utils.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/public/common/service_worker/service_worker_embedded_worker_status_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace blink::mojom {
ServiceWorkerRouterData::ServiceWorkerRouterData()
    : router_rules(),
      initial_running_status(),
      running_status_receiver(),
      remote_cache_storage() {}

ServiceWorkerRouterData::ServiceWorkerRouterData(
    const ::blink::ServiceWorkerRouterRules& router_rules_in,
    std::optional<::blink::EmbeddedWorkerStatus> initial_running_status_in,
    ::mojo::PendingReceiver<::blink::mojom::ServiceWorkerRunningStatusCallback> running_status_receiver_in,
    ::mojo::PendingRemote<::blink::mojom::CacheStorage> remote_cache_storage_in)
    : router_rules(std::move(router_rules_in)),
      initial_running_status(std::move(initial_running_status_in)),
      running_status_receiver(std::move(running_status_receiver_in)),
      remote_cache_storage(std::move(remote_cache_storage_in)) {}

ServiceWorkerRouterData::~ServiceWorkerRouterData() = default;

void ServiceWorkerRouterData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "router_rules"), this->router_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ServiceWorkerRouterRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_running_status"), this->initial_running_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::EmbeddedWorkerStatus>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "running_status_receiver"), this->running_status_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ServiceWorkerRunningStatusCallback>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_cache_storage"), this->remote_cache_storage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::CacheStorage>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ControllerServiceWorkerInfo::ControllerServiceWorkerInfo()
    : mode(::blink::mojom::ControllerServiceWorkerMode::kNoController),
      fetch_handler_type(::blink::mojom::ServiceWorkerFetchHandlerType::kNoHandler),
      fetch_handler_bypass_option(::blink::mojom::ServiceWorkerFetchHandlerBypassOption::kDefault),
      sha256_script_checksum(),
      need_router_evaluate(),
      router_data(),
      remote_controller(),
      client_id(),
      fetch_request_window_id(),
      object_info(),
      used_features() {}

ControllerServiceWorkerInfo::ControllerServiceWorkerInfo(
    ::blink::mojom::ControllerServiceWorkerMode mode_in,
    ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type_in,
    ::blink::mojom::ServiceWorkerFetchHandlerBypassOption fetch_handler_bypass_option_in,
    const std::optional<std::string>& sha256_script_checksum_in,
    bool need_router_evaluate_in,
    ServiceWorkerRouterDataPtr router_data_in,
    ::mojo::PendingRemote<ControllerServiceWorker> remote_controller_in,
    const std::string& client_id_in,
    const std::optional<::base::UnguessableToken>& fetch_request_window_id_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr object_info_in,
    std::vector<::blink::mojom::WebFeature> used_features_in)
    : mode(std::move(mode_in)),
      fetch_handler_type(std::move(fetch_handler_type_in)),
      fetch_handler_bypass_option(std::move(fetch_handler_bypass_option_in)),
      sha256_script_checksum(std::move(sha256_script_checksum_in)),
      need_router_evaluate(std::move(need_router_evaluate_in)),
      router_data(std::move(router_data_in)),
      remote_controller(std::move(remote_controller_in)),
      client_id(std::move(client_id_in)),
      fetch_request_window_id(std::move(fetch_request_window_id_in)),
      object_info(std::move(object_info_in)),
      used_features(std::move(used_features_in)) {}

ControllerServiceWorkerInfo::~ControllerServiceWorkerInfo() = default;

void ControllerServiceWorkerInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ControllerServiceWorkerMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_handler_type"), this->fetch_handler_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerFetchHandlerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_handler_bypass_option"), this->fetch_handler_bypass_option,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerFetchHandlerBypassOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha256_script_checksum"), this->sha256_script_checksum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "need_router_evaluate"), this->need_router_evaluate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "router_data"), this->router_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_controller"), this->remote_controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ControllerServiceWorker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_request_window_id"), this->fetch_request_window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "object_info"), this->object_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerObjectInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "used_features"), this->used_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::mojom::WebFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ControllerServiceWorkerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ControllerServiceWorker::IPCStableHashFunction ControllerServiceWorker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ControllerServiceWorker>(message.name())) {
    case messages::ControllerServiceWorker::kDispatchFetchEventForSubresource: {
      return &ControllerServiceWorker::DispatchFetchEventForSubresource_Sym::IPCStableHash;
    }
    case messages::ControllerServiceWorker::kClone: {
      return &ControllerServiceWorker::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ControllerServiceWorker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ControllerServiceWorker>(message.name())) {
      case messages::ControllerServiceWorker::kDispatchFetchEventForSubresource:
            return "Receive blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource";
      case messages::ControllerServiceWorker::kClone:
            return "Receive blink::mojom::ControllerServiceWorker::Clone";
    }
  } else {
    switch (static_cast<messages::ControllerServiceWorker>(message.name())) {
      case messages::ControllerServiceWorker::kDispatchFetchEventForSubresource:
            return "Receive reply blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource";
      case messages::ControllerServiceWorker::kClone:
            return "Receive reply blink::mojom::ControllerServiceWorker::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ControllerServiceWorker::DispatchFetchEventForSubresource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc3504b0;  // IPCStableHash for blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ControllerServiceWorker::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97901b8e;  // IPCStableHash for blink::mojom::ControllerServiceWorker::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback(
      ControllerServiceWorker::DispatchFetchEventForSubresourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback(const ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback&) = delete;
  ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback& operator=(const ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ControllerServiceWorker::DispatchFetchEventForSubresourceCallback callback_;
};

ControllerServiceWorkerProxy::ControllerServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ControllerServiceWorkerProxy::DispatchFetchEventForSubresource(
    ::blink::mojom::DispatchFetchEventParamsPtr in_params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> in_response_callback, DispatchFetchEventForSubresourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::DispatchFetchEventParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_callback"), in_response_callback,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ControllerServiceWorker::kDispatchFetchEventForSubresource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DispatchFetchEventParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ControllerServiceWorker.DispatchFetchEventForSubresource request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerFetchResponseCallbackInterfaceBase>>(
    in_response_callback,
    &params->response_callback,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_callback)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_callback in ControllerServiceWorker.DispatchFetchEventForSubresource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForSubresource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ControllerServiceWorkerProxy::Clone(
    ::mojo::PendingReceiver<ControllerServiceWorker> in_receiver, const ::network::CrossOriginEmbedderPolicy& in_cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> in_coep_reporter, const ::network::DocumentIsolationPolicy& in_document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> in_dip_reporter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ControllerServiceWorker::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ControllerServiceWorker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_embedder_policy"), in_cross_origin_embedder_policy,
                        "<value of type const ::network::CrossOriginEmbedderPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporter"), in_coep_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_isolation_policy"), in_document_isolation_policy,
                        "<value of type const ::network::DocumentIsolationPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dip_reporter"), in_dip_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ControllerServiceWorker::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ControllerServiceWorker.Clone request");
  mojo::internal::MessageFragment<
      typename decltype(params->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
    in_cross_origin_embedder_policy,
    cross_origin_embedder_policy_fragment);

  params->cross_origin_embedder_policy.Set(
      cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cross_origin_embedder_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cross_origin_embedder_policy in ControllerServiceWorker.Clone request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
    in_coep_reporter,
    &params->coep_reporter,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->document_isolation_policy)::BaseType> document_isolation_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DocumentIsolationPolicyDataView>(
    in_document_isolation_policy,
    document_isolation_policy_fragment);

  params->document_isolation_policy.Set(
      document_isolation_policy_fragment.is_null() ? nullptr : document_isolation_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_isolation_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_isolation_policy in ControllerServiceWorker.Clone request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
    in_dip_reporter,
    &params->dip_reporter,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ControllerServiceWorker::DispatchFetchEventForSubresourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder> proxy(
        new ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ControllerServiceWorker::DispatchFetchEventForSubresourceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerEventStatus in_status);
};

bool ControllerServiceWorker_DispatchFetchEventForSubresource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ControllerServiceWorker.0
  bool success = true;
  ::blink::mojom::ServiceWorkerEventStatus p_status{};
  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ControllerServiceWorker::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerEventStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ControllerServiceWorker::DispatchFetchEventForSubresource", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerEventStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ControllerServiceWorker::kDispatchFetchEventForSubresource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerEventStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorker::Name_);
  message.set_method_name("DispatchFetchEventForSubresource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ControllerServiceWorkerStubDispatch::Accept(
    ControllerServiceWorker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ControllerServiceWorker>(message->header()->name)) {
    case messages::ControllerServiceWorker::kDispatchFetchEventForSubresource: {
      break;
    }
    case messages::ControllerServiceWorker::kClone: {
      DCHECK(message->is_serialized());
      internal::ControllerServiceWorker_Clone_Params_Data* params =
          reinterpret_cast<internal::ControllerServiceWorker_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ControllerServiceWorker.1
      bool success = true;
      ::mojo::PendingReceiver<ControllerServiceWorker> p_receiver{};
      ::network::CrossOriginEmbedderPolicy p_cross_origin_embedder_policy{};
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> p_coep_reporter{};
      ::network::DocumentIsolationPolicy p_document_isolation_policy{};
      ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> p_dip_reporter{};
      ControllerServiceWorker_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadCrossOriginEmbedderPolicy(&p_cross_origin_embedder_policy))
        success = false;
      if (success) {
        p_coep_reporter =
            input_data_view.TakeCoepReporter<decltype(p_coep_reporter)>();
      }
      if (success && !input_data_view.ReadDocumentIsolationPolicy(&p_document_isolation_policy))
        success = false;
      if (success) {
        p_dip_reporter =
            input_data_view.TakeDipReporter<decltype(p_dip_reporter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver), 
        std::move(p_cross_origin_embedder_policy), 
        std::move(p_coep_reporter), 
        std::move(p_document_isolation_policy), 
        std::move(p_dip_reporter));
      return true;
    }
  }
  return false;
}

// static
bool ControllerServiceWorkerStubDispatch::AcceptWithResponder(
    ControllerServiceWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ControllerServiceWorker>(message->header()->name)) {
    case messages::ControllerServiceWorker::kDispatchFetchEventForSubresource: {
      internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data* params =
          reinterpret_cast<
              internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ControllerServiceWorker.0
      bool success = true;
      ::blink::mojom::DispatchFetchEventParamsPtr p_params{};
      ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> p_response_callback{};
      ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_response_callback =
            input_data_view.TakeResponseCallback<decltype(p_response_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorker::Name_, 0, false);
        return false;
      }
      auto callback =
          ControllerServiceWorker_DispatchFetchEventForSubresource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchFetchEventForSubresource(        
        std::move(p_params), 
        std::move(p_response_callback), std::move(callback));
      return true;
    }
    case messages::ControllerServiceWorker::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kControllerServiceWorkerValidationInfo[] = {
    { &internal::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data::Validate,
     &internal::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data::Validate},
    { &internal::ControllerServiceWorker_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ControllerServiceWorkerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ControllerServiceWorker::Name_,
    kControllerServiceWorkerValidationInfo);
}

bool ControllerServiceWorkerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::ControllerServiceWorker::Name_,
    kControllerServiceWorkerValidationInfo);
}
// The declaration includes the definition on other builds.

ControllerServiceWorkerConnector::IPCStableHashFunction ControllerServiceWorkerConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ControllerServiceWorkerConnector>(message.name())) {
    case messages::ControllerServiceWorkerConnector::kUpdateController: {
      return &ControllerServiceWorkerConnector::UpdateController_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ControllerServiceWorkerConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ControllerServiceWorkerConnector>(message.name())) {
      case messages::ControllerServiceWorkerConnector::kUpdateController:
            return "Receive blink::mojom::ControllerServiceWorkerConnector::UpdateController";
    }
  } else {
    switch (static_cast<messages::ControllerServiceWorkerConnector>(message.name())) {
      case messages::ControllerServiceWorkerConnector::kUpdateController:
            return "Receive reply blink::mojom::ControllerServiceWorkerConnector::UpdateController";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ControllerServiceWorkerConnector::UpdateController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0514d4e;  // IPCStableHash for blink::mojom::ControllerServiceWorkerConnector::UpdateController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ControllerServiceWorkerConnectorProxy::ControllerServiceWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ControllerServiceWorkerConnectorProxy::UpdateController(
    ::mojo::PendingRemote<ControllerServiceWorker> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ControllerServiceWorkerConnector::UpdateController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller"), in_controller,
                        "<value of type ::mojo::PendingRemote<ControllerServiceWorker>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ControllerServiceWorkerConnector::kUpdateController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ControllerServiceWorkerConnector_UpdateController_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
    in_controller,
    &params->controller,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ControllerServiceWorkerConnector::Name_);
  message.set_method_name("UpdateController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ControllerServiceWorkerConnectorStubDispatch::Accept(
    ControllerServiceWorkerConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ControllerServiceWorkerConnector>(message->header()->name)) {
    case messages::ControllerServiceWorkerConnector::kUpdateController: {
      DCHECK(message->is_serialized());
      internal::ControllerServiceWorkerConnector_UpdateController_Params_Data* params =
          reinterpret_cast<internal::ControllerServiceWorkerConnector_UpdateController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ControllerServiceWorkerConnector.0
      bool success = true;
      ::mojo::PendingRemote<ControllerServiceWorker> p_controller{};
      ControllerServiceWorkerConnector_UpdateController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ControllerServiceWorkerConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateController(        
        std::move(p_controller));
      return true;
    }
  }
  return false;
}

// static
bool ControllerServiceWorkerConnectorStubDispatch::AcceptWithResponder(
    ControllerServiceWorkerConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ControllerServiceWorkerConnector>(message->header()->name)) {
    case messages::ControllerServiceWorkerConnector::kUpdateController: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kControllerServiceWorkerConnectorValidationInfo[] = {
    { &internal::ControllerServiceWorkerConnector_UpdateController_Params_Data::Validate,
     nullptr /* no response */},
};

bool ControllerServiceWorkerConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ControllerServiceWorkerConnector::Name_,
    kControllerServiceWorkerConnectorValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterData::DataView, ::blink::mojom::ServiceWorkerRouterDataPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterData::DataView input,
    ::blink::mojom::ServiceWorkerRouterDataPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterDataPtr result(::blink::mojom::ServiceWorkerRouterData::New());
  
      if (success && !input.ReadRouterRules(&result->router_rules))
        success = false;
      if (success && !input.ReadInitialRunningStatus(&result->initial_running_status)) {
        success = false;
      }
      if (success) {
        result->running_status_receiver =
            input.TakeRunningStatusReceiver<decltype(result->running_status_receiver)>();
      }
      if (success) {
        result->remote_cache_storage =
            input.TakeRemoteCacheStorage<decltype(result->remote_cache_storage)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ControllerServiceWorkerInfo::DataView, ::blink::mojom::ControllerServiceWorkerInfoPtr>::Read(
    ::blink::mojom::ControllerServiceWorkerInfo::DataView input,
    ::blink::mojom::ControllerServiceWorkerInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ControllerServiceWorkerInfoPtr result(::blink::mojom::ControllerServiceWorkerInfo::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadFetchHandlerType(&result->fetch_handler_type))
        success = false;
      if (success && !input.ReadFetchHandlerBypassOption(&result->fetch_handler_bypass_option))
        success = false;
      if (success && !input.ReadSha256ScriptChecksum(&result->sha256_script_checksum))
        success = false;
      if (success)
        result->need_router_evaluate = input.need_router_evaluate();
      if (success && !input.ReadRouterData(&result->router_data))
        success = false;
      if (success) {
        result->remote_controller =
            input.TakeRemoteController<decltype(result->remote_controller)>();
      }
      if (success && !input.ReadClientId(&result->client_id))
        success = false;
      if (success && !input.ReadFetchRequestWindowId(&result->fetch_request_window_id))
        success = false;
      if (success && !input.ReadObjectInfo(&result->object_info))
        success = false;
      if (success && !input.ReadUsedFeatures(&result->used_features))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ControllerServiceWorkerInterceptorForTesting::DispatchFetchEventForSubresource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForSubresourceCallback callback) {
  GetForwardingInterface()->DispatchFetchEventForSubresource(
    std::move(params)
    , 
    std::move(response_callback)
    , std::move(callback));
}
void ControllerServiceWorkerInterceptorForTesting::Clone(::mojo::PendingReceiver<ControllerServiceWorker> receiver, const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    , 
    std::move(cross_origin_embedder_policy)
    , 
    std::move(coep_reporter)
    , 
    std::move(document_isolation_policy)
    , 
    std::move(dip_reporter)
    );
}
ControllerServiceWorkerAsyncWaiter::ControllerServiceWorkerAsyncWaiter(
    ControllerServiceWorker* proxy) : proxy_(proxy) {}

ControllerServiceWorkerAsyncWaiter::~ControllerServiceWorkerAsyncWaiter() = default;


void ControllerServiceWorkerAsyncWaiter::DispatchFetchEventForSubresource(
    ::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, ::blink::mojom::ServiceWorkerEventStatus* out_status) {
  base::RunLoop loop;
  proxy_->DispatchFetchEventForSubresource(
      std::move(params),
      std::move(response_callback),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ServiceWorkerEventStatus* out_status
,
             ::blink::mojom::ServiceWorkerEventStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::ServiceWorkerEventStatus ControllerServiceWorkerAsyncWaiter::DispatchFetchEventForSubresource(
    ::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback) {
  ::blink::mojom::ServiceWorkerEventStatus async_wait_result;
  DispatchFetchEventForSubresource(std::move(params),std::move(response_callback),&async_wait_result);
  return async_wait_result;
}




void ControllerServiceWorkerConnectorInterceptorForTesting::UpdateController(::mojo::PendingRemote<ControllerServiceWorker> controller) {
  GetForwardingInterface()->UpdateController(
    std::move(controller)
    );
}
ControllerServiceWorkerConnectorAsyncWaiter::ControllerServiceWorkerConnectorAsyncWaiter(
    ControllerServiceWorkerConnector* proxy) : proxy_(proxy) {}

ControllerServiceWorkerConnectorAsyncWaiter::~ControllerServiceWorkerConnectorAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif