// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
ScrollAlignment::ScrollAlignment()
    : rect_visible(ScrollAlignment_Behavior::kNoScroll),
      rect_hidden(ScrollAlignment_Behavior::kCenter),
      rect_partial(ScrollAlignment_Behavior::kClosestEdge) {}

ScrollAlignment::ScrollAlignment(
    ScrollAlignment::Behavior rect_visible_in,
    ScrollAlignment::Behavior rect_hidden_in,
    ScrollAlignment::Behavior rect_partial_in)
    : rect_visible(std::move(rect_visible_in)),
      rect_hidden(std::move(rect_hidden_in)),
      rect_partial(std::move(rect_partial_in)) {}

ScrollAlignment::~ScrollAlignment() = default;
size_t ScrollAlignment::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->rect_visible);
  seed = mojo::internal::WTFHash(seed, this->rect_hidden);
  seed = mojo::internal::WTFHash(seed, this->rect_partial);
  return seed;
}

void ScrollAlignment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_visible"), this->rect_visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAlignment::Behavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_hidden"), this->rect_hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAlignment::Behavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect_partial"), this->rect_partial,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAlignment::Behavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollAlignment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FocusedEditableParams::FocusedEditableParams()
    : relative_location(),
      size(),
      can_zoom(true) {}

FocusedEditableParams::FocusedEditableParams(
    const ::gfx::Vector2dF& relative_location_in,
    const ::gfx::SizeF& size_in,
    bool can_zoom_in)
    : relative_location(std::move(relative_location_in)),
      size(std::move(size_in)),
      can_zoom(std::move(can_zoom_in)) {}

FocusedEditableParams::~FocusedEditableParams() = default;

void FocusedEditableParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_location"), this->relative_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SizeF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_zoom"), this->can_zoom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FocusedEditableParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollIntoViewParams::ScrollIntoViewParams()
    : align_x(),
      align_y(),
      type(::blink::mojom::blink::ScrollType::kProgrammatic),
      make_visible_in_visual_viewport(true),
      behavior(::blink::mojom::blink::ScrollBehavior::kAuto),
      is_for_scroll_sequence(false),
      for_focused_editable(),
      cross_origin_boundaries(true) {}

ScrollIntoViewParams::ScrollIntoViewParams(
    ScrollAlignmentPtr align_x_in,
    ScrollAlignmentPtr align_y_in,
    ::blink::mojom::blink::ScrollType type_in,
    bool make_visible_in_visual_viewport_in,
    ::blink::mojom::blink::ScrollBehavior behavior_in,
    bool is_for_scroll_sequence_in,
    FocusedEditableParamsPtr for_focused_editable_in,
    bool cross_origin_boundaries_in)
    : align_x(std::move(align_x_in)),
      align_y(std::move(align_y_in)),
      type(std::move(type_in)),
      make_visible_in_visual_viewport(std::move(make_visible_in_visual_viewport_in)),
      behavior(std::move(behavior_in)),
      is_for_scroll_sequence(std::move(is_for_scroll_sequence_in)),
      for_focused_editable(std::move(for_focused_editable_in)),
      cross_origin_boundaries(std::move(cross_origin_boundaries_in)) {}

ScrollIntoViewParams::~ScrollIntoViewParams() = default;

void ScrollIntoViewParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "align_x"), this->align_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAlignmentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "align_y"), this->align_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollAlignmentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ScrollType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "make_visible_in_visual_viewport"), this->make_visible_in_visual_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "behavior"), this->behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ScrollBehavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_for_scroll_sequence"), this->is_for_scroll_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "for_focused_editable"), this->for_focused_editable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FocusedEditableParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_boundaries"), this->cross_origin_boundaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollIntoViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ScrollAlignment::DataView, ::blink::mojom::blink::ScrollAlignmentPtr>::Read(
    ::blink::mojom::blink::ScrollAlignment::DataView input,
    ::blink::mojom::blink::ScrollAlignmentPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ScrollAlignmentPtr result(::blink::mojom::blink::ScrollAlignment::New());
  
      if (success && !input.ReadRectVisible(&result->rect_visible))
        success = false;
      if (success && !input.ReadRectHidden(&result->rect_hidden))
        success = false;
      if (success && !input.ReadRectPartial(&result->rect_partial))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FocusedEditableParams::DataView, ::blink::mojom::blink::FocusedEditableParamsPtr>::Read(
    ::blink::mojom::blink::FocusedEditableParams::DataView input,
    ::blink::mojom::blink::FocusedEditableParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FocusedEditableParamsPtr result(::blink::mojom::blink::FocusedEditableParams::New());
  
      if (success && !input.ReadRelativeLocation(&result->relative_location))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success)
        result->can_zoom = input.can_zoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ScrollIntoViewParams::DataView, ::blink::mojom::blink::ScrollIntoViewParamsPtr>::Read(
    ::blink::mojom::blink::ScrollIntoViewParams::DataView input,
    ::blink::mojom::blink::ScrollIntoViewParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ScrollIntoViewParamsPtr result(::blink::mojom::blink::ScrollIntoViewParams::New());
  
      if (success && !input.ReadAlignX(&result->align_x))
        success = false;
      if (success && !input.ReadAlignY(&result->align_y))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->make_visible_in_visual_viewport = input.make_visible_in_visual_viewport();
      if (success && !input.ReadBehavior(&result->behavior))
        success = false;
      if (success)
        result->is_for_scroll_sequence = input.is_for_scroll_sequence();
      if (success && !input.ReadForFocusedEditable(&result->for_focused_editable))
        success = false;
      if (success)
        result->cross_origin_boundaries = input.cross_origin_boundaries();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {




}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif