// third_party/blink/public/mojom/reporting/reporting.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ReportingServiceProxyPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ReportingServiceProxy', scope);
  }
}

/** @interface */
export class ReportingServiceProxyInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } id
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueInterventionReport(url, id, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } id
   * @param { ?mojoBase_mojom_Time } anticipatedRemoval
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDeprecationReport(url, id, anticipatedRemoval, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } group
   * @param { !string } documentUrl
   * @param { ?string } referrer
   * @param { ?string } blockedUrl
   * @param { !string } effectiveDirective
   * @param { !string } originalPolicy
   * @param { ?string } sourceFile
   * @param { ?string } scriptSample
   * @param { !string } disposition
   * @param { !number } statusCode
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueCspViolationReport(url, group, documentUrl, referrer, blockedUrl, effectiveDirective, originalPolicy, sourceFile, scriptSample, disposition, statusCode, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } documentUrl
   * @param { !string } blockedUrl
   * @param { !string } destination
   * @param { !boolean } reportOnly
   */

  queueIntegrityViolationReport(url, endpoint, documentUrl, blockedUrl, destination, reportOnly) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } allowAttribute
   * @param { ?string } srcAttribute
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePotentialPermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, allowAttribute, srcAttribute, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } group
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDocumentPolicyViolationReport(url, group, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } subresourceUrl
   * @param { !string } integrityHash
   * @param { !string } type
   * @param { !string } destination
   */

  queueCSPHashReport(url, endpoint, subresourceUrl, integrityHash, type, destination) {}
}

/**
 * @implements { ReportingServiceProxyInterface }
 */
export class ReportingServiceProxyRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ReportingServiceProxyPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ReportingServiceProxyPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ReportingServiceProxyPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } id
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueInterventionReport(
      url,
      id,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        0,
        ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        [
          url,
          id,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } id
   * @param { ?mojoBase_mojom_Time } anticipatedRemoval
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDeprecationReport(
      url,
      id,
      anticipatedRemoval,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        1,
        ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        [
          url,
          id,
          anticipatedRemoval,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } group
   * @param { !string } documentUrl
   * @param { ?string } referrer
   * @param { ?string } blockedUrl
   * @param { !string } effectiveDirective
   * @param { !string } originalPolicy
   * @param { ?string } sourceFile
   * @param { ?string } scriptSample
   * @param { !string } disposition
   * @param { !number } statusCode
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueCspViolationReport(
      url,
      group,
      documentUrl,
      referrer,
      blockedUrl,
      effectiveDirective,
      originalPolicy,
      sourceFile,
      scriptSample,
      disposition,
      statusCode,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        2,
        ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        [
          url,
          group,
          documentUrl,
          referrer,
          blockedUrl,
          effectiveDirective,
          originalPolicy,
          sourceFile,
          scriptSample,
          disposition,
          statusCode,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } documentUrl
   * @param { !string } blockedUrl
   * @param { !string } destination
   * @param { !boolean } reportOnly
   */

  queueIntegrityViolationReport(
      url,
      endpoint,
      documentUrl,
      blockedUrl,
      destination,
      reportOnly) {
    this.proxy.sendMessage(
        3,
        ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          documentUrl,
          blockedUrl,
          destination,
          reportOnly
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePermissionsPolicyViolationReport(
      url,
      endpoint,
      policyId,
      disposition,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        4,
        ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          policyId,
          disposition,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } allowAttribute
   * @param { ?string } srcAttribute
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePotentialPermissionsPolicyViolationReport(
      url,
      endpoint,
      policyId,
      disposition,
      message,
      allowAttribute,
      srcAttribute,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        5,
        ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          policyId,
          disposition,
          message,
          allowAttribute,
          srcAttribute,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } group
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDocumentPolicyViolationReport(
      url,
      group,
      policyId,
      disposition,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        6,
        ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          group,
          policyId,
          disposition,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } endpoint
   * @param { !string } subresourceUrl
   * @param { !string } integrityHash
   * @param { !string } type
   * @param { !string } destination
   */

  queueCSPHashReport(
      url,
      endpoint,
      subresourceUrl,
      integrityHash,
      type,
      destination) {
    this.proxy.sendMessage(
        7,
        ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          subresourceUrl,
          integrityHash,
          type,
          destination
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ReportingServiceProxy
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ReportingServiceProxyReceiver {
  /**
   * @param {!ReportingServiceProxyInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ReportingServiceProxyRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ReportingServiceProxyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReportingServiceProxyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        impl.queueInterventionReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        impl.queueDeprecationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        impl.queueCspViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        impl.queueIntegrityViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queuePermissionsPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queuePotentialPermissionsPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queueDocumentPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        impl.queueCSPHashReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ReportingServiceProxy {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ReportingServiceProxy";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ReportingServiceProxyRemote}
   */
  static getRemote() {
    let remote = new ReportingServiceProxyRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ReportingServiceProxy
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ReportingServiceProxyCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ReportingServiceProxyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReportingServiceProxyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueInterventionReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        this.queueInterventionReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueDeprecationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        this.queueDeprecationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCspViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        this.queueCspViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueIntegrityViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        this.queueIntegrityViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queuePermissionsPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        this.queuePermissionsPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queuePotentialPermissionsPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        this.queuePotentialPermissionsPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueDocumentPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        this.queueDocumentPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCSPHashReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        this.queueCSPHashReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueInterventionReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueDeprecationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueCspViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingServiceProxy_QueueCSPHashReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueInterventionReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueInterventionReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.message;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueDeprecationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'anticipatedRemoval', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueDeprecationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.id;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.anticipatedRemoval;
    /** @type { !string } */
    this.message;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueCspViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedUrl', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'effectiveDirective', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalPolicy', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptSample', 64,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disposition', 72,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'statusCode', 80,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 84,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 88,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 104],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueCspViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.group;
    /** @type { !string } */
    this.documentUrl;
    /** @type { (string|undefined) } */
    this.referrer;
    /** @type { (string|undefined) } */
    this.blockedUrl;
    /** @type { !string } */
    this.effectiveDirective;
    /** @type { !string } */
    this.originalPolicy;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { (string|undefined) } */
    this.scriptSample;
    /** @type { !string } */
    this.disposition;
    /** @type { !number } */
    this.statusCode;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueIntegrityViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedUrl', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destination', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnly', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueIntegrityViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.endpoint;
    /** @type { !string } */
    this.documentUrl;
    /** @type { !string } */
    this.blockedUrl;
    /** @type { !string } */
    this.destination;
    /** @type { !boolean } */
    this.reportOnly;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.endpoint;
    /** @type { !string } */
    this.policyId;
    /** @type { !string } */
    this.disposition;
    /** @type { (string|undefined) } */
    this.message;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowAttribute', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'srcAttribute', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 64,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 68,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.endpoint;
    /** @type { !string } */
    this.policyId;
    /** @type { !string } */
    this.disposition;
    /** @type { (string|undefined) } */
    this.message;
    /** @type { (string|undefined) } */
    this.allowAttribute;
    /** @type { (string|undefined) } */
    this.srcAttribute;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFile', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.group;
    /** @type { !string } */
    this.policyId;
    /** @type { !string } */
    this.disposition;
    /** @type { (string|undefined) } */
    this.message;
    /** @type { (string|undefined) } */
    this.sourceFile;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
  }
}



mojo.internal.Struct(
    ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueCSPHashReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'integrityHash', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destination', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ReportingServiceProxy_QueueCSPHashReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.endpoint;
    /** @type { !string } */
    this.subresourceUrl;
    /** @type { !string } */
    this.integrityHash;
    /** @type { !string } */
    this.type;
    /** @type { !string } */
    this.destination;
  }
}

