// third_party/blink/public/mojom/reporting/reporting.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/reporting/reporting.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/reporting/reporting.mojom-params-data.h"
#include "third_party/blink/public/mojom/reporting/reporting.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/reporting/reporting.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/reporting/reporting.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

ReportingServiceProxy::IPCStableHashFunction ReportingServiceProxy::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ReportingServiceProxy>(message.name())) {
    case messages::ReportingServiceProxy::kQueueInterventionReport: {
      return &ReportingServiceProxy::QueueInterventionReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueueDeprecationReport: {
      return &ReportingServiceProxy::QueueDeprecationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueueCspViolationReport: {
      return &ReportingServiceProxy::QueueCspViolationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueueIntegrityViolationReport: {
      return &ReportingServiceProxy::QueueIntegrityViolationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport: {
      return &ReportingServiceProxy::QueuePermissionsPolicyViolationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport: {
      return &ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport: {
      return &ReportingServiceProxy::QueueDocumentPolicyViolationReport_Sym::IPCStableHash;
    }
    case messages::ReportingServiceProxy::kQueueCSPHashReport: {
      return &ReportingServiceProxy::QueueCSPHashReport_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ReportingServiceProxy::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ReportingServiceProxy>(message.name())) {
      case messages::ReportingServiceProxy::kQueueInterventionReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueInterventionReport";
      case messages::ReportingServiceProxy::kQueueDeprecationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueDeprecationReport";
      case messages::ReportingServiceProxy::kQueueCspViolationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueCspViolationReport";
      case messages::ReportingServiceProxy::kQueueIntegrityViolationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueIntegrityViolationReport";
      case messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueuePermissionsPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueueCSPHashReport:
            return "Receive blink::mojom::ReportingServiceProxy::QueueCSPHashReport";
    }
  } else {
    switch (static_cast<messages::ReportingServiceProxy>(message.name())) {
      case messages::ReportingServiceProxy::kQueueInterventionReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueInterventionReport";
      case messages::ReportingServiceProxy::kQueueDeprecationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueDeprecationReport";
      case messages::ReportingServiceProxy::kQueueCspViolationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueCspViolationReport";
      case messages::ReportingServiceProxy::kQueueIntegrityViolationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueIntegrityViolationReport";
      case messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueuePermissionsPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport";
      case messages::ReportingServiceProxy::kQueueCSPHashReport:
            return "Receive reply blink::mojom::ReportingServiceProxy::QueueCSPHashReport";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ReportingServiceProxy::QueueInterventionReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9bdcff1a;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueInterventionReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueueDeprecationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7ed4677;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueDeprecationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueueCspViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb42f31d;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueCspViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueueIntegrityViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d03f9e9;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueIntegrityViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueuePermissionsPolicyViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ecd6a8b;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueuePermissionsPolicyViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd2297e9;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueueDocumentPolicyViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e3d8103;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingServiceProxy::QueueCSPHashReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33b61807;  // IPCStableHash for blink::mojom::ReportingServiceProxy::QueueCSPHashReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ReportingServiceProxyProxy::ReportingServiceProxyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReportingServiceProxyProxy::QueueInterventionReport(
    const ::blink::KURL& in_url, const ::blink::String& in_id, const ::blink::String& in_message, const ::blink::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueInterventionReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueInterventionReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueInterventionReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ReportingServiceProxy.QueueInterventionReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueInterventionReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueueDeprecationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_id, std::optional<::base::Time> in_anticipatedRemoval, const ::blink::String& in_message, const ::blink::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueDeprecationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anticipatedRemoval"), in_anticipatedRemoval,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueDeprecationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->anticipatedRemoval)::BaseType> anticipatedRemoval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_anticipatedRemoval,
    anticipatedRemoval_fragment);

  params->anticipatedRemoval.Set(
      anticipatedRemoval_fragment.is_null() ? nullptr : anticipatedRemoval_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ReportingServiceProxy.QueueDeprecationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueDeprecationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueueCspViolationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_group, const ::blink::String& in_document_url, const ::blink::String& in_referrer, const ::blink::String& in_blocked_url, const ::blink::String& in_effective_directive, const ::blink::String& in_original_policy, const ::blink::String& in_source_file, const ::blink::String& in_script_sample, const ::blink::String& in_disposition, uint16_t in_status_code, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueCspViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer"), in_referrer,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("effective_directive"), in_effective_directive,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_policy"), in_original_policy,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_sample"), in_script_sample,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_code"), in_status_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueCspViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group,
    group_fragment);

  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_document_url,
    document_url_fragment);

  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_url in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->referrer)::BaseType> referrer_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_referrer,
    referrer_fragment);

  params->referrer.Set(
      referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_blocked_url,
    blocked_url_fragment);

  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->effective_directive)::BaseType> effective_directive_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_effective_directive,
    effective_directive_fragment);

  params->effective_directive.Set(
      effective_directive_fragment.is_null() ? nullptr : effective_directive_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->effective_directive.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null effective_directive in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->original_policy)::BaseType> original_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_original_policy,
    original_policy_fragment);

  params->original_policy.Set(
      original_policy_fragment.is_null() ? nullptr : original_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_policy in ReportingServiceProxy.QueueCspViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->script_sample)::BaseType> script_sample_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_script_sample,
    script_sample_fragment);

  params->script_sample.Set(
      script_sample_fragment.is_null() ? nullptr : script_sample_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_disposition,
    disposition_fragment);

  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disposition.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disposition in ReportingServiceProxy.QueueCspViolationReport request");

  params->status_code = in_status_code;

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueCspViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueueIntegrityViolationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_endpoint, const ::blink::String& in_document_url, const ::blink::String& in_blocked_url, const ::blink::String& in_destination, bool in_report_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueIntegrityViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_only"), in_report_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueIntegrityViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueIntegrityViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueIntegrityViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in ReportingServiceProxy.QueueIntegrityViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_document_url,
    document_url_fragment);

  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_url in ReportingServiceProxy.QueueIntegrityViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_blocked_url,
    blocked_url_fragment);

  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->blocked_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null blocked_url in ReportingServiceProxy.QueueIntegrityViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->destination)::BaseType> destination_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_destination,
    destination_fragment);

  params->destination.Set(
      destination_fragment.is_null() ? nullptr : destination_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination in ReportingServiceProxy.QueueIntegrityViolationReport request");

  params->report_only = in_report_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueIntegrityViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueuePermissionsPolicyViolationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_endpoint, const ::blink::String& in_policy_id, const ::blink::String& in_disposition, const ::blink::String& in_message, const ::blink::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueuePermissionsPolicyViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_id"), in_policy_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueuePermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in ReportingServiceProxy.QueuePermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_id)::BaseType> policy_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_policy_id,
    policy_id_fragment);

  params->policy_id.Set(
      policy_id_fragment.is_null() ? nullptr : policy_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_id in ReportingServiceProxy.QueuePermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_disposition,
    disposition_fragment);

  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disposition.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disposition in ReportingServiceProxy.QueuePermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueuePermissionsPolicyViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueuePotentialPermissionsPolicyViolationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_endpoint, const ::blink::String& in_policy_id, const ::blink::String& in_disposition, const ::blink::String& in_message, const ::blink::String& in_allow_attribute, const ::blink::String& in_src_attribute, const ::blink::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueuePotentialPermissionsPolicyViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_id"), in_policy_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_attribute"), in_allow_attribute,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_attribute"), in_src_attribute,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueuePotentialPermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in ReportingServiceProxy.QueuePotentialPermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_id)::BaseType> policy_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_policy_id,
    policy_id_fragment);

  params->policy_id.Set(
      policy_id_fragment.is_null() ? nullptr : policy_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_id in ReportingServiceProxy.QueuePotentialPermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_disposition,
    disposition_fragment);

  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disposition.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disposition in ReportingServiceProxy.QueuePotentialPermissionsPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->allow_attribute)::BaseType> allow_attribute_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_allow_attribute,
    allow_attribute_fragment);

  params->allow_attribute.Set(
      allow_attribute_fragment.is_null() ? nullptr : allow_attribute_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->src_attribute)::BaseType> src_attribute_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_src_attribute,
    src_attribute_fragment);

  params->src_attribute.Set(
      src_attribute_fragment.is_null() ? nullptr : src_attribute_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueuePotentialPermissionsPolicyViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueueDocumentPolicyViolationReport(
    const ::blink::KURL& in_url, const ::blink::String& in_group, const ::blink::String& in_policy_id, const ::blink::String& in_disposition, const ::blink::String& in_message, const ::blink::String& in_source_file, int32_t in_line_number, int32_t in_column_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueDocumentPolicyViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_id"), in_policy_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group,
    group_fragment);

  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_id)::BaseType> policy_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_policy_id,
    policy_id_fragment);

  params->policy_id.Set(
      policy_id_fragment.is_null() ? nullptr : policy_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_id in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->disposition)::BaseType> disposition_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_disposition,
    disposition_fragment);

  params->disposition.Set(
      disposition_fragment.is_null() ? nullptr : disposition_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disposition.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disposition in ReportingServiceProxy.QueueDocumentPolicyViolationReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  params->line_number = in_line_number;

  params->column_number = in_column_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueDocumentPolicyViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingServiceProxyProxy::QueueCSPHashReport(
    const ::blink::KURL& in_url, const ::blink::String& in_endpoint, const ::blink::String& in_subresource_url, const ::blink::String& in_integrity_hash, const ::blink::String& in_type, const ::blink::String& in_destination) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingServiceProxy::QueueCSPHashReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_url"), in_subresource_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("integrity_hash"), in_integrity_hash,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingServiceProxy::kQueueCSPHashReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingServiceProxy_QueueCSPHashReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ReportingServiceProxy.QueueCSPHashReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in ReportingServiceProxy.QueueCSPHashReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_url)::BaseType> subresource_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_subresource_url,
    subresource_url_fragment);

  params->subresource_url.Set(
      subresource_url_fragment.is_null() ? nullptr : subresource_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_url in ReportingServiceProxy.QueueCSPHashReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->integrity_hash)::BaseType> integrity_hash_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_integrity_hash,
    integrity_hash_fragment);

  params->integrity_hash.Set(
      integrity_hash_fragment.is_null() ? nullptr : integrity_hash_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->integrity_hash.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null integrity_hash in ReportingServiceProxy.QueueCSPHashReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in ReportingServiceProxy.QueueCSPHashReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->destination)::BaseType> destination_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_destination,
    destination_fragment);

  params->destination.Set(
      destination_fragment.is_null() ? nullptr : destination_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination in ReportingServiceProxy.QueueCSPHashReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingServiceProxy::Name_);
  message.set_method_name("QueueCSPHashReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ReportingServiceProxyStubDispatch::Accept(
    ReportingServiceProxy* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ReportingServiceProxy>(message->header()->name)) {
    case messages::ReportingServiceProxy::kQueueInterventionReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueInterventionReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueInterventionReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.0
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_id{};
      ::blink::String p_message{};
      ::blink::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueInterventionReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueInterventionReport(        
        std::move(p_url), 
        std::move(p_id), 
        std::move(p_message), 
        std::move(p_source_file), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueueDeprecationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.1
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_id{};
      std::optional<::base::Time> p_anticipatedRemoval{};
      ::blink::String p_message{};
      ::blink::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueDeprecationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadAnticipatedRemoval(&p_anticipatedRemoval))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueDeprecationReport(        
        std::move(p_url), 
        std::move(p_id), 
        std::move(p_anticipatedRemoval), 
        std::move(p_message), 
        std::move(p_source_file), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueueCspViolationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.2
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_group{};
      ::blink::String p_document_url{};
      ::blink::String p_referrer{};
      ::blink::String p_blocked_url{};
      ::blink::String p_effective_directive{};
      ::blink::String p_original_policy{};
      ::blink::String p_source_file{};
      ::blink::String p_script_sample{};
      ::blink::String p_disposition{};
      uint16_t p_status_code{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueCspViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadReferrer(&p_referrer))
        success = false;
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadEffectiveDirective(&p_effective_directive))
        success = false;
      if (success && !input_data_view.ReadOriginalPolicy(&p_original_policy))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success && !input_data_view.ReadScriptSample(&p_script_sample))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success)
        p_status_code = input_data_view.status_code();
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCspViolationReport(        
        std::move(p_url), 
        std::move(p_group), 
        std::move(p_document_url), 
        std::move(p_referrer), 
        std::move(p_blocked_url), 
        std::move(p_effective_directive), 
        std::move(p_original_policy), 
        std::move(p_source_file), 
        std::move(p_script_sample), 
        std::move(p_disposition), 
        std::move(p_status_code), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueueIntegrityViolationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueIntegrityViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueIntegrityViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.3
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_endpoint{};
      ::blink::String p_document_url{};
      ::blink::String p_blocked_url{};
      ::blink::String p_destination{};
      bool p_report_only{};
      ReportingServiceProxy_QueueIntegrityViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success)
        p_report_only = input_data_view.report_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueIntegrityViolationReport(        
        std::move(p_url), 
        std::move(p_endpoint), 
        std::move(p_document_url), 
        std::move(p_blocked_url), 
        std::move(p_destination), 
        std::move(p_report_only));
      return true;
    }
    case messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.4
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_endpoint{};
      ::blink::String p_policy_id{};
      ::blink::String p_disposition{};
      ::blink::String p_message{};
      ::blink::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (success && !input_data_view.ReadPolicyId(&p_policy_id))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueuePermissionsPolicyViolationReport(        
        std::move(p_url), 
        std::move(p_endpoint), 
        std::move(p_policy_id), 
        std::move(p_disposition), 
        std::move(p_message), 
        std::move(p_source_file), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.5
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_endpoint{};
      ::blink::String p_policy_id{};
      ::blink::String p_disposition{};
      ::blink::String p_message{};
      ::blink::String p_allow_attribute{};
      ::blink::String p_src_attribute{};
      ::blink::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (success && !input_data_view.ReadPolicyId(&p_policy_id))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadAllowAttribute(&p_allow_attribute))
        success = false;
      if (success && !input_data_view.ReadSrcAttribute(&p_src_attribute))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueuePotentialPermissionsPolicyViolationReport(        
        std::move(p_url), 
        std::move(p_endpoint), 
        std::move(p_policy_id), 
        std::move(p_disposition), 
        std::move(p_message), 
        std::move(p_allow_attribute), 
        std::move(p_src_attribute), 
        std::move(p_source_file), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.6
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_group{};
      ::blink::String p_policy_id{};
      ::blink::String p_disposition{};
      ::blink::String p_message{};
      ::blink::String p_source_file{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadPolicyId(&p_policy_id))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueDocumentPolicyViolationReport(        
        std::move(p_url), 
        std::move(p_group), 
        std::move(p_policy_id), 
        std::move(p_disposition), 
        std::move(p_message), 
        std::move(p_source_file), 
        std::move(p_line_number), 
        std::move(p_column_number));
      return true;
    }
    case messages::ReportingServiceProxy::kQueueCSPHashReport: {
      DCHECK(message->is_serialized());
      internal::ReportingServiceProxy_QueueCSPHashReport_Params_Data* params =
          reinterpret_cast<internal::ReportingServiceProxy_QueueCSPHashReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingServiceProxy.7
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::String p_endpoint{};
      ::blink::String p_subresource_url{};
      ::blink::String p_integrity_hash{};
      ::blink::String p_type{};
      ::blink::String p_destination{};
      ReportingServiceProxy_QueueCSPHashReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (success && !input_data_view.ReadSubresourceUrl(&p_subresource_url))
        success = false;
      if (success && !input_data_view.ReadIntegrityHash(&p_integrity_hash))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingServiceProxy::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCSPHashReport(        
        std::move(p_url), 
        std::move(p_endpoint), 
        std::move(p_subresource_url), 
        std::move(p_integrity_hash), 
        std::move(p_type), 
        std::move(p_destination));
      return true;
    }
  }
  return false;
}

// static
bool ReportingServiceProxyStubDispatch::AcceptWithResponder(
    ReportingServiceProxy* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ReportingServiceProxy>(message->header()->name)) {
    case messages::ReportingServiceProxy::kQueueInterventionReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueueDeprecationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueueCspViolationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueueIntegrityViolationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueuePermissionsPolicyViolationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueuePotentialPermissionsPolicyViolationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueueDocumentPolicyViolationReport: {
      break;
    }
    case messages::ReportingServiceProxy::kQueueCSPHashReport: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kReportingServiceProxyValidationInfo[] = {
    { &internal::ReportingServiceProxy_QueueInterventionReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueueDeprecationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueueCspViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueueIntegrityViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ReportingServiceProxy_QueueCSPHashReport_Params_Data::Validate,
     nullptr /* no response */},
};

bool ReportingServiceProxyRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ReportingServiceProxy::Name_,
    kReportingServiceProxyValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ReportingServiceProxyInterceptorForTesting::QueueInterventionReport(const ::blink::KURL& url, const ::blink::String& id, const ::blink::String& message, const ::blink::String& source_file, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueueInterventionReport(
    std::move(url)
    , 
    std::move(id)
    , 
    std::move(message)
    , 
    std::move(source_file)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueueDeprecationReport(const ::blink::KURL& url, const ::blink::String& id, std::optional<::base::Time> anticipatedRemoval, const ::blink::String& message, const ::blink::String& source_file, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueueDeprecationReport(
    std::move(url)
    , 
    std::move(id)
    , 
    std::move(anticipatedRemoval)
    , 
    std::move(message)
    , 
    std::move(source_file)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueueCspViolationReport(const ::blink::KURL& url, const ::blink::String& group, const ::blink::String& document_url, const ::blink::String& referrer, const ::blink::String& blocked_url, const ::blink::String& effective_directive, const ::blink::String& original_policy, const ::blink::String& source_file, const ::blink::String& script_sample, const ::blink::String& disposition, uint16_t status_code, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueueCspViolationReport(
    std::move(url)
    , 
    std::move(group)
    , 
    std::move(document_url)
    , 
    std::move(referrer)
    , 
    std::move(blocked_url)
    , 
    std::move(effective_directive)
    , 
    std::move(original_policy)
    , 
    std::move(source_file)
    , 
    std::move(script_sample)
    , 
    std::move(disposition)
    , 
    std::move(status_code)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueueIntegrityViolationReport(const ::blink::KURL& url, const ::blink::String& endpoint, const ::blink::String& document_url, const ::blink::String& blocked_url, const ::blink::String& destination, bool report_only) {
  GetForwardingInterface()->QueueIntegrityViolationReport(
    std::move(url)
    , 
    std::move(endpoint)
    , 
    std::move(document_url)
    , 
    std::move(blocked_url)
    , 
    std::move(destination)
    , 
    std::move(report_only)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueuePermissionsPolicyViolationReport(const ::blink::KURL& url, const ::blink::String& endpoint, const ::blink::String& policy_id, const ::blink::String& disposition, const ::blink::String& message, const ::blink::String& source_file, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueuePermissionsPolicyViolationReport(
    std::move(url)
    , 
    std::move(endpoint)
    , 
    std::move(policy_id)
    , 
    std::move(disposition)
    , 
    std::move(message)
    , 
    std::move(source_file)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueuePotentialPermissionsPolicyViolationReport(const ::blink::KURL& url, const ::blink::String& endpoint, const ::blink::String& policy_id, const ::blink::String& disposition, const ::blink::String& message, const ::blink::String& allow_attribute, const ::blink::String& src_attribute, const ::blink::String& source_file, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueuePotentialPermissionsPolicyViolationReport(
    std::move(url)
    , 
    std::move(endpoint)
    , 
    std::move(policy_id)
    , 
    std::move(disposition)
    , 
    std::move(message)
    , 
    std::move(allow_attribute)
    , 
    std::move(src_attribute)
    , 
    std::move(source_file)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueueDocumentPolicyViolationReport(const ::blink::KURL& url, const ::blink::String& group, const ::blink::String& policy_id, const ::blink::String& disposition, const ::blink::String& message, const ::blink::String& source_file, int32_t line_number, int32_t column_number) {
  GetForwardingInterface()->QueueDocumentPolicyViolationReport(
    std::move(url)
    , 
    std::move(group)
    , 
    std::move(policy_id)
    , 
    std::move(disposition)
    , 
    std::move(message)
    , 
    std::move(source_file)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    );
}
void ReportingServiceProxyInterceptorForTesting::QueueCSPHashReport(const ::blink::KURL& url, const ::blink::String& endpoint, const ::blink::String& subresource_url, const ::blink::String& integrity_hash, const ::blink::String& type, const ::blink::String& destination) {
  GetForwardingInterface()->QueueCSPHashReport(
    std::move(url)
    , 
    std::move(endpoint)
    , 
    std::move(subresource_url)
    , 
    std::move(integrity_hash)
    , 
    std::move(type)
    , 
    std::move(destination)
    );
}
ReportingServiceProxyAsyncWaiter::ReportingServiceProxyAsyncWaiter(
    ReportingServiceProxy* proxy) : proxy_(proxy) {}

ReportingServiceProxyAsyncWaiter::~ReportingServiceProxyAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif