// third_party/blink/public/mojom/renderer_preferences.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared.h"


namespace blink::mojom {
class RendererPreferencesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::RendererPreferencesDataView> {
  using Data = ::blink::mojom::internal::RendererPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class RendererPreferencesDataView {
 public:
  RendererPreferencesDataView() = default;

  RendererPreferencesDataView(
      internal::RendererPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool can_accept_load_drops() const {
    return data_->can_accept_load_drops;
  }
  bool should_antialias_text() const {
    return data_->should_antialias_text;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHinting(UserType* output) const {
    auto data_value = data_->hinting;
    return mojo::internal::Deserialize<::gfx::mojom::Hinting>(
        data_value, output);
  }
  ::gfx::mojom::Hinting hinting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::Hinting>(data_->hinting));
  }
  bool use_autohinter() const {
    return data_->use_autohinter;
  }
  bool use_bitmaps() const {
    return data_->use_bitmaps;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubpixelRendering(UserType* output) const {
    auto data_value = data_->subpixel_rendering;
    return mojo::internal::Deserialize<::gfx::mojom::SubpixelRendering>(
        data_value, output);
  }
  ::gfx::mojom::SubpixelRendering subpixel_rendering() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::SubpixelRendering>(data_->subpixel_rendering));
  }
  bool use_subpixel_positioning() const {
    return data_->use_subpixel_positioning;
  }
  uint32_t focus_ring_color() const {
    return data_->focus_ring_color;
  }
  uint32_t active_selection_bg_color() const {
    return data_->active_selection_bg_color;
  }
  uint32_t active_selection_fg_color() const {
    return data_->active_selection_fg_color;
  }
  uint32_t inactive_selection_bg_color() const {
    return data_->inactive_selection_bg_color;
  }
  uint32_t inactive_selection_fg_color() const {
    return data_->inactive_selection_fg_color;
  }
  bool browser_handles_all_top_level_requests() const {
    return data_->browser_handles_all_top_level_requests;
  }
  inline void GetCaretBlinkIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaretBlinkInterval(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `caret_blink_interval` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaretBlinkInterval` instead "
    "of `ReadCaretBlinkInterval if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->caret_blink_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool use_custom_colors() const {
    return data_->use_custom_colors;
  }
  bool enable_referrers() const {
    return data_->enable_referrers;
  }
  bool allow_cross_origin_auth_prompt() const {
    return data_->allow_cross_origin_auth_prompt;
  }
  bool enable_do_not_track() const {
    return data_->enable_do_not_track;
  }
  bool enable_encrypted_media() const {
    return data_->enable_encrypted_media;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcIpHandlingPolicy(UserType* output) const {
    auto data_value = data_->webrtc_ip_handling_policy;
    return mojo::internal::Deserialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        data_value, output);
  }
  ::blink::mojom::WebRtcIpHandlingPolicy webrtc_ip_handling_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebRtcIpHandlingPolicy>(data_->webrtc_ip_handling_policy));
  }
  inline void GetWebrtcIpHandlingUrlsDataView(
      mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcIpHandlingUrls(UserType* output) {
    
    auto* pointer = data_->webrtc_ip_handling_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>>(
        pointer, output, message_);
  }
  std::optional<bool> webrtc_post_quantum_key_agreement() const {

    return data_->webrtc_post_quantum_key_agreement_$flag
        ? std::make_optional(!!data_->webrtc_post_quantum_key_agreement_$value)
        : std::nullopt;
  }
  uint16_t webrtc_udp_min_port() const {
    return data_->webrtc_udp_min_port;
  }
  uint16_t webrtc_udp_max_port() const {
    return data_->webrtc_udp_max_port;
  }
  inline void GetWebrtcLocalIpsAllowedUrlsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcLocalIpsAllowedUrls(UserType* output) {
    
    auto* pointer = data_->webrtc_local_ips_allowed_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetUserAgentOverrideDataView(
      ::blink::mojom::UserAgentOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgentOverride(UserType* output) {
    
    auto* pointer = data_->user_agent_override.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetAcceptLanguagesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptLanguages(UserType* output) {
    
    auto* pointer = data_->accept_languages.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool send_subresource_notification() const {
    return data_->send_subresource_notification;
  }
  bool plugin_fullscreen_allowed() const {
    return data_->plugin_fullscreen_allowed;
  }
  bool caret_browsing_enabled() const {
    return data_->caret_browsing_enabled;
  }
  inline void GetExplicitlyAllowedNetworkPortsDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExplicitlyAllowedNetworkPorts(UserType* output) {
    
    auto* pointer = data_->explicitly_allowed_network_ports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  bool view_source_line_wrap_enabled() const {
    return data_->view_source_line_wrap_enabled;
  }
 private:
  internal::RendererPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_DATA_VIEW_H_