// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DebugKey::DebugKey()
    : value() {}

DebugKey::DebugKey(
    uint64_t value_in)
    : value(std::move(value_in)) {}

DebugKey::~DebugKey() = default;
size_t DebugKey::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void DebugKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugModeDetails::DebugModeDetails()
    : is_enabled(false),
      debug_key() {}

DebugModeDetails::DebugModeDetails(
    bool is_enabled_in,
    DebugKeyPtr debug_key_in)
    : is_enabled(std::move(is_enabled_in)),
      debug_key(std::move(debug_key_in)) {}

DebugModeDetails::~DebugModeDetails() = default;

void DebugModeDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_key"), this->debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DebugKeyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugModeDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PrivateAggregationHost::IPCStableHashFunction PrivateAggregationHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrivateAggregationHost>(message.name())) {
    case messages::PrivateAggregationHost::kContributeToHistogram: {
      return &PrivateAggregationHost::ContributeToHistogram_Sym::IPCStableHash;
    }
    case messages::PrivateAggregationHost::kContributeToHistogramOnEvent: {
      return &PrivateAggregationHost::ContributeToHistogramOnEvent_Sym::IPCStableHash;
    }
    case messages::PrivateAggregationHost::kEnableDebugMode: {
      return &PrivateAggregationHost::EnableDebugMode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrivateAggregationHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrivateAggregationHost>(message.name())) {
      case messages::PrivateAggregationHost::kContributeToHistogram:
            return "Receive blink::mojom::PrivateAggregationHost::ContributeToHistogram";
      case messages::PrivateAggregationHost::kContributeToHistogramOnEvent:
            return "Receive blink::mojom::PrivateAggregationHost::ContributeToHistogramOnEvent";
      case messages::PrivateAggregationHost::kEnableDebugMode:
            return "Receive blink::mojom::PrivateAggregationHost::EnableDebugMode";
    }
  } else {
    switch (static_cast<messages::PrivateAggregationHost>(message.name())) {
      case messages::PrivateAggregationHost::kContributeToHistogram:
            return "Receive reply blink::mojom::PrivateAggregationHost::ContributeToHistogram";
      case messages::PrivateAggregationHost::kContributeToHistogramOnEvent:
            return "Receive reply blink::mojom::PrivateAggregationHost::ContributeToHistogramOnEvent";
      case messages::PrivateAggregationHost::kEnableDebugMode:
            return "Receive reply blink::mojom::PrivateAggregationHost::EnableDebugMode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrivateAggregationHost::ContributeToHistogram_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05e0a9b1;  // IPCStableHash for blink::mojom::PrivateAggregationHost::ContributeToHistogram
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrivateAggregationHost::ContributeToHistogramOnEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa188212f;  // IPCStableHash for blink::mojom::PrivateAggregationHost::ContributeToHistogramOnEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrivateAggregationHost::EnableDebugMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf948edde;  // IPCStableHash for blink::mojom::PrivateAggregationHost::EnableDebugMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PrivateAggregationHostProxy::PrivateAggregationHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrivateAggregationHostProxy::ContributeToHistogram(
    ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> in_contributions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PrivateAggregationHost::ContributeToHistogram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contributions"), in_contributions,
                        "<value of type ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrivateAggregationHost::kContributeToHistogram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PrivateAggregationHost_ContributeToHistogram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->contributions)::BaseType>
      contributions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AggregatableReportHistogramContributionDataView>>(
    in_contributions,
    contributions_fragment,
    &contributions_validate_params);

  params->contributions.Set(
      contributions_fragment.is_null() ? nullptr : contributions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->contributions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null contributions in PrivateAggregationHost.ContributeToHistogram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrivateAggregationHost::Name_);
  message.set_method_name("ContributeToHistogram");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrivateAggregationHostProxy::ContributeToHistogramOnEvent(
    PrivateAggregationErrorEvent in_error_event, ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> in_contributions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PrivateAggregationHost::ContributeToHistogramOnEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_event"), in_error_event,
                        "<value of type PrivateAggregationErrorEvent>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contributions"), in_contributions,
                        "<value of type ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrivateAggregationHost::kContributeToHistogramOnEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PrivateAggregationHost_ContributeToHistogramOnEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PrivateAggregationErrorEvent>(
    in_error_event,
    &params->error_event);
  mojo::internal::MessageFragment<
      typename decltype(params->contributions)::BaseType>
      contributions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AggregatableReportHistogramContributionDataView>>(
    in_contributions,
    contributions_fragment,
    &contributions_validate_params);

  params->contributions.Set(
      contributions_fragment.is_null() ? nullptr : contributions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->contributions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null contributions in PrivateAggregationHost.ContributeToHistogramOnEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrivateAggregationHost::Name_);
  message.set_method_name("ContributeToHistogramOnEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrivateAggregationHostProxy::EnableDebugMode(
    DebugKeyPtr in_debug_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PrivateAggregationHost::EnableDebugMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_key"), in_debug_key,
                        "<value of type DebugKeyPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrivateAggregationHost::kEnableDebugMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PrivateAggregationHost_EnableDebugMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->debug_key)::BaseType> debug_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DebugKeyDataView>(
    in_debug_key,
    debug_key_fragment);

  params->debug_key.Set(
      debug_key_fragment.is_null() ? nullptr : debug_key_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrivateAggregationHost::Name_);
  message.set_method_name("EnableDebugMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PrivateAggregationHostStubDispatch::Accept(
    PrivateAggregationHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrivateAggregationHost>(message->header()->name)) {
    case messages::PrivateAggregationHost::kContributeToHistogram: {
      DCHECK(message->is_serialized());
      internal::PrivateAggregationHost_ContributeToHistogram_Params_Data* params =
          reinterpret_cast<internal::PrivateAggregationHost_ContributeToHistogram_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrivateAggregationHost.0
      bool success = true;
      ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> p_contributions{};
      PrivateAggregationHost_ContributeToHistogram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContributions(&p_contributions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrivateAggregationHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContributeToHistogram(        
        std::move(p_contributions));
      return true;
    }
    case messages::PrivateAggregationHost::kContributeToHistogramOnEvent: {
      DCHECK(message->is_serialized());
      internal::PrivateAggregationHost_ContributeToHistogramOnEvent_Params_Data* params =
          reinterpret_cast<internal::PrivateAggregationHost_ContributeToHistogramOnEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrivateAggregationHost.1
      bool success = true;
      PrivateAggregationErrorEvent p_error_event{};
      ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> p_contributions{};
      PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorEvent(&p_error_event))
        success = false;
      if (success && !input_data_view.ReadContributions(&p_contributions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrivateAggregationHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContributeToHistogramOnEvent(        
        std::move(p_error_event), 
        std::move(p_contributions));
      return true;
    }
    case messages::PrivateAggregationHost::kEnableDebugMode: {
      DCHECK(message->is_serialized());
      internal::PrivateAggregationHost_EnableDebugMode_Params_Data* params =
          reinterpret_cast<internal::PrivateAggregationHost_EnableDebugMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PrivateAggregationHost.2
      bool success = true;
      DebugKeyPtr p_debug_key{};
      PrivateAggregationHost_EnableDebugMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDebugKey(&p_debug_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrivateAggregationHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDebugMode(        
        std::move(p_debug_key));
      return true;
    }
  }
  return false;
}

// static
bool PrivateAggregationHostStubDispatch::AcceptWithResponder(
    PrivateAggregationHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrivateAggregationHost>(message->header()->name)) {
    case messages::PrivateAggregationHost::kContributeToHistogram: {
      break;
    }
    case messages::PrivateAggregationHost::kContributeToHistogramOnEvent: {
      break;
    }
    case messages::PrivateAggregationHost::kEnableDebugMode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPrivateAggregationHostValidationInfo[] = {
    { &internal::PrivateAggregationHost_ContributeToHistogram_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrivateAggregationHost_ContributeToHistogramOnEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PrivateAggregationHost_EnableDebugMode_Params_Data::Validate,
     nullptr /* no response */},
};

bool PrivateAggregationHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PrivateAggregationHost::Name_,
    kPrivateAggregationHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DebugKey::DataView, ::blink::mojom::blink::DebugKeyPtr>::Read(
    ::blink::mojom::blink::DebugKey::DataView input,
    ::blink::mojom::blink::DebugKeyPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DebugKeyPtr result(::blink::mojom::blink::DebugKey::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DebugModeDetails::DataView, ::blink::mojom::blink::DebugModeDetailsPtr>::Read(
    ::blink::mojom::blink::DebugModeDetails::DataView input,
    ::blink::mojom::blink::DebugModeDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DebugModeDetailsPtr result(::blink::mojom::blink::DebugModeDetails::New());
  
      if (success)
        result->is_enabled = input.is_enabled();
      if (success && !input.ReadDebugKey(&result->debug_key))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PrivateAggregationHostInterceptorForTesting::ContributeToHistogram(::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) {
  GetForwardingInterface()->ContributeToHistogram(
    std::move(contributions)
    );
}
void PrivateAggregationHostInterceptorForTesting::ContributeToHistogramOnEvent(PrivateAggregationErrorEvent error_event, ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) {
  GetForwardingInterface()->ContributeToHistogramOnEvent(
    std::move(error_event)
    , 
    std::move(contributions)
    );
}
void PrivateAggregationHostInterceptorForTesting::EnableDebugMode(DebugKeyPtr debug_key) {
  GetForwardingInterface()->EnableDebugMode(
    std::move(debug_key)
    );
}
PrivateAggregationHostAsyncWaiter::PrivateAggregationHostAsyncWaiter(
    PrivateAggregationHost* proxy) : proxy_(proxy) {}

PrivateAggregationHostAsyncWaiter::~PrivateAggregationHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif