// third_party/blink/public/mojom/presentation/presentation.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ScreenAvailability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PresentationConnectionState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PresentationConnectionCloseReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PresentationErrorType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PresentationInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PresentationInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PresentationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PresentationInfo struct");

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in PresentationInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PresentationErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PresentationErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PresentationError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::PresentationErrorType>(
        Traits::error_type(input),
        &fragment->error_type);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in PresentationError struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PresentationConnectionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PresentationConnectionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PresentationConnectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::presentation_info(input)) in_presentation_info = Traits::presentation_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->presentation_info)::BaseType> presentation_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView, send_validation>(
        in_presentation_info,
        presentation_info_fragment);

      fragment->presentation_info.Set(
          presentation_info_fragment.is_null() ? nullptr : presentation_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->presentation_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presentation_info in PresentationConnectionResult struct");

      decltype(Traits::connection_remote(input)) in_connection_remote = Traits::connection_remote(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
        in_connection_remote,
        &fragment->connection_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection_remote in PresentationConnectionResult struct");

      decltype(Traits::connection_receiver(input)) in_connection_receiver = Traits::connection_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
        in_connection_receiver,
        &fragment->connection_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection_receiver in PresentationConnectionResult struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PresentationConnectionMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PresentationConnectionMessageDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PresentationConnectionMessage_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::PresentationConnectionMessageDataView::Tag::kMessage: {
    decltype(Traits::message(input))
    in_message = Traits::message(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_message)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_message,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null message in PresentationConnectionMessage union");
    fragment->data.f_message.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PresentationConnectionMessageDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_data,
  value_fragment,
  &data_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in PresentationConnectionMessage union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_SEND_VALIDATION_H_