// third_party/blink/public/mojom/presentation/presentation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class PresentationInfoDataView;

class PresentationErrorDataView;

class PresentationConnectionResultDataView;

class PresentationConnectionMessageDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PresentationInfoDataView> {
  using Data = ::blink::mojom::internal::PresentationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PresentationErrorDataView> {
  using Data = ::blink::mojom::internal::PresentationError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PresentationConnectionResultDataView> {
  using Data = ::blink::mojom::internal::PresentationConnectionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PresentationConnectionMessageDataView> {
  using Data = ::blink::mojom::internal::PresentationConnectionMessage_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ScreenAvailability : int32_t {
  
  UNKNOWN = 0,
  
  UNAVAILABLE = 1,
  
  SOURCE_NOT_SUPPORTED = 2,
  
  DISABLED = 3,
  
  AVAILABLE = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ScreenAvailability value);
inline bool IsKnownEnumValue(ScreenAvailability value) {
  return internal::ScreenAvailability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PresentationConnectionState : int32_t {
  
  CONNECTING = 0,
  
  CONNECTED = 1,
  
  CLOSED = 2,
  
  TERMINATED = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PresentationConnectionState value);
inline bool IsKnownEnumValue(PresentationConnectionState value) {
  return internal::PresentationConnectionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PresentationConnectionCloseReason : int32_t {
  
  CONNECTION_ERROR = 0,
  
  CLOSED = 1,
  
  WENT_AWAY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PresentationConnectionCloseReason value);
inline bool IsKnownEnumValue(PresentationConnectionCloseReason value) {
  return internal::PresentationConnectionCloseReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PresentationErrorType : int32_t {
  
  NO_AVAILABLE_SCREENS = 0,
  
  PRESENTATION_REQUEST_CANCELLED = 1,
  
  NO_PRESENTATION_FOUND = 2,
  
  PREVIOUS_START_IN_PROGRESS = 3,
  
  UNKNOWN = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PresentationErrorType value);
inline bool IsKnownEnumValue(PresentationErrorType value) {
  return internal::PresentationErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PresentationConnectionInterfaceBase {};

using PresentationConnectionPtrDataView =
    mojo::InterfacePtrDataView<PresentationConnectionInterfaceBase>;
using PresentationConnectionRequestDataView =
    mojo::InterfaceRequestDataView<PresentationConnectionInterfaceBase>;
using PresentationConnectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PresentationConnectionInterfaceBase>;
using PresentationConnectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PresentationConnectionInterfaceBase>;
class PresentationServiceInterfaceBase {};

using PresentationServicePtrDataView =
    mojo::InterfacePtrDataView<PresentationServiceInterfaceBase>;
using PresentationServiceRequestDataView =
    mojo::InterfaceRequestDataView<PresentationServiceInterfaceBase>;
using PresentationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PresentationServiceInterfaceBase>;
using PresentationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PresentationServiceInterfaceBase>;
class PresentationControllerInterfaceBase {};

using PresentationControllerPtrDataView =
    mojo::InterfacePtrDataView<PresentationControllerInterfaceBase>;
using PresentationControllerRequestDataView =
    mojo::InterfaceRequestDataView<PresentationControllerInterfaceBase>;
using PresentationControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PresentationControllerInterfaceBase>;
using PresentationControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PresentationControllerInterfaceBase>;
class PresentationReceiverInterfaceBase {};

using PresentationReceiverPtrDataView =
    mojo::InterfacePtrDataView<PresentationReceiverInterfaceBase>;
using PresentationReceiverRequestDataView =
    mojo::InterfaceRequestDataView<PresentationReceiverInterfaceBase>;
using PresentationReceiverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PresentationReceiverInterfaceBase>;
using PresentationReceiverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PresentationReceiverInterfaceBase>;


class PresentationInfoDataView {
 public:
  PresentationInfoDataView() = default;

  PresentationInfoDataView(
      internal::PresentationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PresentationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PresentationErrorDataView {
 public:
  PresentationErrorDataView() = default;

  PresentationErrorDataView(
      internal::PresentationError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorType(UserType* output) const {
    auto data_value = data_->error_type;
    return mojo::internal::Deserialize<::blink::mojom::PresentationErrorType>(
        data_value, output);
  }
  PresentationErrorType error_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PresentationErrorType>(data_->error_type));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PresentationError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PresentationConnectionResultDataView {
 public:
  PresentationConnectionResultDataView() = default;

  PresentationConnectionResultDataView(
      internal::PresentationConnectionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPresentationInfoDataView(
      PresentationInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentationInfo(UserType* output) {
    
    auto* pointer = data_->presentation_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::PresentationInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeConnectionRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
            &data_->connection_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeConnectionReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
            &data_->connection_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PresentationConnectionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PresentationConnectionMessageDataView {
 public:
  using Tag = internal::PresentationConnectionMessage_Data::PresentationConnectionMessage_Tag;

  PresentationConnectionMessageDataView() = default;

  PresentationConnectionMessageDataView(
      internal::PresentationConnectionMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_message() const { return data_->tag == Tag::kMessage; }
  inline void GetMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) const {
    
    CHECK(is_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_message.Get(), output, message_);
  }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_data.Get(), output, message_);
  }

 private:
  internal::PresentationConnectionMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_DATA_VIEW_H_