// third_party/blink/public/mojom/presentation/presentation.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/presentation/presentation.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PresentationConnectionProxy;

template <typename ImplRefTraits>
class PresentationConnectionStub;

class PresentationConnectionRequestValidator;


class PLATFORM_EXPORT PresentationConnection
    : public PresentationConnectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PresentationConnection";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PresentationConnectionInterfaceBase;
  using Proxy_ = PresentationConnectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PresentationConnectionStub<ImplRefTraits>;

  using RequestValidator_ = PresentationConnectionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMessageMinVersion = 0,
    kDidChangeStateMinVersion = 0,
    kDidCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PresentationConnection() = default;

  virtual void OnMessage(PresentationConnectionMessagePtr message) = 0;

  virtual void DidChangeState(PresentationConnectionState state) = 0;

  virtual void DidClose(PresentationConnectionCloseReason reason) = 0;
};

class PresentationServiceProxy;

template <typename ImplRefTraits>
class PresentationServiceStub;

class PresentationServiceRequestValidator;
class PresentationServiceResponseValidator;


class PLATFORM_EXPORT PresentationService
    : public PresentationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PresentationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PresentationServiceInterfaceBase;
  using Proxy_ = PresentationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PresentationServiceStub<ImplRefTraits>;

  using RequestValidator_ = PresentationServiceRequestValidator;
  using ResponseValidator_ = PresentationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetControllerMinVersion = 0,
    kSetReceiverMinVersion = 0,
    kSetDefaultPresentationUrlsMinVersion = 0,
    kListenForScreenAvailabilityMinVersion = 0,
    kStopListeningForScreenAvailabilityMinVersion = 0,
    kStartPresentationMinVersion = 0,
    kReconnectPresentationMinVersion = 0,
    kCloseConnectionMinVersion = 0,
    kTerminateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDefaultPresentationUrls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ListenForScreenAvailability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopListeningForScreenAvailability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartPresentation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReconnectPresentation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseConnection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Terminate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PresentationService() = default;

  virtual void SetController(::mojo::PendingRemote<PresentationController> controller) = 0;

  virtual void SetReceiver(::mojo::PendingRemote<PresentationReceiver> receiver) = 0;

  virtual void SetDefaultPresentationUrls(const ::blink::Vector<::blink::KURL>& presentation_urls) = 0;

  virtual void ListenForScreenAvailability(const ::blink::KURL& availability_url) = 0;

  virtual void StopListeningForScreenAvailability(const ::blink::KURL& availability_url) = 0;

  using StartPresentationCallback = base::OnceCallback<void(PresentationConnectionResultPtr, PresentationErrorPtr)>;
  using StartPresentationMojoCallback = base::OnceCallback<void(PresentationConnectionResultPtr, PresentationErrorPtr)>;

  virtual void StartPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, StartPresentationCallback callback) = 0;

  using ReconnectPresentationCallback = base::OnceCallback<void(PresentationConnectionResultPtr, PresentationErrorPtr)>;
  using ReconnectPresentationMojoCallback = base::OnceCallback<void(PresentationConnectionResultPtr, PresentationErrorPtr)>;

  virtual void ReconnectPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, const ::blink::String& presentation_id, ReconnectPresentationCallback callback) = 0;

  virtual void CloseConnection(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) = 0;

  virtual void Terminate(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) = 0;
};

class PresentationControllerProxy;

template <typename ImplRefTraits>
class PresentationControllerStub;

class PresentationControllerRequestValidator;


class PLATFORM_EXPORT PresentationController
    : public PresentationControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PresentationController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PresentationControllerInterfaceBase;
  using Proxy_ = PresentationControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PresentationControllerStub<ImplRefTraits>;

  using RequestValidator_ = PresentationControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnScreenAvailabilityUpdatedMinVersion = 0,
    kOnDefaultPresentationStartedMinVersion = 0,
    kOnConnectionStateChangedMinVersion = 0,
    kOnConnectionClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnScreenAvailabilityUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDefaultPresentationStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConnectionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConnectionClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PresentationController() = default;

  virtual void OnScreenAvailabilityUpdated(const ::blink::KURL& url, ScreenAvailability availability) = 0;

  virtual void OnDefaultPresentationStarted(PresentationConnectionResultPtr result) = 0;

  virtual void OnConnectionStateChanged(PresentationInfoPtr presentation_info, PresentationConnectionState newState) = 0;

  virtual void OnConnectionClosed(PresentationInfoPtr presentation_info, PresentationConnectionCloseReason reason, const ::blink::String& message) = 0;
};

class PresentationReceiverProxy;

template <typename ImplRefTraits>
class PresentationReceiverStub;

class PresentationReceiverRequestValidator;


class PLATFORM_EXPORT PresentationReceiver
    : public PresentationReceiverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PresentationReceiver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PresentationReceiverInterfaceBase;
  using Proxy_ = PresentationReceiverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PresentationReceiverStub<ImplRefTraits>;

  using RequestValidator_ = PresentationReceiverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReceiverConnectionAvailableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReceiverConnectionAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PresentationReceiver() = default;

  virtual void OnReceiverConnectionAvailable(PresentationConnectionResultPtr result) = 0;
};



class PLATFORM_EXPORT PresentationConnectionProxy
    : public PresentationConnection {
 public:
  using InterfaceType = PresentationConnection;

  explicit PresentationConnectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMessage(PresentationConnectionMessagePtr message) final;
  
  void DidChangeState(PresentationConnectionState state) final;
  
  void DidClose(PresentationConnectionCloseReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PresentationServiceProxy
    : public PresentationService {
 public:
  using InterfaceType = PresentationService;

  explicit PresentationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetController(::mojo::PendingRemote<PresentationController> controller) final;
  
  void SetReceiver(::mojo::PendingRemote<PresentationReceiver> receiver) final;
  
  void SetDefaultPresentationUrls(const ::blink::Vector<::blink::KURL>& presentation_urls) final;
  
  void ListenForScreenAvailability(const ::blink::KURL& availability_url) final;
  
  void StopListeningForScreenAvailability(const ::blink::KURL& availability_url) final;
  
  void StartPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, StartPresentationCallback callback) final;
  
  void ReconnectPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, const ::blink::String& presentation_id, ReconnectPresentationCallback callback) final;
  
  void CloseConnection(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) final;
  
  void Terminate(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PresentationControllerProxy
    : public PresentationController {
 public:
  using InterfaceType = PresentationController;

  explicit PresentationControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnScreenAvailabilityUpdated(const ::blink::KURL& url, ScreenAvailability availability) final;
  
  void OnDefaultPresentationStarted(PresentationConnectionResultPtr result) final;
  
  void OnConnectionStateChanged(PresentationInfoPtr presentation_info, PresentationConnectionState newState) final;
  
  void OnConnectionClosed(PresentationInfoPtr presentation_info, PresentationConnectionCloseReason reason, const ::blink::String& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PresentationReceiverProxy
    : public PresentationReceiver {
 public:
  using InterfaceType = PresentationReceiver;

  explicit PresentationReceiverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReceiverConnectionAvailable(PresentationConnectionResultPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PresentationConnectionStubDispatch {
 public:
  static bool Accept(PresentationConnection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PresentationConnection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PresentationConnection>>
class PresentationConnectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PresentationConnectionStub() = default;
  ~PresentationConnectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationConnectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationConnectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PresentationServiceStubDispatch {
 public:
  static bool Accept(PresentationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PresentationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PresentationService>>
class PresentationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PresentationServiceStub() = default;
  ~PresentationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PresentationControllerStubDispatch {
 public:
  static bool Accept(PresentationController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PresentationController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PresentationController>>
class PresentationControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PresentationControllerStub() = default;
  ~PresentationControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PresentationReceiverStubDispatch {
 public:
  static bool Accept(PresentationReceiver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PresentationReceiver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PresentationReceiver>>
class PresentationReceiverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PresentationReceiverStub() = default;
  ~PresentationReceiverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationReceiverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PresentationReceiverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PresentationConnectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PresentationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PresentationControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PresentationReceiverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PresentationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT PresentationError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PresentationError, T>::value>;
  using DataView = PresentationErrorDataView;
  using Data_ = internal::PresentationError_Data;

  template <typename... Args>
  static PresentationErrorPtr New(Args&&... args) {
    return PresentationErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PresentationErrorPtr From(const U& u) {
    return mojo::TypeConverter<PresentationErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PresentationError>::Convert(*this);
  }


  PresentationError();

  PresentationError(
      PresentationErrorType error_type,
      const ::blink::String& message);


  ~PresentationError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PresentationErrorPtr>
  PresentationErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PresentationError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PresentationError_UnserializedMessageContext<
            UserType, PresentationError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PresentationError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PresentationError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PresentationError_UnserializedMessageContext<
            UserType, PresentationError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PresentationError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PresentationErrorType error_type;
  
  ::blink::String message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PresentationError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PresentationConnectionMessage {
 public:
  using DataView = PresentationConnectionMessageDataView;
  using Data_ = internal::PresentationConnectionMessage_Data;
  using Tag = Data_::PresentationConnectionMessage_Tag;

  template <typename... Args>
  static PresentationConnectionMessagePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |message|.
  static PresentationConnectionMessagePtr NewMessage(
      const ::blink::String& value);
  // Construct an instance holding |data|.
  static PresentationConnectionMessagePtr NewData(
      ::blink::Vector<uint8_t> value);

  template <typename U>
  static PresentationConnectionMessagePtr From(const U& u) {
    return mojo::TypeConverter<PresentationConnectionMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PresentationConnectionMessage>::Convert(*this);
  }
  ~PresentationConnectionMessage();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PresentationConnectionMessage(const PresentationConnectionMessage& other) = delete;
  PresentationConnectionMessage& operator=(const PresentationConnectionMessage& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PresentationConnectionMessagePtr>
  PresentationConnectionMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PresentationConnectionMessage>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PresentationConnectionMessage>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_message() const { return tag_ == Tag::kMessage; }
  const ::blink::String& get_message() const {
    CHECK(tag_ == Tag::kMessage);
    return data_.message;
  }
  ::blink::String& get_message() {
    CHECK(tag_ == Tag::kMessage);
    return data_.message;
  }
  void set_message(const ::blink::String& message);

  bool is_data() const { return tag_ == Tag::kData; }
  const ::blink::Vector<uint8_t>& get_data() const {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  ::blink::Vector<uint8_t>& get_data() {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  void set_data(::blink::Vector<uint8_t> data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PresentationConnectionMessage::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PresentationConnectionMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMessage)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
        ::blink::Vector<uint8_t> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::String message;
    ::blink::Vector<uint8_t> data;
  };

  PresentationConnectionMessage(
      std::in_place_index_t<static_cast<size_t>(Tag::kMessage)>,
      const ::blink::String& value);
  PresentationConnectionMessage(
      std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
      ::blink::Vector<uint8_t> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT PresentationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PresentationInfo, T>::value>;
  using DataView = PresentationInfoDataView;
  using Data_ = internal::PresentationInfo_Data;

  template <typename... Args>
  static PresentationInfoPtr New(Args&&... args) {
    return PresentationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PresentationInfoPtr From(const U& u) {
    return mojo::TypeConverter<PresentationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PresentationInfo>::Convert(*this);
  }


  PresentationInfo();

  PresentationInfo(
      const ::blink::KURL& url,
      const ::blink::String& id);


  ~PresentationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PresentationInfoPtr>
  PresentationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PresentationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PresentationInfo_UnserializedMessageContext<
            UserType, PresentationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PresentationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PresentationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PresentationInfo_UnserializedMessageContext<
            UserType, PresentationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PresentationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::String id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PresentationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PresentationConnectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PresentationConnectionResult, T>::value>;
  using DataView = PresentationConnectionResultDataView;
  using Data_ = internal::PresentationConnectionResult_Data;

  template <typename... Args>
  static PresentationConnectionResultPtr New(Args&&... args) {
    return PresentationConnectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PresentationConnectionResultPtr From(const U& u) {
    return mojo::TypeConverter<PresentationConnectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PresentationConnectionResult>::Convert(*this);
  }


  PresentationConnectionResult();

  PresentationConnectionResult(
      PresentationInfoPtr presentation_info,
      ::mojo::PendingRemote<PresentationConnection> connection_remote,
      ::mojo::PendingReceiver<PresentationConnection> connection_receiver);

PresentationConnectionResult(const PresentationConnectionResult&) = delete;
PresentationConnectionResult& operator=(const PresentationConnectionResult&) = delete;

  ~PresentationConnectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PresentationConnectionResultPtr>
  PresentationConnectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PresentationConnectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PresentationConnectionResult_UnserializedMessageContext<
            UserType, PresentationConnectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PresentationConnectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PresentationConnectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PresentationConnectionResult_UnserializedMessageContext<
            UserType, PresentationConnectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PresentationConnectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PresentationInfoPtr presentation_info;
  
  ::mojo::PendingRemote<PresentationConnection> connection_remote;
  
  ::mojo::PendingReceiver<PresentationConnection> connection_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PresentationConnectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PresentationConnectionMessagePtr PresentationConnectionMessage::Clone() const {
  switch (tag_) {
    case Tag::kMessage:
      return NewMessage(
          mojo::Clone(data_.message));
    case Tag::kData:
      return NewData(
          mojo::Clone(data_.data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PresentationConnectionMessage>::value>::type*>
bool PresentationConnectionMessage::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kMessage:
      return mojo::Equals(data_.message, other.data_.message);
    case Tag::kData:
      return mojo::Equals(data_.data, other.data_.data);
  }

  return false;
}
template <typename StructPtrType>
PresentationInfoPtr PresentationInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(id)
  );
}

template <typename T, PresentationInfo::EnableIfSame<T>*>
bool PresentationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, PresentationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
PresentationErrorPtr PresentationError::Clone() const {
  return New(
      mojo::Clone(error_type),
      mojo::Clone(message)
  );
}

template <typename T, PresentationError::EnableIfSame<T>*>
bool PresentationError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_type, other_struct.error_type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, PresentationError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_type < rhs.error_type)
    return true;
  if (rhs.error_type < lhs.error_type)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
PresentationConnectionResultPtr PresentationConnectionResult::Clone() const {
  return New(
      mojo::Clone(presentation_info),
      mojo::Clone(connection_remote),
      mojo::Clone(connection_receiver)
  );
}

template <typename T, PresentationConnectionResult::EnableIfSame<T>*>
bool PresentationConnectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->presentation_info, other_struct.presentation_info))
    return false;
  if (!mojo::Equals(this->connection_remote, other_struct.connection_remote))
    return false;
  if (!mojo::Equals(this->connection_receiver, other_struct.connection_receiver))
    return false;
  return true;
}

template <typename T, PresentationConnectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.presentation_info < rhs.presentation_info)
    return true;
  if (rhs.presentation_info < lhs.presentation_info)
    return false;
  if (lhs.connection_remote < rhs.connection_remote)
    return true;
  if (rhs.connection_remote < lhs.connection_remote)
    return false;
  if (lhs.connection_receiver < rhs.connection_receiver)
    return true;
  if (rhs.connection_receiver < lhs.connection_receiver)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PresentationInfo::DataView,
                                         ::blink::mojom::blink::PresentationInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::PresentationInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PresentationInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PresentationInfo::url)& url(
      const ::blink::mojom::blink::PresentationInfoPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::PresentationInfo::id)& id(
      const ::blink::mojom::blink::PresentationInfoPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::blink::PresentationInfo::DataView input, ::blink::mojom::blink::PresentationInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PresentationError::DataView,
                                         ::blink::mojom::blink::PresentationErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::PresentationErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PresentationErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PresentationError::error_type) error_type(
      const ::blink::mojom::blink::PresentationErrorPtr& input) {
    return input->error_type;
  }

  static const decltype(::blink::mojom::blink::PresentationError::message)& message(
      const ::blink::mojom::blink::PresentationErrorPtr& input) {
    return input->message;
  }

  static bool Read(::blink::mojom::blink::PresentationError::DataView input, ::blink::mojom::blink::PresentationErrorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PresentationConnectionResult::DataView,
                                         ::blink::mojom::blink::PresentationConnectionResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::PresentationConnectionResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PresentationConnectionResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PresentationConnectionResult::presentation_info)& presentation_info(
      const ::blink::mojom::blink::PresentationConnectionResultPtr& input) {
    return input->presentation_info;
  }

  static  decltype(::blink::mojom::blink::PresentationConnectionResult::connection_remote)& connection_remote(
       ::blink::mojom::blink::PresentationConnectionResultPtr& input) {
    return input->connection_remote;
  }

  static  decltype(::blink::mojom::blink::PresentationConnectionResult::connection_receiver)& connection_receiver(
       ::blink::mojom::blink::PresentationConnectionResultPtr& input) {
    return input->connection_receiver;
  }

  static bool Read(::blink::mojom::blink::PresentationConnectionResult::DataView input, ::blink::mojom::blink::PresentationConnectionResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::PresentationConnectionMessage::DataView,
                                        ::blink::mojom::blink::PresentationConnectionMessagePtr> {
  static bool IsNull(const ::blink::mojom::blink::PresentationConnectionMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PresentationConnectionMessagePtr* output) { output->reset(); }

  static ::blink::mojom::blink::PresentationConnectionMessage::Tag GetTag(const ::blink::mojom::blink::PresentationConnectionMessagePtr& input) {
    return input->which();
  }

  static const ::blink::String& message(const ::blink::mojom::blink::PresentationConnectionMessagePtr& input) {
    return input->get_message();
  }

  static const ::blink::Vector<uint8_t>& data(const ::blink::mojom::blink::PresentationConnectionMessagePtr& input) {
    return input->get_data();
  }

  static bool Read(::blink::mojom::blink::PresentationConnectionMessage::DataView input, ::blink::mojom::blink::PresentationConnectionMessagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_H_