// third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-import-headers.h"
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-test-utils.h"


namespace blink::mojom {
AnchorElementPointerData::AnchorElementPointerData()
    : is_mouse_pointer(),
      mouse_velocity(),
      mouse_acceleration() {}

AnchorElementPointerData::AnchorElementPointerData(
    bool is_mouse_pointer_in,
    double mouse_velocity_in,
    double mouse_acceleration_in)
    : is_mouse_pointer(std::move(is_mouse_pointer_in)),
      mouse_velocity(std::move(mouse_velocity_in)),
      mouse_acceleration(std::move(mouse_acceleration_in)) {}

AnchorElementPointerData::~AnchorElementPointerData() = default;
size_t AnchorElementPointerData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_mouse_pointer);
  seed = mojo::internal::Hash(seed, this->mouse_velocity);
  seed = mojo::internal::Hash(seed, this->mouse_acceleration);
  return seed;
}

void AnchorElementPointerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mouse_pointer"), this->is_mouse_pointer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_velocity"), this->mouse_velocity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_acceleration"), this->mouse_acceleration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AnchorElementInteractionHost::IPCStableHashFunction AnchorElementInteractionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AnchorElementInteractionHost>(message.name())) {
    case messages::AnchorElementInteractionHost::kOnPointerDown: {
      return &AnchorElementInteractionHost::OnPointerDown_Sym::IPCStableHash;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverEager: {
      return &AnchorElementInteractionHost::OnPointerHoverEager_Sym::IPCStableHash;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverModerate: {
      return &AnchorElementInteractionHost::OnPointerHoverModerate_Sym::IPCStableHash;
    }
    case messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered: {
      return &AnchorElementInteractionHost::OnViewportHeuristicTriggered_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AnchorElementInteractionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AnchorElementInteractionHost>(message.name())) {
      case messages::AnchorElementInteractionHost::kOnPointerDown:
            return "Receive blink::mojom::AnchorElementInteractionHost::OnPointerDown";
      case messages::AnchorElementInteractionHost::kOnPointerHoverEager:
            return "Receive blink::mojom::AnchorElementInteractionHost::OnPointerHoverEager";
      case messages::AnchorElementInteractionHost::kOnPointerHoverModerate:
            return "Receive blink::mojom::AnchorElementInteractionHost::OnPointerHoverModerate";
      case messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered:
            return "Receive blink::mojom::AnchorElementInteractionHost::OnViewportHeuristicTriggered";
    }
  } else {
    switch (static_cast<messages::AnchorElementInteractionHost>(message.name())) {
      case messages::AnchorElementInteractionHost::kOnPointerDown:
            return "Receive reply blink::mojom::AnchorElementInteractionHost::OnPointerDown";
      case messages::AnchorElementInteractionHost::kOnPointerHoverEager:
            return "Receive reply blink::mojom::AnchorElementInteractionHost::OnPointerHoverEager";
      case messages::AnchorElementInteractionHost::kOnPointerHoverModerate:
            return "Receive reply blink::mojom::AnchorElementInteractionHost::OnPointerHoverModerate";
      case messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered:
            return "Receive reply blink::mojom::AnchorElementInteractionHost::OnViewportHeuristicTriggered";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AnchorElementInteractionHost::OnPointerDown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x951e6258;  // IPCStableHash for blink::mojom::AnchorElementInteractionHost::OnPointerDown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementInteractionHost::OnPointerHoverEager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x949c2c6d;  // IPCStableHash for blink::mojom::AnchorElementInteractionHost::OnPointerHoverEager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementInteractionHost::OnPointerHoverModerate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x760dbde3;  // IPCStableHash for blink::mojom::AnchorElementInteractionHost::OnPointerHoverModerate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementInteractionHost::OnViewportHeuristicTriggered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f28777c;  // IPCStableHash for blink::mojom::AnchorElementInteractionHost::OnViewportHeuristicTriggered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AnchorElementInteractionHostProxy::AnchorElementInteractionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnchorElementInteractionHostProxy::OnPointerDown(
    const ::GURL& in_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementInteractionHost::OnPointerDown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementInteractionHost::kOnPointerDown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementInteractionHost_OnPointerDown_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in AnchorElementInteractionHost.OnPointerDown request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementInteractionHost::Name_);
  message.set_method_name("OnPointerDown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementInteractionHostProxy::OnPointerHoverEager(
    const ::GURL& in_target, AnchorElementPointerDataPtr in_mouse_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementInteractionHost::OnPointerHoverEager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_data"), in_mouse_data,
                        "<value of type AnchorElementPointerDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementInteractionHost::kOnPointerHoverEager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementInteractionHost_OnPointerHoverEager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in AnchorElementInteractionHost.OnPointerHoverEager request");
  mojo::internal::MessageFragment<
      typename decltype(params->mouse_data)::BaseType> mouse_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerDataDataView>(
    in_mouse_data,
    mouse_data_fragment);

  params->mouse_data.Set(
      mouse_data_fragment.is_null() ? nullptr : mouse_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mouse_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mouse_data in AnchorElementInteractionHost.OnPointerHoverEager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementInteractionHost::Name_);
  message.set_method_name("OnPointerHoverEager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementInteractionHostProxy::OnPointerHoverModerate(
    const ::GURL& in_target, AnchorElementPointerDataPtr in_mouse_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementInteractionHost::OnPointerHoverModerate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_data"), in_mouse_data,
                        "<value of type AnchorElementPointerDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementInteractionHost::kOnPointerHoverModerate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementInteractionHost_OnPointerHoverModerate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in AnchorElementInteractionHost.OnPointerHoverModerate request");
  mojo::internal::MessageFragment<
      typename decltype(params->mouse_data)::BaseType> mouse_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerDataDataView>(
    in_mouse_data,
    mouse_data_fragment);

  params->mouse_data.Set(
      mouse_data_fragment.is_null() ? nullptr : mouse_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mouse_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mouse_data in AnchorElementInteractionHost.OnPointerHoverModerate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementInteractionHost::Name_);
  message.set_method_name("OnPointerHoverModerate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementInteractionHostProxy::OnViewportHeuristicTriggered(
    const ::GURL& in_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementInteractionHost::OnViewportHeuristicTriggered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_target,
    target_fragment);

  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target in AnchorElementInteractionHost.OnViewportHeuristicTriggered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementInteractionHost::Name_);
  message.set_method_name("OnViewportHeuristicTriggered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AnchorElementInteractionHostStubDispatch::Accept(
    AnchorElementInteractionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AnchorElementInteractionHost>(message->header()->name)) {
    case messages::AnchorElementInteractionHost::kOnPointerDown: {
      DCHECK(message->is_serialized());
      internal::AnchorElementInteractionHost_OnPointerDown_Params_Data* params =
          reinterpret_cast<internal::AnchorElementInteractionHost_OnPointerDown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementInteractionHost.0
      bool success = true;
      ::GURL p_target{};
      AnchorElementInteractionHost_OnPointerDown_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementInteractionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPointerDown(        
        std::move(p_target));
      return true;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverEager: {
      DCHECK(message->is_serialized());
      internal::AnchorElementInteractionHost_OnPointerHoverEager_Params_Data* params =
          reinterpret_cast<internal::AnchorElementInteractionHost_OnPointerHoverEager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementInteractionHost.1
      bool success = true;
      ::GURL p_target{};
      AnchorElementPointerDataPtr p_mouse_data{};
      AnchorElementInteractionHost_OnPointerHoverEager_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (success && !input_data_view.ReadMouseData(&p_mouse_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementInteractionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPointerHoverEager(        
        std::move(p_target), 
        std::move(p_mouse_data));
      return true;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverModerate: {
      DCHECK(message->is_serialized());
      internal::AnchorElementInteractionHost_OnPointerHoverModerate_Params_Data* params =
          reinterpret_cast<internal::AnchorElementInteractionHost_OnPointerHoverModerate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementInteractionHost.2
      bool success = true;
      ::GURL p_target{};
      AnchorElementPointerDataPtr p_mouse_data{};
      AnchorElementInteractionHost_OnPointerHoverModerate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (success && !input_data_view.ReadMouseData(&p_mouse_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementInteractionHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPointerHoverModerate(        
        std::move(p_target), 
        std::move(p_mouse_data));
      return true;
    }
    case messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered: {
      DCHECK(message->is_serialized());
      internal::AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params_Data* params =
          reinterpret_cast<internal::AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementInteractionHost.3
      bool success = true;
      ::GURL p_target{};
      AnchorElementInteractionHost_OnViewportHeuristicTriggered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementInteractionHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnViewportHeuristicTriggered(        
        std::move(p_target));
      return true;
    }
  }
  return false;
}

// static
bool AnchorElementInteractionHostStubDispatch::AcceptWithResponder(
    AnchorElementInteractionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AnchorElementInteractionHost>(message->header()->name)) {
    case messages::AnchorElementInteractionHost::kOnPointerDown: {
      break;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverEager: {
      break;
    }
    case messages::AnchorElementInteractionHost::kOnPointerHoverModerate: {
      break;
    }
    case messages::AnchorElementInteractionHost::kOnViewportHeuristicTriggered: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnchorElementInteractionHostValidationInfo[] = {
    { &internal::AnchorElementInteractionHost_OnPointerDown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementInteractionHost_OnPointerHoverEager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementInteractionHost_OnPointerHoverModerate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementInteractionHost_OnViewportHeuristicTriggered_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnchorElementInteractionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AnchorElementInteractionHost::Name_,
    kAnchorElementInteractionHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::AnchorElementPointerData::DataView, ::blink::mojom::AnchorElementPointerDataPtr>::Read(
    ::blink::mojom::AnchorElementPointerData::DataView input,
    ::blink::mojom::AnchorElementPointerDataPtr* output) {
  bool success = true;
  ::blink::mojom::AnchorElementPointerDataPtr result(::blink::mojom::AnchorElementPointerData::New());
  
      if (success)
        result->is_mouse_pointer = input.is_mouse_pointer();
      if (success)
        result->mouse_velocity = input.mouse_velocity();
      if (success)
        result->mouse_acceleration = input.mouse_acceleration();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AnchorElementInteractionHostInterceptorForTesting::OnPointerDown(const ::GURL& target) {
  GetForwardingInterface()->OnPointerDown(
    std::move(target)
    );
}
void AnchorElementInteractionHostInterceptorForTesting::OnPointerHoverEager(const ::GURL& target, AnchorElementPointerDataPtr mouse_data) {
  GetForwardingInterface()->OnPointerHoverEager(
    std::move(target)
    , 
    std::move(mouse_data)
    );
}
void AnchorElementInteractionHostInterceptorForTesting::OnPointerHoverModerate(const ::GURL& target, AnchorElementPointerDataPtr mouse_data) {
  GetForwardingInterface()->OnPointerHoverModerate(
    std::move(target)
    , 
    std::move(mouse_data)
    );
}
void AnchorElementInteractionHostInterceptorForTesting::OnViewportHeuristicTriggered(const ::GURL& target) {
  GetForwardingInterface()->OnViewportHeuristicTriggered(
    std::move(target)
    );
}
AnchorElementInteractionHostAsyncWaiter::AnchorElementInteractionHostAsyncWaiter(
    AnchorElementInteractionHost* proxy) : proxy_(proxy) {}

AnchorElementInteractionHostAsyncWaiter::~AnchorElementInteractionHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif