// third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  MediaPlayerRemote as media_mojom_MediaPlayerRemote,
  MediaPlayerPendingReceiver as media_mojom_MediaPlayerPendingReceiver
} from '../../../../../media/mojo/mojom/media_player.mojom.m.js';

import {
  MediaPosition as mediaSession_mojom_MediaPosition,
  MediaPositionSpec as mediaSession_mojom_MediaPositionSpec
} from '../../../../../services/media_session/public/mojom/media_session.mojom.m.js';

import {
  SurfaceId as viz_mojom_SurfaceId,
  SurfaceIdSpec as viz_mojom_SurfaceIdSpec
} from '../../../../../services/viz/public/mojom/compositing/surface_id.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PictureInPictureSessionObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PictureInPictureSessionObserver', scope);
  }
}

/** @interface */
export class PictureInPictureSessionObserverInterface {
  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onWindowSizeChanged(size) {}
  
  /**
   */

  onStopped() {}
}

/**
 * @implements { PictureInPictureSessionObserverInterface }
 */
export class PictureInPictureSessionObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PictureInPictureSessionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PictureInPictureSessionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PictureInPictureSessionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onWindowSizeChanged(
      size) {
    this.proxy.sendMessage(
        0,
        PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   */

  onStopped() {
    this.proxy.sendMessage(
        1,
        PictureInPictureSessionObserver_OnStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PictureInPictureSessionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PictureInPictureSessionObserverReceiver {
  /**
   * @param {!PictureInPictureSessionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PictureInPictureSessionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PictureInPictureSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsSpec.$,
        null,
        impl.onWindowSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PictureInPictureSessionObserver_OnStopped_ParamsSpec.$,
        null,
        impl.onStopped.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PictureInPictureSessionObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PictureInPictureSessionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PictureInPictureSessionObserverRemote}
   */
  static getRemote() {
    let remote = new PictureInPictureSessionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PictureInPictureSessionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PictureInPictureSessionObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PictureInPictureSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWindowSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsSpec.$,
        null,
        this.onWindowSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PictureInPictureSessionObserver_OnStopped_ParamsSpec.$,
        null,
        this.onStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PictureInPictureSessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PictureInPictureSession', scope);
  }
}

/** @interface */
export class PictureInPictureSessionInterface {
  
  /**
   * @param { !number } playerId
   * @param { !Object } playerRemote
   * @param { !viz_mojom_SurfaceId } surfaceId
   * @param { !gfx_mojom_Size } naturalSize
   * @param { !boolean } showPlayPauseButton
   */

  update(playerId, playerRemote, surfaceId, naturalSize, showPlayPauseButton) {}
  
  /**
   * @return {!Promise}
   */

  stop() {}
  
  /**
   * @param { !mediaSession_mojom_MediaPosition } mediaPosition
   */

  updateMediaPosition(mediaPosition) {}
}

/**
 * @implements { PictureInPictureSessionInterface }
 */
export class PictureInPictureSessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PictureInPictureSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PictureInPictureSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PictureInPictureSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } playerId
   * @param { !Object } playerRemote
   * @param { !viz_mojom_SurfaceId } surfaceId
   * @param { !gfx_mojom_Size } naturalSize
   * @param { !boolean } showPlayPauseButton
   */

  update(
      playerId,
      playerRemote,
      surfaceId,
      naturalSize,
      showPlayPauseButton) {
    this.proxy.sendMessage(
        0,
        PictureInPictureSession_Update_ParamsSpec.$,
        null,
        [
          playerId,
          playerRemote,
          surfaceId,
          naturalSize,
          showPlayPauseButton
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  stop() {
    return this.proxy.sendMessage(
        1,
        PictureInPictureSession_Stop_ParamsSpec.$,
        PictureInPictureSession_Stop_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaPosition } mediaPosition
   */

  updateMediaPosition(
      mediaPosition) {
    this.proxy.sendMessage(
        2,
        PictureInPictureSession_UpdateMediaPosition_ParamsSpec.$,
        null,
        [
          mediaPosition
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PictureInPictureSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PictureInPictureSessionReceiver {
  /**
   * @param {!PictureInPictureSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PictureInPictureSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PictureInPictureSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PictureInPictureSession_Update_ParamsSpec.$,
        null,
        impl.update.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PictureInPictureSession_Stop_ParamsSpec.$,
        PictureInPictureSession_Stop_ResponseParamsSpec.$,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PictureInPictureSession_UpdateMediaPosition_ParamsSpec.$,
        null,
        impl.updateMediaPosition.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PictureInPictureSession {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PictureInPictureSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PictureInPictureSessionRemote}
   */
  static getRemote() {
    let remote = new PictureInPictureSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PictureInPictureSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PictureInPictureSessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PictureInPictureSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.update =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PictureInPictureSession_Update_ParamsSpec.$,
        null,
        this.update.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PictureInPictureSession_Stop_ParamsSpec.$,
        PictureInPictureSession_Stop_ResponseParamsSpec.$,
        this.stop.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateMediaPosition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PictureInPictureSession_UpdateMediaPosition_ParamsSpec.$,
        null,
        this.updateMediaPosition.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PictureInPictureServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PictureInPictureService', scope);
  }
}

/** @interface */
export class PictureInPictureServiceInterface {
  
  /**
   * @param { !number } playerId
   * @param { !Object } playerRemote
   * @param { !viz_mojom_SurfaceId } surfaceId
   * @param { !gfx_mojom_Size } naturalSize
   * @param { !boolean } showPlayPauseButton
   * @param { !PictureInPictureSessionObserverRemote } observer
   * @param { !gfx_mojom_Rect } sourceBounds
   * @return {!Promise<{
        session: ?PictureInPictureSessionRemote,
        size: !gfx_mojom_Size,
   *  }>}
   */

  startSession(playerId, playerRemote, surfaceId, naturalSize, showPlayPauseButton, observer, sourceBounds) {}
}

/**
 * @implements { PictureInPictureServiceInterface }
 */
export class PictureInPictureServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PictureInPictureServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PictureInPictureServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PictureInPictureServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } playerId
   * @param { !Object } playerRemote
   * @param { !viz_mojom_SurfaceId } surfaceId
   * @param { !gfx_mojom_Size } naturalSize
   * @param { !boolean } showPlayPauseButton
   * @param { !PictureInPictureSessionObserverRemote } observer
   * @param { !gfx_mojom_Rect } sourceBounds
   * @return {!Promise<{
        session: ?PictureInPictureSessionRemote,
        size: !gfx_mojom_Size,
   *  }>}
   */

  startSession(
      playerId,
      playerRemote,
      surfaceId,
      naturalSize,
      showPlayPauseButton,
      observer,
      sourceBounds) {
    return this.proxy.sendMessage(
        0,
        PictureInPictureService_StartSession_ParamsSpec.$,
        PictureInPictureService_StartSession_ResponseParamsSpec.$,
        [
          playerId,
          playerRemote,
          surfaceId,
          naturalSize,
          showPlayPauseButton,
          observer,
          sourceBounds
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PictureInPictureService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PictureInPictureServiceReceiver {
  /**
   * @param {!PictureInPictureServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PictureInPictureServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PictureInPictureServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PictureInPictureService_StartSession_ParamsSpec.$,
        PictureInPictureService_StartSession_ResponseParamsSpec.$,
        impl.startSession.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PictureInPictureService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PictureInPictureService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PictureInPictureServiceRemote}
   */
  static getRemote() {
    let remote = new PictureInPictureServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PictureInPictureService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PictureInPictureServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PictureInPictureServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PictureInPictureServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PictureInPictureService_StartSession_ParamsSpec.$,
        PictureInPictureService_StartSession_ResponseParamsSpec.$,
        this.startSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSessionObserver_OnStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSession_Update_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSession_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSession_Stop_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureSession_UpdateMediaPosition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureService_StartSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PictureInPictureService_StartSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsSpec.$,
    'PictureInPictureSessionObserver_OnWindowSizeChanged_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PictureInPictureSessionObserver_OnWindowSizeChanged_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.size;
  }
}



mojo.internal.Struct(
    PictureInPictureSessionObserver_OnStopped_ParamsSpec.$,
    'PictureInPictureSessionObserver_OnStopped_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PictureInPictureSessionObserver_OnStopped_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PictureInPictureSession_Update_ParamsSpec.$,
    'PictureInPictureSession_Update_Params',
    [
      mojo.internal.StructField(
        'playerId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'playerRemote', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(media_mojom_MediaPlayerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'surfaceId', 16,
        0,
        viz_mojom_SurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'naturalSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'showPlayPauseButton', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PictureInPictureSession_Update_Params {
  constructor() {
    /** @type { !number } */
    this.playerId;
    /** @type { !Object } */
    this.playerRemote;
    /** @type { !viz_mojom_SurfaceId } */
    this.surfaceId;
    /** @type { !gfx_mojom_Size } */
    this.naturalSize;
    /** @type { !boolean } */
    this.showPlayPauseButton;
  }
}



mojo.internal.Struct(
    PictureInPictureSession_Stop_ParamsSpec.$,
    'PictureInPictureSession_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PictureInPictureSession_Stop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PictureInPictureSession_Stop_ResponseParamsSpec.$,
    'PictureInPictureSession_Stop_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PictureInPictureSession_Stop_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PictureInPictureSession_UpdateMediaPosition_ParamsSpec.$,
    'PictureInPictureSession_UpdateMediaPosition_Params',
    [
      mojo.internal.StructField(
        'mediaPosition', 0,
        0,
        mediaSession_mojom_MediaPositionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PictureInPictureSession_UpdateMediaPosition_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaPosition } */
    this.mediaPosition;
  }
}



mojo.internal.Struct(
    PictureInPictureService_StartSession_ParamsSpec.$,
    'PictureInPictureService_StartSession_Params',
    [
      mojo.internal.StructField(
        'playerId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'playerRemote', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(media_mojom_MediaPlayerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'surfaceId', 16,
        0,
        viz_mojom_SurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'naturalSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'showPlayPauseButton', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 32,
        0,
        mojo.internal.InterfaceProxy(PictureInPictureSessionObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceBounds', 40,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PictureInPictureService_StartSession_Params {
  constructor() {
    /** @type { !number } */
    this.playerId;
    /** @type { !Object } */
    this.playerRemote;
    /** @type { !viz_mojom_SurfaceId } */
    this.surfaceId;
    /** @type { !gfx_mojom_Size } */
    this.naturalSize;
    /** @type { !boolean } */
    this.showPlayPauseButton;
    /** @type { !PictureInPictureSessionObserverRemote } */
    this.observer;
    /** @type { !gfx_mojom_Rect } */
    this.sourceBounds;
  }
}



mojo.internal.Struct(
    PictureInPictureService_StartSession_ResponseParamsSpec.$,
    'PictureInPictureService_StartSession_ResponseParams',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceProxy(PictureInPictureSessionRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PictureInPictureService_StartSession_ResponseParams {
  constructor() {
    /** @type { (PictureInPictureSessionRemote|undefined) } */
    this.session;
    /** @type { !gfx_mojom_Size } */
    this.size;
  }
}

