// third_party/blink/public/mojom/permissions/permission.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/permissions/permission.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-params-data.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-import-headers.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-test-utils.h"


namespace blink::mojom {
MidiPermissionDescriptor::MidiPermissionDescriptor()
    : sysex() {}

MidiPermissionDescriptor::MidiPermissionDescriptor(
    bool sysex_in)
    : sysex(std::move(sysex_in)) {}

MidiPermissionDescriptor::~MidiPermissionDescriptor() = default;
size_t MidiPermissionDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->sysex);
  return seed;
}

void MidiPermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sysex"), this->sysex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MidiPermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClipboardPermissionDescriptor::ClipboardPermissionDescriptor()
    : has_user_gesture(),
      will_be_sanitized() {}

ClipboardPermissionDescriptor::ClipboardPermissionDescriptor(
    bool has_user_gesture_in,
    bool will_be_sanitized_in)
    : has_user_gesture(std::move(has_user_gesture_in)),
      will_be_sanitized(std::move(will_be_sanitized_in)) {}

ClipboardPermissionDescriptor::~ClipboardPermissionDescriptor() = default;
size_t ClipboardPermissionDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_user_gesture);
  seed = mojo::internal::Hash(seed, this->will_be_sanitized);
  return seed;
}

void ClipboardPermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_be_sanitized"), this->will_be_sanitized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClipboardPermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CameraDevicePermissionDescriptor::CameraDevicePermissionDescriptor()
    : panTiltZoom() {}

CameraDevicePermissionDescriptor::CameraDevicePermissionDescriptor(
    bool panTiltZoom_in)
    : panTiltZoom(std::move(panTiltZoom_in)) {}

CameraDevicePermissionDescriptor::~CameraDevicePermissionDescriptor() = default;
size_t CameraDevicePermissionDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->panTiltZoom);
  return seed;
}

void CameraDevicePermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panTiltZoom"), this->panTiltZoom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CameraDevicePermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TopLevelStorageAccessPermissionDescriptor::TopLevelStorageAccessPermissionDescriptor()
    : requestedOrigin() {}

TopLevelStorageAccessPermissionDescriptor::TopLevelStorageAccessPermissionDescriptor(
    const ::url::Origin& requestedOrigin_in)
    : requestedOrigin(std::move(requestedOrigin_in)) {}

TopLevelStorageAccessPermissionDescriptor::~TopLevelStorageAccessPermissionDescriptor() = default;

void TopLevelStorageAccessPermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requestedOrigin"), this->requestedOrigin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TopLevelStorageAccessPermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FullscreenPermissionDescriptor::FullscreenPermissionDescriptor()
    : allow_without_user_gesture() {}

FullscreenPermissionDescriptor::FullscreenPermissionDescriptor(
    bool allow_without_user_gesture_in)
    : allow_without_user_gesture(std::move(allow_without_user_gesture_in)) {}

FullscreenPermissionDescriptor::~FullscreenPermissionDescriptor() = default;
size_t FullscreenPermissionDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->allow_without_user_gesture);
  return seed;
}

void FullscreenPermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_without_user_gesture"), this->allow_without_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FullscreenPermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionDescriptor::PermissionDescriptor()
    : name(),
      extension() {}

PermissionDescriptor::PermissionDescriptor(
    PermissionName name_in,
    PermissionDescriptorExtensionPtr extension_in)
    : name(std::move(name_in)),
      extension(std::move(extension_in)) {}

PermissionDescriptor::~PermissionDescriptor() = default;

void PermissionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PermissionName>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension"), this->extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PermissionDescriptorExtensionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeolocationEmbeddedPermissionRequestDescriptor::GeolocationEmbeddedPermissionRequestDescriptor()
    : autolocate() {}

GeolocationEmbeddedPermissionRequestDescriptor::GeolocationEmbeddedPermissionRequestDescriptor(
    bool autolocate_in)
    : autolocate(std::move(autolocate_in)) {}

GeolocationEmbeddedPermissionRequestDescriptor::~GeolocationEmbeddedPermissionRequestDescriptor() = default;
size_t GeolocationEmbeddedPermissionRequestDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->autolocate);
  return seed;
}

void GeolocationEmbeddedPermissionRequestDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "autolocate"), this->autolocate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GeolocationEmbeddedPermissionRequestDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EmbeddedPermissionRequestDescriptor::EmbeddedPermissionRequestDescriptor()
    : element_position(),
      geolocation() {}

EmbeddedPermissionRequestDescriptor::EmbeddedPermissionRequestDescriptor(
    const ::gfx::Rect& element_position_in,
    GeolocationEmbeddedPermissionRequestDescriptorPtr geolocation_in)
    : element_position(std::move(element_position_in)),
      geolocation(std::move(geolocation_in)) {}

EmbeddedPermissionRequestDescriptor::~EmbeddedPermissionRequestDescriptor() = default;

void EmbeddedPermissionRequestDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_position"), this->element_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geolocation"), this->geolocation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GeolocationEmbeddedPermissionRequestDescriptorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EmbeddedPermissionRequestDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionDescriptorExtensionPtr
PermissionDescriptorExtension::NewMidi(
    MidiPermissionDescriptorPtr value) {
  return PermissionDescriptorExtensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMidi)>,
      std::move(value));
}

PermissionDescriptorExtensionPtr
PermissionDescriptorExtension::NewClipboard(
    ClipboardPermissionDescriptorPtr value) {
  return PermissionDescriptorExtensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kClipboard)>,
      std::move(value));
}

PermissionDescriptorExtensionPtr
PermissionDescriptorExtension::NewCameraDevice(
    CameraDevicePermissionDescriptorPtr value) {
  return PermissionDescriptorExtensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCameraDevice)>,
      std::move(value));
}

PermissionDescriptorExtensionPtr
PermissionDescriptorExtension::NewTopLevelStorageAccess(
    TopLevelStorageAccessPermissionDescriptorPtr value) {
  return PermissionDescriptorExtensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
      std::move(value));
}

PermissionDescriptorExtensionPtr
PermissionDescriptorExtension::NewFullscreen(
    FullscreenPermissionDescriptorPtr value) {
  return PermissionDescriptorExtensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFullscreen)>,
      std::move(value));
}

PermissionDescriptorExtension::PermissionDescriptorExtension(
    std::in_place_index_t<static_cast<size_t>(Tag::kMidi)>,
    MidiPermissionDescriptorPtr value)
    : tag_(Tag::kMidi),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMidi)>,
            std::move(value)) {}

PermissionDescriptorExtension::PermissionDescriptorExtension(
    std::in_place_index_t<static_cast<size_t>(Tag::kClipboard)>,
    ClipboardPermissionDescriptorPtr value)
    : tag_(Tag::kClipboard),
      data_(std::in_place_index<static_cast<size_t>(Tag::kClipboard)>,
            std::move(value)) {}

PermissionDescriptorExtension::PermissionDescriptorExtension(
    std::in_place_index_t<static_cast<size_t>(Tag::kCameraDevice)>,
    CameraDevicePermissionDescriptorPtr value)
    : tag_(Tag::kCameraDevice),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCameraDevice)>,
            std::move(value)) {}

PermissionDescriptorExtension::PermissionDescriptorExtension(
    std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
    TopLevelStorageAccessPermissionDescriptorPtr value)
    : tag_(Tag::kTopLevelStorageAccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
            std::move(value)) {}

PermissionDescriptorExtension::PermissionDescriptorExtension(
    std::in_place_index_t<static_cast<size_t>(Tag::kFullscreen)>,
    FullscreenPermissionDescriptorPtr value)
    : tag_(Tag::kFullscreen),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFullscreen)>,
            std::move(value)) {}
PermissionDescriptorExtension::~PermissionDescriptorExtension() {
  DestroyActive();
}

void PermissionDescriptorExtension::set_midi(MidiPermissionDescriptorPtr midi) {
  if (tag_ == Tag::kMidi) {
    data_.midi = std::move(midi);
  } else {
    DestroyActive();
    tag_ = Tag::kMidi;
    new (&data_.midi) MidiPermissionDescriptorPtr(
        std::move(midi));
  }
}

void PermissionDescriptorExtension::set_clipboard(ClipboardPermissionDescriptorPtr clipboard) {
  if (tag_ == Tag::kClipboard) {
    data_.clipboard = std::move(clipboard);
  } else {
    DestroyActive();
    tag_ = Tag::kClipboard;
    new (&data_.clipboard) ClipboardPermissionDescriptorPtr(
        std::move(clipboard));
  }
}

void PermissionDescriptorExtension::set_camera_device(CameraDevicePermissionDescriptorPtr camera_device) {
  if (tag_ == Tag::kCameraDevice) {
    data_.camera_device = std::move(camera_device);
  } else {
    DestroyActive();
    tag_ = Tag::kCameraDevice;
    new (&data_.camera_device) CameraDevicePermissionDescriptorPtr(
        std::move(camera_device));
  }
}

void PermissionDescriptorExtension::set_top_level_storage_access(TopLevelStorageAccessPermissionDescriptorPtr top_level_storage_access) {
  if (tag_ == Tag::kTopLevelStorageAccess) {
    data_.top_level_storage_access = std::move(top_level_storage_access);
  } else {
    DestroyActive();
    tag_ = Tag::kTopLevelStorageAccess;
    new (&data_.top_level_storage_access) TopLevelStorageAccessPermissionDescriptorPtr(
        std::move(top_level_storage_access));
  }
}

void PermissionDescriptorExtension::set_fullscreen(FullscreenPermissionDescriptorPtr fullscreen) {
  if (tag_ == Tag::kFullscreen) {
    data_.fullscreen = std::move(fullscreen);
  } else {
    DestroyActive();
    tag_ = Tag::kFullscreen;
    new (&data_.fullscreen) FullscreenPermissionDescriptorPtr(
        std::move(fullscreen));
  }
}


PermissionDescriptorExtension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMidi)>,
    MidiPermissionDescriptorPtr value)
    : midi(std::move(value)) {}

PermissionDescriptorExtension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kClipboard)>,
    ClipboardPermissionDescriptorPtr value)
    : clipboard(std::move(value)) {}

PermissionDescriptorExtension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCameraDevice)>,
    CameraDevicePermissionDescriptorPtr value)
    : camera_device(std::move(value)) {}

PermissionDescriptorExtension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
    TopLevelStorageAccessPermissionDescriptorPtr value)
    : top_level_storage_access(std::move(value)) {}

PermissionDescriptorExtension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFullscreen)>,
    FullscreenPermissionDescriptorPtr value)
    : fullscreen(std::move(value)) {}

void PermissionDescriptorExtension::DestroyActive() {
  switch (tag_) {

    case Tag::kMidi:
      std::destroy_at(&data_.midi);
      break;
    case Tag::kClipboard:
      std::destroy_at(&data_.clipboard);
      break;
    case Tag::kCameraDevice:
      std::destroy_at(&data_.camera_device);
      break;
    case Tag::kTopLevelStorageAccess:
      std::destroy_at(&data_.top_level_storage_access);
      break;
    case Tag::kFullscreen:
      std::destroy_at(&data_.fullscreen);
      break;
  }
}

bool PermissionDescriptorExtension::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PermissionObserver::IPCStableHashFunction PermissionObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PermissionObserver>(message.name())) {
    case messages::PermissionObserver::kOnPermissionStatusChange: {
      return &PermissionObserver::OnPermissionStatusChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PermissionObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PermissionObserver>(message.name())) {
      case messages::PermissionObserver::kOnPermissionStatusChange:
            return "Receive blink::mojom::PermissionObserver::OnPermissionStatusChange";
    }
  } else {
    switch (static_cast<messages::PermissionObserver>(message.name())) {
      case messages::PermissionObserver::kOnPermissionStatusChange:
            return "Receive reply blink::mojom::PermissionObserver::OnPermissionStatusChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PermissionObserver::OnPermissionStatusChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f494498;  // IPCStableHash for blink::mojom::PermissionObserver::OnPermissionStatusChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PermissionObserverProxy::PermissionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PermissionObserverProxy::OnPermissionStatusChange(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionObserver::OnPermissionStatusChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionObserver::kOnPermissionStatusChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionObserver_OnPermissionStatusChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionObserver::Name_);
  message.set_method_name("OnPermissionStatusChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PermissionObserverStubDispatch::Accept(
    PermissionObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PermissionObserver>(message->header()->name)) {
    case messages::PermissionObserver::kOnPermissionStatusChange: {
      DCHECK(message->is_serialized());
      internal::PermissionObserver_OnPermissionStatusChange_Params_Data* params =
          reinterpret_cast<internal::PermissionObserver_OnPermissionStatusChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionObserver.0
      bool success = true;
      ::blink::mojom::PermissionStatus p_status{};
      PermissionObserver_OnPermissionStatusChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPermissionStatusChange(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool PermissionObserverStubDispatch::AcceptWithResponder(
    PermissionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PermissionObserver>(message->header()->name)) {
    case messages::PermissionObserver::kOnPermissionStatusChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPermissionObserverValidationInfo[] = {
    { &internal::PermissionObserver_OnPermissionStatusChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool PermissionObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PermissionObserver::Name_,
    kPermissionObserverValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedPermissionControlClient::IPCStableHashFunction EmbeddedPermissionControlClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedPermissionControlClient>(message.name())) {
    case messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered: {
      return &EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedPermissionControlClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedPermissionControlClient>(message.name())) {
      case messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered:
            return "Receive blink::mojom::EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered";
    }
  } else {
    switch (static_cast<messages::EmbeddedPermissionControlClient>(message.name())) {
      case messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered:
            return "Receive reply blink::mojom::EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d97b2a6;  // IPCStableHash for blink::mojom::EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedPermissionControlClientProxy::EmbeddedPermissionControlClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedPermissionControlClientProxy::OnEmbeddedPermissionControlRegistered(
    bool in_allow, const std::optional<std::vector<::blink::mojom::PermissionStatus>>& in_statuses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedPermissionControlClient::OnEmbeddedPermissionControlRegistered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow"), in_allow,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statuses"), in_statuses,
                        "<value of type const std::optional<std::vector<::blink::mojom::PermissionStatus>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data> params(
          message);
  params.Allocate();

  params->allow = in_allow;
  mojo::internal::MessageFragment<
      typename decltype(params->statuses)::BaseType>
      statuses_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& statuses_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionStatus>>(
    in_statuses,
    statuses_fragment,
    &statuses_validate_params);

  params->statuses.Set(
      statuses_fragment.is_null() ? nullptr : statuses_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedPermissionControlClient::Name_);
  message.set_method_name("OnEmbeddedPermissionControlRegistered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedPermissionControlClientStubDispatch::Accept(
    EmbeddedPermissionControlClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedPermissionControlClient>(message->header()->name)) {
    case messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered: {
      DCHECK(message->is_serialized());
      internal::EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data* params =
          reinterpret_cast<internal::EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedPermissionControlClient.0
      bool success = true;
      bool p_allow{};
      std::optional<std::vector<::blink::mojom::PermissionStatus>> p_statuses{};
      EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allow = input_data_view.allow();
      if (success && !input_data_view.ReadStatuses(&p_statuses))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedPermissionControlClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEmbeddedPermissionControlRegistered(        
        std::move(p_allow), 
        std::move(p_statuses));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedPermissionControlClientStubDispatch::AcceptWithResponder(
    EmbeddedPermissionControlClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedPermissionControlClient>(message->header()->name)) {
    case messages::EmbeddedPermissionControlClient::kOnEmbeddedPermissionControlRegistered: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedPermissionControlClientValidationInfo[] = {
    { &internal::EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedPermissionControlClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EmbeddedPermissionControlClient::Name_,
    kEmbeddedPermissionControlClientValidationInfo);
}

// The declaration includes the definition on other builds.

PermissionService::IPCStableHashFunction PermissionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PermissionService>(message.name())) {
    case messages::PermissionService::kHasPermission: {
      return &PermissionService::HasPermission_Sym::IPCStableHash;
    }
    case messages::PermissionService::kRegisterPageEmbeddedPermissionControl: {
      return &PermissionService::RegisterPageEmbeddedPermissionControl_Sym::IPCStableHash;
    }
    case messages::PermissionService::kRequestPageEmbeddedPermission: {
      return &PermissionService::RequestPageEmbeddedPermission_Sym::IPCStableHash;
    }
    case messages::PermissionService::kRequestPermission: {
      return &PermissionService::RequestPermission_Sym::IPCStableHash;
    }
    case messages::PermissionService::kRequestPermissions: {
      return &PermissionService::RequestPermissions_Sym::IPCStableHash;
    }
    case messages::PermissionService::kRevokePermission: {
      return &PermissionService::RevokePermission_Sym::IPCStableHash;
    }
    case messages::PermissionService::kAddPermissionObserver: {
      return &PermissionService::AddPermissionObserver_Sym::IPCStableHash;
    }
    case messages::PermissionService::kAddCombinedPermissionObserver: {
      return &PermissionService::AddCombinedPermissionObserver_Sym::IPCStableHash;
    }
    case messages::PermissionService::kNotifyEventListener: {
      return &PermissionService::NotifyEventListener_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PermissionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PermissionService>(message.name())) {
      case messages::PermissionService::kHasPermission:
            return "Receive blink::mojom::PermissionService::HasPermission";
      case messages::PermissionService::kRegisterPageEmbeddedPermissionControl:
            return "Receive blink::mojom::PermissionService::RegisterPageEmbeddedPermissionControl";
      case messages::PermissionService::kRequestPageEmbeddedPermission:
            return "Receive blink::mojom::PermissionService::RequestPageEmbeddedPermission";
      case messages::PermissionService::kRequestPermission:
            return "Receive blink::mojom::PermissionService::RequestPermission";
      case messages::PermissionService::kRequestPermissions:
            return "Receive blink::mojom::PermissionService::RequestPermissions";
      case messages::PermissionService::kRevokePermission:
            return "Receive blink::mojom::PermissionService::RevokePermission";
      case messages::PermissionService::kAddPermissionObserver:
            return "Receive blink::mojom::PermissionService::AddPermissionObserver";
      case messages::PermissionService::kAddCombinedPermissionObserver:
            return "Receive blink::mojom::PermissionService::AddCombinedPermissionObserver";
      case messages::PermissionService::kNotifyEventListener:
            return "Receive blink::mojom::PermissionService::NotifyEventListener";
    }
  } else {
    switch (static_cast<messages::PermissionService>(message.name())) {
      case messages::PermissionService::kHasPermission:
            return "Receive reply blink::mojom::PermissionService::HasPermission";
      case messages::PermissionService::kRegisterPageEmbeddedPermissionControl:
            return "Receive reply blink::mojom::PermissionService::RegisterPageEmbeddedPermissionControl";
      case messages::PermissionService::kRequestPageEmbeddedPermission:
            return "Receive reply blink::mojom::PermissionService::RequestPageEmbeddedPermission";
      case messages::PermissionService::kRequestPermission:
            return "Receive reply blink::mojom::PermissionService::RequestPermission";
      case messages::PermissionService::kRequestPermissions:
            return "Receive reply blink::mojom::PermissionService::RequestPermissions";
      case messages::PermissionService::kRevokePermission:
            return "Receive reply blink::mojom::PermissionService::RevokePermission";
      case messages::PermissionService::kAddPermissionObserver:
            return "Receive reply blink::mojom::PermissionService::AddPermissionObserver";
      case messages::PermissionService::kAddCombinedPermissionObserver:
            return "Receive reply blink::mojom::PermissionService::AddCombinedPermissionObserver";
      case messages::PermissionService::kNotifyEventListener:
            return "Receive reply blink::mojom::PermissionService::NotifyEventListener";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PermissionService::HasPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5f5fc3b;  // IPCStableHash for blink::mojom::PermissionService::HasPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::RegisterPageEmbeddedPermissionControl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0dd8e277;  // IPCStableHash for blink::mojom::PermissionService::RegisterPageEmbeddedPermissionControl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::RequestPageEmbeddedPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1adf961b;  // IPCStableHash for blink::mojom::PermissionService::RequestPageEmbeddedPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::RequestPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79ed544e;  // IPCStableHash for blink::mojom::PermissionService::RequestPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::RequestPermissions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x880fba9e;  // IPCStableHash for blink::mojom::PermissionService::RequestPermissions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::RevokePermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6bd6191;  // IPCStableHash for blink::mojom::PermissionService::RevokePermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::AddPermissionObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe86631a;  // IPCStableHash for blink::mojom::PermissionService::AddPermissionObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::AddCombinedPermissionObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06d732a0;  // IPCStableHash for blink::mojom::PermissionService::AddCombinedPermissionObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PermissionService::NotifyEventListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93ca806c;  // IPCStableHash for blink::mojom::PermissionService::NotifyEventListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PermissionService_HasPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionService_HasPermission_ForwardToCallback(
      PermissionService::HasPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PermissionService_HasPermission_ForwardToCallback(const PermissionService_HasPermission_ForwardToCallback&) = delete;
  PermissionService_HasPermission_ForwardToCallback& operator=(const PermissionService_HasPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PermissionService::HasPermissionCallback callback_;
};

class PermissionService_RequestPageEmbeddedPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionService_RequestPageEmbeddedPermission_ForwardToCallback(
      PermissionService::RequestPageEmbeddedPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PermissionService_RequestPageEmbeddedPermission_ForwardToCallback(const PermissionService_RequestPageEmbeddedPermission_ForwardToCallback&) = delete;
  PermissionService_RequestPageEmbeddedPermission_ForwardToCallback& operator=(const PermissionService_RequestPageEmbeddedPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PermissionService::RequestPageEmbeddedPermissionCallback callback_;
};

class PermissionService_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionService_RequestPermission_ForwardToCallback(
      PermissionService::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PermissionService_RequestPermission_ForwardToCallback(const PermissionService_RequestPermission_ForwardToCallback&) = delete;
  PermissionService_RequestPermission_ForwardToCallback& operator=(const PermissionService_RequestPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PermissionService::RequestPermissionCallback callback_;
};

class PermissionService_RequestPermissions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionService_RequestPermissions_ForwardToCallback(
      PermissionService::RequestPermissionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PermissionService_RequestPermissions_ForwardToCallback(const PermissionService_RequestPermissions_ForwardToCallback&) = delete;
  PermissionService_RequestPermissions_ForwardToCallback& operator=(const PermissionService_RequestPermissions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PermissionService::RequestPermissionsCallback callback_;
};

class PermissionService_RevokePermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionService_RevokePermission_ForwardToCallback(
      PermissionService::RevokePermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PermissionService_RevokePermission_ForwardToCallback(const PermissionService_RevokePermission_ForwardToCallback&) = delete;
  PermissionService_RevokePermission_ForwardToCallback& operator=(const PermissionService_RevokePermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PermissionService::RevokePermissionCallback callback_;
};

PermissionServiceProxy::PermissionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PermissionServiceProxy::HasPermission(
    PermissionDescriptorPtr in_permission, HasPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::HasPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kHasPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_HasPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.HasPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("HasPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionService_HasPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PermissionServiceProxy::RegisterPageEmbeddedPermissionControl(
    std::vector<PermissionDescriptorPtr> in_permissions, EmbeddedPermissionRequestDescriptorPtr in_descriptor, ::mojo::PendingRemote<EmbeddedPermissionControlClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::RegisterPageEmbeddedPermissionControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions"), in_permissions,
                        "<value of type std::vector<PermissionDescriptorPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor"), in_descriptor,
                        "<value of type EmbeddedPermissionRequestDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<EmbeddedPermissionControlClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRegisterPageEmbeddedPermissionControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permissions)::BaseType>
      permissions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionDescriptorDataView>>(
    in_permissions,
    permissions_fragment,
    &permissions_validate_params);

  params->permissions.Set(
      permissions_fragment.is_null() ? nullptr : permissions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permissions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permissions in PermissionService.RegisterPageEmbeddedPermissionControl request");
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor)::BaseType> descriptor_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView>(
    in_descriptor,
    descriptor_fragment);

  params->descriptor.Set(
      descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor in PermissionService.RegisterPageEmbeddedPermissionControl request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::EmbeddedPermissionControlClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in PermissionService.RegisterPageEmbeddedPermissionControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RegisterPageEmbeddedPermissionControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionServiceProxy::RequestPageEmbeddedPermission(
    std::vector<PermissionDescriptorPtr> in_permissions, EmbeddedPermissionRequestDescriptorPtr in_descriptor, RequestPageEmbeddedPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::RequestPageEmbeddedPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions"), in_permissions,
                        "<value of type std::vector<PermissionDescriptorPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor"), in_descriptor,
                        "<value of type EmbeddedPermissionRequestDescriptorPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPageEmbeddedPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPageEmbeddedPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permissions)::BaseType>
      permissions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& permissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionDescriptorDataView>>(
    in_permissions,
    permissions_fragment,
    &permissions_validate_params);

  params->permissions.Set(
      permissions_fragment.is_null() ? nullptr : permissions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permissions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permissions in PermissionService.RequestPageEmbeddedPermission request");
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor)::BaseType> descriptor_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView>(
    in_descriptor,
    descriptor_fragment);

  params->descriptor.Set(
      descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor in PermissionService.RequestPageEmbeddedPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPageEmbeddedPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionService_RequestPageEmbeddedPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PermissionServiceProxy::RequestPermission(
    PermissionDescriptorPtr in_permission, bool in_user_gesture, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::RequestPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.RequestPermission request");

  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionService_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PermissionServiceProxy::RequestPermissions(
    std::vector<PermissionDescriptorPtr> in_permission, bool in_user_gesture, RequestPermissionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::RequestPermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type std::vector<PermissionDescriptorPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType>
      permission_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& permission_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionDescriptorDataView>>(
    in_permission,
    permission_fragment,
    &permission_validate_params);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.RequestPermissions request");

  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPermissions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionService_RequestPermissions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PermissionServiceProxy::RevokePermission(
    PermissionDescriptorPtr in_permission, RevokePermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::RevokePermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRevokePermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RevokePermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.RevokePermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RevokePermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionService_RevokePermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PermissionServiceProxy::AddPermissionObserver(
    PermissionDescriptorPtr in_permission, ::blink::mojom::PermissionStatus in_last_known_status, ::mojo::PendingRemote<PermissionObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::AddPermissionObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_known_status"), in_last_known_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PermissionObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kAddPermissionObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_AddPermissionObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.AddPermissionObserver request");

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_last_known_status,
    &params->last_known_status);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PermissionObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in PermissionService.AddPermissionObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("AddPermissionObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionServiceProxy::AddCombinedPermissionObserver(
    PermissionDescriptorPtr in_permission, ::blink::mojom::PermissionStatus in_last_known_status, ::mojo::PendingRemote<PermissionObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::AddCombinedPermissionObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_known_status"), in_last_known_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PermissionObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kAddCombinedPermissionObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_AddCombinedPermissionObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.AddCombinedPermissionObserver request");

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_last_known_status,
    &params->last_known_status);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PermissionObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in PermissionService.AddCombinedPermissionObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("AddCombinedPermissionObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PermissionServiceProxy::NotifyEventListener(
    PermissionDescriptorPtr in_permission, const std::string& in_event_type, bool in_is_added) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PermissionService::NotifyEventListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type PermissionDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_added"), in_is_added,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kNotifyEventListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_NotifyEventListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PermissionService.NotifyEventListener request");
  mojo::internal::MessageFragment<
      typename decltype(params->event_type)::BaseType> event_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_type,
    event_type_fragment);

  params->event_type.Set(
      event_type_fragment.is_null() ? nullptr : event_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_type in PermissionService.NotifyEventListener request");

  params->is_added = in_is_added;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("NotifyEventListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PermissionService_HasPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PermissionService::HasPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PermissionService_HasPermission_ProxyToResponder> proxy(
        new PermissionService_HasPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PermissionService_HasPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionService_HasPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PermissionService_HasPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PermissionService::HasPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool PermissionService_HasPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PermissionService_HasPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionService_HasPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PermissionService.0
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  PermissionService_HasPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void PermissionService_HasPermission_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PermissionService::HasPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kHasPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_HasPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("HasPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PermissionService_RequestPageEmbeddedPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PermissionService::RequestPageEmbeddedPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PermissionService_RequestPageEmbeddedPermission_ProxyToResponder> proxy(
        new PermissionService_RequestPageEmbeddedPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PermissionService_RequestPageEmbeddedPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionService_RequestPageEmbeddedPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PermissionService_RequestPageEmbeddedPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PermissionService::RequestPageEmbeddedPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      EmbeddedPermissionControlResult in_status);
};

bool PermissionService_RequestPageEmbeddedPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PermissionService.2
  bool success = true;
  EmbeddedPermissionControlResult p_status{};
  PermissionService_RequestPageEmbeddedPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void PermissionService_RequestPageEmbeddedPermission_ProxyToResponder::Run(
    EmbeddedPermissionControlResult in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PermissionService::RequestPageEmbeddedPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type EmbeddedPermissionControlResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPageEmbeddedPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::EmbeddedPermissionControlResult>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPageEmbeddedPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PermissionService_RequestPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PermissionService::RequestPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PermissionService_RequestPermission_ProxyToResponder> proxy(
        new PermissionService_RequestPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PermissionService_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionService_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PermissionService_RequestPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PermissionService::RequestPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool PermissionService_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PermissionService_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionService_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PermissionService.3
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  PermissionService_RequestPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void PermissionService_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PermissionService::RequestPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PermissionService_RequestPermissions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PermissionService::RequestPermissionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PermissionService_RequestPermissions_ProxyToResponder> proxy(
        new PermissionService_RequestPermissions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PermissionService_RequestPermissions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionService_RequestPermissions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PermissionService_RequestPermissions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PermissionService::RequestPermissionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::blink::mojom::PermissionStatus>& in_statuses);
};

bool PermissionService_RequestPermissions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PermissionService_RequestPermissions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionService_RequestPermissions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PermissionService.4
  bool success = true;
  std::vector<::blink::mojom::PermissionStatus> p_statuses{};
  PermissionService_RequestPermissions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatuses(&p_statuses))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_statuses));
  }
  return true;
}

void PermissionService_RequestPermissions_ProxyToResponder::Run(
    const std::vector<::blink::mojom::PermissionStatus>& in_statuses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PermissionService::RequestPermissions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statuses"), in_statuses,
                        "<value of type const std::vector<::blink::mojom::PermissionStatus>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRequestPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RequestPermissions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->statuses)::BaseType>
      statuses_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& statuses_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PermissionStatus>>(
    in_statuses,
    statuses_fragment,
    &statuses_validate_params);

  params->statuses.Set(
      statuses_fragment.is_null() ? nullptr : statuses_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->statuses.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null statuses in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RequestPermissions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PermissionService_RevokePermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PermissionService::RevokePermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PermissionService_RevokePermission_ProxyToResponder> proxy(
        new PermissionService_RevokePermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PermissionService_RevokePermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionService_RevokePermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PermissionService_RevokePermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PermissionService::RevokePermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);
};

bool PermissionService_RevokePermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PermissionService_RevokePermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionService_RevokePermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PermissionService.5
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  PermissionService_RevokePermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void PermissionService_RevokePermission_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PermissionService::RevokePermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PermissionService::kRevokePermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PermissionService_RevokePermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionService::Name_);
  message.set_method_name("RevokePermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PermissionServiceStubDispatch::Accept(
    PermissionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PermissionService>(message->header()->name)) {
    case messages::PermissionService::kHasPermission: {
      break;
    }
    case messages::PermissionService::kRegisterPageEmbeddedPermissionControl: {
      DCHECK(message->is_serialized());
      internal::PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data* params =
          reinterpret_cast<internal::PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionService.1
      bool success = true;
      std::vector<PermissionDescriptorPtr> p_permissions{};
      EmbeddedPermissionRequestDescriptorPtr p_descriptor{};
      ::mojo::PendingRemote<EmbeddedPermissionControlClient> p_client{};
      PermissionService_RegisterPageEmbeddedPermissionControl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermissions(&p_permissions))
        success = false;
      if (success && !input_data_view.ReadDescriptor(&p_descriptor))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterPageEmbeddedPermissionControl(        
        std::move(p_permissions), 
        std::move(p_descriptor), 
        std::move(p_client));
      return true;
    }
    case messages::PermissionService::kRequestPageEmbeddedPermission: {
      break;
    }
    case messages::PermissionService::kRequestPermission: {
      break;
    }
    case messages::PermissionService::kRequestPermissions: {
      break;
    }
    case messages::PermissionService::kRevokePermission: {
      break;
    }
    case messages::PermissionService::kAddPermissionObserver: {
      DCHECK(message->is_serialized());
      internal::PermissionService_AddPermissionObserver_Params_Data* params =
          reinterpret_cast<internal::PermissionService_AddPermissionObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionService.6
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      ::blink::mojom::PermissionStatus p_last_known_status{};
      ::mojo::PendingRemote<PermissionObserver> p_observer{};
      PermissionService_AddPermissionObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (success && !input_data_view.ReadLastKnownStatus(&p_last_known_status))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPermissionObserver(        
        std::move(p_permission), 
        std::move(p_last_known_status), 
        std::move(p_observer));
      return true;
    }
    case messages::PermissionService::kAddCombinedPermissionObserver: {
      DCHECK(message->is_serialized());
      internal::PermissionService_AddCombinedPermissionObserver_Params_Data* params =
          reinterpret_cast<internal::PermissionService_AddCombinedPermissionObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionService.7
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      ::blink::mojom::PermissionStatus p_last_known_status{};
      ::mojo::PendingRemote<PermissionObserver> p_observer{};
      PermissionService_AddCombinedPermissionObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (success && !input_data_view.ReadLastKnownStatus(&p_last_known_status))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCombinedPermissionObserver(        
        std::move(p_permission), 
        std::move(p_last_known_status), 
        std::move(p_observer));
      return true;
    }
    case messages::PermissionService::kNotifyEventListener: {
      DCHECK(message->is_serialized());
      internal::PermissionService_NotifyEventListener_Params_Data* params =
          reinterpret_cast<internal::PermissionService_NotifyEventListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PermissionService.8
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      std::string p_event_type{};
      bool p_is_added{};
      PermissionService_NotifyEventListener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (success)
        p_is_added = input_data_view.is_added();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyEventListener(        
        std::move(p_permission), 
        std::move(p_event_type), 
        std::move(p_is_added));
      return true;
    }
  }
  return false;
}

// static
bool PermissionServiceStubDispatch::AcceptWithResponder(
    PermissionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PermissionService>(message->header()->name)) {
    case messages::PermissionService::kHasPermission: {
      internal::PermissionService_HasPermission_Params_Data* params =
          reinterpret_cast<
              internal::PermissionService_HasPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PermissionService.0
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      PermissionService_HasPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 0, false);
        return false;
      }
      auto callback =
          PermissionService_HasPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasPermission(        
        std::move(p_permission), std::move(callback));
      return true;
    }
    case messages::PermissionService::kRegisterPageEmbeddedPermissionControl: {
      break;
    }
    case messages::PermissionService::kRequestPageEmbeddedPermission: {
      internal::PermissionService_RequestPageEmbeddedPermission_Params_Data* params =
          reinterpret_cast<
              internal::PermissionService_RequestPageEmbeddedPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PermissionService.2
      bool success = true;
      std::vector<PermissionDescriptorPtr> p_permissions{};
      EmbeddedPermissionRequestDescriptorPtr p_descriptor{};
      PermissionService_RequestPageEmbeddedPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermissions(&p_permissions))
        success = false;
      if (success && !input_data_view.ReadDescriptor(&p_descriptor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 2, false);
        return false;
      }
      auto callback =
          PermissionService_RequestPageEmbeddedPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPageEmbeddedPermission(        
        std::move(p_permissions), 
        std::move(p_descriptor), std::move(callback));
      return true;
    }
    case messages::PermissionService::kRequestPermission: {
      internal::PermissionService_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::PermissionService_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PermissionService.3
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      bool p_user_gesture{};
      PermissionService_RequestPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 3, false);
        return false;
      }
      auto callback =
          PermissionService_RequestPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(        
        std::move(p_permission), 
        std::move(p_user_gesture), std::move(callback));
      return true;
    }
    case messages::PermissionService::kRequestPermissions: {
      internal::PermissionService_RequestPermissions_Params_Data* params =
          reinterpret_cast<
              internal::PermissionService_RequestPermissions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PermissionService.4
      bool success = true;
      std::vector<PermissionDescriptorPtr> p_permission{};
      bool p_user_gesture{};
      PermissionService_RequestPermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 4, false);
        return false;
      }
      auto callback =
          PermissionService_RequestPermissions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermissions(        
        std::move(p_permission), 
        std::move(p_user_gesture), std::move(callback));
      return true;
    }
    case messages::PermissionService::kRevokePermission: {
      internal::PermissionService_RevokePermission_Params_Data* params =
          reinterpret_cast<
              internal::PermissionService_RevokePermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PermissionService.5
      bool success = true;
      PermissionDescriptorPtr p_permission{};
      PermissionService_RevokePermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionService::Name_, 5, false);
        return false;
      }
      auto callback =
          PermissionService_RevokePermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RevokePermission(        
        std::move(p_permission), std::move(callback));
      return true;
    }
    case messages::PermissionService::kAddPermissionObserver: {
      break;
    }
    case messages::PermissionService::kAddCombinedPermissionObserver: {
      break;
    }
    case messages::PermissionService::kNotifyEventListener: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPermissionServiceValidationInfo[] = {
    { &internal::PermissionService_HasPermission_Params_Data::Validate,
     &internal::PermissionService_HasPermission_ResponseParams_Data::Validate},
    { &internal::PermissionService_RegisterPageEmbeddedPermissionControl_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionService_RequestPageEmbeddedPermission_Params_Data::Validate,
     &internal::PermissionService_RequestPageEmbeddedPermission_ResponseParams_Data::Validate},
    { &internal::PermissionService_RequestPermission_Params_Data::Validate,
     &internal::PermissionService_RequestPermission_ResponseParams_Data::Validate},
    { &internal::PermissionService_RequestPermissions_Params_Data::Validate,
     &internal::PermissionService_RequestPermissions_ResponseParams_Data::Validate},
    { &internal::PermissionService_RevokePermission_Params_Data::Validate,
     &internal::PermissionService_RevokePermission_ResponseParams_Data::Validate},
    { &internal::PermissionService_AddPermissionObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionService_AddCombinedPermissionObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PermissionService_NotifyEventListener_Params_Data::Validate,
     nullptr /* no response */},
};

bool PermissionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PermissionService::Name_,
    kPermissionServiceValidationInfo);
}

bool PermissionServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::PermissionService::Name_,
    kPermissionServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::MidiPermissionDescriptor::DataView, ::blink::mojom::MidiPermissionDescriptorPtr>::Read(
    ::blink::mojom::MidiPermissionDescriptor::DataView input,
    ::blink::mojom::MidiPermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::MidiPermissionDescriptorPtr result(::blink::mojom::MidiPermissionDescriptor::New());
  
      if (success)
        result->sysex = input.sysex();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ClipboardPermissionDescriptor::DataView, ::blink::mojom::ClipboardPermissionDescriptorPtr>::Read(
    ::blink::mojom::ClipboardPermissionDescriptor::DataView input,
    ::blink::mojom::ClipboardPermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::ClipboardPermissionDescriptorPtr result(::blink::mojom::ClipboardPermissionDescriptor::New());
  
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->will_be_sanitized = input.will_be_sanitized();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CameraDevicePermissionDescriptor::DataView, ::blink::mojom::CameraDevicePermissionDescriptorPtr>::Read(
    ::blink::mojom::CameraDevicePermissionDescriptor::DataView input,
    ::blink::mojom::CameraDevicePermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::CameraDevicePermissionDescriptorPtr result(::blink::mojom::CameraDevicePermissionDescriptor::New());
  
      if (success)
        result->panTiltZoom = input.panTiltZoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptor::DataView, ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr>::Read(
    ::blink::mojom::TopLevelStorageAccessPermissionDescriptor::DataView input,
    ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr result(::blink::mojom::TopLevelStorageAccessPermissionDescriptor::New());
  
      if (success && !input.ReadRequestedOrigin(&result->requestedOrigin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FullscreenPermissionDescriptor::DataView, ::blink::mojom::FullscreenPermissionDescriptorPtr>::Read(
    ::blink::mojom::FullscreenPermissionDescriptor::DataView input,
    ::blink::mojom::FullscreenPermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::FullscreenPermissionDescriptorPtr result(::blink::mojom::FullscreenPermissionDescriptor::New());
  
      if (success)
        result->allow_without_user_gesture = input.allow_without_user_gesture();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PermissionDescriptor::DataView, ::blink::mojom::PermissionDescriptorPtr>::Read(
    ::blink::mojom::PermissionDescriptor::DataView input,
    ::blink::mojom::PermissionDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::PermissionDescriptorPtr result(::blink::mojom::PermissionDescriptor::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadExtension(&result->extension))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptor::DataView, ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorPtr>::Read(
    ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptor::DataView input,
    ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorPtr result(::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptor::New());
  
      if (success)
        result->autolocate = input.autolocate();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::EmbeddedPermissionRequestDescriptor::DataView, ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr>::Read(
    ::blink::mojom::EmbeddedPermissionRequestDescriptor::DataView input,
    ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr result(::blink::mojom::EmbeddedPermissionRequestDescriptor::New());
  
      if (success && !input.ReadElementPosition(&result->element_position))
        success = false;
      if (success && !input.ReadGeolocation(&result->geolocation))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::PermissionDescriptorExtension::DataView, ::blink::mojom::PermissionDescriptorExtensionPtr>::Read(
    ::blink::mojom::PermissionDescriptorExtension::DataView input,
    ::blink::mojom::PermissionDescriptorExtensionPtr* output) {
  using UnionType = ::blink::mojom::PermissionDescriptorExtension;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kMidi: {
      ::blink::mojom::MidiPermissionDescriptorPtr result_midi{};
      if (!input.ReadMidi(&result_midi))
        return false;

      *output = UnionType::NewMidi(
          std::move(result_midi));
      break;
    }
    case Tag::kClipboard: {
      ::blink::mojom::ClipboardPermissionDescriptorPtr result_clipboard{};
      if (!input.ReadClipboard(&result_clipboard))
        return false;

      *output = UnionType::NewClipboard(
          std::move(result_clipboard));
      break;
    }
    case Tag::kCameraDevice: {
      ::blink::mojom::CameraDevicePermissionDescriptorPtr result_camera_device{};
      if (!input.ReadCameraDevice(&result_camera_device))
        return false;

      *output = UnionType::NewCameraDevice(
          std::move(result_camera_device));
      break;
    }
    case Tag::kTopLevelStorageAccess: {
      ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr result_top_level_storage_access{};
      if (!input.ReadTopLevelStorageAccess(&result_top_level_storage_access))
        return false;

      *output = UnionType::NewTopLevelStorageAccess(
          std::move(result_top_level_storage_access));
      break;
    }
    case Tag::kFullscreen: {
      ::blink::mojom::FullscreenPermissionDescriptorPtr result_fullscreen{};
      if (!input.ReadFullscreen(&result_fullscreen))
        return false;

      *output = UnionType::NewFullscreen(
          std::move(result_fullscreen));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void PermissionObserverInterceptorForTesting::OnPermissionStatusChange(::blink::mojom::PermissionStatus status) {
  GetForwardingInterface()->OnPermissionStatusChange(
    std::move(status)
    );
}
PermissionObserverAsyncWaiter::PermissionObserverAsyncWaiter(
    PermissionObserver* proxy) : proxy_(proxy) {}

PermissionObserverAsyncWaiter::~PermissionObserverAsyncWaiter() = default;





void EmbeddedPermissionControlClientInterceptorForTesting::OnEmbeddedPermissionControlRegistered(bool allow, const std::optional<std::vector<::blink::mojom::PermissionStatus>>& statuses) {
  GetForwardingInterface()->OnEmbeddedPermissionControlRegistered(
    std::move(allow)
    , 
    std::move(statuses)
    );
}
EmbeddedPermissionControlClientAsyncWaiter::EmbeddedPermissionControlClientAsyncWaiter(
    EmbeddedPermissionControlClient* proxy) : proxy_(proxy) {}

EmbeddedPermissionControlClientAsyncWaiter::~EmbeddedPermissionControlClientAsyncWaiter() = default;





void PermissionServiceInterceptorForTesting::HasPermission(PermissionDescriptorPtr permission, HasPermissionCallback callback) {
  GetForwardingInterface()->HasPermission(
    std::move(permission)
    , std::move(callback));
}
void PermissionServiceInterceptorForTesting::RegisterPageEmbeddedPermissionControl(std::vector<PermissionDescriptorPtr> permissions, EmbeddedPermissionRequestDescriptorPtr descriptor, ::mojo::PendingRemote<EmbeddedPermissionControlClient> client) {
  GetForwardingInterface()->RegisterPageEmbeddedPermissionControl(
    std::move(permissions)
    , 
    std::move(descriptor)
    , 
    std::move(client)
    );
}
void PermissionServiceInterceptorForTesting::RequestPageEmbeddedPermission(std::vector<PermissionDescriptorPtr> permissions, EmbeddedPermissionRequestDescriptorPtr descriptor, RequestPageEmbeddedPermissionCallback callback) {
  GetForwardingInterface()->RequestPageEmbeddedPermission(
    std::move(permissions)
    , 
    std::move(descriptor)
    , std::move(callback));
}
void PermissionServiceInterceptorForTesting::RequestPermission(PermissionDescriptorPtr permission, bool user_gesture, RequestPermissionCallback callback) {
  GetForwardingInterface()->RequestPermission(
    std::move(permission)
    , 
    std::move(user_gesture)
    , std::move(callback));
}
void PermissionServiceInterceptorForTesting::RequestPermissions(std::vector<PermissionDescriptorPtr> permission, bool user_gesture, RequestPermissionsCallback callback) {
  GetForwardingInterface()->RequestPermissions(
    std::move(permission)
    , 
    std::move(user_gesture)
    , std::move(callback));
}
void PermissionServiceInterceptorForTesting::RevokePermission(PermissionDescriptorPtr permission, RevokePermissionCallback callback) {
  GetForwardingInterface()->RevokePermission(
    std::move(permission)
    , std::move(callback));
}
void PermissionServiceInterceptorForTesting::AddPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) {
  GetForwardingInterface()->AddPermissionObserver(
    std::move(permission)
    , 
    std::move(last_known_status)
    , 
    std::move(observer)
    );
}
void PermissionServiceInterceptorForTesting::AddCombinedPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) {
  GetForwardingInterface()->AddCombinedPermissionObserver(
    std::move(permission)
    , 
    std::move(last_known_status)
    , 
    std::move(observer)
    );
}
void PermissionServiceInterceptorForTesting::NotifyEventListener(PermissionDescriptorPtr permission, const std::string& event_type, bool is_added) {
  GetForwardingInterface()->NotifyEventListener(
    std::move(permission)
    , 
    std::move(event_type)
    , 
    std::move(is_added)
    );
}
PermissionServiceAsyncWaiter::PermissionServiceAsyncWaiter(
    PermissionService* proxy) : proxy_(proxy) {}

PermissionServiceAsyncWaiter::~PermissionServiceAsyncWaiter() = default;


void PermissionServiceAsyncWaiter::HasPermission(
    PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->HasPermission(
      std::move(permission),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus PermissionServiceAsyncWaiter::HasPermission(
    PermissionDescriptorPtr permission) {
  ::blink::mojom::PermissionStatus async_wait_result;
  HasPermission(std::move(permission),&async_wait_result);
  return async_wait_result;
}

void PermissionServiceAsyncWaiter::RequestPageEmbeddedPermission(
    std::vector<PermissionDescriptorPtr> permissions, EmbeddedPermissionRequestDescriptorPtr descriptor, EmbeddedPermissionControlResult* out_status) {
  base::RunLoop loop;
  proxy_->RequestPageEmbeddedPermission(
      std::move(permissions),
      std::move(descriptor),
      base::BindOnce(
          [](base::RunLoop* loop,
             EmbeddedPermissionControlResult* out_status
,
             EmbeddedPermissionControlResult status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

EmbeddedPermissionControlResult PermissionServiceAsyncWaiter::RequestPageEmbeddedPermission(
    std::vector<PermissionDescriptorPtr> permissions, EmbeddedPermissionRequestDescriptorPtr descriptor) {
  EmbeddedPermissionControlResult async_wait_result;
  RequestPageEmbeddedPermission(std::move(permissions),std::move(descriptor),&async_wait_result);
  return async_wait_result;
}

void PermissionServiceAsyncWaiter::RequestPermission(
    PermissionDescriptorPtr permission, bool user_gesture, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->RequestPermission(
      std::move(permission),
      std::move(user_gesture),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus PermissionServiceAsyncWaiter::RequestPermission(
    PermissionDescriptorPtr permission, bool user_gesture) {
  ::blink::mojom::PermissionStatus async_wait_result;
  RequestPermission(std::move(permission),std::move(user_gesture),&async_wait_result);
  return async_wait_result;
}

void PermissionServiceAsyncWaiter::RequestPermissions(
    std::vector<PermissionDescriptorPtr> permission, bool user_gesture, std::vector<::blink::mojom::PermissionStatus>* out_statuses) {
  base::RunLoop loop;
  proxy_->RequestPermissions(
      std::move(permission),
      std::move(user_gesture),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::blink::mojom::PermissionStatus>* out_statuses
,
             const std::vector<::blink::mojom::PermissionStatus>& statuses) {*out_statuses = std::move(statuses);
            loop->Quit();
          },
          &loop,
          out_statuses));
  loop.Run();
}

std::vector<::blink::mojom::PermissionStatus> PermissionServiceAsyncWaiter::RequestPermissions(
    std::vector<PermissionDescriptorPtr> permission, bool user_gesture) {
  std::vector<::blink::mojom::PermissionStatus> async_wait_result;
  RequestPermissions(std::move(permission),std::move(user_gesture),&async_wait_result);
  return async_wait_result;
}

void PermissionServiceAsyncWaiter::RevokePermission(
    PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->RevokePermission(
      std::move(permission),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::PermissionStatus PermissionServiceAsyncWaiter::RevokePermission(
    PermissionDescriptorPtr permission) {
  ::blink::mojom::PermissionStatus async_wait_result;
  RevokePermission(std::move(permission),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif