// third_party/blink/public/mojom/permissions/permission.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PermissionNameSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PermissionName = {
  
  GEOLOCATION: 0,
  NOTIFICATIONS: 1,
  MIDI: 2,
  PROTECTED_MEDIA_IDENTIFIER: 3,
  DURABLE_STORAGE: 4,
  AUDIO_CAPTURE: 5,
  VIDEO_CAPTURE: 6,
  BACKGROUND_SYNC: 7,
  SENSORS: 8,
  CLIPBOARD_READ: 9,
  CLIPBOARD_WRITE: 10,
  PAYMENT_HANDLER: 11,
  BACKGROUND_FETCH: 12,
  IDLE_DETECTION: 13,
  PERIODIC_BACKGROUND_SYNC: 14,
  SCREEN_WAKE_LOCK: 15,
  SYSTEM_WAKE_LOCK: 16,
  NFC: 17,
  STORAGE_ACCESS: 18,
  WINDOW_MANAGEMENT: 19,
  LOCAL_FONTS: 20,
  DISPLAY_CAPTURE: 21,
  TOP_LEVEL_STORAGE_ACCESS: 22,
  CAPTURED_SURFACE_CONTROL: 23,
  SPEAKER_SELECTION: 24,
  KEYBOARD_LOCK: 25,
  POINTER_LOCK: 26,
  FULLSCREEN: 27,
  WEB_APP_INSTALLATION: 28,
  LOCAL_NETWORK_ACCESS: 29,
  VR: 30,
  AR: 31,
  HAND_TRACKING: 32,
  WEB_PRINTING: 33,
  SMART_CARD: 34,
  MIN_VALUE: 0,
  MAX_VALUE: 34,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.EmbeddedPermissionControlResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.EmbeddedPermissionControlResult = {
  
  kDismissed: 0,
  kGranted: 1,
  kDenied: 2,
  kNotSupported: 3,
  kResolvedNoUserGesture: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PermissionObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PermissionObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PermissionObserverInterface }
 */
blink.mojom.PermissionObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PermissionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PermissionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PermissionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PermissionStatus } status
   */

  onPermissionStatusChange(
      status) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PermissionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PermissionObserverReceiver = class {
  /**
   * @param {!blink.mojom.PermissionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PermissionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PermissionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PermissionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        impl.onPermissionStatusChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PermissionObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PermissionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PermissionObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PermissionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PermissionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PermissionObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PermissionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PermissionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPermissionStatusChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
        null,
        this.onPermissionStatusChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.EmbeddedPermissionControlClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.EmbeddedPermissionControlClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.EmbeddedPermissionControlClientInterface }
 */
blink.mojom.EmbeddedPermissionControlClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.EmbeddedPermissionControlClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.EmbeddedPermissionControlClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.EmbeddedPermissionControlClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } allow
   * @param { ?Array<!blink.mojom.PermissionStatus> } statuses
   */

  onEmbeddedPermissionControlRegistered(
      allow,
      statuses) {
    this.proxy.sendMessage(
        0,
        blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        [
          allow,
          statuses
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EmbeddedPermissionControlClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.EmbeddedPermissionControlClientReceiver = class {
  /**
   * @param {!blink.mojom.EmbeddedPermissionControlClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.EmbeddedPermissionControlClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.EmbeddedPermissionControlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedPermissionControlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        impl.onEmbeddedPermissionControlRegistered.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.EmbeddedPermissionControlClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedPermissionControlClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.EmbeddedPermissionControlClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.EmbeddedPermissionControlClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EmbeddedPermissionControlClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.EmbeddedPermissionControlClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.EmbeddedPermissionControlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.EmbeddedPermissionControlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEmbeddedPermissionControlRegistered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
        null,
        this.onEmbeddedPermissionControlRegistered.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PermissionServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PermissionService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PermissionServiceInterface }
 */
blink.mojom.PermissionServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PermissionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PermissionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PermissionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  hasPermission(
      permission) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.PermissionService_HasPermission_ParamsSpec.$,
        blink.mojom.PermissionService_HasPermission_ResponseParamsSpec.$,
        [
          permission
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.PermissionDescriptor> } permissions
   * @param { !blink.mojom.EmbeddedPermissionRequestDescriptor } descriptor
   * @param { !blink.mojom.EmbeddedPermissionControlClientRemote } client
   */

  registerPageEmbeddedPermissionControl(
      permissions,
      descriptor,
      client) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        [
          permissions,
          descriptor,
          client
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.PermissionDescriptor> } permissions
   * @param { !blink.mojom.EmbeddedPermissionRequestDescriptor } descriptor
   * @return {!Promise<{
        status: !blink.mojom.EmbeddedPermissionControlResult,
   *  }>}
   */

  requestPageEmbeddedPermission(
      permissions,
      descriptor) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        [
          permissions,
          descriptor
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  requestPermission(
      permission,
      userGesture) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.PermissionService_RequestPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermission_ResponseParamsSpec.$,
        [
          permission,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.PermissionDescriptor> } permission
   * @param { !boolean } userGesture
   * @return {!Promise<{
        statuses: !Array<!blink.mojom.PermissionStatus>,
   *  }>}
   */

  requestPermissions(
      permission,
      userGesture) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.PermissionService_RequestPermissions_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermissions_ResponseParamsSpec.$,
        [
          permission,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  revokePermission(
      permission) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.PermissionService_RevokePermission_ParamsSpec.$,
        blink.mojom.PermissionService_RevokePermission_ResponseParamsSpec.$,
        [
          permission
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @param { !blink.mojom.PermissionStatus } lastKnownStatus
   * @param { !blink.mojom.PermissionObserverRemote } observer
   */

  addPermissionObserver(
      permission,
      lastKnownStatus,
      observer) {
    this.proxy.sendMessage(
        6,
        blink.mojom.PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        [
          permission,
          lastKnownStatus,
          observer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @param { !blink.mojom.PermissionStatus } lastKnownStatus
   * @param { !blink.mojom.PermissionObserverRemote } observer
   */

  addCombinedPermissionObserver(
      permission,
      lastKnownStatus,
      observer) {
    this.proxy.sendMessage(
        7,
        blink.mojom.PermissionService_AddCombinedPermissionObserver_ParamsSpec.$,
        null,
        [
          permission,
          lastKnownStatus,
          observer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PermissionDescriptor } permission
   * @param { !string } eventType
   * @param { !boolean } isAdded
   */

  notifyEventListener(
      permission,
      eventType,
      isAdded) {
    this.proxy.sendMessage(
        8,
        blink.mojom.PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        [
          permission,
          eventType,
          isAdded
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PermissionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PermissionServiceReceiver = class {
  /**
   * @param {!blink.mojom.PermissionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PermissionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PermissionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PermissionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PermissionService_HasPermission_ParamsSpec.$,
        blink.mojom.PermissionService_HasPermission_ResponseParamsSpec.$,
        impl.hasPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        impl.registerPageEmbeddedPermissionControl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        impl.requestPageEmbeddedPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PermissionService_RequestPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PermissionService_RequestPermissions_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermissions_ResponseParamsSpec.$,
        impl.requestPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PermissionService_RevokePermission_ParamsSpec.$,
        blink.mojom.PermissionService_RevokePermission_ResponseParamsSpec.$,
        impl.revokePermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        impl.addPermissionObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PermissionService_AddCombinedPermissionObserver_ParamsSpec.$,
        null,
        impl.addCombinedPermissionObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        impl.notifyEventListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PermissionService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PermissionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PermissionServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PermissionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PermissionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PermissionServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PermissionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PermissionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PermissionService_HasPermission_ParamsSpec.$,
        blink.mojom.PermissionService_HasPermission_ResponseParamsSpec.$,
        this.hasPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerPageEmbeddedPermissionControl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
        null,
        this.registerPageEmbeddedPermissionControl.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPageEmbeddedPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
        this.requestPageEmbeddedPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PermissionService_RequestPermission_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PermissionService_RequestPermissions_ParamsSpec.$,
        blink.mojom.PermissionService_RequestPermissions_ResponseParamsSpec.$,
        this.requestPermissions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.revokePermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PermissionService_RevokePermission_ParamsSpec.$,
        blink.mojom.PermissionService_RevokePermission_ResponseParamsSpec.$,
        this.revokePermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPermissionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PermissionService_AddPermissionObserver_ParamsSpec.$,
        null,
        this.addPermissionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addCombinedPermissionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PermissionService_AddCombinedPermissionObserver_ParamsSpec.$,
        null,
        this.addCombinedPermissionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyEventListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PermissionService_NotifyEventListener_ParamsSpec.$,
        null,
        this.notifyEventListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MidiPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CameraDevicePermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TopLevelStorageAccessPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FullscreenPermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GeolocationEmbeddedPermissionRequestDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedPermissionRequestDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionObserver_OnPermissionStatusChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_HasPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_HasPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPageEmbeddedPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RequestPermissions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RevokePermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_RevokePermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_AddPermissionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_AddCombinedPermissionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PermissionService_NotifyEventListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PermissionDescriptorExtensionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.MidiPermissionDescriptorSpec.$,
    'MidiPermissionDescriptor',
    [
      mojo.internal.StructField(
        'sysex', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MidiPermissionDescriptor = class {
  constructor() {
    /** @export { !boolean } */
    this.sysex;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardPermissionDescriptorSpec.$,
    'ClipboardPermissionDescriptor',
    [
      mojo.internal.StructField(
        'hasUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'willBeSanitized', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ClipboardPermissionDescriptor = class {
  constructor() {
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !boolean } */
    this.willBeSanitized;
  }
};



mojo.internal.Struct(
    blink.mojom.CameraDevicePermissionDescriptorSpec.$,
    'CameraDevicePermissionDescriptor',
    [
      mojo.internal.StructField(
        'panTiltZoom', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CameraDevicePermissionDescriptor = class {
  constructor() {
    /** @export { !boolean } */
    this.panTiltZoom;
  }
};



mojo.internal.Struct(
    blink.mojom.TopLevelStorageAccessPermissionDescriptorSpec.$,
    'TopLevelStorageAccessPermissionDescriptor',
    [
      mojo.internal.StructField(
        'requestedOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TopLevelStorageAccessPermissionDescriptor = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.requestedOrigin;
  }
};



mojo.internal.Struct(
    blink.mojom.FullscreenPermissionDescriptorSpec.$,
    'FullscreenPermissionDescriptor',
    [
      mojo.internal.StructField(
        'allowWithoutUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FullscreenPermissionDescriptor = class {
  constructor() {
    /** @export { !boolean } */
    this.allowWithoutUserGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionDescriptorSpec.$,
    'PermissionDescriptor',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        blink.mojom.PermissionNameSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extension', 8,
        0,
        blink.mojom.PermissionDescriptorExtensionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PermissionDescriptor = class {
  constructor() {
    /** @export { !blink.mojom.PermissionName } */
    this.name;
    /** @export { (blink.mojom.PermissionDescriptorExtension|undefined) } */
    this.extension;
  }
};



mojo.internal.Struct(
    blink.mojom.GeolocationEmbeddedPermissionRequestDescriptorSpec.$,
    'GeolocationEmbeddedPermissionRequestDescriptor',
    [
      mojo.internal.StructField(
        'autolocate', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.GeolocationEmbeddedPermissionRequestDescriptor = class {
  constructor() {
    /** @export { !boolean } */
    this.autolocate;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedPermissionRequestDescriptorSpec.$,
    'EmbeddedPermissionRequestDescriptor',
    [
      mojo.internal.StructField(
        'elementPosition', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'geolocation', 8,
        0,
        blink.mojom.GeolocationEmbeddedPermissionRequestDescriptorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.EmbeddedPermissionRequestDescriptor = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.elementPosition;
    /** @export { (blink.mojom.GeolocationEmbeddedPermissionRequestDescriptor|undefined) } */
    this.geolocation;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionObserver_OnPermissionStatusChange_ParamsSpec.$,
    'PermissionObserver_OnPermissionStatusChange_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionObserver_OnPermissionStatusChange_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_ParamsSpec.$,
    'EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'statuses', 8,
        0,
        mojo.internal.Array(blink.mojom.PermissionStatusSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.allow;
    /** @export { (Array<!blink.mojom.PermissionStatus>|undefined) } */
    this.statuses;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_HasPermission_ParamsSpec.$,
    'PermissionService_HasPermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_HasPermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_HasPermission_ResponseParamsSpec.$,
    'PermissionService_HasPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_HasPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_ParamsSpec.$,
    'PermissionService_RegisterPageEmbeddedPermissionControl_Params',
    [
      mojo.internal.StructField(
        'permissions', 0,
        0,
        mojo.internal.Array(blink.mojom.PermissionDescriptorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'descriptor', 8,
        0,
        blink.mojom.EmbeddedPermissionRequestDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.EmbeddedPermissionControlClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PermissionService_RegisterPageEmbeddedPermissionControl_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PermissionDescriptor> } */
    this.permissions;
    /** @export { !blink.mojom.EmbeddedPermissionRequestDescriptor } */
    this.descriptor;
    /** @export { !blink.mojom.EmbeddedPermissionControlClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPageEmbeddedPermission_ParamsSpec.$,
    'PermissionService_RequestPageEmbeddedPermission_Params',
    [
      mojo.internal.StructField(
        'permissions', 0,
        0,
        mojo.internal.Array(blink.mojom.PermissionDescriptorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'descriptor', 8,
        0,
        blink.mojom.EmbeddedPermissionRequestDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PermissionService_RequestPageEmbeddedPermission_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PermissionDescriptor> } */
    this.permissions;
    /** @export { !blink.mojom.EmbeddedPermissionRequestDescriptor } */
    this.descriptor;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParamsSpec.$,
    'PermissionService_RequestPageEmbeddedPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.EmbeddedPermissionControlResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_RequestPageEmbeddedPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.EmbeddedPermissionControlResult } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPermission_ParamsSpec.$,
    'PermissionService_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PermissionService_RequestPermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPermission_ResponseParamsSpec.$,
    'PermissionService_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_RequestPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPermissions_ParamsSpec.$,
    'PermissionService_RequestPermissions_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        mojo.internal.Array(blink.mojom.PermissionDescriptorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PermissionService_RequestPermissions_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PermissionDescriptor> } */
    this.permission;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RequestPermissions_ResponseParamsSpec.$,
    'PermissionService_RequestPermissions_ResponseParams',
    [
      mojo.internal.StructField(
        'statuses', 0,
        0,
        mojo.internal.Array(blink.mojom.PermissionStatusSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_RequestPermissions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.PermissionStatus> } */
    this.statuses;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RevokePermission_ParamsSpec.$,
    'PermissionService_RevokePermission_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_RevokePermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_RevokePermission_ResponseParamsSpec.$,
    'PermissionService_RevokePermission_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PermissionService_RevokePermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_AddPermissionObserver_ParamsSpec.$,
    'PermissionService_AddPermissionObserver_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastKnownStatus', 8,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PermissionObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PermissionService_AddPermissionObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
    /** @export { !blink.mojom.PermissionStatus } */
    this.lastKnownStatus;
    /** @export { !blink.mojom.PermissionObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_AddCombinedPermissionObserver_ParamsSpec.$,
    'PermissionService_AddCombinedPermissionObserver_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastKnownStatus', 8,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PermissionObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PermissionService_AddCombinedPermissionObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
    /** @export { !blink.mojom.PermissionStatus } */
    this.lastKnownStatus;
    /** @export { !blink.mojom.PermissionObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.PermissionService_NotifyEventListener_ParamsSpec.$,
    'PermissionService_NotifyEventListener_Params',
    [
      mojo.internal.StructField(
        'permission', 0,
        0,
        blink.mojom.PermissionDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdded', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PermissionService_NotifyEventListener_Params = class {
  constructor() {
    /** @export { !blink.mojom.PermissionDescriptor } */
    this.permission;
    /** @export { !string } */
    this.eventType;
    /** @export { !boolean } */
    this.isAdded;
  }
};



mojo.internal.Union(
    blink.mojom.PermissionDescriptorExtensionSpec.$, 'PermissionDescriptorExtension',
    {
      'midi': {
        'ordinal': 0,
        'type': blink.mojom.MidiPermissionDescriptorSpec.$,
      },
      'clipboard': {
        'ordinal': 1,
        'type': blink.mojom.ClipboardPermissionDescriptorSpec.$,
      },
      'cameraDevice': {
        'ordinal': 2,
        'type': blink.mojom.CameraDevicePermissionDescriptorSpec.$,
      },
      'topLevelStorageAccess': {
        'ordinal': 3,
        'type': blink.mojom.TopLevelStorageAccessPermissionDescriptorSpec.$,
      },
      'fullscreen': {
        'ordinal': 4,
        'type': blink.mojom.FullscreenPermissionDescriptorSpec.$,
      },
    });

/**
 * @typedef { {
 *   midi: (!blink.mojom.MidiPermissionDescriptor|undefined),
 *   clipboard: (!blink.mojom.ClipboardPermissionDescriptor|undefined),
 *   cameraDevice: (!blink.mojom.CameraDevicePermissionDescriptor|undefined),
 *   topLevelStorageAccess: (!blink.mojom.TopLevelStorageAccessPermissionDescriptor|undefined),
 *   fullscreen: (!blink.mojom.FullscreenPermissionDescriptor|undefined),
 * } }
 */
blink.mojom.PermissionDescriptorExtension;
