// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }


  var SPEED_LIMIT_MAX = 100;
  var DeviceThermalState = {};
  DeviceThermalState.kUnknown = 0;
  DeviceThermalState.kNominal = 1;
  DeviceThermalState.kFair = 2;
  DeviceThermalState.kSerious = 3;
  DeviceThermalState.kCritical = 4;
  DeviceThermalState.MIN_VALUE = 0;
  DeviceThermalState.MAX_VALUE = 4;

  DeviceThermalState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  DeviceThermalState.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceThermalState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PeerConnectionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionInfo.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.rtcConfiguration = null;
    this.url = null;
  };
  PeerConnectionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionInfo.rtcConfiguration
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionInfo.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionInfo.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionInfo.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.rtcConfiguration =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.rtcConfiguration);
    encoder.encodeStruct(codec.String, val.url);
  };
  function PeerConnectionManager_OnSuspend_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_OnSuspend_Params.prototype.initDefaults_ = function() {
  };
  PeerConnectionManager_OnSuspend_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_OnSuspend_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionManager_OnSuspend_Params.encodedSize = codec.kStructHeaderSize + 0;

  PeerConnectionManager_OnSuspend_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_OnSuspend_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PeerConnectionManager_OnSuspend_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_OnSuspend_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PeerConnectionManager_OnThermalStateChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_OnThermalStateChange_Params.prototype.initDefaults_ = function() {
    this.thermalState = 0;
  };
  PeerConnectionManager_OnThermalStateChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_OnThermalStateChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionManager_OnThermalStateChange_Params.thermalState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeviceThermalState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionManager_OnThermalStateChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionManager_OnThermalStateChange_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_OnThermalStateChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.thermalState =
        decoder.decodeStruct(new codec.Enum(DeviceThermalState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeerConnectionManager_OnThermalStateChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_OnThermalStateChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.thermalState);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeerConnectionManager_StartEventLog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_StartEventLog_Params.prototype.initDefaults_ = function() {
    this.peerConnectionLocalId = 0;
    this.outputPeriodMs = 0;
  };
  PeerConnectionManager_StartEventLog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_StartEventLog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  PeerConnectionManager_StartEventLog_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionManager_StartEventLog_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_StartEventLog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.peerConnectionLocalId =
        decoder.decodeStruct(codec.Int32);
    val.outputPeriodMs =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  PeerConnectionManager_StartEventLog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_StartEventLog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.peerConnectionLocalId);
    encoder.encodeStruct(codec.Int32, val.outputPeriodMs);
  };
  function PeerConnectionManager_StopEventLog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_StopEventLog_Params.prototype.initDefaults_ = function() {
    this.peerConnectionLocalId = 0;
  };
  PeerConnectionManager_StopEventLog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_StopEventLog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeerConnectionManager_StopEventLog_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionManager_StopEventLog_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_StopEventLog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.peerConnectionLocalId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeerConnectionManager_StopEventLog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_StopEventLog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.peerConnectionLocalId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeerConnectionManager_StartDataChannelLog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_StartDataChannelLog_Params.prototype.initDefaults_ = function() {
    this.peerConnectionLocalId = 0;
  };
  PeerConnectionManager_StartDataChannelLog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_StartDataChannelLog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeerConnectionManager_StartDataChannelLog_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionManager_StartDataChannelLog_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_StartDataChannelLog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.peerConnectionLocalId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeerConnectionManager_StartDataChannelLog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_StartDataChannelLog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.peerConnectionLocalId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeerConnectionManager_StopDataChannelLog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_StopDataChannelLog_Params.prototype.initDefaults_ = function() {
    this.peerConnectionLocalId = 0;
  };
  PeerConnectionManager_StopDataChannelLog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_StopDataChannelLog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeerConnectionManager_StopDataChannelLog_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionManager_StopDataChannelLog_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_StopDataChannelLog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.peerConnectionLocalId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeerConnectionManager_StopDataChannelLog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_StopDataChannelLog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.peerConnectionLocalId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeerConnectionManager_GetStandardStats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_GetStandardStats_Params.prototype.initDefaults_ = function() {
  };
  PeerConnectionManager_GetStandardStats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_GetStandardStats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionManager_GetStandardStats_Params.encodedSize = codec.kStructHeaderSize + 0;

  PeerConnectionManager_GetStandardStats_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_GetStandardStats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PeerConnectionManager_GetStandardStats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_GetStandardStats_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PeerConnectionManager_GetCurrentState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionManager_GetCurrentState_Params.prototype.initDefaults_ = function() {
  };
  PeerConnectionManager_GetCurrentState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionManager_GetCurrentState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionManager_GetCurrentState_Params.encodedSize = codec.kStructHeaderSize + 0;

  PeerConnectionManager_GetCurrentState_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionManager_GetCurrentState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PeerConnectionManager_GetCurrentState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionManager_GetCurrentState_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PeerConnectionTrackerHost_AddPeerConnection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_AddPeerConnection_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  PeerConnectionTrackerHost_AddPeerConnection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_AddPeerConnection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_AddPeerConnection_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PeerConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_AddPeerConnection_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionTrackerHost_AddPeerConnection_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_AddPeerConnection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(PeerConnectionInfo);
    return val;
  };

  PeerConnectionTrackerHost_AddPeerConnection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_AddPeerConnection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PeerConnectionInfo, val.info);
  };
  function PeerConnectionTrackerHost_RemovePeerConnection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_RemovePeerConnection_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
  };
  PeerConnectionTrackerHost_RemovePeerConnection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_RemovePeerConnection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_RemovePeerConnection_Params.encodedSize = codec.kStructHeaderSize + 8;

  PeerConnectionTrackerHost_RemovePeerConnection_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_RemovePeerConnection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PeerConnectionTrackerHost_RemovePeerConnection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_RemovePeerConnection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PeerConnectionTrackerHost_UpdatePeerConnection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_UpdatePeerConnection_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.type = null;
    this.value = null;
  };
  PeerConnectionTrackerHost_UpdatePeerConnection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_UpdatePeerConnection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_UpdatePeerConnection_Params.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_UpdatePeerConnection_Params.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_UpdatePeerConnection_Params.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionTrackerHost_UpdatePeerConnection_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_UpdatePeerConnection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_UpdatePeerConnection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_UpdatePeerConnection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.value);
  };
  function PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.sessionId = null;
  };
  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.sessionId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sessionId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.sessionId);
  };
  function PeerConnectionTrackerHost_GetUserMedia_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetUserMedia_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.audio = false;
    this.video = false;
    this.audioConstraints = null;
    this.videoConstraints = null;
  };
  PeerConnectionTrackerHost_GetUserMedia_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetUserMedia_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate PeerConnectionTrackerHost_GetUserMedia_Params.audioConstraints
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetUserMedia_Params.videoConstraints
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetUserMedia_Params.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionTrackerHost_GetUserMedia_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetUserMedia_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.audio = (packed >> 0) & 1 ? true : false;
    val.video = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.audioConstraints =
        decoder.decodeStruct(codec.String);
    val.videoConstraints =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetUserMedia_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetUserMedia_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    packed = 0;
    packed |= (val.audio & 1) << 0
    packed |= (val.video & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.audioConstraints);
    encoder.encodeStruct(codec.String, val.videoConstraints);
  };
  function PeerConnectionTrackerHost_GetUserMediaSuccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.streamId = null;
    this.audioTrackInfo = null;
    this.videoTrackInfo = null;
  };
  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_GetUserMediaSuccess_Params.streamId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetUserMediaSuccess_Params.audioTrackInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetUserMediaSuccess_Params.videoTrackInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.encodedSize = codec.kStructHeaderSize + 32;

  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetUserMediaSuccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.streamId =
        decoder.decodeStruct(codec.String);
    val.audioTrackInfo =
        decoder.decodeStruct(codec.String);
    val.videoTrackInfo =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetUserMediaSuccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetUserMediaSuccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.streamId);
    encoder.encodeStruct(codec.String, val.audioTrackInfo);
    encoder.encodeStruct(codec.String, val.videoTrackInfo);
  };
  function PeerConnectionTrackerHost_GetUserMediaFailure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetUserMediaFailure_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.error = null;
    this.errorMessage = null;
  };
  PeerConnectionTrackerHost_GetUserMediaFailure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetUserMediaFailure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_GetUserMediaFailure_Params.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetUserMediaFailure_Params.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetUserMediaFailure_Params.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionTrackerHost_GetUserMediaFailure_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetUserMediaFailure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.error =
        decoder.decodeStruct(codec.String);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetUserMediaFailure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetUserMediaFailure_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.error);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function PeerConnectionTrackerHost_GetDisplayMedia_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetDisplayMedia_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.audio = false;
    this.video = false;
    this.audioConstraints = null;
    this.videoConstraints = null;
  };
  PeerConnectionTrackerHost_GetDisplayMedia_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetDisplayMedia_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate PeerConnectionTrackerHost_GetDisplayMedia_Params.audioConstraints
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetDisplayMedia_Params.videoConstraints
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetDisplayMedia_Params.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionTrackerHost_GetDisplayMedia_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetDisplayMedia_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.audio = (packed >> 0) & 1 ? true : false;
    val.video = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.audioConstraints =
        decoder.decodeStruct(codec.String);
    val.videoConstraints =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetDisplayMedia_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetDisplayMedia_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    packed = 0;
    packed |= (val.audio & 1) << 0
    packed |= (val.video & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.audioConstraints);
    encoder.encodeStruct(codec.String, val.videoConstraints);
  };
  function PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.streamId = null;
    this.audioTrackInfo = null;
    this.videoTrackInfo = null;
  };
  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.streamId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.audioTrackInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.videoTrackInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.encodedSize = codec.kStructHeaderSize + 32;

  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.streamId =
        decoder.decodeStruct(codec.String);
    val.audioTrackInfo =
        decoder.decodeStruct(codec.String);
    val.videoTrackInfo =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.streamId);
    encoder.encodeStruct(codec.String, val.audioTrackInfo);
    encoder.encodeStruct(codec.String, val.videoTrackInfo);
  };
  function PeerConnectionTrackerHost_GetDisplayMediaFailure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.error = null;
    this.errorMessage = null;
  };
  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.encodedSize = codec.kStructHeaderSize + 24;

  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_GetDisplayMediaFailure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.error =
        decoder.decodeStruct(codec.String);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.error);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function PeerConnectionTrackerHost_WebRtcEventLogWrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.output = null;
  };
  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.output
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_WebRtcEventLogWrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.output =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.output);
  };
  function PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.output = null;
  };
  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.output
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.output =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.output);
  };
  function PeerConnectionTrackerHost_AddStandardStats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PeerConnectionTrackerHost_AddStandardStats_Params.prototype.initDefaults_ = function() {
    this.lid = 0;
    this.value = null;
  };
  PeerConnectionTrackerHost_AddStandardStats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PeerConnectionTrackerHost_AddStandardStats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PeerConnectionTrackerHost_AddStandardStats_Params.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PeerConnectionTrackerHost_AddStandardStats_Params.encodedSize = codec.kStructHeaderSize + 16;

  PeerConnectionTrackerHost_AddStandardStats_Params.decode = function(decoder) {
    var packed;
    var val = new PeerConnectionTrackerHost_AddStandardStats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lid =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeStructPointer(values$.ListValue);
    return val;
  };

  PeerConnectionTrackerHost_AddStandardStats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PeerConnectionTrackerHost_AddStandardStats_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.lid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(values$.ListValue, val.value);
  };
  var kPeerConnectionManager_OnSuspend_Name = 0;
  var kPeerConnectionManager_OnThermalStateChange_Name = 1;
  var kPeerConnectionManager_StartEventLog_Name = 2;
  var kPeerConnectionManager_StopEventLog_Name = 3;
  var kPeerConnectionManager_StartDataChannelLog_Name = 4;
  var kPeerConnectionManager_StopDataChannelLog_Name = 5;
  var kPeerConnectionManager_GetStandardStats_Name = 6;
  var kPeerConnectionManager_GetCurrentState_Name = 7;

  function PeerConnectionManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PeerConnectionManager,
                                                   handleOrPtrInfo);
  }

  function PeerConnectionManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PeerConnectionManager, associatedInterfacePtrInfo);
  }

  PeerConnectionManagerAssociatedPtr.prototype =
      Object.create(PeerConnectionManagerPtr.prototype);
  PeerConnectionManagerAssociatedPtr.prototype.constructor =
      PeerConnectionManagerAssociatedPtr;

  function PeerConnectionManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  PeerConnectionManagerPtr.prototype.onSuspend = function() {
    return PeerConnectionManagerProxy.prototype.onSuspend
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.onSuspend = function() {
    var params_ = new PeerConnectionManager_OnSuspend_Params();
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_OnSuspend_Name,
        codec.align(PeerConnectionManager_OnSuspend_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_OnSuspend_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.onThermalStateChange = function() {
    return PeerConnectionManagerProxy.prototype.onThermalStateChange
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.onThermalStateChange = function(thermalState) {
    var params_ = new PeerConnectionManager_OnThermalStateChange_Params();
    params_.thermalState = thermalState;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_OnThermalStateChange_Name,
        codec.align(PeerConnectionManager_OnThermalStateChange_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_OnThermalStateChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.startEventLog = function() {
    return PeerConnectionManagerProxy.prototype.startEventLog
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.startEventLog = function(peerConnectionLocalId, outputPeriodMs) {
    var params_ = new PeerConnectionManager_StartEventLog_Params();
    params_.peerConnectionLocalId = peerConnectionLocalId;
    params_.outputPeriodMs = outputPeriodMs;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_StartEventLog_Name,
        codec.align(PeerConnectionManager_StartEventLog_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_StartEventLog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.stopEventLog = function() {
    return PeerConnectionManagerProxy.prototype.stopEventLog
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.stopEventLog = function(peerConnectionLocalId) {
    var params_ = new PeerConnectionManager_StopEventLog_Params();
    params_.peerConnectionLocalId = peerConnectionLocalId;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_StopEventLog_Name,
        codec.align(PeerConnectionManager_StopEventLog_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_StopEventLog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.startDataChannelLog = function() {
    return PeerConnectionManagerProxy.prototype.startDataChannelLog
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.startDataChannelLog = function(peerConnectionLocalId) {
    var params_ = new PeerConnectionManager_StartDataChannelLog_Params();
    params_.peerConnectionLocalId = peerConnectionLocalId;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_StartDataChannelLog_Name,
        codec.align(PeerConnectionManager_StartDataChannelLog_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_StartDataChannelLog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.stopDataChannelLog = function() {
    return PeerConnectionManagerProxy.prototype.stopDataChannelLog
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.stopDataChannelLog = function(peerConnectionLocalId) {
    var params_ = new PeerConnectionManager_StopDataChannelLog_Params();
    params_.peerConnectionLocalId = peerConnectionLocalId;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_StopDataChannelLog_Name,
        codec.align(PeerConnectionManager_StopDataChannelLog_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_StopDataChannelLog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.getStandardStats = function() {
    return PeerConnectionManagerProxy.prototype.getStandardStats
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.getStandardStats = function() {
    var params_ = new PeerConnectionManager_GetStandardStats_Params();
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_GetStandardStats_Name,
        codec.align(PeerConnectionManager_GetStandardStats_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_GetStandardStats_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionManagerPtr.prototype.getCurrentState = function() {
    return PeerConnectionManagerProxy.prototype.getCurrentState
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionManagerProxy.prototype.getCurrentState = function() {
    var params_ = new PeerConnectionManager_GetCurrentState_Params();
    var builder = new codec.MessageV0Builder(
        kPeerConnectionManager_GetCurrentState_Name,
        codec.align(PeerConnectionManager_GetCurrentState_Params.encodedSize));
    builder.encodeStruct(PeerConnectionManager_GetCurrentState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PeerConnectionManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  PeerConnectionManagerStub.prototype.onSuspend = function() {
    return this.delegate_ && this.delegate_.onSuspend && this.delegate_.onSuspend();
  }
  PeerConnectionManagerStub.prototype.onThermalStateChange = function(thermalState) {
    return this.delegate_ && this.delegate_.onThermalStateChange && this.delegate_.onThermalStateChange(thermalState);
  }
  PeerConnectionManagerStub.prototype.startEventLog = function(peerConnectionLocalId, outputPeriodMs) {
    return this.delegate_ && this.delegate_.startEventLog && this.delegate_.startEventLog(peerConnectionLocalId, outputPeriodMs);
  }
  PeerConnectionManagerStub.prototype.stopEventLog = function(peerConnectionLocalId) {
    return this.delegate_ && this.delegate_.stopEventLog && this.delegate_.stopEventLog(peerConnectionLocalId);
  }
  PeerConnectionManagerStub.prototype.startDataChannelLog = function(peerConnectionLocalId) {
    return this.delegate_ && this.delegate_.startDataChannelLog && this.delegate_.startDataChannelLog(peerConnectionLocalId);
  }
  PeerConnectionManagerStub.prototype.stopDataChannelLog = function(peerConnectionLocalId) {
    return this.delegate_ && this.delegate_.stopDataChannelLog && this.delegate_.stopDataChannelLog(peerConnectionLocalId);
  }
  PeerConnectionManagerStub.prototype.getStandardStats = function() {
    return this.delegate_ && this.delegate_.getStandardStats && this.delegate_.getStandardStats();
  }
  PeerConnectionManagerStub.prototype.getCurrentState = function() {
    return this.delegate_ && this.delegate_.getCurrentState && this.delegate_.getCurrentState();
  }

  PeerConnectionManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPeerConnectionManager_OnSuspend_Name:
      var params = reader.decodeStruct(PeerConnectionManager_OnSuspend_Params);
      this.onSuspend();
      return true;
    case kPeerConnectionManager_OnThermalStateChange_Name:
      var params = reader.decodeStruct(PeerConnectionManager_OnThermalStateChange_Params);
      this.onThermalStateChange(params.thermalState);
      return true;
    case kPeerConnectionManager_StartEventLog_Name:
      var params = reader.decodeStruct(PeerConnectionManager_StartEventLog_Params);
      this.startEventLog(params.peerConnectionLocalId, params.outputPeriodMs);
      return true;
    case kPeerConnectionManager_StopEventLog_Name:
      var params = reader.decodeStruct(PeerConnectionManager_StopEventLog_Params);
      this.stopEventLog(params.peerConnectionLocalId);
      return true;
    case kPeerConnectionManager_StartDataChannelLog_Name:
      var params = reader.decodeStruct(PeerConnectionManager_StartDataChannelLog_Params);
      this.startDataChannelLog(params.peerConnectionLocalId);
      return true;
    case kPeerConnectionManager_StopDataChannelLog_Name:
      var params = reader.decodeStruct(PeerConnectionManager_StopDataChannelLog_Params);
      this.stopDataChannelLog(params.peerConnectionLocalId);
      return true;
    case kPeerConnectionManager_GetStandardStats_Name:
      var params = reader.decodeStruct(PeerConnectionManager_GetStandardStats_Params);
      this.getStandardStats();
      return true;
    case kPeerConnectionManager_GetCurrentState_Name:
      var params = reader.decodeStruct(PeerConnectionManager_GetCurrentState_Params);
      this.getCurrentState();
      return true;
    default:
      return false;
    }
  };

  PeerConnectionManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePeerConnectionManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPeerConnectionManager_OnSuspend_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_OnSuspend_Params;
      break;
      case kPeerConnectionManager_OnThermalStateChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_OnThermalStateChange_Params;
      break;
      case kPeerConnectionManager_StartEventLog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_StartEventLog_Params;
      break;
      case kPeerConnectionManager_StopEventLog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_StopEventLog_Params;
      break;
      case kPeerConnectionManager_StartDataChannelLog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_StartDataChannelLog_Params;
      break;
      case kPeerConnectionManager_StopDataChannelLog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_StopDataChannelLog_Params;
      break;
      case kPeerConnectionManager_GetStandardStats_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_GetStandardStats_Params;
      break;
      case kPeerConnectionManager_GetCurrentState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionManager_GetCurrentState_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePeerConnectionManagerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PeerConnectionManager = {
    name: 'blink.mojom.PeerConnectionManager',
    kVersion: 0,
    ptrClass: PeerConnectionManagerPtr,
    proxyClass: PeerConnectionManagerProxy,
    stubClass: PeerConnectionManagerStub,
    validateRequest: validatePeerConnectionManagerRequest,
    validateResponse: null,
  };
  PeerConnectionManagerStub.prototype.validator = validatePeerConnectionManagerRequest;
  PeerConnectionManagerProxy.prototype.validator = null;
  var kPeerConnectionTrackerHost_AddPeerConnection_Name = 0;
  var kPeerConnectionTrackerHost_RemovePeerConnection_Name = 1;
  var kPeerConnectionTrackerHost_UpdatePeerConnection_Name = 2;
  var kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name = 3;
  var kPeerConnectionTrackerHost_GetUserMedia_Name = 4;
  var kPeerConnectionTrackerHost_GetUserMediaSuccess_Name = 5;
  var kPeerConnectionTrackerHost_GetUserMediaFailure_Name = 6;
  var kPeerConnectionTrackerHost_GetDisplayMedia_Name = 7;
  var kPeerConnectionTrackerHost_GetDisplayMediaSuccess_Name = 8;
  var kPeerConnectionTrackerHost_GetDisplayMediaFailure_Name = 9;
  var kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name = 10;
  var kPeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Name = 11;
  var kPeerConnectionTrackerHost_AddStandardStats_Name = 12;

  function PeerConnectionTrackerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PeerConnectionTrackerHost,
                                                   handleOrPtrInfo);
  }

  function PeerConnectionTrackerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PeerConnectionTrackerHost, associatedInterfacePtrInfo);
  }

  PeerConnectionTrackerHostAssociatedPtr.prototype =
      Object.create(PeerConnectionTrackerHostPtr.prototype);
  PeerConnectionTrackerHostAssociatedPtr.prototype.constructor =
      PeerConnectionTrackerHostAssociatedPtr;

  function PeerConnectionTrackerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  PeerConnectionTrackerHostPtr.prototype.addPeerConnection = function() {
    return PeerConnectionTrackerHostProxy.prototype.addPeerConnection
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.addPeerConnection = function(info) {
    var params_ = new PeerConnectionTrackerHost_AddPeerConnection_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_AddPeerConnection_Name,
        codec.align(PeerConnectionTrackerHost_AddPeerConnection_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_AddPeerConnection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.removePeerConnection = function() {
    return PeerConnectionTrackerHostProxy.prototype.removePeerConnection
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.removePeerConnection = function(lid) {
    var params_ = new PeerConnectionTrackerHost_RemovePeerConnection_Params();
    params_.lid = lid;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_RemovePeerConnection_Name,
        codec.align(PeerConnectionTrackerHost_RemovePeerConnection_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_RemovePeerConnection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.updatePeerConnection = function() {
    return PeerConnectionTrackerHostProxy.prototype.updatePeerConnection
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.updatePeerConnection = function(lid, type, value) {
    var params_ = new PeerConnectionTrackerHost_UpdatePeerConnection_Params();
    params_.lid = lid;
    params_.type = type;
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_UpdatePeerConnection_Name,
        codec.align(PeerConnectionTrackerHost_UpdatePeerConnection_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_UpdatePeerConnection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.onPeerConnectionSessionIdSet = function() {
    return PeerConnectionTrackerHostProxy.prototype.onPeerConnectionSessionIdSet
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.onPeerConnectionSessionIdSet = function(lid, sessionId) {
    var params_ = new PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params();
    params_.lid = lid;
    params_.sessionId = sessionId;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name,
        codec.align(PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getUserMedia = function() {
    return PeerConnectionTrackerHostProxy.prototype.getUserMedia
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getUserMedia = function(requestId, audio, video, audioConstraints, videoConstraints) {
    var params_ = new PeerConnectionTrackerHost_GetUserMedia_Params();
    params_.requestId = requestId;
    params_.audio = audio;
    params_.video = video;
    params_.audioConstraints = audioConstraints;
    params_.videoConstraints = videoConstraints;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetUserMedia_Name,
        codec.align(PeerConnectionTrackerHost_GetUserMedia_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetUserMedia_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getUserMediaSuccess = function() {
    return PeerConnectionTrackerHostProxy.prototype.getUserMediaSuccess
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getUserMediaSuccess = function(requestId, streamId, audioTrackInfo, videoTrackInfo) {
    var params_ = new PeerConnectionTrackerHost_GetUserMediaSuccess_Params();
    params_.requestId = requestId;
    params_.streamId = streamId;
    params_.audioTrackInfo = audioTrackInfo;
    params_.videoTrackInfo = videoTrackInfo;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetUserMediaSuccess_Name,
        codec.align(PeerConnectionTrackerHost_GetUserMediaSuccess_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetUserMediaSuccess_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getUserMediaFailure = function() {
    return PeerConnectionTrackerHostProxy.prototype.getUserMediaFailure
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getUserMediaFailure = function(requestId, error, errorMessage) {
    var params_ = new PeerConnectionTrackerHost_GetUserMediaFailure_Params();
    params_.requestId = requestId;
    params_.error = error;
    params_.errorMessage = errorMessage;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetUserMediaFailure_Name,
        codec.align(PeerConnectionTrackerHost_GetUserMediaFailure_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetUserMediaFailure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getDisplayMedia = function() {
    return PeerConnectionTrackerHostProxy.prototype.getDisplayMedia
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getDisplayMedia = function(requestId, audio, video, audioConstraints, videoConstraints) {
    var params_ = new PeerConnectionTrackerHost_GetDisplayMedia_Params();
    params_.requestId = requestId;
    params_.audio = audio;
    params_.video = video;
    params_.audioConstraints = audioConstraints;
    params_.videoConstraints = videoConstraints;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetDisplayMedia_Name,
        codec.align(PeerConnectionTrackerHost_GetDisplayMedia_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetDisplayMedia_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getDisplayMediaSuccess = function() {
    return PeerConnectionTrackerHostProxy.prototype.getDisplayMediaSuccess
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getDisplayMediaSuccess = function(requestId, streamId, audioTrackInfo, videoTrackInfo) {
    var params_ = new PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params();
    params_.requestId = requestId;
    params_.streamId = streamId;
    params_.audioTrackInfo = audioTrackInfo;
    params_.videoTrackInfo = videoTrackInfo;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetDisplayMediaSuccess_Name,
        codec.align(PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.getDisplayMediaFailure = function() {
    return PeerConnectionTrackerHostProxy.prototype.getDisplayMediaFailure
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.getDisplayMediaFailure = function(requestId, error, errorMessage) {
    var params_ = new PeerConnectionTrackerHost_GetDisplayMediaFailure_Params();
    params_.requestId = requestId;
    params_.error = error;
    params_.errorMessage = errorMessage;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_GetDisplayMediaFailure_Name,
        codec.align(PeerConnectionTrackerHost_GetDisplayMediaFailure_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_GetDisplayMediaFailure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.webRtcEventLogWrite = function() {
    return PeerConnectionTrackerHostProxy.prototype.webRtcEventLogWrite
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.webRtcEventLogWrite = function(lid, output) {
    var params_ = new PeerConnectionTrackerHost_WebRtcEventLogWrite_Params();
    params_.lid = lid;
    params_.output = output;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name,
        codec.align(PeerConnectionTrackerHost_WebRtcEventLogWrite_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_WebRtcEventLogWrite_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.webRtcDataChannelLogWrite = function() {
    return PeerConnectionTrackerHostProxy.prototype.webRtcDataChannelLogWrite
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.webRtcDataChannelLogWrite = function(lid, output) {
    var params_ = new PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params();
    params_.lid = lid;
    params_.output = output;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Name,
        codec.align(PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PeerConnectionTrackerHostPtr.prototype.addStandardStats = function() {
    return PeerConnectionTrackerHostProxy.prototype.addStandardStats
        .apply(this.ptr.getProxy(), arguments);
  };

  PeerConnectionTrackerHostProxy.prototype.addStandardStats = function(lid, value) {
    var params_ = new PeerConnectionTrackerHost_AddStandardStats_Params();
    params_.lid = lid;
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kPeerConnectionTrackerHost_AddStandardStats_Name,
        codec.align(PeerConnectionTrackerHost_AddStandardStats_Params.encodedSize));
    builder.encodeStruct(PeerConnectionTrackerHost_AddStandardStats_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PeerConnectionTrackerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  PeerConnectionTrackerHostStub.prototype.addPeerConnection = function(info) {
    return this.delegate_ && this.delegate_.addPeerConnection && this.delegate_.addPeerConnection(info);
  }
  PeerConnectionTrackerHostStub.prototype.removePeerConnection = function(lid) {
    return this.delegate_ && this.delegate_.removePeerConnection && this.delegate_.removePeerConnection(lid);
  }
  PeerConnectionTrackerHostStub.prototype.updatePeerConnection = function(lid, type, value) {
    return this.delegate_ && this.delegate_.updatePeerConnection && this.delegate_.updatePeerConnection(lid, type, value);
  }
  PeerConnectionTrackerHostStub.prototype.onPeerConnectionSessionIdSet = function(lid, sessionId) {
    return this.delegate_ && this.delegate_.onPeerConnectionSessionIdSet && this.delegate_.onPeerConnectionSessionIdSet(lid, sessionId);
  }
  PeerConnectionTrackerHostStub.prototype.getUserMedia = function(requestId, audio, video, audioConstraints, videoConstraints) {
    return this.delegate_ && this.delegate_.getUserMedia && this.delegate_.getUserMedia(requestId, audio, video, audioConstraints, videoConstraints);
  }
  PeerConnectionTrackerHostStub.prototype.getUserMediaSuccess = function(requestId, streamId, audioTrackInfo, videoTrackInfo) {
    return this.delegate_ && this.delegate_.getUserMediaSuccess && this.delegate_.getUserMediaSuccess(requestId, streamId, audioTrackInfo, videoTrackInfo);
  }
  PeerConnectionTrackerHostStub.prototype.getUserMediaFailure = function(requestId, error, errorMessage) {
    return this.delegate_ && this.delegate_.getUserMediaFailure && this.delegate_.getUserMediaFailure(requestId, error, errorMessage);
  }
  PeerConnectionTrackerHostStub.prototype.getDisplayMedia = function(requestId, audio, video, audioConstraints, videoConstraints) {
    return this.delegate_ && this.delegate_.getDisplayMedia && this.delegate_.getDisplayMedia(requestId, audio, video, audioConstraints, videoConstraints);
  }
  PeerConnectionTrackerHostStub.prototype.getDisplayMediaSuccess = function(requestId, streamId, audioTrackInfo, videoTrackInfo) {
    return this.delegate_ && this.delegate_.getDisplayMediaSuccess && this.delegate_.getDisplayMediaSuccess(requestId, streamId, audioTrackInfo, videoTrackInfo);
  }
  PeerConnectionTrackerHostStub.prototype.getDisplayMediaFailure = function(requestId, error, errorMessage) {
    return this.delegate_ && this.delegate_.getDisplayMediaFailure && this.delegate_.getDisplayMediaFailure(requestId, error, errorMessage);
  }
  PeerConnectionTrackerHostStub.prototype.webRtcEventLogWrite = function(lid, output) {
    return this.delegate_ && this.delegate_.webRtcEventLogWrite && this.delegate_.webRtcEventLogWrite(lid, output);
  }
  PeerConnectionTrackerHostStub.prototype.webRtcDataChannelLogWrite = function(lid, output) {
    return this.delegate_ && this.delegate_.webRtcDataChannelLogWrite && this.delegate_.webRtcDataChannelLogWrite(lid, output);
  }
  PeerConnectionTrackerHostStub.prototype.addStandardStats = function(lid, value) {
    return this.delegate_ && this.delegate_.addStandardStats && this.delegate_.addStandardStats(lid, value);
  }

  PeerConnectionTrackerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPeerConnectionTrackerHost_AddPeerConnection_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_AddPeerConnection_Params);
      this.addPeerConnection(params.info);
      return true;
    case kPeerConnectionTrackerHost_RemovePeerConnection_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_RemovePeerConnection_Params);
      this.removePeerConnection(params.lid);
      return true;
    case kPeerConnectionTrackerHost_UpdatePeerConnection_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_UpdatePeerConnection_Params);
      this.updatePeerConnection(params.lid, params.type, params.value);
      return true;
    case kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params);
      this.onPeerConnectionSessionIdSet(params.lid, params.sessionId);
      return true;
    case kPeerConnectionTrackerHost_GetUserMedia_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetUserMedia_Params);
      this.getUserMedia(params.requestId, params.audio, params.video, params.audioConstraints, params.videoConstraints);
      return true;
    case kPeerConnectionTrackerHost_GetUserMediaSuccess_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetUserMediaSuccess_Params);
      this.getUserMediaSuccess(params.requestId, params.streamId, params.audioTrackInfo, params.videoTrackInfo);
      return true;
    case kPeerConnectionTrackerHost_GetUserMediaFailure_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetUserMediaFailure_Params);
      this.getUserMediaFailure(params.requestId, params.error, params.errorMessage);
      return true;
    case kPeerConnectionTrackerHost_GetDisplayMedia_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetDisplayMedia_Params);
      this.getDisplayMedia(params.requestId, params.audio, params.video, params.audioConstraints, params.videoConstraints);
      return true;
    case kPeerConnectionTrackerHost_GetDisplayMediaSuccess_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params);
      this.getDisplayMediaSuccess(params.requestId, params.streamId, params.audioTrackInfo, params.videoTrackInfo);
      return true;
    case kPeerConnectionTrackerHost_GetDisplayMediaFailure_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_GetDisplayMediaFailure_Params);
      this.getDisplayMediaFailure(params.requestId, params.error, params.errorMessage);
      return true;
    case kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_WebRtcEventLogWrite_Params);
      this.webRtcEventLogWrite(params.lid, params.output);
      return true;
    case kPeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params);
      this.webRtcDataChannelLogWrite(params.lid, params.output);
      return true;
    case kPeerConnectionTrackerHost_AddStandardStats_Name:
      var params = reader.decodeStruct(PeerConnectionTrackerHost_AddStandardStats_Params);
      this.addStandardStats(params.lid, params.value);
      return true;
    default:
      return false;
    }
  };

  PeerConnectionTrackerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePeerConnectionTrackerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPeerConnectionTrackerHost_AddPeerConnection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_AddPeerConnection_Params;
      break;
      case kPeerConnectionTrackerHost_RemovePeerConnection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_RemovePeerConnection_Params;
      break;
      case kPeerConnectionTrackerHost_UpdatePeerConnection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_UpdatePeerConnection_Params;
      break;
      case kPeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params;
      break;
      case kPeerConnectionTrackerHost_GetUserMedia_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetUserMedia_Params;
      break;
      case kPeerConnectionTrackerHost_GetUserMediaSuccess_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetUserMediaSuccess_Params;
      break;
      case kPeerConnectionTrackerHost_GetUserMediaFailure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetUserMediaFailure_Params;
      break;
      case kPeerConnectionTrackerHost_GetDisplayMedia_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetDisplayMedia_Params;
      break;
      case kPeerConnectionTrackerHost_GetDisplayMediaSuccess_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params;
      break;
      case kPeerConnectionTrackerHost_GetDisplayMediaFailure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_GetDisplayMediaFailure_Params;
      break;
      case kPeerConnectionTrackerHost_WebRtcEventLogWrite_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_WebRtcEventLogWrite_Params;
      break;
      case kPeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params;
      break;
      case kPeerConnectionTrackerHost_AddStandardStats_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PeerConnectionTrackerHost_AddStandardStats_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePeerConnectionTrackerHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PeerConnectionTrackerHost = {
    name: 'blink.mojom.PeerConnectionTrackerHost',
    kVersion: 0,
    ptrClass: PeerConnectionTrackerHostPtr,
    proxyClass: PeerConnectionTrackerHostProxy,
    stubClass: PeerConnectionTrackerHostStub,
    validateRequest: validatePeerConnectionTrackerHostRequest,
    validateResponse: null,
  };
  PeerConnectionTrackerHostStub.prototype.validator = validatePeerConnectionTrackerHostRequest;
  PeerConnectionTrackerHostProxy.prototype.validator = null;
  exports.SPEED_LIMIT_MAX = SPEED_LIMIT_MAX;
  exports.DeviceThermalState = DeviceThermalState;
  exports.PeerConnectionInfo = PeerConnectionInfo;
  exports.PeerConnectionManager = PeerConnectionManager;
  exports.PeerConnectionManagerPtr = PeerConnectionManagerPtr;
  exports.PeerConnectionManagerAssociatedPtr = PeerConnectionManagerAssociatedPtr;
  exports.PeerConnectionTrackerHost = PeerConnectionTrackerHost;
  exports.PeerConnectionTrackerHostPtr = PeerConnectionTrackerHostPtr;
  exports.PeerConnectionTrackerHostAssociatedPtr = PeerConnectionTrackerHostAssociatedPtr;
})();