// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AuthenticatorStatus as blink_mojom_AuthenticatorStatus,
  AuthenticatorStatusSpec as blink_mojom_AuthenticatorStatusSpec,
  MakeCredentialAuthenticatorResponse as blink_mojom_MakeCredentialAuthenticatorResponse,
  MakeCredentialAuthenticatorResponseSpec as blink_mojom_MakeCredentialAuthenticatorResponseSpec,
  PublicKeyCredentialCreationOptions as blink_mojom_PublicKeyCredentialCreationOptions,
  PublicKeyCredentialCreationOptionsSpec as blink_mojom_PublicKeyCredentialCreationOptionsSpec,
  WebAuthnDOMExceptionDetails as blink_mojom_WebAuthnDOMExceptionDetails,
  WebAuthnDOMExceptionDetailsSpec as blink_mojom_WebAuthnDOMExceptionDetailsSpec
} from '../webauthn/authenticator.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentCredentialStorageStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentCredentialStorageStatus = {
  
  SUCCESS: 0,
  FAILED_TO_STORE_CREDENTIAL: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SecurePaymentConfirmationAvailabilityEnumSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SecurePaymentConfirmationAvailabilityEnum = {
  
  kAvailable: 0,
  kUnavailableUnknownReason: 1,
  kUnavailableFeatureNotEnabled: 2,
  kUnavailableNoPermissionPolicy: 3,
  kUnavailableNoUserVerifyingPlatformAuthenticator: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SecurePaymentConfirmationServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.SecurePaymentConfirmationService', scope);
  }
}

/** @interface */
export class SecurePaymentConfirmationServiceInterface {
  
  /**
   * @return {!Promise<{
        availability: !SecurePaymentConfirmationAvailabilityEnum,
   *  }>}
   */

  securePaymentConfirmationAvailability() {}
  
  /**
   * @param { !Array<!number> } credentialId
   * @param { !string } rpId
   * @param { !Array<!number> } userId
   * @return {!Promise<{
        status: !PaymentCredentialStorageStatus,
   *  }>}
   */

  storePaymentCredential(credentialId, rpId, userId) {}
  
  /**
   * @param { !blink_mojom_PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !blink_mojom_AuthenticatorStatus,
        credential: ?blink_mojom_MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?blink_mojom_WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makePaymentCredential(options) {}
}

/**
 * @implements { SecurePaymentConfirmationServiceInterface }
 */
export class SecurePaymentConfirmationServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SecurePaymentConfirmationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SecurePaymentConfirmationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SecurePaymentConfirmationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        availability: !SecurePaymentConfirmationAvailabilityEnum,
   *  }>}
   */

  securePaymentConfirmationAvailability() {
    return this.proxy.sendMessage(
        0,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } credentialId
   * @param { !string } rpId
   * @param { !Array<!number> } userId
   * @return {!Promise<{
        status: !PaymentCredentialStorageStatus,
   *  }>}
   */

  storePaymentCredential(
      credentialId,
      rpId,
      userId) {
    return this.proxy.sendMessage(
        1,
        SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        [
          credentialId,
          rpId,
          userId
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !blink_mojom_AuthenticatorStatus,
        credential: ?blink_mojom_MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?blink_mojom_WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makePaymentCredential(
      options) {
    return this.proxy.sendMessage(
        2,
        SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SecurePaymentConfirmationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SecurePaymentConfirmationServiceReceiver {
  /**
   * @param {!SecurePaymentConfirmationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SecurePaymentConfirmationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SecurePaymentConfirmationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SecurePaymentConfirmationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        impl.securePaymentConfirmationAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        impl.storePaymentCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        impl.makePaymentCredential.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SecurePaymentConfirmationService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.SecurePaymentConfirmationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SecurePaymentConfirmationServiceRemote}
   */
  static getRemote() {
    let remote = new SecurePaymentConfirmationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SecurePaymentConfirmationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SecurePaymentConfirmationServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SecurePaymentConfirmationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SecurePaymentConfirmationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.securePaymentConfirmationAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        this.securePaymentConfirmationAvailability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storePaymentCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        this.storePaymentCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makePaymentCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        this.makePaymentCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
    'SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams',
    [
      mojo.internal.StructField(
        'availability', 0,
        0,
        SecurePaymentConfirmationAvailabilityEnumSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams {
  constructor() {
    /** @type { !SecurePaymentConfirmationAvailabilityEnum } */
    this.availability;
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
    'SecurePaymentConfirmationService_StorePaymentCredential_Params',
    [
      mojo.internal.StructField(
        'credentialId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rpId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userId', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_StorePaymentCredential_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.credentialId;
    /** @type { !string } */
    this.rpId;
    /** @type { !Array<!number> } */
    this.userId;
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentCredentialStorageStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams {
  constructor() {
    /** @type { !PaymentCredentialStorageStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
    'SecurePaymentConfirmationService_MakePaymentCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_PublicKeyCredentialCreationOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_MakePaymentCredential_Params {
  constructor() {
    /** @type { !blink_mojom_PublicKeyCredentialCreationOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_AuthenticatorStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        blink_mojom_MakeCredentialAuthenticatorResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        blink_mojom_WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_AuthenticatorStatus } */
    this.status;
    /** @type { (blink_mojom_MakeCredentialAuthenticatorResponse|undefined) } */
    this.credential;
    /** @type { (blink_mojom_WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
}

