// third_party/blink/public/mojom/payments/payment_request.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/payments/payment_request.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace payments::mojom {


class BLINK_COMMON_EXPORT PaymentRequestClientInterceptorForTesting : public PaymentRequestClient {
  virtual PaymentRequestClient* GetForwardingInterface() = 0;
  void OnPaymentMethodChange(const std::string& method_name, const std::string& stringified_details) override;
  void OnShippingAddressChange(::payments::mojom::PaymentAddressPtr address) override;
  void OnShippingOptionChange(const std::string& shipping_option_id) override;
  void OnPayerDetailChange(PayerDetailPtr detail) override;
  void OnPaymentResponse(PaymentResponsePtr response) override;
  void OnError(PaymentErrorReason error, const std::string& error_message) override;
  void OnComplete() override;
  void OnAbort(bool aborted_successfully) override;
  void OnCanMakePayment(CanMakePaymentQueryResult result) override;
  void OnHasEnrolledInstrument(HasEnrolledInstrumentQueryResult result) override;
  void WarnNoFavicon() override;
  void AllowConnectToSource(const ::GURL& url, const ::GURL& url_before_redirects, bool did_follow_redirect, AllowConnectToSourceCallback callback) override;
};
class BLINK_COMMON_EXPORT PaymentRequestClientAsyncWaiter {
 public:
  explicit PaymentRequestClientAsyncWaiter(PaymentRequestClient* proxy);

  PaymentRequestClientAsyncWaiter(const PaymentRequestClientAsyncWaiter&) = delete;
  PaymentRequestClientAsyncWaiter& operator=(const PaymentRequestClientAsyncWaiter&) = delete;

  ~PaymentRequestClientAsyncWaiter();
  void AllowConnectToSource(
      const ::GURL& url, const ::GURL& url_before_redirects, bool did_follow_redirect, bool* out_allow);
  bool AllowConnectToSource(const ::GURL& url, const ::GURL& url_before_redirects, bool did_follow_redirect);

 private:
  PaymentRequestClient* const proxy_;
};


class BLINK_COMMON_EXPORT PaymentRequestInterceptorForTesting : public PaymentRequest {
  virtual PaymentRequest* GetForwardingInterface() = 0;
  void Init(::mojo::PendingRemote<PaymentRequestClient> client, std::vector<PaymentMethodDataPtr> method_data, PaymentDetailsPtr details, PaymentOptionsPtr options) override;
  void Show(bool wait_for_updated_details, bool had_user_activation) override;
  void UpdateWith(PaymentDetailsPtr details) override;
  void OnPaymentDetailsNotUpdated() override;
  void Abort() override;
  void Complete(PaymentComplete result) override;
  void Retry(::payments::mojom::PaymentValidationErrorsPtr errors) override;
  void CanMakePayment() override;
  void HasEnrolledInstrument() override;
};
class BLINK_COMMON_EXPORT PaymentRequestAsyncWaiter {
 public:
  explicit PaymentRequestAsyncWaiter(PaymentRequest* proxy);

  PaymentRequestAsyncWaiter(const PaymentRequestAsyncWaiter&) = delete;
  PaymentRequestAsyncWaiter& operator=(const PaymentRequestAsyncWaiter&) = delete;

  ~PaymentRequestAsyncWaiter();

 private:
  PaymentRequest* const proxy_;
};




}  // payments::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_TEST_UTILS_H_