// third_party/blink/public/mojom/parakeet/ad_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {






class PLATFORM_EXPORT AdGeolocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdGeolocation, T>::value>;
  using DataView = AdGeolocationDataView;
  using Data_ = internal::AdGeolocation_Data;

  template <typename... Args>
  static AdGeolocationPtr New(Args&&... args) {
    return AdGeolocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdGeolocationPtr From(const U& u) {
    return mojo::TypeConverter<AdGeolocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdGeolocation>::Convert(*this);
  }


  AdGeolocation();

  AdGeolocation(
      double latitude,
      double longitude);


  ~AdGeolocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdGeolocationPtr>
  AdGeolocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdGeolocation::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdGeolocation::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdGeolocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdGeolocation_UnserializedMessageContext<
            UserType, AdGeolocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdGeolocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdGeolocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdGeolocation_UnserializedMessageContext<
            UserType, AdGeolocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdGeolocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double latitude;
  
  double longitude;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdGeolocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT AdProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdProperties, T>::value>;
  using DataView = AdPropertiesDataView;
  using Data_ = internal::AdProperties_Data;

  template <typename... Args>
  static AdPropertiesPtr New(Args&&... args) {
    return AdPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<AdPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdProperties>::Convert(*this);
  }


  AdProperties();

  AdProperties(
      const ::blink::String& width,
      const ::blink::String& height,
      const ::blink::String& slot,
      const ::blink::String& lang,
      const ::blink::String& ad_type,
      double bid_floor);


  ~AdProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdPropertiesPtr>
  AdPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdProperties_UnserializedMessageContext<
            UserType, AdProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdProperties_UnserializedMessageContext<
            UserType, AdProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String width;
  
  ::blink::String height;
  
  ::blink::String slot;
  
  ::blink::String lang;
  
  ::blink::String ad_type;
  
  double bid_floor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AdTargeting {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdTargeting, T>::value>;
  using DataView = AdTargetingDataView;
  using Data_ = internal::AdTargeting_Data;

  template <typename... Args>
  static AdTargetingPtr New(Args&&... args) {
    return AdTargetingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdTargetingPtr From(const U& u) {
    return mojo::TypeConverter<AdTargetingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdTargeting>::Convert(*this);
  }


  AdTargeting();

  AdTargeting(
      std::optional<::blink::Vector<::blink::String>> interests,
      AdGeolocationPtr geolocation);

AdTargeting(const AdTargeting&) = delete;
AdTargeting& operator=(const AdTargeting&) = delete;

  ~AdTargeting();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdTargetingPtr>
  AdTargetingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdTargeting::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdTargeting::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdTargeting::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdTargeting_UnserializedMessageContext<
            UserType, AdTargeting::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdTargeting::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdTargeting::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdTargeting_UnserializedMessageContext<
            UserType, AdTargeting::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdTargeting::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::Vector<::blink::String>> interests;
  
  AdGeolocationPtr geolocation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdTargeting::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AdRequestConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdRequestConfig, T>::value>;
  using DataView = AdRequestConfigDataView;
  using Data_ = internal::AdRequestConfig_Data;

  template <typename... Args>
  static AdRequestConfigPtr New(Args&&... args) {
    return AdRequestConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdRequestConfigPtr From(const U& u) {
    return mojo::TypeConverter<AdRequestConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdRequestConfig>::Convert(*this);
  }


  AdRequestConfig();

  AdRequestConfig(
      const ::blink::KURL& ad_request_url,
      ::blink::Vector<AdPropertiesPtr> ad_properties,
      const ::blink::String& publisher_code,
      AdTargetingPtr targeting,
      std::optional<::blink::Vector<AdSignals>> anonymized_proxied_signals,
      const std::optional<::blink::KURL>& fallback_source);

AdRequestConfig(const AdRequestConfig&) = delete;
AdRequestConfig& operator=(const AdRequestConfig&) = delete;

  ~AdRequestConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdRequestConfigPtr>
  AdRequestConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdRequestConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdRequestConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdRequestConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdRequestConfig_UnserializedMessageContext<
            UserType, AdRequestConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdRequestConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdRequestConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdRequestConfig_UnserializedMessageContext<
            UserType, AdRequestConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdRequestConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL ad_request_url;
  
  ::blink::Vector<AdPropertiesPtr> ad_properties;
  
  ::blink::String publisher_code;
  
  AdTargetingPtr targeting;
  
  std::optional<::blink::Vector<AdSignals>> anonymized_proxied_signals;
  
  std::optional<::blink::KURL> fallback_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdRequestConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AdPropertiesPtr AdProperties::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(slot),
      mojo::Clone(lang),
      mojo::Clone(ad_type),
      mojo::Clone(bid_floor)
  );
}

template <typename T, AdProperties::EnableIfSame<T>*>
bool AdProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->slot, other_struct.slot))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->ad_type, other_struct.ad_type))
    return false;
  if (!mojo::Equals(this->bid_floor, other_struct.bid_floor))
    return false;
  return true;
}

template <typename T, AdProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.slot < rhs.slot)
    return true;
  if (rhs.slot < lhs.slot)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  if (lhs.ad_type < rhs.ad_type)
    return true;
  if (rhs.ad_type < lhs.ad_type)
    return false;
  if (lhs.bid_floor < rhs.bid_floor)
    return true;
  if (rhs.bid_floor < lhs.bid_floor)
    return false;
  return false;
}
template <typename StructPtrType>
AdGeolocationPtr AdGeolocation::Clone() const {
  return New(
      mojo::Clone(latitude),
      mojo::Clone(longitude)
  );
}

template <typename T, AdGeolocation::EnableIfSame<T>*>
bool AdGeolocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->latitude, other_struct.latitude))
    return false;
  if (!mojo::Equals(this->longitude, other_struct.longitude))
    return false;
  return true;
}

template <typename T, AdGeolocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.latitude < rhs.latitude)
    return true;
  if (rhs.latitude < lhs.latitude)
    return false;
  if (lhs.longitude < rhs.longitude)
    return true;
  if (rhs.longitude < lhs.longitude)
    return false;
  return false;
}
template <typename StructPtrType>
AdTargetingPtr AdTargeting::Clone() const {
  return New(
      mojo::Clone(interests),
      mojo::Clone(geolocation)
  );
}

template <typename T, AdTargeting::EnableIfSame<T>*>
bool AdTargeting::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interests, other_struct.interests))
    return false;
  if (!mojo::Equals(this->geolocation, other_struct.geolocation))
    return false;
  return true;
}

template <typename T, AdTargeting::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interests < rhs.interests)
    return true;
  if (rhs.interests < lhs.interests)
    return false;
  if (lhs.geolocation < rhs.geolocation)
    return true;
  if (rhs.geolocation < lhs.geolocation)
    return false;
  return false;
}
template <typename StructPtrType>
AdRequestConfigPtr AdRequestConfig::Clone() const {
  return New(
      mojo::Clone(ad_request_url),
      mojo::Clone(ad_properties),
      mojo::Clone(publisher_code),
      mojo::Clone(targeting),
      mojo::Clone(anonymized_proxied_signals),
      mojo::Clone(fallback_source)
  );
}

template <typename T, AdRequestConfig::EnableIfSame<T>*>
bool AdRequestConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ad_request_url, other_struct.ad_request_url))
    return false;
  if (!mojo::Equals(this->ad_properties, other_struct.ad_properties))
    return false;
  if (!mojo::Equals(this->publisher_code, other_struct.publisher_code))
    return false;
  if (!mojo::Equals(this->targeting, other_struct.targeting))
    return false;
  if (!mojo::Equals(this->anonymized_proxied_signals, other_struct.anonymized_proxied_signals))
    return false;
  if (!mojo::Equals(this->fallback_source, other_struct.fallback_source))
    return false;
  return true;
}

template <typename T, AdRequestConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ad_request_url < rhs.ad_request_url)
    return true;
  if (rhs.ad_request_url < lhs.ad_request_url)
    return false;
  if (lhs.ad_properties < rhs.ad_properties)
    return true;
  if (rhs.ad_properties < lhs.ad_properties)
    return false;
  if (lhs.publisher_code < rhs.publisher_code)
    return true;
  if (rhs.publisher_code < lhs.publisher_code)
    return false;
  if (lhs.targeting < rhs.targeting)
    return true;
  if (rhs.targeting < lhs.targeting)
    return false;
  if (lhs.anonymized_proxied_signals < rhs.anonymized_proxied_signals)
    return true;
  if (rhs.anonymized_proxied_signals < lhs.anonymized_proxied_signals)
    return false;
  if (lhs.fallback_source < rhs.fallback_source)
    return true;
  if (rhs.fallback_source < lhs.fallback_source)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdProperties::DataView,
                                         ::blink::mojom::blink::AdPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdProperties::width)& width(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->width;
  }

  static const decltype(::blink::mojom::blink::AdProperties::height)& height(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->height;
  }

  static const decltype(::blink::mojom::blink::AdProperties::slot)& slot(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->slot;
  }

  static const decltype(::blink::mojom::blink::AdProperties::lang)& lang(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->lang;
  }

  static const decltype(::blink::mojom::blink::AdProperties::ad_type)& ad_type(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->ad_type;
  }

  static decltype(::blink::mojom::blink::AdProperties::bid_floor) bid_floor(
      const ::blink::mojom::blink::AdPropertiesPtr& input) {
    return input->bid_floor;
  }

  static bool Read(::blink::mojom::blink::AdProperties::DataView input, ::blink::mojom::blink::AdPropertiesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdGeolocation::DataView,
                                         ::blink::mojom::blink::AdGeolocationPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdGeolocationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdGeolocationPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AdGeolocation::latitude) latitude(
      const ::blink::mojom::blink::AdGeolocationPtr& input) {
    return input->latitude;
  }

  static decltype(::blink::mojom::blink::AdGeolocation::longitude) longitude(
      const ::blink::mojom::blink::AdGeolocationPtr& input) {
    return input->longitude;
  }

  static bool Read(::blink::mojom::blink::AdGeolocation::DataView input, ::blink::mojom::blink::AdGeolocationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdTargeting::DataView,
                                         ::blink::mojom::blink::AdTargetingPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdTargetingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdTargetingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdTargeting::interests)& interests(
      const ::blink::mojom::blink::AdTargetingPtr& input) {
    return input->interests;
  }

  static const decltype(::blink::mojom::blink::AdTargeting::geolocation)& geolocation(
      const ::blink::mojom::blink::AdTargetingPtr& input) {
    return input->geolocation;
  }

  static bool Read(::blink::mojom::blink::AdTargeting::DataView input, ::blink::mojom::blink::AdTargetingPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AdRequestConfig::DataView,
                                         ::blink::mojom::blink::AdRequestConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::AdRequestConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AdRequestConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AdRequestConfig::ad_request_url)& ad_request_url(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->ad_request_url;
  }

  static const decltype(::blink::mojom::blink::AdRequestConfig::ad_properties)& ad_properties(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->ad_properties;
  }

  static const decltype(::blink::mojom::blink::AdRequestConfig::publisher_code)& publisher_code(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->publisher_code;
  }

  static const decltype(::blink::mojom::blink::AdRequestConfig::targeting)& targeting(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->targeting;
  }

  static const decltype(::blink::mojom::blink::AdRequestConfig::anonymized_proxied_signals)& anonymized_proxied_signals(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->anonymized_proxied_signals;
  }

  static const decltype(::blink::mojom::blink::AdRequestConfig::fallback_source)& fallback_source(
      const ::blink::mojom::blink::AdRequestConfigPtr& input) {
    return input->fallback_source;
  }

  static bool Read(::blink::mojom::blink::AdRequestConfig::DataView input, ::blink::mojom::blink::AdRequestConfigPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_BLINK_H_