// third_party/blink/public/mojom/page/page.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "ui/color/color_id.mojom-shared.h"


namespace blink::mojom {
class PageLifecycleStateDataView;

class PageRestoreParamsDataView;

class ColorProviderColorMapsDataView;

class PrerenderPageActivationParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PageLifecycleStateDataView> {
  using Data = ::blink::mojom::internal::PageLifecycleState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageRestoreParamsDataView> {
  using Data = ::blink::mojom::internal::PageRestoreParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ColorProviderColorMapsDataView> {
  using Data = ::blink::mojom::internal::ColorProviderColorMaps_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PrerenderPageActivationParamsDataView> {
  using Data = ::blink::mojom::internal::PrerenderPageActivationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PagehideDispatch : int32_t {
  
  kNotDispatched = 0,
  
  kDispatchedNotPersisted = 1,
  
  kDispatchedPersisted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PagehideDispatch value);
inline bool IsKnownEnumValue(PagehideDispatch value) {
  return internal::PagehideDispatch_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageBroadcastInterfaceBase {};

using PageBroadcastPtrDataView =
    mojo::InterfacePtrDataView<PageBroadcastInterfaceBase>;
using PageBroadcastRequestDataView =
    mojo::InterfaceRequestDataView<PageBroadcastInterfaceBase>;
using PageBroadcastAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageBroadcastInterfaceBase>;
using PageBroadcastAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageBroadcastInterfaceBase>;


class PageLifecycleStateDataView {
 public:
  PageLifecycleStateDataView() = default;

  PageLifecycleStateDataView(
      internal::PageLifecycleState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_frozen() const {
    return data_->is_frozen;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibility(UserType* output) const {
    auto data_value = data_->visibility;
    return mojo::internal::Deserialize<::blink::mojom::PageVisibilityState>(
        data_value, output);
  }
  ::blink::mojom::PageVisibilityState visibility() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PageVisibilityState>(data_->visibility));
  }
  bool is_in_back_forward_cache() const {
    return data_->is_in_back_forward_cache;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPagehideDispatch(UserType* output) const {
    auto data_value = data_->pagehide_dispatch;
    return mojo::internal::Deserialize<::blink::mojom::PagehideDispatch>(
        data_value, output);
  }
  PagehideDispatch pagehide_dispatch() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PagehideDispatch>(data_->pagehide_dispatch));
  }
  bool eviction_enabled() const {
    return data_->eviction_enabled;
  }
 private:
  internal::PageLifecycleState_Data* data_ = nullptr;
};


class PageRestoreParamsDataView {
 public:
  PageRestoreParamsDataView() = default;

  PageRestoreParamsDataView(
      internal::PageRestoreParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  int32_t pending_history_list_index() const {
    return data_->pending_history_list_index;
  }
  int32_t current_history_list_length() const {
    return data_->current_history_list_length;
  }
  inline void GetViewTransitionStateDataView(
      ::blink::mojom::ViewTransitionStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewTransitionStateDataView, UserType>(),
    "Attempting to read the optional `view_transition_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewTransitionState` instead "
    "of `ReadViewTransitionState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_transition_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageRestoreParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ColorProviderColorMapsDataView {
 public:
  ColorProviderColorMapsDataView() = default;

  ColorProviderColorMapsDataView(
      internal::ColorProviderColorMaps_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLightColorsMapDataView(
      mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLightColorsMap(UserType* output) {
    
    auto* pointer = data_->light_colors_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
        pointer, output, message_);
  }
  inline void GetDarkColorsMapDataView(
      mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDarkColorsMap(UserType* output) {
    
    auto* pointer = data_->dark_colors_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
        pointer, output, message_);
  }
  inline void GetForcedColorsMapDataView(
      mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForcedColorsMap(UserType* output) {
    
    auto* pointer = data_->forced_colors_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ColorProviderColorMaps_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrerenderPageActivationParamsDataView {
 public:
  PrerenderPageActivationParamsDataView() = default;

  PrerenderPageActivationParamsDataView(
      internal::PrerenderPageActivationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadWasUserActivated(UserType* output) const {
    auto data_value = data_->was_user_activated;
    return mojo::internal::Deserialize<::blink::mojom::WasActivatedOption>(
        data_value, output);
  }
  ::blink::mojom::WasActivatedOption was_user_activated() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WasActivatedOption>(data_->was_user_activated));
  }
  inline void GetActivationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivationStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeTicksDataView, UserType>(),
    "Attempting to read the optional `activation_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActivationStart` instead "
    "of `ReadActivationStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->activation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetViewTransitionStateDataView(
      ::blink::mojom::ViewTransitionStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewTransitionStateDataView, UserType>(),
    "Attempting to read the optional `view_transition_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewTransitionState` instead "
    "of `ReadViewTransitionState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_transition_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrerenderPageActivationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_DATA_VIEW_H_