// third_party/blink/public/mojom/page/page.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/page.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/page.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/attribution.mojom-blink-forward.h"
#include "skia/public/mojom/skcolor.mojom-blink.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-blink.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-blink.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-blink.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-blink.h"
#include "ui/color/color_id.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/page/color_provider_color_maps_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PageBroadcastProxy;

template <typename ImplRefTraits>
class PageBroadcastStub;

class PageBroadcastRequestValidator;
class PageBroadcastResponseValidator;


class CORE_EXPORT PageBroadcast
    : public PageBroadcastInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PageBroadcast";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageBroadcastInterfaceBase;
  using Proxy_ = PageBroadcastProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageBroadcastStub<ImplRefTraits>;

  using RequestValidator_ = PageBroadcastRequestValidator;
  using ResponseValidator_ = PageBroadcastResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetPageLifecycleStateMinVersion = 0,
    kAudioStateChangedMinVersion = 0,
    kActivatePrerenderedPageMinVersion = 0,
    kUpdateWebPreferencesMinVersion = 0,
    kUpdateRendererPreferencesMinVersion = 0,
    kSetHistoryIndexAndLengthMinVersion = 0,
    kSetPageBaseBackgroundColorMinVersion = 0,
    kCreateRemoteMainFrameMinVersion = 0,
    kUpdatePageBrowsingContextGroupMinVersion = 0,
    kSetPageAttributionSupportMinVersion = 0,
    kUpdateColorProvidersMinVersion = 0,
    kUpdateCanvasNoiseTokenMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPageLifecycleState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivatePrerenderedPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateWebPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateRendererPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHistoryIndexAndLength_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPageBaseBackgroundColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRemoteMainFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePageBrowsingContextGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPageAttributionSupport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateColorProviders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCanvasNoiseToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageBroadcast() = default;

  using SetPageLifecycleStateCallback = base::OnceCallback<void()>;
  using SetPageLifecycleStateMojoCallback = base::OnceCallback<void()>;

  virtual void SetPageLifecycleState(PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params, SetPageLifecycleStateCallback callback) = 0;

  virtual void AudioStateChanged(bool is_audio_playing) = 0;

  using ActivatePrerenderedPageCallback = base::OnceCallback<void()>;
  using ActivatePrerenderedPageMojoCallback = base::OnceCallback<void()>;

  virtual void ActivatePrerenderedPage(PrerenderPageActivationParamsPtr prerender_page_activation_params, ActivatePrerenderedPageCallback callback) = 0;

  virtual void UpdateWebPreferences(const ::blink::web_pref::WebPreferences& preferences) = 0;

  virtual void UpdateRendererPreferences(const ::blink::RendererPreferences& preferences) = 0;

  virtual void SetHistoryIndexAndLength(int32_t index, int32_t length) = 0;

  virtual void SetPageBaseBackgroundColor(std::optional<::SkColor> color) = 0;

  virtual void CreateRemoteMainFrame(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::blink::FrameReplicationStatePtr replication_state, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, const std::optional<::base::UnguessableToken>& navigation_metrics_token, ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces, ::blink::mojom::blink::RemoteMainFrameInterfacesPtr remote_main_frame_interfaces) = 0;

  virtual void UpdatePageBrowsingContextGroup(const ::base::UnguessableToken& browsing_context_group_token) = 0;

  virtual void SetPageAttributionSupport(::network::mojom::blink::AttributionSupport support) = 0;

  virtual void UpdateColorProviders(const ::blink::ColorProviderColorMaps& color_provider_colors) = 0;

  virtual void UpdateCanvasNoiseToken(std::optional<::blink::NoiseToken> canvas_noise_token) = 0;
};



class CORE_EXPORT PageBroadcastProxy
    : public PageBroadcast {
 public:
  using InterfaceType = PageBroadcast;

  explicit PageBroadcastProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPageLifecycleState(PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params, SetPageLifecycleStateCallback callback) final;
  
  void AudioStateChanged(bool is_audio_playing) final;
  
  void ActivatePrerenderedPage(PrerenderPageActivationParamsPtr prerender_page_activation_params, ActivatePrerenderedPageCallback callback) final;
  
  void UpdateWebPreferences(const ::blink::web_pref::WebPreferences& preferences) final;
  
  void UpdateRendererPreferences(const ::blink::RendererPreferences& preferences) final;
  
  void SetHistoryIndexAndLength(int32_t index, int32_t length) final;
  
  void SetPageBaseBackgroundColor(std::optional<::SkColor> color) final;
  
  void CreateRemoteMainFrame(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::blink::FrameReplicationStatePtr replication_state, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, const std::optional<::base::UnguessableToken>& navigation_metrics_token, ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces, ::blink::mojom::blink::RemoteMainFrameInterfacesPtr remote_main_frame_interfaces) final;
  
  void UpdatePageBrowsingContextGroup(const ::base::UnguessableToken& browsing_context_group_token) final;
  
  void SetPageAttributionSupport(::network::mojom::blink::AttributionSupport support) final;
  
  void UpdateColorProviders(const ::blink::ColorProviderColorMaps& color_provider_colors) final;
  
  void UpdateCanvasNoiseToken(std::optional<::blink::NoiseToken> canvas_noise_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT PageBroadcastStubDispatch {
 public:
  static bool Accept(PageBroadcast* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageBroadcast* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageBroadcast>>
class PageBroadcastStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageBroadcastStub() = default;
  ~PageBroadcastStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageBroadcastStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageBroadcastStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT PageBroadcastRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT PageBroadcastResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class CORE_EXPORT PageLifecycleState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageLifecycleState, T>::value>;
  using DataView = PageLifecycleStateDataView;
  using Data_ = internal::PageLifecycleState_Data;

  template <typename... Args>
  static PageLifecycleStatePtr New(Args&&... args) {
    return PageLifecycleStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageLifecycleStatePtr From(const U& u) {
    return mojo::TypeConverter<PageLifecycleStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageLifecycleState>::Convert(*this);
  }


  PageLifecycleState();

  PageLifecycleState(
      bool is_frozen,
      ::blink::mojom::blink::PageVisibilityState visibility,
      bool is_in_back_forward_cache,
      PagehideDispatch pagehide_dispatch,
      bool eviction_enabled);


  ~PageLifecycleState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageLifecycleStatePtr>
  PageLifecycleStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageLifecycleState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageLifecycleState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageLifecycleState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageLifecycleState_UnserializedMessageContext<
            UserType, PageLifecycleState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageLifecycleState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageLifecycleState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageLifecycleState_UnserializedMessageContext<
            UserType, PageLifecycleState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageLifecycleState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_frozen;
  
  ::blink::mojom::blink::PageVisibilityState visibility;
  
  bool is_in_back_forward_cache;
  
  PagehideDispatch pagehide_dispatch;
  
  bool eviction_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT PageRestoreParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageRestoreParams, T>::value>;
  using DataView = PageRestoreParamsDataView;
  using Data_ = internal::PageRestoreParams_Data;

  template <typename... Args>
  static PageRestoreParamsPtr New(Args&&... args) {
    return PageRestoreParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageRestoreParamsPtr From(const U& u) {
    return mojo::TypeConverter<PageRestoreParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageRestoreParams>::Convert(*this);
  }


  PageRestoreParams();

  PageRestoreParams(
      ::base::TimeTicks navigation_start,
      int32_t pending_history_list_index,
      int32_t current_history_list_length,
      const std::optional<::blink::ViewTransitionState>& view_transition_state);


  ~PageRestoreParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageRestoreParamsPtr>
  PageRestoreParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageRestoreParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageRestoreParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageRestoreParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageRestoreParams_UnserializedMessageContext<
            UserType, PageRestoreParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageRestoreParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageRestoreParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageRestoreParams_UnserializedMessageContext<
            UserType, PageRestoreParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageRestoreParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks navigation_start;
  
  int32_t pending_history_list_index;
  
  int32_t current_history_list_length;
  
  std::optional<::blink::ViewTransitionState> view_transition_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT ColorProviderColorMaps {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorProviderColorMaps, T>::value>;
  using DataView = ColorProviderColorMapsDataView;
  using Data_ = internal::ColorProviderColorMaps_Data;

  template <typename... Args>
  static ColorProviderColorMapsPtr New(Args&&... args) {
    return ColorProviderColorMapsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorProviderColorMapsPtr From(const U& u) {
    return mojo::TypeConverter<ColorProviderColorMapsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorProviderColorMaps>::Convert(*this);
  }


  ColorProviderColorMaps();

  ColorProviderColorMaps(
      const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& light_colors_map,
      const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& dark_colors_map,
      const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& forced_colors_map);


  ~ColorProviderColorMaps();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorProviderColorMapsPtr>
  ColorProviderColorMapsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorProviderColorMaps::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorProviderColorMaps::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorProviderColorMaps::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorProviderColorMaps_UnserializedMessageContext<
            UserType, ColorProviderColorMaps::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorProviderColorMaps::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorProviderColorMaps::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorProviderColorMaps_UnserializedMessageContext<
            UserType, ColorProviderColorMaps::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorProviderColorMaps::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor> light_colors_map;
  
  ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor> dark_colors_map;
  
  ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor> forced_colors_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorProviderColorMaps::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT PrerenderPageActivationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrerenderPageActivationParams, T>::value>;
  using DataView = PrerenderPageActivationParamsDataView;
  using Data_ = internal::PrerenderPageActivationParams_Data;

  template <typename... Args>
  static PrerenderPageActivationParamsPtr New(Args&&... args) {
    return PrerenderPageActivationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrerenderPageActivationParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrerenderPageActivationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrerenderPageActivationParams>::Convert(*this);
  }


  PrerenderPageActivationParams();

  PrerenderPageActivationParams(
      ::blink::mojom::blink::WasActivatedOption was_user_activated,
      std::optional<::base::TimeTicks> activation_start,
      const std::optional<::blink::ViewTransitionState>& view_transition_state);


  ~PrerenderPageActivationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrerenderPageActivationParamsPtr>
  PrerenderPageActivationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderPageActivationParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderPageActivationParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrerenderPageActivationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrerenderPageActivationParams_UnserializedMessageContext<
            UserType, PrerenderPageActivationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrerenderPageActivationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrerenderPageActivationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrerenderPageActivationParams_UnserializedMessageContext<
            UserType, PrerenderPageActivationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrerenderPageActivationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::WasActivatedOption was_user_activated;
  
  std::optional<::base::TimeTicks> activation_start;
  
  std::optional<::blink::ViewTransitionState> view_transition_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrerenderPageActivationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PageLifecycleStatePtr PageLifecycleState::Clone() const {
  return New(
      mojo::Clone(is_frozen),
      mojo::Clone(visibility),
      mojo::Clone(is_in_back_forward_cache),
      mojo::Clone(pagehide_dispatch),
      mojo::Clone(eviction_enabled)
  );
}

template <typename T, PageLifecycleState::EnableIfSame<T>*>
bool PageLifecycleState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_frozen, other_struct.is_frozen))
    return false;
  if (!mojo::Equals(this->visibility, other_struct.visibility))
    return false;
  if (!mojo::Equals(this->is_in_back_forward_cache, other_struct.is_in_back_forward_cache))
    return false;
  if (!mojo::Equals(this->pagehide_dispatch, other_struct.pagehide_dispatch))
    return false;
  if (!mojo::Equals(this->eviction_enabled, other_struct.eviction_enabled))
    return false;
  return true;
}

template <typename T, PageLifecycleState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_frozen < rhs.is_frozen)
    return true;
  if (rhs.is_frozen < lhs.is_frozen)
    return false;
  if (lhs.visibility < rhs.visibility)
    return true;
  if (rhs.visibility < lhs.visibility)
    return false;
  if (lhs.is_in_back_forward_cache < rhs.is_in_back_forward_cache)
    return true;
  if (rhs.is_in_back_forward_cache < lhs.is_in_back_forward_cache)
    return false;
  if (lhs.pagehide_dispatch < rhs.pagehide_dispatch)
    return true;
  if (rhs.pagehide_dispatch < lhs.pagehide_dispatch)
    return false;
  if (lhs.eviction_enabled < rhs.eviction_enabled)
    return true;
  if (rhs.eviction_enabled < lhs.eviction_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
PageRestoreParamsPtr PageRestoreParams::Clone() const {
  return New(
      mojo::Clone(navigation_start),
      mojo::Clone(pending_history_list_index),
      mojo::Clone(current_history_list_length),
      mojo::Clone(view_transition_state)
  );
}

template <typename T, PageRestoreParams::EnableIfSame<T>*>
bool PageRestoreParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->navigation_start, other_struct.navigation_start))
    return false;
  if (!mojo::Equals(this->pending_history_list_index, other_struct.pending_history_list_index))
    return false;
  if (!mojo::Equals(this->current_history_list_length, other_struct.current_history_list_length))
    return false;
  if (!mojo::Equals(this->view_transition_state, other_struct.view_transition_state))
    return false;
  return true;
}

template <typename T, PageRestoreParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.navigation_start < rhs.navigation_start)
    return true;
  if (rhs.navigation_start < lhs.navigation_start)
    return false;
  if (lhs.pending_history_list_index < rhs.pending_history_list_index)
    return true;
  if (rhs.pending_history_list_index < lhs.pending_history_list_index)
    return false;
  if (lhs.current_history_list_length < rhs.current_history_list_length)
    return true;
  if (rhs.current_history_list_length < lhs.current_history_list_length)
    return false;
  if (lhs.view_transition_state < rhs.view_transition_state)
    return true;
  if (rhs.view_transition_state < lhs.view_transition_state)
    return false;
  return false;
}
template <typename StructPtrType>
ColorProviderColorMapsPtr ColorProviderColorMaps::Clone() const {
  return New(
      mojo::Clone(light_colors_map),
      mojo::Clone(dark_colors_map),
      mojo::Clone(forced_colors_map)
  );
}

template <typename T, ColorProviderColorMaps::EnableIfSame<T>*>
bool ColorProviderColorMaps::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->light_colors_map, other_struct.light_colors_map))
    return false;
  if (!mojo::Equals(this->dark_colors_map, other_struct.dark_colors_map))
    return false;
  if (!mojo::Equals(this->forced_colors_map, other_struct.forced_colors_map))
    return false;
  return true;
}

template <typename T, ColorProviderColorMaps::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.light_colors_map < rhs.light_colors_map)
    return true;
  if (rhs.light_colors_map < lhs.light_colors_map)
    return false;
  if (lhs.dark_colors_map < rhs.dark_colors_map)
    return true;
  if (rhs.dark_colors_map < lhs.dark_colors_map)
    return false;
  if (lhs.forced_colors_map < rhs.forced_colors_map)
    return true;
  if (rhs.forced_colors_map < lhs.forced_colors_map)
    return false;
  return false;
}
template <typename StructPtrType>
PrerenderPageActivationParamsPtr PrerenderPageActivationParams::Clone() const {
  return New(
      mojo::Clone(was_user_activated),
      mojo::Clone(activation_start),
      mojo::Clone(view_transition_state)
  );
}

template <typename T, PrerenderPageActivationParams::EnableIfSame<T>*>
bool PrerenderPageActivationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->was_user_activated, other_struct.was_user_activated))
    return false;
  if (!mojo::Equals(this->activation_start, other_struct.activation_start))
    return false;
  if (!mojo::Equals(this->view_transition_state, other_struct.view_transition_state))
    return false;
  return true;
}

template <typename T, PrerenderPageActivationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.was_user_activated < rhs.was_user_activated)
    return true;
  if (rhs.was_user_activated < lhs.was_user_activated)
    return false;
  if (lhs.activation_start < rhs.activation_start)
    return true;
  if (rhs.activation_start < lhs.activation_start)
    return false;
  if (lhs.view_transition_state < rhs.view_transition_state)
    return true;
  if (rhs.view_transition_state < lhs.view_transition_state)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PageLifecycleState::DataView,
                                         ::blink::mojom::blink::PageLifecycleStatePtr> {
  static bool IsNull(const ::blink::mojom::blink::PageLifecycleStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PageLifecycleStatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PageLifecycleState::is_frozen) is_frozen(
      const ::blink::mojom::blink::PageLifecycleStatePtr& input) {
    return input->is_frozen;
  }

  static decltype(::blink::mojom::blink::PageLifecycleState::visibility) visibility(
      const ::blink::mojom::blink::PageLifecycleStatePtr& input) {
    return input->visibility;
  }

  static decltype(::blink::mojom::blink::PageLifecycleState::is_in_back_forward_cache) is_in_back_forward_cache(
      const ::blink::mojom::blink::PageLifecycleStatePtr& input) {
    return input->is_in_back_forward_cache;
  }

  static decltype(::blink::mojom::blink::PageLifecycleState::pagehide_dispatch) pagehide_dispatch(
      const ::blink::mojom::blink::PageLifecycleStatePtr& input) {
    return input->pagehide_dispatch;
  }

  static decltype(::blink::mojom::blink::PageLifecycleState::eviction_enabled) eviction_enabled(
      const ::blink::mojom::blink::PageLifecycleStatePtr& input) {
    return input->eviction_enabled;
  }

  static bool Read(::blink::mojom::blink::PageLifecycleState::DataView input, ::blink::mojom::blink::PageLifecycleStatePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PageRestoreParams::DataView,
                                         ::blink::mojom::blink::PageRestoreParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PageRestoreParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PageRestoreParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PageRestoreParams::navigation_start)& navigation_start(
      const ::blink::mojom::blink::PageRestoreParamsPtr& input) {
    return input->navigation_start;
  }

  static decltype(::blink::mojom::blink::PageRestoreParams::pending_history_list_index) pending_history_list_index(
      const ::blink::mojom::blink::PageRestoreParamsPtr& input) {
    return input->pending_history_list_index;
  }

  static decltype(::blink::mojom::blink::PageRestoreParams::current_history_list_length) current_history_list_length(
      const ::blink::mojom::blink::PageRestoreParamsPtr& input) {
    return input->current_history_list_length;
  }

  static const decltype(::blink::mojom::blink::PageRestoreParams::view_transition_state)& view_transition_state(
      const ::blink::mojom::blink::PageRestoreParamsPtr& input) {
    return input->view_transition_state;
  }

  static bool Read(::blink::mojom::blink::PageRestoreParams::DataView input, ::blink::mojom::blink::PageRestoreParamsPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ColorProviderColorMaps::DataView,
                                         ::blink::mojom::blink::ColorProviderColorMapsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ColorProviderColorMapsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ColorProviderColorMapsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ColorProviderColorMaps::light_colors_map)& light_colors_map(
      const ::blink::mojom::blink::ColorProviderColorMapsPtr& input) {
    return input->light_colors_map;
  }

  static const decltype(::blink::mojom::blink::ColorProviderColorMaps::dark_colors_map)& dark_colors_map(
      const ::blink::mojom::blink::ColorProviderColorMapsPtr& input) {
    return input->dark_colors_map;
  }

  static const decltype(::blink::mojom::blink::ColorProviderColorMaps::forced_colors_map)& forced_colors_map(
      const ::blink::mojom::blink::ColorProviderColorMapsPtr& input) {
    return input->forced_colors_map;
  }

  static bool Read(::blink::mojom::blink::ColorProviderColorMaps::DataView input, ::blink::mojom::blink::ColorProviderColorMapsPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PrerenderPageActivationParams::DataView,
                                         ::blink::mojom::blink::PrerenderPageActivationParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PrerenderPageActivationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PrerenderPageActivationParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PrerenderPageActivationParams::was_user_activated) was_user_activated(
      const ::blink::mojom::blink::PrerenderPageActivationParamsPtr& input) {
    return input->was_user_activated;
  }

  static const decltype(::blink::mojom::blink::PrerenderPageActivationParams::activation_start)& activation_start(
      const ::blink::mojom::blink::PrerenderPageActivationParamsPtr& input) {
    return input->activation_start;
  }

  static const decltype(::blink::mojom::blink::PrerenderPageActivationParams::view_transition_state)& view_transition_state(
      const ::blink::mojom::blink::PrerenderPageActivationParamsPtr& input) {
    return input->view_transition_state;
  }

  static bool Read(::blink::mojom::blink::PrerenderPageActivationParams::DataView input, ::blink::mojom::blink::PrerenderPageActivationParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_BLINK_H_