// third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-params-data.h"
#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DetectionArgs::DetectionArgs()
    : private_footprint_threshold() {}

DetectionArgs::DetectionArgs(
    uint64_t private_footprint_threshold_in)
    : private_footprint_threshold(std::move(private_footprint_threshold_in)) {}

DetectionArgs::~DetectionArgs() = default;
size_t DetectionArgs::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->private_footprint_threshold);
  return seed;
}

void DetectionArgs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_footprint_threshold"), this->private_footprint_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DetectionArgs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

OomInterventionHost::IPCStableHashFunction OomInterventionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OomInterventionHost>(message.name())) {
    case messages::OomInterventionHost::kOnHighMemoryUsage: {
      return &OomInterventionHost::OnHighMemoryUsage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OomInterventionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OomInterventionHost>(message.name())) {
      case messages::OomInterventionHost::kOnHighMemoryUsage:
            return "Receive blink::mojom::OomInterventionHost::OnHighMemoryUsage";
    }
  } else {
    switch (static_cast<messages::OomInterventionHost>(message.name())) {
      case messages::OomInterventionHost::kOnHighMemoryUsage:
            return "Receive reply blink::mojom::OomInterventionHost::OnHighMemoryUsage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OomInterventionHost::OnHighMemoryUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb4bbaa57;  // IPCStableHash for blink::mojom::OomInterventionHost::OnHighMemoryUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

OomInterventionHostProxy::OomInterventionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OomInterventionHostProxy::OnHighMemoryUsage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::OomInterventionHost::OnHighMemoryUsage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OomInterventionHost::kOnHighMemoryUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OomInterventionHost_OnHighMemoryUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OomInterventionHost::Name_);
  message.set_method_name("OnHighMemoryUsage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OomInterventionHostStubDispatch::Accept(
    OomInterventionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OomInterventionHost>(message->header()->name)) {
    case messages::OomInterventionHost::kOnHighMemoryUsage: {
      DCHECK(message->is_serialized());
      internal::OomInterventionHost_OnHighMemoryUsage_Params_Data* params =
          reinterpret_cast<internal::OomInterventionHost_OnHighMemoryUsage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OomInterventionHost.0
      bool success = true;
      OomInterventionHost_OnHighMemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OomInterventionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHighMemoryUsage(        );
      return true;
    }
  }
  return false;
}

// static
bool OomInterventionHostStubDispatch::AcceptWithResponder(
    OomInterventionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OomInterventionHost>(message->header()->name)) {
    case messages::OomInterventionHost::kOnHighMemoryUsage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOomInterventionHostValidationInfo[] = {
    { &internal::OomInterventionHost_OnHighMemoryUsage_Params_Data::Validate,
     nullptr /* no response */},
};

bool OomInterventionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::OomInterventionHost::Name_,
    kOomInterventionHostValidationInfo);
}

// The declaration includes the definition on other builds.

OomIntervention::IPCStableHashFunction OomIntervention::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OomIntervention>(message.name())) {
    case messages::OomIntervention::kStartDetection: {
      return &OomIntervention::StartDetection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OomIntervention::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OomIntervention>(message.name())) {
      case messages::OomIntervention::kStartDetection:
            return "Receive blink::mojom::OomIntervention::StartDetection";
    }
  } else {
    switch (static_cast<messages::OomIntervention>(message.name())) {
      case messages::OomIntervention::kStartDetection:
            return "Receive reply blink::mojom::OomIntervention::StartDetection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OomIntervention::StartDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54a0b474;  // IPCStableHash for blink::mojom::OomIntervention::StartDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

OomInterventionProxy::OomInterventionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OomInterventionProxy::StartDetection(
    ::mojo::PendingRemote<OomInterventionHost> in_host, DetectionArgsPtr in_detection_args, bool in_renderer_pause_enabled, bool in_navigate_ads_enabled, bool in_purge_v8_memory_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OomIntervention::StartDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<OomInterventionHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("detection_args"), in_detection_args,
                        "<value of type DetectionArgsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_pause_enabled"), in_renderer_pause_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigate_ads_enabled"), in_navigate_ads_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purge_v8_memory_enabled"), in_purge_v8_memory_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OomIntervention::kStartDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OomIntervention_StartDetection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::OomInterventionHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in OomIntervention.StartDetection request");
  mojo::internal::MessageFragment<
      typename decltype(params->detection_args)::BaseType> detection_args_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DetectionArgsDataView>(
    in_detection_args,
    detection_args_fragment);

  params->detection_args.Set(
      detection_args_fragment.is_null() ? nullptr : detection_args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->detection_args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null detection_args in OomIntervention.StartDetection request");

  params->renderer_pause_enabled = in_renderer_pause_enabled;

  params->navigate_ads_enabled = in_navigate_ads_enabled;

  params->purge_v8_memory_enabled = in_purge_v8_memory_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OomIntervention::Name_);
  message.set_method_name("StartDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OomInterventionStubDispatch::Accept(
    OomIntervention* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OomIntervention>(message->header()->name)) {
    case messages::OomIntervention::kStartDetection: {
      DCHECK(message->is_serialized());
      internal::OomIntervention_StartDetection_Params_Data* params =
          reinterpret_cast<internal::OomIntervention_StartDetection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OomIntervention.0
      bool success = true;
      ::mojo::PendingRemote<OomInterventionHost> p_host{};
      DetectionArgsPtr p_detection_args{};
      bool p_renderer_pause_enabled{};
      bool p_navigate_ads_enabled{};
      bool p_purge_v8_memory_enabled{};
      OomIntervention_StartDetection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success && !input_data_view.ReadDetectionArgs(&p_detection_args))
        success = false;
      if (success)
        p_renderer_pause_enabled = input_data_view.renderer_pause_enabled();
      if (success)
        p_navigate_ads_enabled = input_data_view.navigate_ads_enabled();
      if (success)
        p_purge_v8_memory_enabled = input_data_view.purge_v8_memory_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OomIntervention::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDetection(        
        std::move(p_host), 
        std::move(p_detection_args), 
        std::move(p_renderer_pause_enabled), 
        std::move(p_navigate_ads_enabled), 
        std::move(p_purge_v8_memory_enabled));
      return true;
    }
  }
  return false;
}

// static
bool OomInterventionStubDispatch::AcceptWithResponder(
    OomIntervention* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OomIntervention>(message->header()->name)) {
    case messages::OomIntervention::kStartDetection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOomInterventionValidationInfo[] = {
    { &internal::OomIntervention_StartDetection_Params_Data::Validate,
     nullptr /* no response */},
};

bool OomInterventionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::OomIntervention::Name_,
    kOomInterventionValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DetectionArgs::DataView, ::blink::mojom::blink::DetectionArgsPtr>::Read(
    ::blink::mojom::blink::DetectionArgs::DataView input,
    ::blink::mojom::blink::DetectionArgsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DetectionArgsPtr result(::blink::mojom::blink::DetectionArgs::New());
  
      if (success)
        result->private_footprint_threshold = input.private_footprint_threshold();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void OomInterventionHostInterceptorForTesting::OnHighMemoryUsage() {
  GetForwardingInterface()->OnHighMemoryUsage();
}
OomInterventionHostAsyncWaiter::OomInterventionHostAsyncWaiter(
    OomInterventionHost* proxy) : proxy_(proxy) {}

OomInterventionHostAsyncWaiter::~OomInterventionHostAsyncWaiter() = default;





void OomInterventionInterceptorForTesting::StartDetection(::mojo::PendingRemote<OomInterventionHost> host, DetectionArgsPtr detection_args, bool renderer_pause_enabled, bool navigate_ads_enabled, bool purge_v8_memory_enabled) {
  GetForwardingInterface()->StartDetection(
    std::move(host)
    , 
    std::move(detection_args)
    , 
    std::move(renderer_pause_enabled)
    , 
    std::move(navigate_ads_enabled)
    , 
    std::move(purge_v8_memory_enabled)
    );
}
OomInterventionAsyncWaiter::OomInterventionAsyncWaiter(
    OomIntervention* proxy) : proxy_(proxy) {}

OomInterventionAsyncWaiter::~OomInterventionAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif