// third_party/blink/public/mojom/on_device_translation/translator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class TranslatorProxy;

template <typename ImplRefTraits>
class TranslatorStub;

class TranslatorRequestValidator;


class BLINK_COMMON_EXPORT Translator
    : public TranslatorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.Translator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TranslatorInterfaceBase;
  using Proxy_ = TranslatorProxy;

  template <typename ImplRefTraits>
  using Stub_ = TranslatorStub<ImplRefTraits>;

  using RequestValidator_ = TranslatorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kTranslateMinVersion = 0,
    kTranslateStreamingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Translate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TranslateStreaming_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Translator() = default;

  virtual void Translate(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) = 0;

  virtual void TranslateStreaming(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) = 0;
};



class BLINK_COMMON_EXPORT TranslatorProxy
    : public Translator {
 public:
  using InterfaceType = Translator;

  explicit TranslatorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Translate(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) final;
  
  void TranslateStreaming(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT TranslatorStubDispatch {
 public:
  static bool Accept(Translator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Translator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Translator>>
class TranslatorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TranslatorStub() = default;
  ~TranslatorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslatorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslatorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT TranslatorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATOR_MOJOM_H_