// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CanCreateTranslatorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CanCreateTranslatorResult = {
  
  kReadily: 0,
  kAfterDownloadLibraryNotReady: 1,
  kAfterDownloadLanguagePackNotReady: 2,
  kAfterDownloadLibraryAndLanguagePackNotReady: 3,
  kAfterDownloadTranslatorCreationRequired: 4,
  kNoNotSupportedLanguage: 5,
  kNoServiceCrashed: 6,
  kNoDisallowedByPolicy: 7,
  kNoExceedsServiceCountLimitation: 8,
  kNoInvalidStoragePartition: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CreateTranslatorErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CreateTranslatorError = {
  
  kInvalidBinary: 1,
  kInvalidFunctionPointer: 2,
  kFailedToInitialize: 3,
  kFailedToCreateTranslator: 4,
  kServiceCrashed: 5,
  kDisallowedByPolicy: 6,
  kExceedsServiceCountLimitation: 7,
  kExceedsPendingTaskCountLimitation: 8,
  kInvalidVersion: 9,
  kInvalidStoragePartition: 10,
  MIN_VALUE: 1,
  MAX_VALUE: 10,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TranslationManagerCreateTranslatorClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TranslationManagerCreateTranslatorClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.TranslationManagerCreateTranslatorClientInterface }
 */
blink.mojom.TranslationManagerCreateTranslatorClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TranslationManagerCreateTranslatorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TranslationManagerCreateTranslatorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TranslationManagerCreateTranslatorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.CreateTranslatorResult } result
   * @param { ?blink.mojom.TranslatorLanguageCode } sourceLang
   * @param { ?blink.mojom.TranslatorLanguageCode } targetLang
   */

  onResult(
      result,
      sourceLang,
      targetLang) {
    this.proxy.sendMessage(
        0,
        blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        [
          result,
          sourceLang,
          targetLang
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TranslationManagerCreateTranslatorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TranslationManagerCreateTranslatorClientReceiver = class {
  /**
   * @param {!blink.mojom.TranslationManagerCreateTranslatorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TranslationManagerCreateTranslatorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TranslationManagerCreateTranslatorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslationManagerCreateTranslatorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TranslationManagerCreateTranslatorClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TranslationManagerCreateTranslatorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TranslationManagerCreateTranslatorClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TranslationManagerCreateTranslatorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TranslationManagerCreateTranslatorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TranslationManagerCreateTranslatorClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TranslationManagerCreateTranslatorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslationManagerCreateTranslatorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TranslationManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TranslationManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.TranslationManagerInterface }
 */
blink.mojom.TranslationManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TranslationManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TranslationManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TranslationManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.TranslationManagerCreateTranslatorClientRemote } client
   * @param { !blink.mojom.TranslatorCreateOptions } options
   * @param { !boolean } addFakeDownloadDelay
   */

  createTranslator(
      client,
      options,
      addFakeDownloadDelay) {
    this.proxy.sendMessage(
        0,
        blink.mojom.TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        [
          client,
          options,
          addFakeDownloadDelay
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.TranslatorLanguageCode } sourceLang
   * @param { !blink.mojom.TranslatorLanguageCode } targetLang
   * @return {!Promise<{
        result: !blink.mojom.CanCreateTranslatorResult,
   *  }>}
   */

  translationAvailable(
      sourceLang,
      targetLang) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.TranslationManager_TranslationAvailable_ParamsSpec.$,
        blink.mojom.TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        [
          sourceLang,
          targetLang
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TranslationManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TranslationManagerReceiver = class {
  /**
   * @param {!blink.mojom.TranslationManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TranslationManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TranslationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        impl.createTranslator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TranslationManager_TranslationAvailable_ParamsSpec.$,
        blink.mojom.TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        impl.translationAvailable.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TranslationManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TranslationManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TranslationManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TranslationManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TranslationManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TranslationManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TranslationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTranslator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        this.createTranslator.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translationAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TranslationManager_TranslationAvailable_ParamsSpec.$,
        blink.mojom.TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        this.translationAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslatorLanguageCodeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslatorCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslationManager_CreateTranslator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslationManager_TranslationAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TranslationManager_TranslationAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CreateTranslatorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.TranslatorLanguageCodeSpec.$,
    'TranslatorLanguageCode',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TranslatorLanguageCode = class {
  constructor() {
    /** @export { !string } */
    this.code;
  }
};



mojo.internal.Struct(
    blink.mojom.TranslatorCreateOptionsSpec.$,
    'TranslatorCreateOptions',
    [
      mojo.internal.StructField(
        'sourceLang', 0,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetLang', 8,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observerRemote', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelDownloadProgressObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.TranslatorCreateOptions = class {
  constructor() {
    /** @export { !blink.mojom.TranslatorLanguageCode } */
    this.sourceLang;
    /** @export { !blink.mojom.TranslatorLanguageCode } */
    this.targetLang;
    /** @export { (blink.mojom.ModelDownloadProgressObserverRemote|undefined) } */
    this.observerRemote;
  }
};



mojo.internal.Struct(
    blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
    'TranslationManagerCreateTranslatorClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CreateTranslatorResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLang', 16,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetLang', 24,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.TranslationManagerCreateTranslatorClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.CreateTranslatorResult } */
    this.result;
    /** @export { (blink.mojom.TranslatorLanguageCode|undefined) } */
    this.sourceLang;
    /** @export { (blink.mojom.TranslatorLanguageCode|undefined) } */
    this.targetLang;
  }
};



mojo.internal.Struct(
    blink.mojom.TranslationManager_CreateTranslator_ParamsSpec.$,
    'TranslationManager_CreateTranslator_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.TranslationManagerCreateTranslatorClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.TranslatorCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addFakeDownloadDelay', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.TranslationManager_CreateTranslator_Params = class {
  constructor() {
    /** @export { !blink.mojom.TranslationManagerCreateTranslatorClientRemote } */
    this.client;
    /** @export { !blink.mojom.TranslatorCreateOptions } */
    this.options;
    /** @export { !boolean } */
    this.addFakeDownloadDelay;
  }
};



mojo.internal.Struct(
    blink.mojom.TranslationManager_TranslationAvailable_ParamsSpec.$,
    'TranslationManager_TranslationAvailable_Params',
    [
      mojo.internal.StructField(
        'sourceLang', 0,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetLang', 8,
        0,
        blink.mojom.TranslatorLanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.TranslationManager_TranslationAvailable_Params = class {
  constructor() {
    /** @export { !blink.mojom.TranslatorLanguageCode } */
    this.sourceLang;
    /** @export { !blink.mojom.TranslatorLanguageCode } */
    this.targetLang;
  }
};



mojo.internal.Struct(
    blink.mojom.TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
    'TranslationManager_TranslationAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CanCreateTranslatorResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.TranslationManager_TranslationAvailable_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CanCreateTranslatorResult } */
    this.result;
  }
};



mojo.internal.Union(
    blink.mojom.CreateTranslatorResultSpec.$, 'CreateTranslatorResult',
    {
      'translator': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(blink.mojom.TranslatorRemote),
      },
      'error': {
        'ordinal': 1,
        'type': blink.mojom.CreateTranslatorErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   translator: (!blink.mojom.TranslatorRemote|undefined),
 *   error: (!blink.mojom.CreateTranslatorError|undefined),
 * } }
 */
blink.mojom.CreateTranslatorResult;
