// third_party/blink/public/mojom/navigation/navigation_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/navigation/navigation_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function NavigationDownloadTypes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NavigationDownloadTypes.prototype.initDefaults_ = function() {
    this.viewSource = false;
    this.interstitial = false;
    this.openerCrossOrigin = false;
    this.adFrameNoGesture = false;
    this.adFrame = false;
    this.sandbox = false;
    this.noGesture = false;
  };
  NavigationDownloadTypes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NavigationDownloadTypes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  NavigationDownloadTypes.encodedSize = codec.kStructHeaderSize + 8;

  NavigationDownloadTypes.decode = function(decoder) {
    var packed;
    var val = new NavigationDownloadTypes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.viewSource = (packed >> 0) & 1 ? true : false;
    val.interstitial = (packed >> 1) & 1 ? true : false;
    val.openerCrossOrigin = (packed >> 2) & 1 ? true : false;
    val.adFrameNoGesture = (packed >> 3) & 1 ? true : false;
    val.adFrame = (packed >> 4) & 1 ? true : false;
    val.sandbox = (packed >> 5) & 1 ? true : false;
    val.noGesture = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NavigationDownloadTypes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NavigationDownloadTypes.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.viewSource & 1) << 0
    packed |= (val.interstitial & 1) << 1
    packed |= (val.openerCrossOrigin & 1) << 2
    packed |= (val.adFrameNoGesture & 1) << 3
    packed |= (val.adFrame & 1) << 4
    packed |= (val.sandbox & 1) << 5
    packed |= (val.noGesture & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NavigationDownloadPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NavigationDownloadPolicy.prototype.initDefaults_ = function() {
    this.observedTypes = null;
    this.disallowedTypes = null;
  };
  NavigationDownloadPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NavigationDownloadPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationDownloadPolicy.observedTypes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NavigationDownloadTypes, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationDownloadPolicy.disallowedTypes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, NavigationDownloadTypes, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NavigationDownloadPolicy.encodedSize = codec.kStructHeaderSize + 16;

  NavigationDownloadPolicy.decode = function(decoder) {
    var packed;
    var val = new NavigationDownloadPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observedTypes =
        decoder.decodeStructPointer(NavigationDownloadTypes);
    val.disallowedTypes =
        decoder.decodeStructPointer(NavigationDownloadTypes);
    return val;
  };

  NavigationDownloadPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NavigationDownloadPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NavigationDownloadTypes, val.observedTypes);
    encoder.encodeStructPointer(NavigationDownloadTypes, val.disallowedTypes);
  };
  exports.NavigationDownloadTypes = NavigationDownloadTypes;
  exports.NavigationDownloadPolicy = NavigationDownloadPolicy;
})();