// third_party/blink/public/mojom/messaging/cloneable_message.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::CloneableMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CloneableMessageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CloneableMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::encoded_message(input)) in_encoded_message = Traits::encoded_message(input);
      mojo::internal::MessageFragment<decltype(fragment->encoded_message)>
          encoded_message_fragment(fragment.message());
      encoded_message_fragment.Claim(&fragment->encoded_message);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_encoded_message,
        encoded_message_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->encoded_message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoded_message in CloneableMessage struct");

      decltype(Traits::blobs(input)) in_blobs = Traits::blobs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->blobs)::BaseType>
          blobs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& blobs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerializedBlobDataView>, send_validation>(
        in_blobs,
        blobs_fragment,
        &blobs_validate_params);

      fragment->blobs.Set(
          blobs_fragment.is_null() ? nullptr : blobs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->blobs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null blobs in CloneableMessage struct");

      decltype(Traits::sender_origin(input)) in_sender_origin = Traits::sender_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sender_origin)::BaseType> sender_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_sender_origin,
        sender_origin_fragment);

      fragment->sender_origin.Set(
          sender_origin_fragment.is_null() ? nullptr : sender_origin_fragment.data());

      fragment->stack_trace_id = Traits::stack_trace_id(input);

      fragment->stack_trace_debugger_id_first = Traits::stack_trace_debugger_id_first(input);

      fragment->stack_trace_debugger_id_second = Traits::stack_trace_debugger_id_second(input);

      fragment->stack_trace_should_pause = Traits::stack_trace_should_pause(input);

      decltype(Traits::sender_agent_cluster_id(input)) in_sender_agent_cluster_id = Traits::sender_agent_cluster_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sender_agent_cluster_id)::BaseType> sender_agent_cluster_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_sender_agent_cluster_id,
        sender_agent_cluster_id_fragment);

      fragment->sender_agent_cluster_id.Set(
          sender_agent_cluster_id_fragment.is_null() ? nullptr : sender_agent_cluster_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sender_agent_cluster_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sender_agent_cluster_id in CloneableMessage struct");

      fragment->locked_to_sender_agent_cluster = Traits::locked_to_sender_agent_cluster(input);

      decltype(Traits::file_system_access_tokens(input)) in_file_system_access_tokens = Traits::file_system_access_tokens(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_system_access_tokens)::BaseType>
          file_system_access_tokens_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_system_access_tokens_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>, send_validation>(
        in_file_system_access_tokens,
        file_system_access_tokens_fragment,
        &file_system_access_tokens_validate_params);

      fragment->file_system_access_tokens.Set(
          file_system_access_tokens_fragment.is_null() ? nullptr : file_system_access_tokens_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_system_access_tokens.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_system_access_tokens in CloneableMessage struct");
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_CLONEABLE_MESSAGE_MOJOM_SEND_VALIDATION_H_