// third_party/blink/public/mojom/mediastream/media_stream.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaStreamTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaStreamType = {
  
  NO_SERVICE: 0,
  DEVICE_AUDIO_CAPTURE: 1,
  DEVICE_VIDEO_CAPTURE: 2,
  GUM_TAB_AUDIO_CAPTURE: 3,
  GUM_TAB_VIDEO_CAPTURE: 4,
  GUM_DESKTOP_VIDEO_CAPTURE: 5,
  GUM_DESKTOP_AUDIO_CAPTURE: 6,
  DISPLAY_VIDEO_CAPTURE: 7,
  DISPLAY_AUDIO_CAPTURE: 8,
  DISPLAY_VIDEO_CAPTURE_THIS_TAB: 9,
  DISPLAY_VIDEO_CAPTURE_SET: 10,
  NUM_MEDIA_TYPES: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaStreamRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaStreamRequestResult = {
  
  OK: 0,
  PERMISSION_DENIED: 1,
  PERMISSION_DISMISSED: 2,
  INVALID_STATE: 3,
  NO_HARDWARE: 4,
  INVALID_SECURITY_ORIGIN: 5,
  TAB_CAPTURE_FAILURE: 6,
  SCREEN_CAPTURE_FAILURE: 7,
  CAPTURE_FAILURE: 8,
  CONSTRAINT_NOT_SATISFIED: 9,
  TRACK_START_FAILURE_AUDIO: 10,
  TRACK_START_FAILURE_VIDEO: 11,
  NOT_SUPPORTED: 12,
  FAILED_DUE_TO_SHUTDOWN: 13,
  KILL_SWITCH_ON: 14,
  PERMISSION_DENIED_BY_SYSTEM: 15,
  DEVICE_IN_USE: 16,
  REQUEST_CANCELLED: 17,
  START_TIMEOUT: 18,
  PERMISSION_DENIED_BY_USER: 19,
  NUM_MEDIA_REQUEST_RESULTS: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MediaStreamStateChangeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MediaStreamStateChange = {
  
  PLAY: 0,
  PAUSE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PreferredDisplaySurfaceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PreferredDisplaySurface = {
  
  NO_PREFERENCE: 0,
  MONITOR: 1,
  WINDOW: 2,
  BROWSER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CapturedSurfaceControlResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CapturedSurfaceControlResult = {
  
  kSuccess: 0,
  kUnknownError: 1,
  kNoPermissionError: 2,
  kCapturerNotFoundError: 3,
  kCapturedSurfaceNotFoundError: 4,
  kDisallowedForSelfCaptureError: 5,
  kCapturerNotFocusedError: 6,
  kMinZoomLevel: 7,
  kMaxZoomLevel: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ZoomLevelActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ZoomLevelAction = {
  
  kIncrease: 0,
  kDecrease: 1,
  kReset: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WindowAudioPreferenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WindowAudioPreference = {
  
  kSystem: 0,
  kWindow: 1,
  kExclude: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaStreamDeviceObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaStreamDeviceObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.MediaStreamDeviceObserverInterface }
 */
blink.mojom.MediaStreamDeviceObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaStreamDeviceObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaStreamDeviceObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaStreamDeviceObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } device
   */

  onDeviceStopped(
      label,
      device) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } oldDevice
   * @param { !blink.mojom.MediaStreamDevice } newDevice
   */

  onDeviceChanged(
      label,
      oldDevice,
      newDevice) {
    this.proxy.sendMessage(
        1,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        [
          label,
          oldDevice,
          newDevice
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } device
   * @param { !blink.mojom.MediaStreamStateChange } newState
   */

  onDeviceRequestStateChange(
      label,
      device,
      newState) {
    this.proxy.sendMessage(
        2,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        [
          label,
          device,
          newState
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } device
   */

  onDeviceCaptureConfigurationChange(
      label,
      device) {
    this.proxy.sendMessage(
        3,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } device
   */

  onDeviceCaptureHandleChange(
      label,
      device) {
    this.proxy.sendMessage(
        4,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        [
          label,
          device
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !blink.mojom.MediaStreamDevice } device
   * @param { !number } zoomLevel
   */

  onZoomLevelChange(
      label,
      device,
      zoomLevel) {
    this.proxy.sendMessage(
        5,
        blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        [
          label,
          device,
          zoomLevel
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaStreamDeviceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaStreamDeviceObserverReceiver = class {
  /**
   * @param {!blink.mojom.MediaStreamDeviceObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaStreamDeviceObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaStreamDeviceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamDeviceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        impl.onDeviceStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        impl.onDeviceChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        impl.onDeviceRequestStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        impl.onDeviceCaptureConfigurationChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        impl.onDeviceCaptureHandleChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        impl.onZoomLevelChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaStreamDeviceObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamDeviceObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaStreamDeviceObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaStreamDeviceObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaStreamDeviceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaStreamDeviceObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaStreamDeviceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamDeviceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
        null,
        this.onDeviceStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
        null,
        this.onDeviceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceRequestStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
        null,
        this.onDeviceRequestStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceCaptureConfigurationChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
        null,
        this.onDeviceCaptureConfigurationChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceCaptureHandleChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
        null,
        this.onDeviceCaptureHandleChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onZoomLevelChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
        null,
        this.onZoomLevelChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaStreamDispatcherHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaStreamDispatcherHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.MediaStreamDispatcherHostInterface }
 */
blink.mojom.MediaStreamDispatcherHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaStreamDispatcherHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaStreamDispatcherHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaStreamDispatcherHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !blink.mojom.StreamControls } controls
   * @param { !boolean } userGesture
   * @param { !blink.mojom.StreamSelectionInfo } audioStreamSelectionInfo
   * @return {!Promise<{
        result: !blink.mojom.MediaStreamRequestResult,
        label: !string,
        streamDevices: ?blink.mojom.StreamDevicesSet,
        panTiltZoomAllowed: !boolean,
   *  }>}
   */

  generateStreams(
      requestId,
      controls,
      userGesture,
      audioStreamSelectionInfo) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        [
          requestId,
          controls,
          userGesture,
          audioStreamSelectionInfo
        ],
        false);
  }

  
  /**
   * @param { !string } label
   * @param { !boolean } focus
   */

  focusCapturedSurface(
      label,
      focus) {
    this.proxy.sendMessage(
        1,
        blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        [
          label,
          focus
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   */

  cancelRequest(
      requestId) {
    this.proxy.sendMessage(
        2,
        blink.mojom.MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { !string } deviceId
   * @param { ?mojoBase.mojom.UnguessableToken } sessionId
   */

  stopStreamDevice(
      deviceId,
      sessionId) {
    this.proxy.sendMessage(
        3,
        blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } deviceId
   * @param { !blink.mojom.MediaStreamType } type
   * @return {!Promise<{
        success: !boolean,
        label: !string,
        device: !blink.mojom.MediaStreamDevice,
   *  }>}
   */

  openDevice(
      requestId,
      deviceId,
      type) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        [
          requestId,
          deviceId,
          type
        ],
        false);
  }

  
  /**
   * @param { !string } label
   */

  closeDevice(
      label) {
    this.proxy.sendMessage(
        5,
        blink.mojom.MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } sessionId
   * @param { !blink.mojom.MediaStreamType } type
   * @param { !boolean } isSecure
   */

  setCapturingLinkSecured(
      sessionId,
      type,
      isSecure) {
    this.proxy.sendMessage(
        6,
        blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        [
          sessionId,
          type,
          isSecure
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.SubCaptureTargetType } type
   * @param { !mojoBase.mojom.Token } subCaptureTarget
   * @param { !number } subCaptureTargetVersion
   * @return {!Promise<{
        result: !media.mojom.ApplySubCaptureTargetResult,
   *  }>}
   */

  applySubCaptureTarget(
      sessionId,
      type,
      subCaptureTarget,
      subCaptureTargetVersion) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        [
          sessionId,
          type,
          subCaptureTarget,
          subCaptureTargetVersion
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !blink.mojom.CapturedWheelAction } action
   */

  sendWheel(
      sessionId,
      action) {
    this.proxy.sendMessage(
        8,
        blink.mojom.MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        [
          sessionId,
          action
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !blink.mojom.ZoomLevelAction } action
   * @return {!Promise<{
        result: !blink.mojom.CapturedSurfaceControlResult,
   *  }>}
   */

  updateZoomLevel(
      sessionId,
      action) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        [
          sessionId,
          action
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @return {!Promise<{
        result: !blink.mojom.CapturedSurfaceControlResult,
   *  }>}
   */

  requestCapturedSurfaceControlPermission(
      sessionId) {
    return this.proxy.sendMessage(
        10,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !mojoBase.mojom.UnguessableToken } transferId
   * @return {!Promise<{
        result: !blink.mojom.MediaStreamRequestResult,
        response: ?blink.mojom.GetOpenDeviceResponse,
   *  }>}
   */

  getOpenDevice(
      requestId,
      sessionId,
      transferId) {
    return this.proxy.sendMessage(
        11,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        [
          requestId,
          sessionId,
          transferId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !mojoBase.mojom.UnguessableToken } transferId
   * @return {!Promise<{
        deviceFound: !boolean,
   *  }>}
   */

  keepDeviceAliveForTransfer(
      sessionId,
      transferId) {
    return this.proxy.sendMessage(
        12,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        [
          sessionId,
          transferId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaStreamDispatcherHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaStreamDispatcherHostReceiver = class {
  /**
   * @param {!blink.mojom.MediaStreamDispatcherHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaStreamDispatcherHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaStreamDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        impl.generateStreams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        impl.focusCapturedSurface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        impl.cancelRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        impl.stopStreamDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        impl.openDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        impl.closeDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        impl.setCapturingLinkSecured.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        impl.applySubCaptureTarget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        impl.sendWheel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        impl.updateZoomLevel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        impl.requestCapturedSurfaceControlPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        impl.getOpenDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        impl.keepDeviceAliveForTransfer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaStreamDispatcherHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamDispatcherHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaStreamDispatcherHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaStreamDispatcherHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaStreamDispatcherHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaStreamDispatcherHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaStreamDispatcherHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamDispatcherHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generateStreams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
        this.generateStreams.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusCapturedSurface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
        null,
        this.focusCapturedSurface.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
        null,
        this.cancelRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopStreamDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
        null,
        this.stopStreamDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
        this.openDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
        null,
        this.closeDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCapturingLinkSecured =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
        null,
        this.setCapturingLinkSecured.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applySubCaptureTarget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
        this.applySubCaptureTarget.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendWheel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
        null,
        this.sendWheel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateZoomLevel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
        this.updateZoomLevel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCapturedSurfaceControlPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
        this.requestCapturedSurfaceControlPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getOpenDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
        this.getOpenDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keepDeviceAliveForTransfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
        blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
        this.keepDeviceAliveForTransfer.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.MediaStreamTrackMetricsHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.MediaStreamTrackMetricsHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.MediaStreamTrackMetricsHostInterface }
 */
blink.mojom.MediaStreamTrackMetricsHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.MediaStreamTrackMetricsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.MediaStreamTrackMetricsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.MediaStreamTrackMetricsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } id
   * @param { !boolean } isAudio
   * @param { !boolean } isRemote
   */

  addTrack(
      id,
      isAudio,
      isRemote) {
    this.proxy.sendMessage(
        0,
        blink.mojom.MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        [
          id,
          isAudio,
          isRemote
        ],
        false);
  }

  
  /**
   * @param { !bigint } id
   */

  removeTrack(
      id) {
    this.proxy.sendMessage(
        1,
        blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaStreamTrackMetricsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.MediaStreamTrackMetricsHostReceiver = class {
  /**
   * @param {!blink.mojom.MediaStreamTrackMetricsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.MediaStreamTrackMetricsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.MediaStreamTrackMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamTrackMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        impl.addTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        impl.removeTrack.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.MediaStreamTrackMetricsHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaStreamTrackMetricsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.MediaStreamTrackMetricsHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.MediaStreamTrackMetricsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaStreamTrackMetricsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.MediaStreamTrackMetricsHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.MediaStreamTrackMetricsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.MediaStreamTrackMetricsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
        null,
        this.addTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
        null,
        this.removeTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SearchOnlyByDeviceIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SearchBySessionIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TrackControlsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StreamControlsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetOpenDeviceResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CapturedWheelActionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StreamDevicesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StreamDevicesSetSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_CancelRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_OpenDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_CloseDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_SendWheel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamTrackMetricsHost_AddTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.StreamSelectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SearchOnlyByDeviceIdSpec.$,
    'SearchOnlyByDeviceId',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SearchOnlyByDeviceId = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SearchBySessionIdSpec.$,
    'SearchBySessionId',
    [
      mojo.internal.StructField(
        'sessionIdMap', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase.mojom.UnguessableTokenSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SearchBySessionId = class {
  constructor() {
    /** @export { !Object<!string, !mojoBase.mojom.UnguessableToken> } */
    this.sessionIdMap;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceSpec.$,
    'MediaStreamDevice',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoFacing', 4,
        0,
        media.mojom.VideoFacingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'groupId', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchedOutputDeviceId', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'input', 48,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 56,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayMediaInfo', 64,
        0,
        media.mojom.DisplayMediaInformationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
blink.mojom.MediaStreamDevice = class {
  constructor() {
    /** @export { !blink.mojom.MediaStreamType } */
    this.type;
    /** @export { !string } */
    this.id;
    /** @export { !bigint } */
    this.displayId;
    /** @export { !media.mojom.VideoFacingMode } */
    this.videoFacing;
    /** @export { (string|undefined) } */
    this.groupId;
    /** @export { (string|undefined) } */
    this.matchedOutputDeviceId;
    /** @export { !string } */
    this.name;
    /** @export { !media.mojom.AudioParameters } */
    this.input;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.sessionId;
    /** @export { (media.mojom.DisplayMediaInformation|undefined) } */
    this.displayMediaInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.TrackControlsSpec.$,
    'TrackControls',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        blink.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceIds', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.TrackControls = class {
  constructor() {
    /** @export { !blink.mojom.MediaStreamType } */
    this.streamType;
    /** @export { !Array<!string> } */
    this.deviceIds;
  }
};



mojo.internal.Struct(
    blink.mojom.StreamControlsSpec.$,
    'StreamControls',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        blink.mojom.TrackControlsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'video', 8,
        0,
        blink.mojom.TrackControlsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hotwordEnabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableLocalEcho', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suppressLocalAudioPlayback', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'restrictOwnAudio', 16,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludeSystemAudio', 16,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowAudioPreference', 20,
        0,
        blink.mojom.WindowAudioPreferenceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludeSelfBrowserSurface', 16,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestPanTiltZoomPermission', 16,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestAllScreens', 16,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferredDisplaySurface', 24,
        0,
        blink.mojom.PreferredDisplaySurfaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dynamicSurfaceSwitchingRequested', 17,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludeMonitorTypeSurfaces', 17,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.StreamControls = class {
  constructor() {
    /** @export { !blink.mojom.TrackControls } */
    this.audio;
    /** @export { !blink.mojom.TrackControls } */
    this.video;
    /** @export { !boolean } */
    this.hotwordEnabled;
    /** @export { !boolean } */
    this.disableLocalEcho;
    /** @export { !boolean } */
    this.suppressLocalAudioPlayback;
    /** @export { !boolean } */
    this.restrictOwnAudio;
    /** @export { !boolean } */
    this.excludeSystemAudio;
    /** @export { !blink.mojom.WindowAudioPreference } */
    this.windowAudioPreference;
    /** @export { !boolean } */
    this.excludeSelfBrowserSurface;
    /** @export { !boolean } */
    this.requestPanTiltZoomPermission;
    /** @export { !boolean } */
    this.requestAllScreens;
    /** @export { !blink.mojom.PreferredDisplaySurface } */
    this.preferredDisplaySurface;
    /** @export { !boolean } */
    this.dynamicSurfaceSwitchingRequested;
    /** @export { !boolean } */
    this.excludeMonitorTypeSurfaces;
  }
};



mojo.internal.Struct(
    blink.mojom.GetOpenDeviceResponseSpec.$,
    'GetOpenDeviceResponse',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'panTiltZoomAllowed', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.GetOpenDeviceResponse = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
    /** @export { !boolean } */
    this.panTiltZoomAllowed;
  }
};



mojo.internal.Struct(
    blink.mojom.CapturedWheelActionSpec.$,
    'CapturedWheelAction',
    [
      mojo.internal.StructField(
        'relativeX', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'relativeY', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wheelDeltaX', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wheelDeltaY', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CapturedWheelAction = class {
  constructor() {
    /** @export { !number } */
    this.relativeX;
    /** @export { !number } */
    this.relativeY;
    /** @export { !number } */
    this.wheelDeltaX;
    /** @export { !number } */
    this.wheelDeltaY;
  }
};



mojo.internal.Struct(
    blink.mojom.StreamDevicesSpec.$,
    'StreamDevices',
    [
      mojo.internal.StructField(
        'audioDevice', 0,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoDevice', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.StreamDevices = class {
  constructor() {
    /** @export { (blink.mojom.MediaStreamDevice|undefined) } */
    this.audioDevice;
    /** @export { (blink.mojom.MediaStreamDevice|undefined) } */
    this.videoDevice;
  }
};



mojo.internal.Struct(
    blink.mojom.StreamDevicesSetSpec.$,
    'StreamDevicesSet',
    [
      mojo.internal.StructField(
        'streamDevices', 0,
        0,
        mojo.internal.Array(blink.mojom.StreamDevicesSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.StreamDevicesSet = class {
  constructor() {
    /** @export { !Array<!blink.mojom.StreamDevices> } */
    this.streamDevices;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceStopped_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnDeviceStopped_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceChanged_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'oldDevice', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newDevice', 16,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnDeviceChanged_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.oldDevice;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.newDevice;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newState', 16,
        0,
        blink.mojom.MediaStreamStateChangeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
    /** @export { !blink.mojom.MediaStreamStateChange } */
    this.newState;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_ParamsSpec.$,
    'MediaStreamDeviceObserver_OnZoomLevelChange_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 8,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'zoomLevel', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDeviceObserver_OnZoomLevelChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
    /** @export { !number } */
    this.zoomLevel;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ParamsSpec.$,
    'MediaStreamDispatcherHost_GenerateStreams_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controls', 8,
        0,
        blink.mojom.StreamControlsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioStreamSelectionInfo', 16,
        0,
        blink.mojom.StreamSelectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_GenerateStreams_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !blink.mojom.StreamControls } */
    this.controls;
    /** @export { !boolean } */
    this.userGesture;
    /** @export { !blink.mojom.StreamSelectionInfo } */
    this.audioStreamSelectionInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_GenerateStreams_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.MediaStreamRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamDevices', 16,
        0,
        blink.mojom.StreamDevicesSetSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'panTiltZoomAllowed', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_GenerateStreams_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.MediaStreamRequestResult } */
    this.result;
    /** @export { !string } */
    this.label;
    /** @export { (blink.mojom.StreamDevicesSet|undefined) } */
    this.streamDevices;
    /** @export { !boolean } */
    this.panTiltZoomAllowed;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_ParamsSpec.$,
    'MediaStreamDispatcherHost_FocusCapturedSurface_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'focus', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_FocusCapturedSurface_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
    /** @export { !boolean } */
    this.focus;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_CancelRequest_ParamsSpec.$,
    'MediaStreamDispatcherHost_CancelRequest_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_CancelRequest_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_StopStreamDevice_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_StopStreamDevice_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceId;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_OpenDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_OpenDevice_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        blink.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_OpenDevice_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.deviceId;
    /** @export { !blink.mojom.MediaStreamType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_OpenDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'device', 16,
        0,
        blink.mojom.MediaStreamDeviceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_OpenDevice_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.label;
    /** @export { !blink.mojom.MediaStreamDevice } */
    this.device;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_CloseDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_CloseDevice_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_CloseDevice_Params = class {
  constructor() {
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsSpec.$,
    'MediaStreamDispatcherHost_SetCapturingLinkSecured_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        blink.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSecure', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_SetCapturingLinkSecured_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.sessionId;
    /** @export { !blink.mojom.MediaStreamType } */
    this.type;
    /** @export { !boolean } */
    this.isSecure;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsSpec.$,
    'MediaStreamDispatcherHost_ApplySubCaptureTarget_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        media.mojom.SubCaptureTargetTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subCaptureTarget', 16,
        0,
        mojoBase.mojom.TokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subCaptureTargetVersion', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !media.mojom.SubCaptureTargetType } */
    this.type;
    /** @export { !mojoBase.mojom.Token } */
    this.subCaptureTarget;
    /** @export { !number } */
    this.subCaptureTargetVersion;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.ApplySubCaptureTargetResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.ApplySubCaptureTargetResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_SendWheel_ParamsSpec.$,
    'MediaStreamDispatcherHost_SendWheel_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        blink.mojom.CapturedWheelActionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_SendWheel_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !blink.mojom.CapturedWheelAction } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ParamsSpec.$,
    'MediaStreamDispatcherHost_UpdateZoomLevel_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        blink.mojom.ZoomLevelActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !blink.mojom.ZoomLevelAction } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CapturedSurfaceControlResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CapturedSurfaceControlResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsSpec.$,
    'MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.CapturedSurfaceControlResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CapturedSurfaceControlResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ParamsSpec.$,
    'MediaStreamDispatcherHost_GetOpenDevice_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transferId', 16,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.transferId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_GetOpenDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.MediaStreamRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink.mojom.GetOpenDeviceResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_GetOpenDevice_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.MediaStreamRequestResult } */
    this.result;
    /** @export { (blink.mojom.GetOpenDeviceResponse|undefined) } */
    this.response;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsSpec.$,
    'MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transferId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.transferId;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsSpec.$,
    'MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams',
    [
      mojo.internal.StructField(
        'deviceFound', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.deviceFound;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamTrackMetricsHost_AddTrack_ParamsSpec.$,
    'MediaStreamTrackMetricsHost_AddTrack_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAudio', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRemote', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.MediaStreamTrackMetricsHost_AddTrack_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.id;
    /** @export { !boolean } */
    this.isAudio;
    /** @export { !boolean } */
    this.isRemote;
  }
};



mojo.internal.Struct(
    blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_ParamsSpec.$,
    'MediaStreamTrackMetricsHost_RemoveTrack_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.MediaStreamTrackMetricsHost_RemoveTrack_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.id;
  }
};



mojo.internal.Union(
    blink.mojom.StreamSelectionInfoSpec.$, 'StreamSelectionInfo',
    {
      'searchOnlyByDeviceId': {
        'ordinal': 0,
        'type': blink.mojom.SearchOnlyByDeviceIdSpec.$,
      },
      'searchBySessionId': {
        'ordinal': 1,
        'type': blink.mojom.SearchBySessionIdSpec.$,
      },
    });

/**
 * @typedef { {
 *   searchOnlyByDeviceId: (!blink.mojom.SearchOnlyByDeviceId|undefined),
 *   searchBySessionId: (!blink.mojom.SearchBySessionId|undefined),
 * } }
 */
blink.mojom.StreamSelectionInfo;
