// third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/display_media_information.mojom-blink.h"
#include "mojo/public/mojom/base/token.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/mediastream/media_stream_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class MediaStreamDeviceObserverProxy;

template <typename ImplRefTraits>
class MediaStreamDeviceObserverStub;

class MediaStreamDeviceObserverRequestValidator;


class PLATFORM_EXPORT MediaStreamDeviceObserver
    : public MediaStreamDeviceObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MediaStreamDeviceObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaStreamDeviceObserverInterfaceBase;
  using Proxy_ = MediaStreamDeviceObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamDeviceObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamDeviceObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceStoppedMinVersion = 0,
    kOnDeviceChangedMinVersion = 0,
    kOnDeviceRequestStateChangeMinVersion = 0,
    kOnDeviceCaptureConfigurationChangeMinVersion = 0,
    kOnDeviceCaptureHandleChangeMinVersion = 0,
    kOnZoomLevelChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceRequestStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceCaptureConfigurationChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceCaptureHandleChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnZoomLevelChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaStreamDeviceObserver() = default;

  virtual void OnDeviceStopped(const ::blink::String& label, const ::blink::MediaStreamDevice& device) = 0;

  virtual void OnDeviceChanged(const ::blink::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) = 0;

  virtual void OnDeviceRequestStateChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, MediaStreamStateChange new_state) = 0;

  virtual void OnDeviceCaptureConfigurationChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) = 0;

  virtual void OnDeviceCaptureHandleChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) = 0;

  virtual void OnZoomLevelChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, int32_t zoom_level) = 0;
};

class MediaStreamDispatcherHostProxy;

template <typename ImplRefTraits>
class MediaStreamDispatcherHostStub;

class MediaStreamDispatcherHostRequestValidator;
class MediaStreamDispatcherHostResponseValidator;


class PLATFORM_EXPORT MediaStreamDispatcherHost
    : public MediaStreamDispatcherHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MediaStreamDispatcherHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    11
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaStreamDispatcherHostInterfaceBase;
  using Proxy_ = MediaStreamDispatcherHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamDispatcherHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamDispatcherHostRequestValidator;
  using ResponseValidator_ = MediaStreamDispatcherHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateStreamsMinVersion = 0,
    kFocusCapturedSurfaceMinVersion = 0,
    kCancelRequestMinVersion = 0,
    kStopStreamDeviceMinVersion = 0,
    kOpenDeviceMinVersion = 0,
    kCloseDeviceMinVersion = 0,
    kSetCapturingLinkSecuredMinVersion = 0,
    kApplySubCaptureTargetMinVersion = 0,
    kSendWheelMinVersion = 0,
    kUpdateZoomLevelMinVersion = 0,
    kRequestCapturedSurfaceControlPermissionMinVersion = 0,
    kGetOpenDeviceMinVersion = 0,
    kKeepDeviceAliveForTransferMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GenerateStreams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusCapturedSurface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopStreamDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCapturingLinkSecured_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplySubCaptureTarget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendWheel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateZoomLevel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestCapturedSurfaceControlPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOpenDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct KeepDeviceAliveForTransfer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaStreamDispatcherHost() = default;

  using GenerateStreamsCallback = base::OnceCallback<void(MediaStreamRequestResult, const ::blink::String&, StreamDevicesSetPtr, bool)>;
  using GenerateStreamsMojoCallback = base::OnceCallback<void(MediaStreamRequestResult, const ::blink::String&, StreamDevicesSetPtr, bool)>;

  virtual void GenerateStreams(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamsCallback callback) = 0;

  virtual void FocusCapturedSurface(const ::blink::String& label, bool focus) = 0;

  virtual void CancelRequest(int32_t request_id) = 0;

  virtual void StopStreamDevice(const ::blink::String& device_id, const std::optional<::base::UnguessableToken>& session_id) = 0;

  using OpenDeviceCallback = base::OnceCallback<void(bool, const ::blink::String&, const ::blink::MediaStreamDevice&)>;
  using OpenDeviceMojoCallback = base::OnceCallback<void(bool, const ::blink::String&, const ::blink::MediaStreamDevice&)>;

  virtual void OpenDevice(int32_t request_id, const ::blink::String& device_id, MediaStreamType type, OpenDeviceCallback callback) = 0;

  virtual void CloseDevice(const ::blink::String& label) = 0;

  virtual void SetCapturingLinkSecured(const std::optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) = 0;

  using ApplySubCaptureTargetCallback = base::OnceCallback<void(::media::mojom::blink::ApplySubCaptureTargetResult)>;
  using ApplySubCaptureTargetMojoCallback = base::OnceCallback<void(::media::mojom::blink::ApplySubCaptureTargetResult)>;

  virtual void ApplySubCaptureTarget(const ::base::UnguessableToken& session_id, ::media::mojom::blink::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ApplySubCaptureTargetCallback callback) = 0;

  virtual void SendWheel(const ::base::UnguessableToken& session_id, CapturedWheelActionPtr action) = 0;

  using UpdateZoomLevelCallback = base::OnceCallback<void(CapturedSurfaceControlResult)>;
  using UpdateZoomLevelMojoCallback = base::OnceCallback<void(CapturedSurfaceControlResult)>;

  virtual void UpdateZoomLevel(const ::base::UnguessableToken& session_id, ZoomLevelAction action, UpdateZoomLevelCallback callback) = 0;

  using RequestCapturedSurfaceControlPermissionCallback = base::OnceCallback<void(CapturedSurfaceControlResult)>;
  using RequestCapturedSurfaceControlPermissionMojoCallback = base::OnceCallback<void(CapturedSurfaceControlResult)>;

  virtual void RequestCapturedSurfaceControlPermission(const ::base::UnguessableToken& session_id, RequestCapturedSurfaceControlPermissionCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response);
  using GetOpenDeviceCallback = base::OnceCallback<void(MediaStreamRequestResult, GetOpenDeviceResponsePtr)>;
  using GetOpenDeviceMojoCallback = base::OnceCallback<void(MediaStreamRequestResult, GetOpenDeviceResponsePtr)>;

  virtual void GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, GetOpenDeviceCallback callback) = 0;

  using KeepDeviceAliveForTransferCallback = base::OnceCallback<void(bool)>;
  using KeepDeviceAliveForTransferMojoCallback = base::OnceCallback<void(bool)>;

  virtual void KeepDeviceAliveForTransfer(const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, KeepDeviceAliveForTransferCallback callback) = 0;
};

class MediaStreamTrackMetricsHostProxy;

template <typename ImplRefTraits>
class MediaStreamTrackMetricsHostStub;

class MediaStreamTrackMetricsHostRequestValidator;


class PLATFORM_EXPORT MediaStreamTrackMetricsHost
    : public MediaStreamTrackMetricsHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MediaStreamTrackMetricsHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaStreamTrackMetricsHostInterfaceBase;
  using Proxy_ = MediaStreamTrackMetricsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamTrackMetricsHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamTrackMetricsHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddTrackMinVersion = 0,
    kRemoveTrackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaStreamTrackMetricsHost() = default;

  virtual void AddTrack(uint64_t id, bool is_audio, bool is_remote) = 0;

  virtual void RemoveTrack(uint64_t id) = 0;
};



class PLATFORM_EXPORT MediaStreamDeviceObserverProxy
    : public MediaStreamDeviceObserver {
 public:
  using InterfaceType = MediaStreamDeviceObserver;

  explicit MediaStreamDeviceObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceStopped(const ::blink::String& label, const ::blink::MediaStreamDevice& device) final;
  
  void OnDeviceChanged(const ::blink::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) final;
  
  void OnDeviceRequestStateChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, MediaStreamStateChange new_state) final;
  
  void OnDeviceCaptureConfigurationChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) final;
  
  void OnDeviceCaptureHandleChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) final;
  
  void OnZoomLevelChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, int32_t zoom_level) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT MediaStreamDispatcherHostProxy
    : public MediaStreamDispatcherHost {
 public:
  using InterfaceType = MediaStreamDispatcherHost;

  explicit MediaStreamDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GenerateStreams(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamsCallback callback) final;
  
  void FocusCapturedSurface(const ::blink::String& label, bool focus) final;
  
  void CancelRequest(int32_t request_id) final;
  
  void StopStreamDevice(const ::blink::String& device_id, const std::optional<::base::UnguessableToken>& session_id) final;
  
  void OpenDevice(int32_t request_id, const ::blink::String& device_id, MediaStreamType type, OpenDeviceCallback callback) final;
  
  void CloseDevice(const ::blink::String& label) final;
  
  void SetCapturingLinkSecured(const std::optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) final;
  
  void ApplySubCaptureTarget(const ::base::UnguessableToken& session_id, ::media::mojom::blink::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ApplySubCaptureTargetCallback callback) final;
  
  void SendWheel(const ::base::UnguessableToken& session_id, CapturedWheelActionPtr action) final;
  
  void UpdateZoomLevel(const ::base::UnguessableToken& session_id, ZoomLevelAction action, UpdateZoomLevelCallback callback) final;
  
  void RequestCapturedSurfaceControlPermission(const ::base::UnguessableToken& session_id, RequestCapturedSurfaceControlPermissionCallback callback) final;
  
  bool GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response) final;
  
  void GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, GetOpenDeviceCallback callback) final;
  
  void KeepDeviceAliveForTransfer(const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, KeepDeviceAliveForTransferCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT MediaStreamTrackMetricsHostProxy
    : public MediaStreamTrackMetricsHost {
 public:
  using InterfaceType = MediaStreamTrackMetricsHost;

  explicit MediaStreamTrackMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddTrack(uint64_t id, bool is_audio, bool is_remote) final;
  
  void RemoveTrack(uint64_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT MediaStreamDeviceObserverStubDispatch {
 public:
  static bool Accept(MediaStreamDeviceObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamDeviceObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamDeviceObserver>>
class MediaStreamDeviceObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamDeviceObserverStub() = default;
  ~MediaStreamDeviceObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDeviceObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDeviceObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostStubDispatch {
 public:
  static bool Accept(MediaStreamDispatcherHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamDispatcherHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamDispatcherHost>>
class MediaStreamDispatcherHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamDispatcherHostStub() = default;
  ~MediaStreamDispatcherHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDispatcherHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDispatcherHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamTrackMetricsHostStubDispatch {
 public:
  static bool Accept(MediaStreamTrackMetricsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamTrackMetricsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamTrackMetricsHost>>
class MediaStreamTrackMetricsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamTrackMetricsHostStub() = default;
  ~MediaStreamTrackMetricsHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamTrackMetricsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamTrackMetricsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamDeviceObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamTrackMetricsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT SearchOnlyByDeviceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchOnlyByDeviceId, T>::value>;
  using DataView = SearchOnlyByDeviceIdDataView;
  using Data_ = internal::SearchOnlyByDeviceId_Data;

  template <typename... Args>
  static SearchOnlyByDeviceIdPtr New(Args&&... args) {
    return SearchOnlyByDeviceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchOnlyByDeviceIdPtr From(const U& u) {
    return mojo::TypeConverter<SearchOnlyByDeviceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchOnlyByDeviceId>::Convert(*this);
  }


  SearchOnlyByDeviceId();


  ~SearchOnlyByDeviceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchOnlyByDeviceIdPtr>
  SearchOnlyByDeviceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchOnlyByDeviceId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchOnlyByDeviceId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchOnlyByDeviceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchOnlyByDeviceId_UnserializedMessageContext<
            UserType, SearchOnlyByDeviceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchOnlyByDeviceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchOnlyByDeviceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchOnlyByDeviceId_UnserializedMessageContext<
            UserType, SearchOnlyByDeviceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchOnlyByDeviceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT CapturedWheelAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CapturedWheelAction, T>::value>;
  using DataView = CapturedWheelActionDataView;
  using Data_ = internal::CapturedWheelAction_Data;

  template <typename... Args>
  static CapturedWheelActionPtr New(Args&&... args) {
    return CapturedWheelActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CapturedWheelActionPtr From(const U& u) {
    return mojo::TypeConverter<CapturedWheelActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CapturedWheelAction>::Convert(*this);
  }


  CapturedWheelAction();

  CapturedWheelAction(
      double relative_x,
      double relative_y,
      int32_t wheel_delta_x,
      int32_t wheel_delta_y);


  ~CapturedWheelAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CapturedWheelActionPtr>
  CapturedWheelActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CapturedWheelAction::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CapturedWheelAction::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CapturedWheelAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CapturedWheelAction_UnserializedMessageContext<
            UserType, CapturedWheelAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CapturedWheelAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CapturedWheelAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CapturedWheelAction_UnserializedMessageContext<
            UserType, CapturedWheelAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CapturedWheelAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double relative_x;
  
  double relative_y;
  
  int32_t wheel_delta_x;
  
  int32_t wheel_delta_y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CapturedWheelAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT StreamSelectionInfo {
 public:
  using DataView = StreamSelectionInfoDataView;
  using Data_ = internal::StreamSelectionInfo_Data;
  using Tag = Data_::StreamSelectionInfo_Tag;

  template <typename... Args>
  static StreamSelectionInfoPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |search_only_by_device_id|.
  static StreamSelectionInfoPtr NewSearchOnlyByDeviceId(
      SearchOnlyByDeviceIdPtr value);
  // Construct an instance holding |search_by_session_id|.
  static StreamSelectionInfoPtr NewSearchBySessionId(
      SearchBySessionIdPtr value);

  template <typename U>
  static StreamSelectionInfoPtr From(const U& u) {
    return mojo::TypeConverter<StreamSelectionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamSelectionInfo>::Convert(*this);
  }
  ~StreamSelectionInfo();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  StreamSelectionInfo(const StreamSelectionInfo& other) = delete;
  StreamSelectionInfo& operator=(const StreamSelectionInfo& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = StreamSelectionInfoPtr>
  StreamSelectionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, StreamSelectionInfo>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, StreamSelectionInfo>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_search_only_by_device_id() const { return tag_ == Tag::kSearchOnlyByDeviceId; }
  const SearchOnlyByDeviceIdPtr& get_search_only_by_device_id() const {
    CHECK(tag_ == Tag::kSearchOnlyByDeviceId);
    return data_.search_only_by_device_id;
  }
  SearchOnlyByDeviceIdPtr& get_search_only_by_device_id() {
    CHECK(tag_ == Tag::kSearchOnlyByDeviceId);
    return data_.search_only_by_device_id;
  }
  void set_search_only_by_device_id(SearchOnlyByDeviceIdPtr search_only_by_device_id);

  bool is_search_by_session_id() const { return tag_ == Tag::kSearchBySessionId; }
  const SearchBySessionIdPtr& get_search_by_session_id() const {
    CHECK(tag_ == Tag::kSearchBySessionId);
    return data_.search_by_session_id;
  }
  SearchBySessionIdPtr& get_search_by_session_id() {
    CHECK(tag_ == Tag::kSearchBySessionId);
    return data_.search_by_session_id;
  }
  void set_search_by_session_id(SearchBySessionIdPtr search_by_session_id);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamSelectionInfo::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<StreamSelectionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
        SearchOnlyByDeviceIdPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSearchBySessionId)>,
        SearchBySessionIdPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SearchOnlyByDeviceIdPtr search_only_by_device_id;
    SearchBySessionIdPtr search_by_session_id;
  };

  StreamSelectionInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
      SearchOnlyByDeviceIdPtr value);
  StreamSelectionInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kSearchBySessionId)>,
      SearchBySessionIdPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class PLATFORM_EXPORT SearchBySessionId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchBySessionId, T>::value>;
  using DataView = SearchBySessionIdDataView;
  using Data_ = internal::SearchBySessionId_Data;

  template <typename... Args>
  static SearchBySessionIdPtr New(Args&&... args) {
    return SearchBySessionIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchBySessionIdPtr From(const U& u) {
    return mojo::TypeConverter<SearchBySessionIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchBySessionId>::Convert(*this);
  }


  SearchBySessionId();

  explicit SearchBySessionId(
      const ::blink::HashMap<::blink::String, ::base::UnguessableToken>& session_id_map);


  ~SearchBySessionId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchBySessionIdPtr>
  SearchBySessionIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchBySessionId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchBySessionId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchBySessionId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchBySessionId_UnserializedMessageContext<
            UserType, SearchBySessionId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchBySessionId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchBySessionId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchBySessionId_UnserializedMessageContext<
            UserType, SearchBySessionId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchBySessionId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, ::base::UnguessableToken> session_id_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchBySessionId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT MediaStreamDevice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaStreamDevice, T>::value>;
  using DataView = MediaStreamDeviceDataView;
  using Data_ = internal::MediaStreamDevice_Data;

  template <typename... Args>
  static MediaStreamDevicePtr New(Args&&... args) {
    return MediaStreamDevicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaStreamDevicePtr From(const U& u) {
    return mojo::TypeConverter<MediaStreamDevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaStreamDevice>::Convert(*this);
  }


  MediaStreamDevice();

  MediaStreamDevice(
      MediaStreamType type,
      const ::blink::String& id,
      int64_t display_id,
      ::media::VideoFacingMode video_facing,
      const ::blink::String& group_id,
      const ::blink::String& matched_output_device_id,
      const ::blink::String& name,
      const ::media::AudioParameters& input,
      const std::optional<::base::UnguessableToken>& session_id,
      ::media::mojom::blink::DisplayMediaInformationPtr display_media_info);

MediaStreamDevice(const MediaStreamDevice&) = delete;
MediaStreamDevice& operator=(const MediaStreamDevice&) = delete;

  ~MediaStreamDevice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaStreamDevicePtr>
  MediaStreamDevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaStreamDevice::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaStreamDevice::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaStreamDevice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaStreamDevice_UnserializedMessageContext<
            UserType, MediaStreamDevice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaStreamDevice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaStreamDevice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaStreamDevice_UnserializedMessageContext<
            UserType, MediaStreamDevice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaStreamDevice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  MediaStreamType type;
  
  ::blink::String id;
  
  int64_t display_id;
  
  ::media::VideoFacingMode video_facing;
  
  ::blink::String group_id;
  
  ::blink::String matched_output_device_id;
  
  ::blink::String name;
  
  ::media::AudioParameters input;
  
  std::optional<::base::UnguessableToken> session_id;
  
  ::media::mojom::blink::DisplayMediaInformationPtr display_media_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TrackControls {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrackControls, T>::value>;
  using DataView = TrackControlsDataView;
  using Data_ = internal::TrackControls_Data;

  template <typename... Args>
  static TrackControlsPtr New(Args&&... args) {
    return TrackControlsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrackControlsPtr From(const U& u) {
    return mojo::TypeConverter<TrackControlsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrackControls>::Convert(*this);
  }


  TrackControls();

  TrackControls(
      MediaStreamType stream_type,
      ::blink::Vector<::blink::String> device_ids);


  ~TrackControls();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrackControlsPtr>
  TrackControlsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrackControls::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrackControls::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrackControls::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrackControls_UnserializedMessageContext<
            UserType, TrackControls::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrackControls::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrackControls::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrackControls_UnserializedMessageContext<
            UserType, TrackControls::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrackControls::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  MediaStreamType stream_type;
  
  ::blink::Vector<::blink::String> device_ids;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT StreamControls {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamControls, T>::value>;
  using DataView = StreamControlsDataView;
  using Data_ = internal::StreamControls_Data;

  template <typename... Args>
  static StreamControlsPtr New(Args&&... args) {
    return StreamControlsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamControlsPtr From(const U& u) {
    return mojo::TypeConverter<StreamControlsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamControls>::Convert(*this);
  }


  StreamControls();

  StreamControls(
      const ::blink::TrackControls& audio,
      const ::blink::TrackControls& video,
      bool hotword_enabled,
      bool disable_local_echo,
      bool suppress_local_audio_playback,
      bool restrict_own_audio,
      bool exclude_system_audio,
      WindowAudioPreference window_audio_preference,
      bool exclude_self_browser_surface,
      bool request_pan_tilt_zoom_permission,
      bool request_all_screens,
      PreferredDisplaySurface preferred_display_surface,
      bool dynamic_surface_switching_requested,
      bool exclude_monitor_type_surfaces);


  ~StreamControls();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamControlsPtr>
  StreamControlsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamControls::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamControls::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamControls::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamControls_UnserializedMessageContext<
            UserType, StreamControls::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StreamControls::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StreamControls::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamControls_UnserializedMessageContext<
            UserType, StreamControls::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamControls::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::TrackControls audio;
  
  ::blink::TrackControls video;
  
  bool hotword_enabled;
  
  bool disable_local_echo;
  
  bool suppress_local_audio_playback;
  
  bool restrict_own_audio;
  
  bool exclude_system_audio;
  
  WindowAudioPreference window_audio_preference;
  
  bool exclude_self_browser_surface;
  
  bool request_pan_tilt_zoom_permission;
  
  bool request_all_screens;
  
  PreferredDisplaySurface preferred_display_surface;
  
  bool dynamic_surface_switching_requested;
  
  bool exclude_monitor_type_surfaces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT GetOpenDeviceResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetOpenDeviceResponse, T>::value>;
  using DataView = GetOpenDeviceResponseDataView;
  using Data_ = internal::GetOpenDeviceResponse_Data;

  template <typename... Args>
  static GetOpenDeviceResponsePtr New(Args&&... args) {
    return GetOpenDeviceResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetOpenDeviceResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetOpenDeviceResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetOpenDeviceResponse>::Convert(*this);
  }


  GetOpenDeviceResponse();

  GetOpenDeviceResponse(
      const ::blink::String& label,
      const ::blink::MediaStreamDevice& device,
      bool pan_tilt_zoom_allowed);


  ~GetOpenDeviceResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetOpenDeviceResponsePtr>
  GetOpenDeviceResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetOpenDeviceResponse::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetOpenDeviceResponse::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetOpenDeviceResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetOpenDeviceResponse_UnserializedMessageContext<
            UserType, GetOpenDeviceResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetOpenDeviceResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetOpenDeviceResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetOpenDeviceResponse_UnserializedMessageContext<
            UserType, GetOpenDeviceResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetOpenDeviceResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String label;
  
  ::blink::MediaStreamDevice device;
  
  bool pan_tilt_zoom_allowed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetOpenDeviceResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT StreamDevices {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamDevices, T>::value>;
  using DataView = StreamDevicesDataView;
  using Data_ = internal::StreamDevices_Data;

  template <typename... Args>
  static StreamDevicesPtr New(Args&&... args) {
    return StreamDevicesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamDevicesPtr From(const U& u) {
    return mojo::TypeConverter<StreamDevicesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamDevices>::Convert(*this);
  }


  StreamDevices();

  StreamDevices(
      const std::optional<::blink::MediaStreamDevice>& audio_device,
      const std::optional<::blink::MediaStreamDevice>& video_device);


  ~StreamDevices();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamDevicesPtr>
  StreamDevicesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamDevices::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamDevices::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamDevices::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamDevices_UnserializedMessageContext<
            UserType, StreamDevices::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StreamDevices::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StreamDevices::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamDevices_UnserializedMessageContext<
            UserType, StreamDevices::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamDevices::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::MediaStreamDevice> audio_device;
  
  std::optional<::blink::MediaStreamDevice> video_device;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamDevices::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT StreamDevicesSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamDevicesSet, T>::value>;
  using DataView = StreamDevicesSetDataView;
  using Data_ = internal::StreamDevicesSet_Data;

  template <typename... Args>
  static StreamDevicesSetPtr New(Args&&... args) {
    return StreamDevicesSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamDevicesSetPtr From(const U& u) {
    return mojo::TypeConverter<StreamDevicesSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamDevicesSet>::Convert(*this);
  }


  StreamDevicesSet();

  explicit StreamDevicesSet(
      ::blink::Vector<StreamDevicesPtr> stream_devices);

StreamDevicesSet(const StreamDevicesSet&) = delete;
StreamDevicesSet& operator=(const StreamDevicesSet&) = delete;

  ~StreamDevicesSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamDevicesSetPtr>
  StreamDevicesSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamDevicesSet::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamDevicesSet::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamDevicesSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamDevicesSet_UnserializedMessageContext<
            UserType, StreamDevicesSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StreamDevicesSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StreamDevicesSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamDevicesSet_UnserializedMessageContext<
            UserType, StreamDevicesSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamDevicesSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<StreamDevicesPtr> stream_devices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamDevicesSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
StreamSelectionInfoPtr StreamSelectionInfo::Clone() const {
  switch (tag_) {
    case Tag::kSearchOnlyByDeviceId:
      return NewSearchOnlyByDeviceId(
          mojo::Clone(data_.search_only_by_device_id));
    case Tag::kSearchBySessionId:
      return NewSearchBySessionId(
          mojo::Clone(data_.search_by_session_id));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, StreamSelectionInfo>::value>::type*>
bool StreamSelectionInfo::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSearchOnlyByDeviceId:
      return mojo::Equals(data_.search_only_by_device_id, other.data_.search_only_by_device_id);
    case Tag::kSearchBySessionId:
      return mojo::Equals(data_.search_by_session_id, other.data_.search_by_session_id);
  }

  return false;
}
template <typename StructPtrType>
SearchOnlyByDeviceIdPtr SearchOnlyByDeviceId::Clone() const {
  return New(
  );
}

template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>*>
bool SearchOnlyByDeviceId::Equals(const T& other_struct) const {
  return true;
}

template <typename T, SearchOnlyByDeviceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
SearchBySessionIdPtr SearchBySessionId::Clone() const {
  return New(
      mojo::Clone(session_id_map)
  );
}

template <typename T, SearchBySessionId::EnableIfSame<T>*>
bool SearchBySessionId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_id_map, other_struct.session_id_map))
    return false;
  return true;
}

template <typename T, SearchBySessionId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_id_map < rhs.session_id_map)
    return true;
  if (rhs.session_id_map < lhs.session_id_map)
    return false;
  return false;
}
template <typename StructPtrType>
MediaStreamDevicePtr MediaStreamDevice::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id),
      mojo::Clone(display_id),
      mojo::Clone(video_facing),
      mojo::Clone(group_id),
      mojo::Clone(matched_output_device_id),
      mojo::Clone(name),
      mojo::Clone(input),
      mojo::Clone(session_id),
      mojo::Clone(display_media_info)
  );
}

template <typename T, MediaStreamDevice::EnableIfSame<T>*>
bool MediaStreamDevice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->display_id, other_struct.display_id))
    return false;
  if (!mojo::Equals(this->video_facing, other_struct.video_facing))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->matched_output_device_id, other_struct.matched_output_device_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->display_media_info, other_struct.display_media_info))
    return false;
  return true;
}

template <typename T, MediaStreamDevice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.display_id < rhs.display_id)
    return true;
  if (rhs.display_id < lhs.display_id)
    return false;
  if (lhs.video_facing < rhs.video_facing)
    return true;
  if (rhs.video_facing < lhs.video_facing)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.matched_output_device_id < rhs.matched_output_device_id)
    return true;
  if (rhs.matched_output_device_id < lhs.matched_output_device_id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  if (lhs.session_id < rhs.session_id)
    return true;
  if (rhs.session_id < lhs.session_id)
    return false;
  if (lhs.display_media_info < rhs.display_media_info)
    return true;
  if (rhs.display_media_info < lhs.display_media_info)
    return false;
  return false;
}
template <typename StructPtrType>
TrackControlsPtr TrackControls::Clone() const {
  return New(
      mojo::Clone(stream_type),
      mojo::Clone(device_ids)
  );
}

template <typename T, TrackControls::EnableIfSame<T>*>
bool TrackControls::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stream_type, other_struct.stream_type))
    return false;
  if (!mojo::Equals(this->device_ids, other_struct.device_ids))
    return false;
  return true;
}

template <typename T, TrackControls::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stream_type < rhs.stream_type)
    return true;
  if (rhs.stream_type < lhs.stream_type)
    return false;
  if (lhs.device_ids < rhs.device_ids)
    return true;
  if (rhs.device_ids < lhs.device_ids)
    return false;
  return false;
}
template <typename StructPtrType>
StreamControlsPtr StreamControls::Clone() const {
  return New(
      mojo::Clone(audio),
      mojo::Clone(video),
      mojo::Clone(hotword_enabled),
      mojo::Clone(disable_local_echo),
      mojo::Clone(suppress_local_audio_playback),
      mojo::Clone(restrict_own_audio),
      mojo::Clone(exclude_system_audio),
      mojo::Clone(window_audio_preference),
      mojo::Clone(exclude_self_browser_surface),
      mojo::Clone(request_pan_tilt_zoom_permission),
      mojo::Clone(request_all_screens),
      mojo::Clone(preferred_display_surface),
      mojo::Clone(dynamic_surface_switching_requested),
      mojo::Clone(exclude_monitor_type_surfaces)
  );
}

template <typename T, StreamControls::EnableIfSame<T>*>
bool StreamControls::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio, other_struct.audio))
    return false;
  if (!mojo::Equals(this->video, other_struct.video))
    return false;
  if (!mojo::Equals(this->hotword_enabled, other_struct.hotword_enabled))
    return false;
  if (!mojo::Equals(this->disable_local_echo, other_struct.disable_local_echo))
    return false;
  if (!mojo::Equals(this->suppress_local_audio_playback, other_struct.suppress_local_audio_playback))
    return false;
  if (!mojo::Equals(this->restrict_own_audio, other_struct.restrict_own_audio))
    return false;
  if (!mojo::Equals(this->exclude_system_audio, other_struct.exclude_system_audio))
    return false;
  if (!mojo::Equals(this->window_audio_preference, other_struct.window_audio_preference))
    return false;
  if (!mojo::Equals(this->exclude_self_browser_surface, other_struct.exclude_self_browser_surface))
    return false;
  if (!mojo::Equals(this->request_pan_tilt_zoom_permission, other_struct.request_pan_tilt_zoom_permission))
    return false;
  if (!mojo::Equals(this->request_all_screens, other_struct.request_all_screens))
    return false;
  if (!mojo::Equals(this->preferred_display_surface, other_struct.preferred_display_surface))
    return false;
  if (!mojo::Equals(this->dynamic_surface_switching_requested, other_struct.dynamic_surface_switching_requested))
    return false;
  if (!mojo::Equals(this->exclude_monitor_type_surfaces, other_struct.exclude_monitor_type_surfaces))
    return false;
  return true;
}

template <typename T, StreamControls::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio < rhs.audio)
    return true;
  if (rhs.audio < lhs.audio)
    return false;
  if (lhs.video < rhs.video)
    return true;
  if (rhs.video < lhs.video)
    return false;
  if (lhs.hotword_enabled < rhs.hotword_enabled)
    return true;
  if (rhs.hotword_enabled < lhs.hotword_enabled)
    return false;
  if (lhs.disable_local_echo < rhs.disable_local_echo)
    return true;
  if (rhs.disable_local_echo < lhs.disable_local_echo)
    return false;
  if (lhs.suppress_local_audio_playback < rhs.suppress_local_audio_playback)
    return true;
  if (rhs.suppress_local_audio_playback < lhs.suppress_local_audio_playback)
    return false;
  if (lhs.restrict_own_audio < rhs.restrict_own_audio)
    return true;
  if (rhs.restrict_own_audio < lhs.restrict_own_audio)
    return false;
  if (lhs.exclude_system_audio < rhs.exclude_system_audio)
    return true;
  if (rhs.exclude_system_audio < lhs.exclude_system_audio)
    return false;
  if (lhs.window_audio_preference < rhs.window_audio_preference)
    return true;
  if (rhs.window_audio_preference < lhs.window_audio_preference)
    return false;
  if (lhs.exclude_self_browser_surface < rhs.exclude_self_browser_surface)
    return true;
  if (rhs.exclude_self_browser_surface < lhs.exclude_self_browser_surface)
    return false;
  if (lhs.request_pan_tilt_zoom_permission < rhs.request_pan_tilt_zoom_permission)
    return true;
  if (rhs.request_pan_tilt_zoom_permission < lhs.request_pan_tilt_zoom_permission)
    return false;
  if (lhs.request_all_screens < rhs.request_all_screens)
    return true;
  if (rhs.request_all_screens < lhs.request_all_screens)
    return false;
  if (lhs.preferred_display_surface < rhs.preferred_display_surface)
    return true;
  if (rhs.preferred_display_surface < lhs.preferred_display_surface)
    return false;
  if (lhs.dynamic_surface_switching_requested < rhs.dynamic_surface_switching_requested)
    return true;
  if (rhs.dynamic_surface_switching_requested < lhs.dynamic_surface_switching_requested)
    return false;
  if (lhs.exclude_monitor_type_surfaces < rhs.exclude_monitor_type_surfaces)
    return true;
  if (rhs.exclude_monitor_type_surfaces < lhs.exclude_monitor_type_surfaces)
    return false;
  return false;
}
template <typename StructPtrType>
GetOpenDeviceResponsePtr GetOpenDeviceResponse::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(device),
      mojo::Clone(pan_tilt_zoom_allowed)
  );
}

template <typename T, GetOpenDeviceResponse::EnableIfSame<T>*>
bool GetOpenDeviceResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->device, other_struct.device))
    return false;
  if (!mojo::Equals(this->pan_tilt_zoom_allowed, other_struct.pan_tilt_zoom_allowed))
    return false;
  return true;
}

template <typename T, GetOpenDeviceResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.device < rhs.device)
    return true;
  if (rhs.device < lhs.device)
    return false;
  if (lhs.pan_tilt_zoom_allowed < rhs.pan_tilt_zoom_allowed)
    return true;
  if (rhs.pan_tilt_zoom_allowed < lhs.pan_tilt_zoom_allowed)
    return false;
  return false;
}
template <typename StructPtrType>
CapturedWheelActionPtr CapturedWheelAction::Clone() const {
  return New(
      mojo::Clone(relative_x),
      mojo::Clone(relative_y),
      mojo::Clone(wheel_delta_x),
      mojo::Clone(wheel_delta_y)
  );
}

template <typename T, CapturedWheelAction::EnableIfSame<T>*>
bool CapturedWheelAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relative_x, other_struct.relative_x))
    return false;
  if (!mojo::Equals(this->relative_y, other_struct.relative_y))
    return false;
  if (!mojo::Equals(this->wheel_delta_x, other_struct.wheel_delta_x))
    return false;
  if (!mojo::Equals(this->wheel_delta_y, other_struct.wheel_delta_y))
    return false;
  return true;
}

template <typename T, CapturedWheelAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relative_x < rhs.relative_x)
    return true;
  if (rhs.relative_x < lhs.relative_x)
    return false;
  if (lhs.relative_y < rhs.relative_y)
    return true;
  if (rhs.relative_y < lhs.relative_y)
    return false;
  if (lhs.wheel_delta_x < rhs.wheel_delta_x)
    return true;
  if (rhs.wheel_delta_x < lhs.wheel_delta_x)
    return false;
  if (lhs.wheel_delta_y < rhs.wheel_delta_y)
    return true;
  if (rhs.wheel_delta_y < lhs.wheel_delta_y)
    return false;
  return false;
}
template <typename StructPtrType>
StreamDevicesPtr StreamDevices::Clone() const {
  return New(
      mojo::Clone(audio_device),
      mojo::Clone(video_device)
  );
}

template <typename T, StreamDevices::EnableIfSame<T>*>
bool StreamDevices::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_device, other_struct.audio_device))
    return false;
  if (!mojo::Equals(this->video_device, other_struct.video_device))
    return false;
  return true;
}

template <typename T, StreamDevices::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio_device < rhs.audio_device)
    return true;
  if (rhs.audio_device < lhs.audio_device)
    return false;
  if (lhs.video_device < rhs.video_device)
    return true;
  if (rhs.video_device < lhs.video_device)
    return false;
  return false;
}
template <typename StructPtrType>
StreamDevicesSetPtr StreamDevicesSet::Clone() const {
  return New(
      mojo::Clone(stream_devices)
  );
}

template <typename T, StreamDevicesSet::EnableIfSame<T>*>
bool StreamDevicesSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stream_devices, other_struct.stream_devices))
    return false;
  return true;
}

template <typename T, StreamDevicesSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stream_devices < rhs.stream_devices)
    return true;
  if (rhs.stream_devices < lhs.stream_devices)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SearchOnlyByDeviceId::DataView,
                                         ::blink::mojom::blink::SearchOnlyByDeviceIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::SearchOnlyByDeviceIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SearchOnlyByDeviceIdPtr* output) { output->reset(); }

  static bool Read(::blink::mojom::blink::SearchOnlyByDeviceId::DataView input, ::blink::mojom::blink::SearchOnlyByDeviceIdPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SearchBySessionId::DataView,
                                         ::blink::mojom::blink::SearchBySessionIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::SearchBySessionIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SearchBySessionIdPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SearchBySessionId::session_id_map)& session_id_map(
      const ::blink::mojom::blink::SearchBySessionIdPtr& input) {
    return input->session_id_map;
  }

  static bool Read(::blink::mojom::blink::SearchBySessionId::DataView input, ::blink::mojom::blink::SearchBySessionIdPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MediaStreamDevice::DataView,
                                         ::blink::mojom::blink::MediaStreamDevicePtr> {
  static bool IsNull(const ::blink::mojom::blink::MediaStreamDevicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MediaStreamDevicePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MediaStreamDevice::type) type(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::id)& id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->id;
  }

  static decltype(::blink::mojom::blink::MediaStreamDevice::display_id) display_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->display_id;
  }

  static decltype(::blink::mojom::blink::MediaStreamDevice::video_facing) video_facing(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->video_facing;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::group_id)& group_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->group_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::matched_output_device_id)& matched_output_device_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->matched_output_device_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::name)& name(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::input)& input(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->input;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::session_id)& session_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->session_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::display_media_info)& display_media_info(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->display_media_info;
  }

  static bool Read(::blink::mojom::blink::MediaStreamDevice::DataView input, ::blink::mojom::blink::MediaStreamDevicePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TrackControls::DataView,
                                         ::blink::mojom::blink::TrackControlsPtr> {
  static bool IsNull(const ::blink::mojom::blink::TrackControlsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TrackControlsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TrackControls::stream_type) stream_type(
      const ::blink::mojom::blink::TrackControlsPtr& input) {
    return input->stream_type;
  }

  static const decltype(::blink::mojom::blink::TrackControls::device_ids)& device_ids(
      const ::blink::mojom::blink::TrackControlsPtr& input) {
    return input->device_ids;
  }

  static bool Read(::blink::mojom::blink::TrackControls::DataView input, ::blink::mojom::blink::TrackControlsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StreamControls::DataView,
                                         ::blink::mojom::blink::StreamControlsPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamControlsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamControlsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::StreamControls::audio)& audio(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->audio;
  }

  static const decltype(::blink::mojom::blink::StreamControls::video)& video(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->video;
  }

  static decltype(::blink::mojom::blink::StreamControls::hotword_enabled) hotword_enabled(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->hotword_enabled;
  }

  static decltype(::blink::mojom::blink::StreamControls::disable_local_echo) disable_local_echo(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->disable_local_echo;
  }

  static decltype(::blink::mojom::blink::StreamControls::suppress_local_audio_playback) suppress_local_audio_playback(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->suppress_local_audio_playback;
  }

  static decltype(::blink::mojom::blink::StreamControls::restrict_own_audio) restrict_own_audio(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->restrict_own_audio;
  }

  static decltype(::blink::mojom::blink::StreamControls::exclude_system_audio) exclude_system_audio(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->exclude_system_audio;
  }

  static decltype(::blink::mojom::blink::StreamControls::window_audio_preference) window_audio_preference(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->window_audio_preference;
  }

  static decltype(::blink::mojom::blink::StreamControls::exclude_self_browser_surface) exclude_self_browser_surface(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->exclude_self_browser_surface;
  }

  static decltype(::blink::mojom::blink::StreamControls::request_pan_tilt_zoom_permission) request_pan_tilt_zoom_permission(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->request_pan_tilt_zoom_permission;
  }

  static decltype(::blink::mojom::blink::StreamControls::request_all_screens) request_all_screens(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->request_all_screens;
  }

  static decltype(::blink::mojom::blink::StreamControls::preferred_display_surface) preferred_display_surface(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->preferred_display_surface;
  }

  static decltype(::blink::mojom::blink::StreamControls::dynamic_surface_switching_requested) dynamic_surface_switching_requested(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->dynamic_surface_switching_requested;
  }

  static decltype(::blink::mojom::blink::StreamControls::exclude_monitor_type_surfaces) exclude_monitor_type_surfaces(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->exclude_monitor_type_surfaces;
  }

  static bool Read(::blink::mojom::blink::StreamControls::DataView input, ::blink::mojom::blink::StreamControlsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::GetOpenDeviceResponse::DataView,
                                         ::blink::mojom::blink::GetOpenDeviceResponsePtr> {
  static bool IsNull(const ::blink::mojom::blink::GetOpenDeviceResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::GetOpenDeviceResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::GetOpenDeviceResponse::label)& label(
      const ::blink::mojom::blink::GetOpenDeviceResponsePtr& input) {
    return input->label;
  }

  static const decltype(::blink::mojom::blink::GetOpenDeviceResponse::device)& device(
      const ::blink::mojom::blink::GetOpenDeviceResponsePtr& input) {
    return input->device;
  }

  static decltype(::blink::mojom::blink::GetOpenDeviceResponse::pan_tilt_zoom_allowed) pan_tilt_zoom_allowed(
      const ::blink::mojom::blink::GetOpenDeviceResponsePtr& input) {
    return input->pan_tilt_zoom_allowed;
  }

  static bool Read(::blink::mojom::blink::GetOpenDeviceResponse::DataView input, ::blink::mojom::blink::GetOpenDeviceResponsePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CapturedWheelAction::DataView,
                                         ::blink::mojom::blink::CapturedWheelActionPtr> {
  static bool IsNull(const ::blink::mojom::blink::CapturedWheelActionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CapturedWheelActionPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CapturedWheelAction::relative_x) relative_x(
      const ::blink::mojom::blink::CapturedWheelActionPtr& input) {
    return input->relative_x;
  }

  static decltype(::blink::mojom::blink::CapturedWheelAction::relative_y) relative_y(
      const ::blink::mojom::blink::CapturedWheelActionPtr& input) {
    return input->relative_y;
  }

  static decltype(::blink::mojom::blink::CapturedWheelAction::wheel_delta_x) wheel_delta_x(
      const ::blink::mojom::blink::CapturedWheelActionPtr& input) {
    return input->wheel_delta_x;
  }

  static decltype(::blink::mojom::blink::CapturedWheelAction::wheel_delta_y) wheel_delta_y(
      const ::blink::mojom::blink::CapturedWheelActionPtr& input) {
    return input->wheel_delta_y;
  }

  static bool Read(::blink::mojom::blink::CapturedWheelAction::DataView input, ::blink::mojom::blink::CapturedWheelActionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StreamDevices::DataView,
                                         ::blink::mojom::blink::StreamDevicesPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamDevicesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamDevicesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::StreamDevices::audio_device)& audio_device(
      const ::blink::mojom::blink::StreamDevicesPtr& input) {
    return input->audio_device;
  }

  static const decltype(::blink::mojom::blink::StreamDevices::video_device)& video_device(
      const ::blink::mojom::blink::StreamDevicesPtr& input) {
    return input->video_device;
  }

  static bool Read(::blink::mojom::blink::StreamDevices::DataView input, ::blink::mojom::blink::StreamDevicesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StreamDevicesSet::DataView,
                                         ::blink::mojom::blink::StreamDevicesSetPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamDevicesSetPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamDevicesSetPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::StreamDevicesSet::stream_devices)& stream_devices(
      const ::blink::mojom::blink::StreamDevicesSetPtr& input) {
    return input->stream_devices;
  }

  static bool Read(::blink::mojom::blink::StreamDevicesSet::DataView input, ::blink::mojom::blink::StreamDevicesSetPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::StreamSelectionInfo::DataView,
                                        ::blink::mojom::blink::StreamSelectionInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamSelectionInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamSelectionInfoPtr* output) { output->reset(); }

  static ::blink::mojom::blink::StreamSelectionInfo::Tag GetTag(const ::blink::mojom::blink::StreamSelectionInfoPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::SearchOnlyByDeviceIdPtr& search_only_by_device_id(const ::blink::mojom::blink::StreamSelectionInfoPtr& input) {
    return input->get_search_only_by_device_id();
  }

  static const ::blink::mojom::blink::SearchBySessionIdPtr& search_by_session_id(const ::blink::mojom::blink::StreamSelectionInfoPtr& input) {
    return input->get_search_by_session_id();
  }

  static bool Read(::blink::mojom::blink::StreamSelectionInfo::DataView input, ::blink::mojom::blink::StreamSelectionInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_