// third_party/blink/public/mojom/mediastream/media_devices.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/mediastream/media_devices_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class MediaDevicesDispatcherHostProxy;

template <typename ImplRefTraits>
class MediaDevicesDispatcherHostStub;

class MediaDevicesDispatcherHostRequestValidator;
class MediaDevicesDispatcherHostResponseValidator;


class PLATFORM_EXPORT MediaDevicesDispatcherHost
    : public MediaDevicesDispatcherHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MediaDevicesDispatcherHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaDevicesDispatcherHostInterfaceBase;
  using Proxy_ = MediaDevicesDispatcherHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaDevicesDispatcherHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaDevicesDispatcherHostRequestValidator;
  using ResponseValidator_ = MediaDevicesDispatcherHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnumerateDevicesMinVersion = 0,
    kGetVideoInputCapabilitiesMinVersion = 0,
    kGetAllVideoInputDeviceFormatsMinVersion = 0,
    kGetAvailableVideoInputDeviceFormatsMinVersion = 0,
    kGetAudioInputCapabilitiesMinVersion = 0,
    kAddMediaDevicesListenerMinVersion = 0,
    kSetCaptureHandleConfigMinVersion = 0,
    kCloseFocusWindowOfOpportunityMinVersion = 0,
    kProduceSubCaptureTargetIdMinVersion = 0,
    kSetPreferredSinkIdMinVersion = 0,
    kSelectAudioOutputMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnumerateDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVideoInputCapabilities_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllVideoInputDeviceFormats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAvailableVideoInputDeviceFormats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAudioInputCapabilities_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddMediaDevicesListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCaptureHandleConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseFocusWindowOfOpportunity_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProduceSubCaptureTargetId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreferredSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectAudioOutput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaDevicesDispatcherHost() = default;

  using EnumerateDevicesCallback = base::OnceCallback<void(const ::blink::Vector<::blink::Vector<::blink::WebMediaDeviceInfo>>&, ::blink::Vector<VideoInputDeviceCapabilitiesPtr>, ::blink::Vector<AudioInputDeviceCapabilitiesPtr>)>;
  using EnumerateDevicesMojoCallback = base::OnceCallback<void(const ::blink::Vector<::blink::Vector<::blink::WebMediaDeviceInfo>>&, ::blink::Vector<VideoInputDeviceCapabilitiesPtr>, ::blink::Vector<AudioInputDeviceCapabilitiesPtr>)>;

  virtual void EnumerateDevices(bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, EnumerateDevicesCallback callback) = 0;

  using GetVideoInputCapabilitiesCallback = base::OnceCallback<void(::blink::Vector<VideoInputDeviceCapabilitiesPtr>)>;
  using GetVideoInputCapabilitiesMojoCallback = base::OnceCallback<void(::blink::Vector<VideoInputDeviceCapabilitiesPtr>)>;

  virtual void GetVideoInputCapabilities(GetVideoInputCapabilitiesCallback callback) = 0;

  using GetAllVideoInputDeviceFormatsCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;
  using GetAllVideoInputDeviceFormatsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;

  virtual void GetAllVideoInputDeviceFormats(const ::blink::String& device_id, GetAllVideoInputDeviceFormatsCallback callback) = 0;

  using GetAvailableVideoInputDeviceFormatsCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;
  using GetAvailableVideoInputDeviceFormatsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;

  virtual void GetAvailableVideoInputDeviceFormats(const ::blink::String& device_id, GetAvailableVideoInputDeviceFormatsCallback callback) = 0;

  using GetAudioInputCapabilitiesCallback = base::OnceCallback<void(::blink::Vector<AudioInputDeviceCapabilitiesPtr>)>;
  using GetAudioInputCapabilitiesMojoCallback = base::OnceCallback<void(::blink::Vector<AudioInputDeviceCapabilitiesPtr>)>;

  virtual void GetAudioInputCapabilities(GetAudioInputCapabilitiesCallback callback) = 0;

  virtual void AddMediaDevicesListener(bool subscribe_audio_input, bool subscribe_video_input, bool subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> listener) = 0;

  virtual void SetCaptureHandleConfig(::blink::mojom::blink::CaptureHandleConfigPtr config) = 0;

  virtual void CloseFocusWindowOfOpportunity(const ::blink::String& label) = 0;

  using ProduceSubCaptureTargetIdCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ProduceSubCaptureTargetIdMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ProduceSubCaptureTargetId(::media::mojom::blink::SubCaptureTargetType type, ProduceSubCaptureTargetIdCallback callback) = 0;

  using SetPreferredSinkIdCallback = base::OnceCallback<void(::media::mojom::blink::OutputDeviceStatus)>;
  using SetPreferredSinkIdMojoCallback = base::OnceCallback<void(::media::mojom::blink::OutputDeviceStatus)>;

  virtual void SetPreferredSinkId(const ::blink::String& sink_id, SetPreferredSinkIdCallback callback) = 0;

  using SelectAudioOutputCallback = base::OnceCallback<void(SelectAudioOutputResultPtr)>;
  using SelectAudioOutputMojoCallback = base::OnceCallback<void(SelectAudioOutputResultPtr)>;

  virtual void SelectAudioOutput(const ::blink::String& device_id, SelectAudioOutputCallback callback) = 0;
};

class MediaDevicesListenerProxy;

template <typename ImplRefTraits>
class MediaDevicesListenerStub;

class MediaDevicesListenerRequestValidator;


class PLATFORM_EXPORT MediaDevicesListener
    : public MediaDevicesListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MediaDevicesListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaDevicesListenerInterfaceBase;
  using Proxy_ = MediaDevicesListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaDevicesListenerStub<ImplRefTraits>;

  using RequestValidator_ = MediaDevicesListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDevicesChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDevicesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaDevicesListener() = default;

  virtual void OnDevicesChanged(MediaDeviceType type, const ::blink::Vector<::blink::WebMediaDeviceInfo>& device_infos) = 0;
};



class PLATFORM_EXPORT MediaDevicesDispatcherHostProxy
    : public MediaDevicesDispatcherHost {
 public:
  using InterfaceType = MediaDevicesDispatcherHost;

  explicit MediaDevicesDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnumerateDevices(bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, EnumerateDevicesCallback callback) final;
  
  void GetVideoInputCapabilities(GetVideoInputCapabilitiesCallback callback) final;
  
  void GetAllVideoInputDeviceFormats(const ::blink::String& device_id, GetAllVideoInputDeviceFormatsCallback callback) final;
  
  void GetAvailableVideoInputDeviceFormats(const ::blink::String& device_id, GetAvailableVideoInputDeviceFormatsCallback callback) final;
  
  void GetAudioInputCapabilities(GetAudioInputCapabilitiesCallback callback) final;
  
  void AddMediaDevicesListener(bool subscribe_audio_input, bool subscribe_video_input, bool subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> listener) final;
  
  void SetCaptureHandleConfig(::blink::mojom::blink::CaptureHandleConfigPtr config) final;
  
  void CloseFocusWindowOfOpportunity(const ::blink::String& label) final;
  
  void ProduceSubCaptureTargetId(::media::mojom::blink::SubCaptureTargetType type, ProduceSubCaptureTargetIdCallback callback) final;
  
  void SetPreferredSinkId(const ::blink::String& sink_id, SetPreferredSinkIdCallback callback) final;
  
  void SelectAudioOutput(const ::blink::String& device_id, SelectAudioOutputCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT MediaDevicesListenerProxy
    : public MediaDevicesListener {
 public:
  using InterfaceType = MediaDevicesListener;

  explicit MediaDevicesListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDevicesChanged(MediaDeviceType type, const ::blink::Vector<::blink::WebMediaDeviceInfo>& device_infos) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT MediaDevicesDispatcherHostStubDispatch {
 public:
  static bool Accept(MediaDevicesDispatcherHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaDevicesDispatcherHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaDevicesDispatcherHost>>
class MediaDevicesDispatcherHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaDevicesDispatcherHostStub() = default;
  ~MediaDevicesDispatcherHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDevicesDispatcherHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDevicesDispatcherHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaDevicesListenerStubDispatch {
 public:
  static bool Accept(MediaDevicesListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaDevicesListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaDevicesListener>>
class MediaDevicesListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaDevicesListenerStub() = default;
  ~MediaDevicesListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDevicesListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaDevicesListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaDevicesDispatcherHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaDevicesListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaDevicesDispatcherHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class PLATFORM_EXPORT MediaDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaDeviceInfo, T>::value>;
  using DataView = MediaDeviceInfoDataView;
  using Data_ = internal::MediaDeviceInfo_Data;

  template <typename... Args>
  static MediaDeviceInfoPtr New(Args&&... args) {
    return MediaDeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaDeviceInfo>::Convert(*this);
  }


  MediaDeviceInfo();

  MediaDeviceInfo(
      const ::blink::String& device_id,
      const ::blink::String& label,
      const ::blink::String& group_id,
      const ::media::VideoCaptureControlSupport& control_support,
      FacingMode facing_mode,
      std::optional<::media::mojom::blink::CameraAvailability> availability);


  ~MediaDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaDeviceInfoPtr>
  MediaDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaDeviceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaDeviceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaDeviceInfo_UnserializedMessageContext<
            UserType, MediaDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaDeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaDeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaDeviceInfo_UnserializedMessageContext<
            UserType, MediaDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaDeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String device_id;
  
  ::blink::String label;
  
  ::blink::String group_id;
  
  ::media::VideoCaptureControlSupport control_support;
  
  FacingMode facing_mode;
  
  std::optional<::media::mojom::blink::CameraAvailability> availability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT VideoInputDeviceCapabilities {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoInputDeviceCapabilities, T>::value>;
  using DataView = VideoInputDeviceCapabilitiesDataView;
  using Data_ = internal::VideoInputDeviceCapabilities_Data;

  template <typename... Args>
  static VideoInputDeviceCapabilitiesPtr New(Args&&... args) {
    return VideoInputDeviceCapabilitiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoInputDeviceCapabilitiesPtr From(const U& u) {
    return mojo::TypeConverter<VideoInputDeviceCapabilitiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoInputDeviceCapabilities>::Convert(*this);
  }


  VideoInputDeviceCapabilities();

  VideoInputDeviceCapabilities(
      const ::blink::String& device_id,
      const ::blink::String& group_id,
      const ::media::VideoCaptureControlSupport& control_support,
      ::blink::Vector<::media::VideoCaptureFormat> formats,
      FacingMode facing_mode,
      std::optional<::media::mojom::blink::CameraAvailability> availability);


  ~VideoInputDeviceCapabilities();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoInputDeviceCapabilitiesPtr>
  VideoInputDeviceCapabilitiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoInputDeviceCapabilities::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoInputDeviceCapabilities::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoInputDeviceCapabilities::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoInputDeviceCapabilities_UnserializedMessageContext<
            UserType, VideoInputDeviceCapabilities::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoInputDeviceCapabilities::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoInputDeviceCapabilities::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoInputDeviceCapabilities_UnserializedMessageContext<
            UserType, VideoInputDeviceCapabilities::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoInputDeviceCapabilities::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String device_id;
  
  ::blink::String group_id;
  
  ::media::VideoCaptureControlSupport control_support;
  
  ::blink::Vector<::media::VideoCaptureFormat> formats;
  
  FacingMode facing_mode;
  
  std::optional<::media::mojom::blink::CameraAvailability> availability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SelectAudioOutputResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectAudioOutputResult, T>::value>;
  using DataView = SelectAudioOutputResultDataView;
  using Data_ = internal::SelectAudioOutputResult_Data;

  template <typename... Args>
  static SelectAudioOutputResultPtr New(Args&&... args) {
    return SelectAudioOutputResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectAudioOutputResultPtr From(const U& u) {
    return mojo::TypeConverter<SelectAudioOutputResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectAudioOutputResult>::Convert(*this);
  }


  SelectAudioOutputResult();

  SelectAudioOutputResult(
      AudioOutputStatus status,
      const ::blink::WebMediaDeviceInfo& device_info);


  ~SelectAudioOutputResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectAudioOutputResultPtr>
  SelectAudioOutputResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAudioOutputResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAudioOutputResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectAudioOutputResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectAudioOutputResult_UnserializedMessageContext<
            UserType, SelectAudioOutputResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectAudioOutputResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectAudioOutputResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectAudioOutputResult_UnserializedMessageContext<
            UserType, SelectAudioOutputResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectAudioOutputResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AudioOutputStatus status;
  
  ::blink::WebMediaDeviceInfo device_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectAudioOutputResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AudioInputDeviceCapabilities {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioInputDeviceCapabilities, T>::value>;
  using DataView = AudioInputDeviceCapabilitiesDataView;
  using Data_ = internal::AudioInputDeviceCapabilities_Data;

  template <typename... Args>
  static AudioInputDeviceCapabilitiesPtr New(Args&&... args) {
    return AudioInputDeviceCapabilitiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioInputDeviceCapabilitiesPtr From(const U& u) {
    return mojo::TypeConverter<AudioInputDeviceCapabilitiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioInputDeviceCapabilities>::Convert(*this);
  }


  AudioInputDeviceCapabilities();

  AudioInputDeviceCapabilities(
      const ::blink::String& device_id,
      const ::blink::String& group_id,
      const ::media::AudioParameters& parameters,
      bool is_valid,
      int32_t channels,
      int32_t sample_rate,
      ::base::TimeDelta latency);


  ~AudioInputDeviceCapabilities();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioInputDeviceCapabilitiesPtr>
  AudioInputDeviceCapabilitiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioInputDeviceCapabilities::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioInputDeviceCapabilities::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioInputDeviceCapabilities::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioInputDeviceCapabilities_UnserializedMessageContext<
            UserType, AudioInputDeviceCapabilities::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioInputDeviceCapabilities::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioInputDeviceCapabilities::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioInputDeviceCapabilities_UnserializedMessageContext<
            UserType, AudioInputDeviceCapabilities::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioInputDeviceCapabilities::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String device_id;
  
  ::blink::String group_id;
  
  ::media::AudioParameters parameters;
  
  bool is_valid;
  
  int32_t channels;
  
  int32_t sample_rate;
  
  ::base::TimeDelta latency;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MediaDeviceInfoPtr MediaDeviceInfo::Clone() const {
  return New(
      mojo::Clone(device_id),
      mojo::Clone(label),
      mojo::Clone(group_id),
      mojo::Clone(control_support),
      mojo::Clone(facing_mode),
      mojo::Clone(availability)
  );
}

template <typename T, MediaDeviceInfo::EnableIfSame<T>*>
bool MediaDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->control_support, other_struct.control_support))
    return false;
  if (!mojo::Equals(this->facing_mode, other_struct.facing_mode))
    return false;
  if (!mojo::Equals(this->availability, other_struct.availability))
    return false;
  return true;
}

template <typename T, MediaDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.control_support < rhs.control_support)
    return true;
  if (rhs.control_support < lhs.control_support)
    return false;
  if (lhs.facing_mode < rhs.facing_mode)
    return true;
  if (rhs.facing_mode < lhs.facing_mode)
    return false;
  if (lhs.availability < rhs.availability)
    return true;
  if (rhs.availability < lhs.availability)
    return false;
  return false;
}
template <typename StructPtrType>
VideoInputDeviceCapabilitiesPtr VideoInputDeviceCapabilities::Clone() const {
  return New(
      mojo::Clone(device_id),
      mojo::Clone(group_id),
      mojo::Clone(control_support),
      mojo::Clone(formats),
      mojo::Clone(facing_mode),
      mojo::Clone(availability)
  );
}

template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>*>
bool VideoInputDeviceCapabilities::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->control_support, other_struct.control_support))
    return false;
  if (!mojo::Equals(this->formats, other_struct.formats))
    return false;
  if (!mojo::Equals(this->facing_mode, other_struct.facing_mode))
    return false;
  if (!mojo::Equals(this->availability, other_struct.availability))
    return false;
  return true;
}

template <typename T, VideoInputDeviceCapabilities::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.control_support < rhs.control_support)
    return true;
  if (rhs.control_support < lhs.control_support)
    return false;
  if (lhs.formats < rhs.formats)
    return true;
  if (rhs.formats < lhs.formats)
    return false;
  if (lhs.facing_mode < rhs.facing_mode)
    return true;
  if (rhs.facing_mode < lhs.facing_mode)
    return false;
  if (lhs.availability < rhs.availability)
    return true;
  if (rhs.availability < lhs.availability)
    return false;
  return false;
}
template <typename StructPtrType>
SelectAudioOutputResultPtr SelectAudioOutputResult::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(device_info)
  );
}

template <typename T, SelectAudioOutputResult::EnableIfSame<T>*>
bool SelectAudioOutputResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->device_info, other_struct.device_info))
    return false;
  return true;
}

template <typename T, SelectAudioOutputResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.device_info < rhs.device_info)
    return true;
  if (rhs.device_info < lhs.device_info)
    return false;
  return false;
}
template <typename StructPtrType>
AudioInputDeviceCapabilitiesPtr AudioInputDeviceCapabilities::Clone() const {
  return New(
      mojo::Clone(device_id),
      mojo::Clone(group_id),
      mojo::Clone(parameters),
      mojo::Clone(is_valid),
      mojo::Clone(channels),
      mojo::Clone(sample_rate),
      mojo::Clone(latency)
  );
}

template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>*>
bool AudioInputDeviceCapabilities::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->parameters, other_struct.parameters))
    return false;
  if (!mojo::Equals(this->is_valid, other_struct.is_valid))
    return false;
  if (!mojo::Equals(this->channels, other_struct.channels))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->latency, other_struct.latency))
    return false;
  return true;
}

template <typename T, AudioInputDeviceCapabilities::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.parameters < rhs.parameters)
    return true;
  if (rhs.parameters < lhs.parameters)
    return false;
  if (lhs.is_valid < rhs.is_valid)
    return true;
  if (rhs.is_valid < lhs.is_valid)
    return false;
  if (lhs.channels < rhs.channels)
    return true;
  if (rhs.channels < lhs.channels)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.latency < rhs.latency)
    return true;
  if (rhs.latency < lhs.latency)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MediaDeviceInfo::DataView,
                                         ::blink::mojom::blink::MediaDeviceInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::MediaDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MediaDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::MediaDeviceInfo::device_id)& device_id(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->device_id;
  }

  static const decltype(::blink::mojom::blink::MediaDeviceInfo::label)& label(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->label;
  }

  static const decltype(::blink::mojom::blink::MediaDeviceInfo::group_id)& group_id(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->group_id;
  }

  static const decltype(::blink::mojom::blink::MediaDeviceInfo::control_support)& control_support(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->control_support;
  }

  static decltype(::blink::mojom::blink::MediaDeviceInfo::facing_mode) facing_mode(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->facing_mode;
  }

  static decltype(::blink::mojom::blink::MediaDeviceInfo::availability) availability(
      const ::blink::mojom::blink::MediaDeviceInfoPtr& input) {
    return input->availability;
  }

  static bool Read(::blink::mojom::blink::MediaDeviceInfo::DataView input, ::blink::mojom::blink::MediaDeviceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::VideoInputDeviceCapabilities::DataView,
                                         ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::device_id)& device_id(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->device_id;
  }

  static const decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::group_id)& group_id(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->group_id;
  }

  static const decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::control_support)& control_support(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->control_support;
  }

  static const decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::formats)& formats(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->formats;
  }

  static decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::facing_mode) facing_mode(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->facing_mode;
  }

  static decltype(::blink::mojom::blink::VideoInputDeviceCapabilities::availability) availability(
      const ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr& input) {
    return input->availability;
  }

  static bool Read(::blink::mojom::blink::VideoInputDeviceCapabilities::DataView input, ::blink::mojom::blink::VideoInputDeviceCapabilitiesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SelectAudioOutputResult::DataView,
                                         ::blink::mojom::blink::SelectAudioOutputResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::SelectAudioOutputResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SelectAudioOutputResultPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::SelectAudioOutputResult::status) status(
      const ::blink::mojom::blink::SelectAudioOutputResultPtr& input) {
    return input->status;
  }

  static const decltype(::blink::mojom::blink::SelectAudioOutputResult::device_info)& device_info(
      const ::blink::mojom::blink::SelectAudioOutputResultPtr& input) {
    return input->device_info;
  }

  static bool Read(::blink::mojom::blink::SelectAudioOutputResult::DataView input, ::blink::mojom::blink::SelectAudioOutputResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AudioInputDeviceCapabilities::DataView,
                                         ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr> {
  static bool IsNull(const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::device_id)& device_id(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->device_id;
  }

  static const decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::group_id)& group_id(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->group_id;
  }

  static const decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::parameters)& parameters(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->parameters;
  }

  static decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::is_valid) is_valid(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->is_valid;
  }

  static decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::channels) channels(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->channels;
  }

  static decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::sample_rate) sample_rate(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->sample_rate;
  }

  static const decltype(::blink::mojom::blink::AudioInputDeviceCapabilities::latency)& latency(
      const ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr& input) {
    return input->latency;
  }

  static bool Read(::blink::mojom::blink::AudioInputDeviceCapabilities::DataView input, ::blink::mojom::blink::AudioInputDeviceCapabilitiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_H_