// third_party/blink/public/mojom/mediasession/media_session.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  CameraState as mediaSession_mojom_CameraState,
  CameraStateSpec as mediaSession_mojom_CameraStateSpec,
  MediaSessionAction as mediaSession_mojom_MediaSessionAction,
  MediaSessionActionSpec as mediaSession_mojom_MediaSessionActionSpec,
  MicrophoneState as mediaSession_mojom_MicrophoneState,
  MicrophoneStateSpec as mediaSession_mojom_MicrophoneStateSpec,
  ChapterInformation as mediaSession_mojom_ChapterInformation,
  ChapterInformationSpec as mediaSession_mojom_ChapterInformationSpec,
  MediaImage as mediaSession_mojom_MediaImage,
  MediaImageSpec as mediaSession_mojom_MediaImageSpec,
  MediaPosition as mediaSession_mojom_MediaPosition,
  MediaPositionSpec as mediaSession_mojom_MediaPositionSpec
} from '../../../../../services/media_session/public/mojom/media_session.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSessionPlaybackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSessionPlaybackState = {
  
  NONE: 0,
  PAUSED: 1,
  PLAYING: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSessionEnterPictureInPictureReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSessionEnterPictureInPictureReason = {
  
  kOther: 0,
  kUserAction: 1,
  kContentOccluded: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaSessionClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaSessionClient', scope);
  }
}

/** @interface */
export class MediaSessionClientInterface {
  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   * @param { ?MediaSessionActionDetails } details
   */

  didReceiveAction(action, details) {}
}

/**
 * @implements { MediaSessionClientInterface }
 */
export class MediaSessionClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaSessionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaSessionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   * @param { ?MediaSessionActionDetails } details
   */

  didReceiveAction(
      action,
      details) {
    this.proxy.sendMessage(
        0,
        MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        [
          action,
          details
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaSessionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionClientReceiver {
  /**
   * @param {!MediaSessionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaSessionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        impl.didReceiveAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSessionClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaSessionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaSessionClientRemote}
   */
  static getRemote() {
    let remote = new MediaSessionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaSessionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReceiveAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSessionClient_DidReceiveAction_ParamsSpec.$,
        null,
        this.didReceiveAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaSessionServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.MediaSessionService', scope);
  }
}

/** @interface */
export class MediaSessionServiceInterface {
  
  /**
   * @param { !MediaSessionClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !MediaSessionPlaybackState } state
   */

  setPlaybackState(state) {}
  
  /**
   * @param { ?mediaSession_mojom_MediaPosition } position
   */

  setPositionState(position) {}
  
  /**
   * @param { ?SpecMediaMetadata } metadata
   */

  setMetadata(metadata) {}
  
  /**
   * @param { !mediaSession_mojom_MicrophoneState } microphoneState
   */

  setMicrophoneState(microphoneState) {}
  
  /**
   * @param { !mediaSession_mojom_CameraState } cameraState
   */

  setCameraState(cameraState) {}
  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   */

  enableAction(action) {}
  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   */

  disableAction(action) {}
}

/**
 * @implements { MediaSessionServiceInterface }
 */
export class MediaSessionServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaSessionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaSessionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MediaSessionClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        MediaSessionService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !MediaSessionPlaybackState } state
   */

  setPlaybackState(
      state) {
    this.proxy.sendMessage(
        1,
        MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession_mojom_MediaPosition } position
   */

  setPositionState(
      position) {
    this.proxy.sendMessage(
        2,
        MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }

  
  /**
   * @param { ?SpecMediaMetadata } metadata
   */

  setMetadata(
      metadata) {
    this.proxy.sendMessage(
        3,
        MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MicrophoneState } microphoneState
   */

  setMicrophoneState(
      microphoneState) {
    this.proxy.sendMessage(
        4,
        MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        [
          microphoneState
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_CameraState } cameraState
   */

  setCameraState(
      cameraState) {
    this.proxy.sendMessage(
        5,
        MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        [
          cameraState
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   */

  enableAction(
      action) {
    this.proxy.sendMessage(
        6,
        MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionAction } action
   */

  disableAction(
      action) {
    this.proxy.sendMessage(
        7,
        MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaSessionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionServiceReceiver {
  /**
   * @param {!MediaSessionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaSessionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSessionService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        impl.setPlaybackState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        impl.setPositionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        impl.setMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        impl.setMicrophoneState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        impl.setCameraState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        impl.enableAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        impl.disableAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSessionService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.MediaSessionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaSessionServiceRemote}
   */
  static getRemote() {
    let remote = new MediaSessionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaSessionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSessionService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlaybackState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaSessionService_SetPlaybackState_ParamsSpec.$,
        null,
        this.setPlaybackState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPositionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaSessionService_SetPositionState_ParamsSpec.$,
        null,
        this.setPositionState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaSessionService_SetMetadata_ParamsSpec.$,
        null,
        this.setMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMicrophoneState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaSessionService_SetMicrophoneState_ParamsSpec.$,
        null,
        this.setMicrophoneState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCameraState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaSessionService_SetCameraState_ParamsSpec.$,
        null,
        this.setCameraState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaSessionService_EnableAction_ParamsSpec.$,
        null,
        this.enableAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaSessionService_DisableAction_ParamsSpec.$,
        null,
        this.disableAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionSeekToDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionEnterPictureInPictureDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpecMediaMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionClient_DidReceiveAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetPlaybackState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetPositionState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetMicrophoneState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_SetCameraState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_EnableAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionService_DisableAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const MediaSessionActionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaSessionSeekToDetailsSpec.$,
    'MediaSessionSeekToDetails',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fastSeek', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaSessionSeekToDetails {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
    /** @type { !boolean } */
    this.fastSeek;
  }
}



mojo.internal.Struct(
    MediaSessionEnterPictureInPictureDetailsSpec.$,
    'MediaSessionEnterPictureInPictureDetails',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        MediaSessionEnterPictureInPictureReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionEnterPictureInPictureDetails {
  constructor() {
    /** @type { !MediaSessionEnterPictureInPictureReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    SpecMediaMetadataSpec.$,
    'SpecMediaMetadata',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'artist', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'album', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'artwork', 24,
        0,
        mojo.internal.Array(mediaSession_mojom_MediaImageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'chapterInfo', 32,
        0,
        mojo.internal.Array(mediaSession_mojom_ChapterInformationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SpecMediaMetadata {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
    /** @type { !mojoBase_mojom_String16 } */
    this.artist;
    /** @type { !mojoBase_mojom_String16 } */
    this.album;
    /** @type { !Array<!mediaSession_mojom_MediaImage> } */
    this.artwork;
    /** @type { !Array<!mediaSession_mojom_ChapterInformation> } */
    this.chapterInfo;
  }
}



mojo.internal.Struct(
    MediaSessionClient_DidReceiveAction_ParamsSpec.$,
    'MediaSessionClient_DidReceiveAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession_mojom_MediaSessionActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        MediaSessionActionDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaSessionClient_DidReceiveAction_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionAction } */
    this.action;
    /** @type { (MediaSessionActionDetails|undefined) } */
    this.details;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetClient_ParamsSpec.$,
    'MediaSessionService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(MediaSessionClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetClient_Params {
  constructor() {
    /** @type { !MediaSessionClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetPlaybackState_ParamsSpec.$,
    'MediaSessionService_SetPlaybackState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        MediaSessionPlaybackStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetPlaybackState_Params {
  constructor() {
    /** @type { !MediaSessionPlaybackState } */
    this.state;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetPositionState_ParamsSpec.$,
    'MediaSessionService_SetPositionState_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        mediaSession_mojom_MediaPositionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetPositionState_Params {
  constructor() {
    /** @type { (mediaSession_mojom_MediaPosition|undefined) } */
    this.position;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetMetadata_ParamsSpec.$,
    'MediaSessionService_SetMetadata_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        SpecMediaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetMetadata_Params {
  constructor() {
    /** @type { (SpecMediaMetadata|undefined) } */
    this.metadata;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetMicrophoneState_ParamsSpec.$,
    'MediaSessionService_SetMicrophoneState_Params',
    [
      mojo.internal.StructField(
        'microphoneState', 0,
        0,
        mediaSession_mojom_MicrophoneStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetMicrophoneState_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MicrophoneState } */
    this.microphoneState;
  }
}



mojo.internal.Struct(
    MediaSessionService_SetCameraState_ParamsSpec.$,
    'MediaSessionService_SetCameraState_Params',
    [
      mojo.internal.StructField(
        'cameraState', 0,
        0,
        mediaSession_mojom_CameraStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_SetCameraState_Params {
  constructor() {
    /** @type { !mediaSession_mojom_CameraState } */
    this.cameraState;
  }
}



mojo.internal.Struct(
    MediaSessionService_EnableAction_ParamsSpec.$,
    'MediaSessionService_EnableAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession_mojom_MediaSessionActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_EnableAction_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionAction } */
    this.action;
  }
}



mojo.internal.Struct(
    MediaSessionService_DisableAction_ParamsSpec.$,
    'MediaSessionService_DisableAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mediaSession_mojom_MediaSessionActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionService_DisableAction_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionAction } */
    this.action;
  }
}

mojo.internal.Union(
    MediaSessionActionDetailsSpec.$, 'MediaSessionActionDetails',
    {
      'seekTo': {
        'ordinal': 0,
        'type': MediaSessionSeekToDetailsSpec.$,
      },
      'enterPictureInPicture': {
        'ordinal': 1,
        'type': MediaSessionEnterPictureInPictureDetailsSpec.$,
      },
    });

/**
 * @typedef { {
 *   seekTo: (!MediaSessionSeekToDetails|undefined),
 *   enterPictureInPicture: (!MediaSessionEnterPictureInPictureDetails|undefined),
 * } }
 */
export const MediaSessionActionDetails = {};
